# flake8: noqa: W291
# pylint: disable=too-many-lines,trailing-whitespace

"""
AbstractAnnofabApi2のヘッダ部分

Note:
    このファイルはopenapi-generatorで自動生成される。詳細は generate/README.mdを参照
"""

import abc
import warnings  # pylint: disable=unused-import
from typing import Any, Dict, List, Optional, Tuple, Union  # pylint: disable=unused-import

import requests

import annofabapi  # pylint: disable=unused-import


class AbstractAnnofabApi2(abc.ABC):
    """
    AnnofabApi2クラスの抽象クラス
    """

    @abc.abstractmethod
    def _request_wrapper(
        self,
        http_method: str,
        url_path: str,
        query_params: Optional[Dict[str, Any]] = None,
        header_params: Optional[Dict[str, Any]] = None,
        request_body: Optional[Any] = None,
    ) -> Tuple[Any, requests.Response]:
        pass

    #########################################
    # Public Method : AfAnnotationSpecsV2Api
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_annotation_specs_v2(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション仕様取得
        https://annofab.com/docs/api/#operation/getAnnotationSpecsV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したプロジェクトのアノテーション仕様を取得します。  本 API は `cache` クエリパラメータが同じであれば結果がキャッシュされ、以降は高速にレスポンスが返ります。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP
                history_id (str):  過去のアノテーション仕様を取得する場合、[アノテーション仕様履歴取得](#operation/getAnnotationSpecsHistories)APIで取得した `history_id` の値を指定します。 未指定時は最新のアノテーション仕様を取得します。
                v (str):  取得するアノテーション仕様のフォーマットバージョンを指定します。

        Returns:
            Tuple[AnnotationSpecs, requests.Response]


        """
        url_path = f"/projects/{project_id}/annotation-specs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationMemberV2Api
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_organization_member_v2(
        self, organization_id: str, user_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織メンバー取得
        https://annofab.com/docs/api/#operation/getOrganizationMemberV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したユーザーが指定した組織にどのようなロールで参加しているかを取得します。

        Args:
            organization_id (str):  組織ID (required)
            user_id (str):  ユーザID (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[OrganizationMember, requests.Response]


        """
        url_path = f"/organizations/{organization_id}/members/{user_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_members_v2(
        self, organization_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織メンバー一括取得
        https://annofab.com/docs/api/#operation/getOrganizationMembersV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        脱退したメンバーは含まれません。

        Args:
            organization_id (str):  組織ID (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[OrganizationMemberList, requests.Response]


        """
        url_path = f"/organizations/{organization_id}/members"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationV2Api
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_organization_by_name_v2(
        self, organization_name: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織名で組織情報取得
        https://annofab.com/docs/api/#operation/getOrganizationByNameV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定された組織を取得します。  本 API は `cache` クエリパラメータが同じであれば結果がキャッシュされ、以降は高速にレスポンスが返ります。

        Args:
            organization_name (str):  組織名 (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/organizations-by-name/{organization_name}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_cache_by_name_v2(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織名で組織キャッシュレコード取得
        https://annofab.com/docs/api/#operation/getOrganizationCacheByNameV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        組織の各リソースのキャッシュタイムスタンプを格納したキャッシュレコードを取得します。  これらタイムスタンプは、各リソースを取得する API の `cache` クエリパラメータに使用します。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[OrganizationCacheRecord, requests.Response]


        """
        url_path = f"/organizations-by-name/{organization_name}/cache"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_cache_v2(self, organization_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織IDで組織キャッシュレコード取得
        https://annofab.com/docs/api/#operation/getOrganizationCacheV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        組織の各リソースのキャッシュタイムスタンプを格納したキャッシュレコードを取得します。  これらタイムスタンプは、各リソースを取得する API の `cache` クエリパラメータに使用します。

        Args:
            organization_id (str):  組織ID (required)

        Returns:
            Tuple[OrganizationCacheRecord, requests.Response]


        """
        url_path = f"/organizations/{organization_id}/cache"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_v2(
        self, organization_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織IDで組織情報取得
        https://annofab.com/docs/api/#operation/getOrganizationV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定された組織を取得します。  本 API は `cache` クエリパラメータが同じであれば結果がキャッシュされ、以降は高速にレスポンスが返ります。

        Args:
            organization_id (str):  組織ID (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/organizations/{organization_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_task_count_v2(
        self, organization_id: str, project_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトのタスク件数取得
        https://annofab.com/docs/api/#operation/getProjectTaskCountV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        プロジェクトのタスク件数を取得します。

        Args:
            organization_id (str):  組織ID (required)
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[ProjectTaskCounts, requests.Response]


        """
        url_path = f"/organizations/{organization_id}/projects/{project_id}/task-counts"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfProjectMemberV2Api
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_project_member_v2(
        self, project_id: str, user_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー取得
        https://annofab.com/docs/api/#operation/getProjectMemberV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したプロジェクトメンバーを取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            user_id (str):  アカウントのユーザID. RESTクライアントユーザが指定しやすいように、Cognitoのaccount_idではなくuser_idとしている。 (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[List[ProjectMember], requests.Response]


        """
        url_path = f"/projects/{project_id}/members/{user_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_members_v2(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー検索
        https://annofab.com/docs/api/#operation/getProjectMembersV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定されたプロジェクトのメンバーを検索します。  パフォーマンスのため、結果はページング形式で返ります。全件取得したい場合は、レスポンスを見て、ページ移動してください。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                include_inactive_member (str):  脱退したプロジェクトメンバーも取得する時に、キーのみ指定します（値は無視されます）。
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[ProjectMemberList, requests.Response]


        """
        url_path = f"/projects/{project_id}/members"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfProjectV2Api
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_project_cache_v2(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトキャッシュレコード取得
        https://annofab.com/docs/api/#operation/getProjectCacheV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        プロジェクトの各種リソースのキャッシュタイムスタンプを取得します。  これらタイムスタンプは、各リソースを取得する API の `cache` クエリパラメータに使用します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[ProjectCacheRecord, requests.Response]


        """
        url_path = f"/projects/{project_id}/cache"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfStatisticsV2Api
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_account_daily_statistics_v2(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """ユーザー別タスク集計取得
        https://annofab.com/docs/api/#operation/getAccountDailyStatisticsV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定した期間の [ユーザー別タスク集計データ](/docs/api/#section/ArrayOfProjectAccountStatistics) を取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[ProjectAccountStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/accounts/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_inspection_daily_statistics_v2(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """検査コメント集計取得
        https://annofab.com/docs/api/#operation/getInspectionDailyStatisticsV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定した期間の [検査コメント集計データ](/docs/api/#section/ArrayOfInspectionStatistics) を取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[InspectionStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/inspections/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_label_statistics_v2(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """ラベル別アノテーション数集計取得
        https://annofab.com/docs/api/#operation/getLabelStatisticsV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したプロジェクトのラベル別アノテーション数集計をすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[List[LabelStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/labels"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_phase_daily_statistics_v2(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """フェーズ別タスク集計取得
        https://annofab.com/docs/api/#operation/getPhaseDailyStatisticsV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定した期間の [フェーズ別タスク集計データ](/docs/api/#section/ArrayOfTaskPhaseStatistics) を取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[TaskPhaseStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/task-phases/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_task_daily_statistics_v2(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク集計取得
        https://annofab.com/docs/api/#operation/getTaskDailyStatisticsV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定した期間の [タスク集計データ](/docs/api/#section/ArrayOfProjectTaskStatisticsHistory) を取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[ProjectTaskStatisticsHistory], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/tasks/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_worktime_daily_statistics_by_account_v2(
        self, project_id: str, account_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー単位のフェーズ別タスク集計取得
        https://annofab.com/docs/api/#operation/getWorktimeDailyStatisticsByAccountV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したプロジェクトメンバーのタスク作業時間集計データを指定した期間分取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            account_id (str):  アカウントID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[WorktimeStatisticsByAccount, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/worktimes-by-account/{account_id}/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_worktime_daily_statistics_v2(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクト単位のフェーズ別タスク集計取得
        https://annofab.com/docs/api/#operation/getWorktimeDailyStatisticsV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したプロジェクトのタスク作業時間集計データを指定した期間分取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[WorktimeStatisticsByProject, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/worktimes/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfUsersV2Api
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_account_v2(
        self, account_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """ユーザーアカウント情報取得
        https://annofab.com/docs/api/#operation/getAccountV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したユーザーの組織のアカウント情報を取得します。  本 API は `cache` クエリパラメータが同じであれば結果がキャッシュされ、以降は高速にレスポンスが返ります。

        Args:
            account_id (str):  アカウントID (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[MyAccount, requests.Response]


        """
        url_path = f"/users/{account_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_user_cache_v2(self, account_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """キャッシュレコード
        https://annofab.com/docs/api/#operation/getUserCacheV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        ユーザー別の各リソースのキャッシュタイムスタンプを格納したキャッシュレコードを取得します。  これらタイムスタンプは、各リソースを取得する API の `cache` クエリパラメータに使用します。

        Args:
            account_id (str):  アカウントID (required)

        Returns:
            Tuple[UserCacheRecord, requests.Response]


        """
        url_path = f"/users/{account_id}/cache"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_user_organizations_v2(
        self, account_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """個人の所属組織検索
        https://annofab.com/docs/api/#operation/getUserOrganizationsV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したユーザーが所属する組織を検索します。  本 API は `cache` クエリパラメータが同じであれば結果がキャッシュされ、以降は高速にレスポンスが返ります。

        Args:
            account_id (str):  アカウントID (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[MyOrganizationList, requests.Response]


        """
        url_path = f"/users/{account_id}/organizations"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_user_project_members_v2(
        self, account_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """個人のプロジェクトメンバー情報一括取得
        https://annofab.com/docs/api/#operation/getUserProjectMembersV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したユーザーが所属するプロジェクトメンバー情報をすべて取得します。  本 API は `cache` クエリパラメータが同じであれば結果がキャッシュされ、以降は高速にレスポンスが返ります。

        Args:
            account_id (str):  アカウントID (required)
            query_params (Dict[str, Any]): Query Parameters
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[ProjectMember, requests.Response]


        """
        url_path = f"/users/{account_id}/project-members"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_user_projects_v2(
        self, account_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """自分のプロジェクトメンバー情報検索
        https://annofab.com/docs/api/#operation/getUserProjectsV2


        authorizations: SignedCookieKeyPairId, SignedCookiePolicy, SignedCookieSignature


        指定したユーザーが所属するプロジェクトを検索します。  本 API は `cache` クエリパラメータが同じであれば結果がキャッシュされ、以降は高速にレスポンスが返ります。

        Args:
            account_id (str):  アカウントID (required)
            query_params (Dict[str, Any]): Query Parameters
                page (int):  表示するページ番号
                limit (int):  1ページあたりの取得するデータ件数
                organization_id (str):  指定した組織に属するプロジェクトに絞り込む。未指定時は全プロジェクト。
                title (str):  プロジェクトタイトルでの部分一致検索。1文字以上あれば使用します。利便性のため、大文字小文字は区別しません。
                status (ProjectStatus):  指定した状態のプロジェクトで絞り込む。未指定時は全プロジェクト。
                input_data_type (InputDataType):  指定した入力データ種別でプロジェクトを絞り込む。未指定時は全プロジェクト
                sort_by (str):  `date` を指定することでプロジェクトの最新のタスク更新時間の順にソートして出力する。 未指定時はプロジェクト名でソートする。
                cache (str):  CACHE TIMESTAMP

        Returns:
            Tuple[ProjectContainer, requests.Response]


        """
        url_path = f"/users/{account_id}/projects"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)
