# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class AnonymizeList(ListResource):

    def __init__(self, version, room_sid, sid):
        """
        Initialize the AnonymizeList

        :param Version version: Version that contains the resource
        :param room_sid: The SID of the participant's room
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeList
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeList
        """
        super(AnonymizeList, self).__init__(version)

        # Path Solution
        self._solution = {'room_sid': room_sid, 'sid': sid, }

    def get(self):
        """
        Constructs a AnonymizeContext

        :returns: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeContext
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeContext
        """
        return AnonymizeContext(
            self._version,
            room_sid=self._solution['room_sid'],
            sid=self._solution['sid'],
        )

    def __call__(self):
        """
        Constructs a AnonymizeContext

        :returns: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeContext
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeContext
        """
        return AnonymizeContext(
            self._version,
            room_sid=self._solution['room_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Video.V1.AnonymizeList>'


class AnonymizePage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the AnonymizePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param room_sid: The SID of the participant's room
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizePage
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizePage
        """
        super(AnonymizePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of AnonymizeInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeInstance
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeInstance
        """
        return AnonymizeInstance(
            self._version,
            payload,
            room_sid=self._solution['room_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Video.V1.AnonymizePage>'


class AnonymizeContext(InstanceContext):

    def __init__(self, version, room_sid, sid):
        """
        Initialize the AnonymizeContext

        :param Version version: Version that contains the resource
        :param room_sid: The SID of the room with the participant to update
        :param sid: The SID that identifies the resource to update

        :returns: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeContext
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeContext
        """
        super(AnonymizeContext, self).__init__(version)

        # Path Solution
        self._solution = {'room_sid': room_sid, 'sid': sid, }
        self._uri = '/Rooms/{room_sid}/Participants/{sid}/Anonymize'.format(**self._solution)

    def update(self):
        """
        Update the AnonymizeInstance

        :returns: The updated AnonymizeInstance
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeInstance
        """
        payload = self._version.update(method='POST', uri=self._uri, )

        return AnonymizeInstance(
            self._version,
            payload,
            room_sid=self._solution['room_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Video.V1.AnonymizeContext {}>'.format(context)


class AnonymizeInstance(InstanceResource):

    class Status(object):
        CONNECTED = "connected"
        DISCONNECTED = "disconnected"

    def __init__(self, version, payload, room_sid, sid):
        """
        Initialize the AnonymizeInstance

        :returns: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeInstance
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeInstance
        """
        super(AnonymizeInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'room_sid': payload.get('room_sid'),
            'account_sid': payload.get('account_sid'),
            'status': payload.get('status'),
            'identity': payload.get('identity'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'start_time': deserialize.iso8601_datetime(payload.get('start_time')),
            'end_time': deserialize.iso8601_datetime(payload.get('end_time')),
            'duration': deserialize.integer(payload.get('duration')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'room_sid': room_sid, 'sid': sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: AnonymizeContext for this AnonymizeInstance
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeContext
        """
        if self._context is None:
            self._context = AnonymizeContext(
                self._version,
                room_sid=self._solution['room_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def room_sid(self):
        """
        :returns: The SID of the participant's room
        :rtype: unicode
        """
        return self._properties['room_sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def status(self):
        """
        :returns: The status of the Participant
        :rtype: AnonymizeInstance.Status
        """
        return self._properties['status']

    @property
    def identity(self):
        """
        :returns: The SID of the participant
        :rtype: unicode
        """
        return self._properties['identity']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def start_time(self):
        """
        :returns: The time of participant connected to the room in ISO 8601 format
        :rtype: datetime
        """
        return self._properties['start_time']

    @property
    def end_time(self):
        """
        :returns: The time when the participant disconnected from the room in ISO 8601 format
        :rtype: datetime
        """
        return self._properties['end_time']

    @property
    def duration(self):
        """
        :returns: Duration of time in seconds the participant was connected
        :rtype: unicode
        """
        return self._properties['duration']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    def update(self):
        """
        Update the AnonymizeInstance

        :returns: The updated AnonymizeInstance
        :rtype: twilio.rest.video.v1.room.room_participant.room_participant_anonymize.AnonymizeInstance
        """
        return self._proxy.update()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Video.V1.AnonymizeInstance {}>'.format(context)
