# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.supersim.v1 import V1


class Supersim(Domain):

    def __init__(self, twilio):
        """
        Initialize the Supersim Domain

        :returns: Domain for Supersim
        :rtype: twilio.rest.supersim.Supersim
        """
        super(Supersim, self).__init__(twilio)

        self.base_url = 'https://supersim.twilio.com'

        # Versions
        self._v1 = None

    @property
    def v1(self):
        """
        :returns: Version v1 of supersim
        :rtype: twilio.rest.supersim.v1.V1
        """
        if self._v1 is None:
            self._v1 = V1(self)
        return self._v1

    @property
    def esim_profiles(self):
        """
        :rtype: twilio.rest.supersim.v1.esim_profile.EsimProfileList
        """
        return self.v1.esim_profiles

    @property
    def fleets(self):
        """
        :rtype: twilio.rest.supersim.v1.fleet.FleetList
        """
        return self.v1.fleets

    @property
    def ip_commands(self):
        """
        :rtype: twilio.rest.supersim.v1.ip_command.IpCommandList
        """
        return self.v1.ip_commands

    @property
    def networks(self):
        """
        :rtype: twilio.rest.supersim.v1.network.NetworkList
        """
        return self.v1.networks

    @property
    def network_access_profiles(self):
        """
        :rtype: twilio.rest.supersim.v1.network_access_profile.NetworkAccessProfileList
        """
        return self.v1.network_access_profiles

    @property
    def settings_updates(self):
        """
        :rtype: twilio.rest.supersim.v1.settings_update.SettingsUpdateList
        """
        return self.v1.settings_updates

    @property
    def sims(self):
        """
        :rtype: twilio.rest.supersim.v1.sim.SimList
        """
        return self.v1.sims

    @property
    def sms_commands(self):
        """
        :rtype: twilio.rest.supersim.v1.sms_command.SmsCommandList
        """
        return self.v1.sms_commands

    @property
    def usage_records(self):
        """
        :rtype: twilio.rest.supersim.v1.usage_record.UsageRecordList
        """
        return self.v1.usage_records

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Supersim>'
