# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class DomainCertsList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the DomainCertsList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.messaging.v1.domain_cert.DomainCertsList
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsList
        """
        super(DomainCertsList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, domain_sid):
        """
        Constructs a DomainCertsContext

        :param domain_sid: Unique string used to identify the domain that this certificate should be associated with.

        :returns: twilio.rest.messaging.v1.domain_cert.DomainCertsContext
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsContext
        """
        return DomainCertsContext(self._version, domain_sid=domain_sid, )

    def __call__(self, domain_sid):
        """
        Constructs a DomainCertsContext

        :param domain_sid: Unique string used to identify the domain that this certificate should be associated with.

        :returns: twilio.rest.messaging.v1.domain_cert.DomainCertsContext
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsContext
        """
        return DomainCertsContext(self._version, domain_sid=domain_sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.DomainCertsList>'


class DomainCertsPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the DomainCertsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.messaging.v1.domain_cert.DomainCertsPage
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsPage
        """
        super(DomainCertsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of DomainCertsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.messaging.v1.domain_cert.DomainCertsInstance
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsInstance
        """
        return DomainCertsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.DomainCertsPage>'


class DomainCertsContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, domain_sid):
        """
        Initialize the DomainCertsContext

        :param Version version: Version that contains the resource
        :param domain_sid: Unique string used to identify the domain that this certificate should be associated with.

        :returns: twilio.rest.messaging.v1.domain_cert.DomainCertsContext
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsContext
        """
        super(DomainCertsContext, self).__init__(version)

        # Path Solution
        self._solution = {'domain_sid': domain_sid, }
        self._uri = '/LinkShortening/Domains/{domain_sid}/Certificate'.format(**self._solution)

    def update(self, tls_cert):
        """
        Update the DomainCertsInstance

        :param unicode tls_cert: Certificate and private key information for this domain.

        :returns: The updated DomainCertsInstance
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsInstance
        """
        data = values.of({'TlsCert': tls_cert, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return DomainCertsInstance(self._version, payload, domain_sid=self._solution['domain_sid'], )

    def fetch(self):
        """
        Fetch the DomainCertsInstance

        :returns: The fetched DomainCertsInstance
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return DomainCertsInstance(self._version, payload, domain_sid=self._solution['domain_sid'], )

    def delete(self):
        """
        Deletes the DomainCertsInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Messaging.V1.DomainCertsContext {}>'.format(context)


class DomainCertsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, domain_sid=None):
        """
        Initialize the DomainCertsInstance

        :returns: twilio.rest.messaging.v1.domain_cert.DomainCertsInstance
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsInstance
        """
        super(DomainCertsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'domain_sid': payload.get('domain_sid'),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'date_expires': deserialize.iso8601_datetime(payload.get('date_expires')),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'domain_name': payload.get('domain_name'),
            'certificate_sid': payload.get('certificate_sid'),
            'url': payload.get('url'),
            'validated': payload.get('validated'),
        }

        # Context
        self._context = None
        self._solution = {'domain_sid': domain_sid or self._properties['domain_sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: DomainCertsContext for this DomainCertsInstance
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsContext
        """
        if self._context is None:
            self._context = DomainCertsContext(self._version, domain_sid=self._solution['domain_sid'], )
        return self._context

    @property
    def domain_sid(self):
        """
        :returns: The unique string that we created to identify the Domain resource.
        :rtype: unicode
        """
        return self._properties['domain_sid']

    @property
    def date_updated(self):
        """
        :returns: Date that this Domain was last updated.
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def date_expires(self):
        """
        :returns: Expiration date for your private certificate.
        :rtype: datetime
        """
        return self._properties['date_expires']

    @property
    def date_created(self):
        """
        :returns: Date this Domain SID was created.
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def domain_name(self):
        """
        :returns: Full url path for this domain.
        :rtype: unicode
        """
        return self._properties['domain_name']

    @property
    def certificate_sid(self):
        """
        :returns: The unique string that we created to identify this Certificate resource.
        :rtype: unicode
        """
        return self._properties['certificate_sid']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def validated(self):
        """
        :returns: Certificate validation field
        :rtype: bool
        """
        return self._properties['validated']

    def update(self, tls_cert):
        """
        Update the DomainCertsInstance

        :param unicode tls_cert: Certificate and private key information for this domain.

        :returns: The updated DomainCertsInstance
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsInstance
        """
        return self._proxy.update(tls_cert, )

    def fetch(self):
        """
        Fetch the DomainCertsInstance

        :returns: The fetched DomainCertsInstance
        :rtype: twilio.rest.messaging.v1.domain_cert.DomainCertsInstance
        """
        return self._proxy.fetch()

    def delete(self):
        """
        Deletes the DomainCertsInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Messaging.V1.DomainCertsInstance {}>'.format(context)
