# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class InsightsSettingsCommentList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the InsightsSettingsCommentList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.insights_settings_comment.InsightsSettingsCommentList
        :rtype: twilio.rest.flex_api.v1.insights_settings_comment.InsightsSettingsCommentList
        """
        super(InsightsSettingsCommentList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Insights/QM/Settings/CommentTags'.format(**self._solution)

    def fetch(self, token=values.unset):
        """
        Fetch the InsightsSettingsCommentInstance

        :param unicode token: The Token HTTP request header

        :returns: The fetched InsightsSettingsCommentInstance
        :rtype: twilio.rest.flex_api.v1.insights_settings_comment.InsightsSettingsCommentInstance
        """
        headers = values.of({'Token': token, })

        payload = self._version.fetch(method='GET', uri=self._uri, headers=headers, )

        return InsightsSettingsCommentInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsSettingsCommentList>'


class InsightsSettingsCommentPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the InsightsSettingsCommentPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.flex_api.v1.insights_settings_comment.InsightsSettingsCommentPage
        :rtype: twilio.rest.flex_api.v1.insights_settings_comment.InsightsSettingsCommentPage
        """
        super(InsightsSettingsCommentPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of InsightsSettingsCommentInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.insights_settings_comment.InsightsSettingsCommentInstance
        :rtype: twilio.rest.flex_api.v1.insights_settings_comment.InsightsSettingsCommentInstance
        """
        return InsightsSettingsCommentInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsSettingsCommentPage>'


class InsightsSettingsCommentInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the InsightsSettingsCommentInstance

        :returns: twilio.rest.flex_api.v1.insights_settings_comment.InsightsSettingsCommentInstance
        :rtype: twilio.rest.flex_api.v1.insights_settings_comment.InsightsSettingsCommentInstance
        """
        super(InsightsSettingsCommentInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'comments': payload.get('comments'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource and owns this Flex Insights
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def comments(self):
        """
        :returns: The comments
        :rtype: dict
        """
        return self._properties['comments']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsSettingsCommentInstance>'
