# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class InsightsSessionList(ListResource):

    def __init__(self, version):
        """
        Initialize the InsightsSessionList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.insights_session.InsightsSessionList
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionList
        """
        super(InsightsSessionList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a InsightsSessionContext

        :returns: twilio.rest.flex_api.v1.insights_session.InsightsSessionContext
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionContext
        """
        return InsightsSessionContext(self._version, )

    def __call__(self):
        """
        Constructs a InsightsSessionContext

        :returns: twilio.rest.flex_api.v1.insights_session.InsightsSessionContext
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionContext
        """
        return InsightsSessionContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsSessionList>'


class InsightsSessionPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the InsightsSessionPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.flex_api.v1.insights_session.InsightsSessionPage
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionPage
        """
        super(InsightsSessionPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of InsightsSessionInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.insights_session.InsightsSessionInstance
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionInstance
        """
        return InsightsSessionInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsSessionPage>'


class InsightsSessionContext(InstanceContext):

    def __init__(self, version):
        """
        Initialize the InsightsSessionContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.insights_session.InsightsSessionContext
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionContext
        """
        super(InsightsSessionContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Insights/Session'.format(**self._solution)

    def create(self, token=values.unset):
        """
        Create the InsightsSessionInstance

        :param unicode token: The Token HTTP request header

        :returns: The created InsightsSessionInstance
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionInstance
        """
        headers = values.of({'Token': token, })

        payload = self._version.create(method='POST', uri=self._uri, headers=headers, )

        return InsightsSessionInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.InsightsSessionContext {}>'.format(context)


class InsightsSessionInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the InsightsSessionInstance

        :returns: twilio.rest.flex_api.v1.insights_session.InsightsSessionInstance
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionInstance
        """
        super(InsightsSessionInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'workspace_id': payload.get('workspace_id'),
            'session_expiry': payload.get('session_expiry'),
            'session_id': payload.get('session_id'),
            'base_url': payload.get('base_url'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: InsightsSessionContext for this InsightsSessionInstance
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionContext
        """
        if self._context is None:
            self._context = InsightsSessionContext(self._version, )
        return self._context

    @property
    def workspace_id(self):
        """
        :returns: Unique ID to identify the user's workspace
        :rtype: unicode
        """
        return self._properties['workspace_id']

    @property
    def session_expiry(self):
        """
        :returns: The session expiry date and time
        :rtype: unicode
        """
        return self._properties['session_expiry']

    @property
    def session_id(self):
        """
        :returns: Unique session ID
        :rtype: unicode
        """
        return self._properties['session_id']

    @property
    def base_url(self):
        """
        :returns: Base URL to fetch reports and dashboards
        :rtype: unicode
        """
        return self._properties['base_url']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    def create(self, token=values.unset):
        """
        Create the InsightsSessionInstance

        :param unicode token: The Token HTTP request header

        :returns: The created InsightsSessionInstance
        :rtype: twilio.rest.flex_api.v1.insights_session.InsightsSessionInstance
        """
        return self._proxy.create(token=token, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.InsightsSessionInstance {}>'.format(context)
