# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class AddressConfigurationList(ListResource):

    def __init__(self, version):
        """
        Initialize the AddressConfigurationList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.conversations.v1.address_configuration.AddressConfigurationList
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationList
        """
        super(AddressConfigurationList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Configuration/Addresses'.format(**self._solution)

    def stream(self, type=values.unset, limit=None, page_size=None):
        """
        Streams AddressConfigurationInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode type: The type of address configuration.
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(type=type, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, type=values.unset, limit=None, page_size=None):
        """
        Lists AddressConfigurationInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode type: The type of address configuration.
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance]
        """
        return list(self.stream(type=type, limit=limit, page_size=page_size, ))

    def page(self, type=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of AddressConfigurationInstance records from the API.
        Request is executed immediately

        :param unicode type: The type of address configuration.
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationPage
        """
        data = values.of({
            'Type': type,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return AddressConfigurationPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of AddressConfigurationInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return AddressConfigurationPage(self._version, response, self._solution)

    def create(self, type, address, friendly_name=values.unset,
               auto_creation_enabled=values.unset, auto_creation_type=values.unset,
               auto_creation_conversation_service_sid=values.unset,
               auto_creation_webhook_url=values.unset,
               auto_creation_webhook_method=values.unset,
               auto_creation_webhook_filters=values.unset,
               auto_creation_studio_flow_sid=values.unset,
               auto_creation_studio_retry_count=values.unset):
        """
        Create the AddressConfigurationInstance

        :param AddressConfigurationInstance.Type type: Type of Address.
        :param unicode address: The unique address to be configured.
        :param unicode friendly_name: The human-readable name of this configuration.
        :param bool auto_creation_enabled: Enable/Disable auto-creating conversations for messages to this address
        :param AddressConfigurationInstance.AutoCreationType auto_creation_type: Type of Auto Creation.
        :param unicode auto_creation_conversation_service_sid: Conversation Service for the auto-created conversation.
        :param unicode auto_creation_webhook_url: For type `webhook`, the url for the webhook request.
        :param AddressConfigurationInstance.Method auto_creation_webhook_method: For type `webhook`, the HTTP method to be used when sending a webhook request.
        :param list[unicode] auto_creation_webhook_filters: The list of events, firing webhook event for this Conversation.
        :param unicode auto_creation_studio_flow_sid: For type `studio`, the studio flow SID where the webhook should be sent to.
        :param unicode auto_creation_studio_retry_count: For type `studio`, number of times to retry the webhook request

        :returns: The created AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance
        """
        data = values.of({
            'Type': type,
            'Address': address,
            'FriendlyName': friendly_name,
            'AutoCreation.Enabled': auto_creation_enabled,
            'AutoCreation.Type': auto_creation_type,
            'AutoCreation.ConversationServiceSid': auto_creation_conversation_service_sid,
            'AutoCreation.WebhookUrl': auto_creation_webhook_url,
            'AutoCreation.WebhookMethod': auto_creation_webhook_method,
            'AutoCreation.WebhookFilters': serialize.map(auto_creation_webhook_filters, lambda e: e),
            'AutoCreation.StudioFlowSid': auto_creation_studio_flow_sid,
            'AutoCreation.StudioRetryCount': auto_creation_studio_retry_count,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return AddressConfigurationInstance(self._version, payload, )

    def get(self, sid):
        """
        Constructs a AddressConfigurationContext

        :param sid: The SID or Address of the Configuration.

        :returns: twilio.rest.conversations.v1.address_configuration.AddressConfigurationContext
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationContext
        """
        return AddressConfigurationContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a AddressConfigurationContext

        :param sid: The SID or Address of the Configuration.

        :returns: twilio.rest.conversations.v1.address_configuration.AddressConfigurationContext
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationContext
        """
        return AddressConfigurationContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.AddressConfigurationList>'


class AddressConfigurationPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the AddressConfigurationPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.conversations.v1.address_configuration.AddressConfigurationPage
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationPage
        """
        super(AddressConfigurationPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of AddressConfigurationInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance
        """
        return AddressConfigurationInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.AddressConfigurationPage>'


class AddressConfigurationContext(InstanceContext):

    def __init__(self, version, sid):
        """
        Initialize the AddressConfigurationContext

        :param Version version: Version that contains the resource
        :param sid: The SID or Address of the Configuration.

        :returns: twilio.rest.conversations.v1.address_configuration.AddressConfigurationContext
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationContext
        """
        super(AddressConfigurationContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Configuration/Addresses/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the AddressConfigurationInstance

        :returns: The fetched AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return AddressConfigurationInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, friendly_name=values.unset, auto_creation_enabled=values.unset,
               auto_creation_type=values.unset,
               auto_creation_conversation_service_sid=values.unset,
               auto_creation_webhook_url=values.unset,
               auto_creation_webhook_method=values.unset,
               auto_creation_webhook_filters=values.unset,
               auto_creation_studio_flow_sid=values.unset,
               auto_creation_studio_retry_count=values.unset):
        """
        Update the AddressConfigurationInstance

        :param unicode friendly_name: The human-readable name of this configuration.
        :param bool auto_creation_enabled: Enable/Disable auto-creating conversations for messages to this address
        :param AddressConfigurationInstance.AutoCreationType auto_creation_type: Type of Auto Creation.
        :param unicode auto_creation_conversation_service_sid: Conversation Service for the auto-created conversation.
        :param unicode auto_creation_webhook_url: For type `webhook`, the url for the webhook request.
        :param AddressConfigurationInstance.Method auto_creation_webhook_method: For type `webhook`, the HTTP method to be used when sending a webhook request.
        :param list[unicode] auto_creation_webhook_filters: The list of events, firing webhook event for this Conversation.
        :param unicode auto_creation_studio_flow_sid: For type `studio`, the studio flow SID where the webhook should be sent to.
        :param unicode auto_creation_studio_retry_count: For type `studio`, number of times to retry the webhook request

        :returns: The updated AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'AutoCreation.Enabled': auto_creation_enabled,
            'AutoCreation.Type': auto_creation_type,
            'AutoCreation.ConversationServiceSid': auto_creation_conversation_service_sid,
            'AutoCreation.WebhookUrl': auto_creation_webhook_url,
            'AutoCreation.WebhookMethod': auto_creation_webhook_method,
            'AutoCreation.WebhookFilters': serialize.map(auto_creation_webhook_filters, lambda e: e),
            'AutoCreation.StudioFlowSid': auto_creation_studio_flow_sid,
            'AutoCreation.StudioRetryCount': auto_creation_studio_retry_count,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return AddressConfigurationInstance(self._version, payload, sid=self._solution['sid'], )

    def delete(self):
        """
        Deletes the AddressConfigurationInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.AddressConfigurationContext {}>'.format(context)


class AddressConfigurationInstance(InstanceResource):

    class Type(object):
        SMS = "sms"
        WHATSAPP = "whatsapp"
        MESSENGER = "messenger"
        GBM = "gbm"

    class AutoCreationType(object):
        WEBHOOK = "webhook"
        STUDIO = "studio"
        DEFAULT = "default"

    class Method(object):
        GET = "GET"
        POST = "POST"

    def __init__(self, version, payload, sid=None):
        """
        Initialize the AddressConfigurationInstance

        :returns: twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance
        """
        super(AddressConfigurationInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'type': payload.get('type'),
            'address': payload.get('address'),
            'friendly_name': payload.get('friendly_name'),
            'auto_creation': payload.get('auto_creation'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: AddressConfigurationContext for this AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationContext
        """
        if self._context is None:
            self._context = AddressConfigurationContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: A 34 character string that uniquely identifies this resource.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The unique ID of the Account the address belongs to.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def type(self):
        """
        :returns: Type of Address.
        :rtype: unicode
        """
        return self._properties['type']

    @property
    def address(self):
        """
        :returns: The unique address to be configured.
        :rtype: unicode
        """
        return self._properties['address']

    @property
    def friendly_name(self):
        """
        :returns: The human-readable name of this configuration.
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def auto_creation(self):
        """
        :returns: Auto Creation configuration for the address.
        :rtype: dict
        """
        return self._properties['auto_creation']

    @property
    def date_created(self):
        """
        :returns: The date that this resource was created.
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date that this resource was last updated.
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: An absolute URL for this address configuration.
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the AddressConfigurationInstance

        :returns: The fetched AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance
        """
        return self._proxy.fetch()

    def update(self, friendly_name=values.unset, auto_creation_enabled=values.unset,
               auto_creation_type=values.unset,
               auto_creation_conversation_service_sid=values.unset,
               auto_creation_webhook_url=values.unset,
               auto_creation_webhook_method=values.unset,
               auto_creation_webhook_filters=values.unset,
               auto_creation_studio_flow_sid=values.unset,
               auto_creation_studio_retry_count=values.unset):
        """
        Update the AddressConfigurationInstance

        :param unicode friendly_name: The human-readable name of this configuration.
        :param bool auto_creation_enabled: Enable/Disable auto-creating conversations for messages to this address
        :param AddressConfigurationInstance.AutoCreationType auto_creation_type: Type of Auto Creation.
        :param unicode auto_creation_conversation_service_sid: Conversation Service for the auto-created conversation.
        :param unicode auto_creation_webhook_url: For type `webhook`, the url for the webhook request.
        :param AddressConfigurationInstance.Method auto_creation_webhook_method: For type `webhook`, the HTTP method to be used when sending a webhook request.
        :param list[unicode] auto_creation_webhook_filters: The list of events, firing webhook event for this Conversation.
        :param unicode auto_creation_studio_flow_sid: For type `studio`, the studio flow SID where the webhook should be sent to.
        :param unicode auto_creation_studio_retry_count: For type `studio`, number of times to retry the webhook request

        :returns: The updated AddressConfigurationInstance
        :rtype: twilio.rest.conversations.v1.address_configuration.AddressConfigurationInstance
        """
        return self._proxy.update(
            friendly_name=friendly_name,
            auto_creation_enabled=auto_creation_enabled,
            auto_creation_type=auto_creation_type,
            auto_creation_conversation_service_sid=auto_creation_conversation_service_sid,
            auto_creation_webhook_url=auto_creation_webhook_url,
            auto_creation_webhook_method=auto_creation_webhook_method,
            auto_creation_webhook_filters=auto_creation_webhook_filters,
            auto_creation_studio_flow_sid=auto_creation_studio_flow_sid,
            auto_creation_studio_retry_count=auto_creation_studio_retry_count,
        )

    def delete(self):
        """
        Deletes the AddressConfigurationInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.AddressConfigurationInstance {}>'.format(context)
