from faker import Faker
import datetime
import random

def patientlist_fake(fake_count, doc_ids):
    localeList = ['en-US']
    fake = Faker(localeList)
    list_response = []
    start_date = datetime.datetime.now() - datetime.timedelta(days=730)
    end_date = datetime.datetime.now() + datetime.timedelta(days=730)
    dob_startdate = datetime.datetime.now() - datetime.timedelta(days=365*70)
    dob_enddate = datetime.datetime.now() - datetime.timedelta(days=365*18)
    appnt_firstdate = datetime.datetime.now() - datetime.timedelta(days=365*2)
    appnt_firstenddate = datetime.datetime.now() - datetime.timedelta(days=365*1)
    appnt_lastdate = datetime.datetime.now() - datetime.timedelta(days=365*1)
    appnt_lastenddate = datetime.datetime.now() + datetime.timedelta(days=365*1)
    for i in range(fake_count):
        dictionaryResponse = {
            "address": fake.address(),
            "auto_accident_insurance": {
                "auto_accident_case_number": fake.ssn(),
                "auto_accident_claim_rep_address": fake.address(),
                "auto_accident_claim_rep_city": fake.city(),
                "auto_accident_claim_rep_is_insurer": fake.boolean(),
                "auto_accident_claim_rep_name": fake.name(),
                "auto_accident_claim_rep_state": fake.state(),
                "auto_accident_claim_rep_zip": fake.zipcode(),
                "auto_accident_company": fake.company(),
                "auto_accident_date_of_accident": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "auto_accident_disabled_from_date": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "auto_accident_disabled_to_date": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "auto_accident_had_similar_condition": fake.boolean(),
                "auto_accident_is_subscriber_the_patient": fake.boolean(),
                "auto_accident_notes": fake.text(),
                "auto_accident_patient_relationship_to_subscriber": fake.random_element(elements=('self', 'spouse', 'child', 'other')),
                "auto_accident_payer_address": fake.address(),
                "auto_accident_payer_city": fake.city(),
                "auto_accident_payer_id": fake.ssn(),
                "auto_accident_payer_state": fake.state(),
                "auto_accident_payer_zip": fake.zipcode(),
                "auto_accident_policy_number": fake.ssn(),
                "auto_accident_return_to_work_date": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "auto_accident_significant_injury": fake.random_element(elements=('yes', 'no')),
                "auto_accident_significant_injury_notes": fake.text(),
                "auto_accident_similar_condition_date": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "auto_accident_similar_condition_notes": fake.text(),
                "auto_accident_state_of_occurrence": fake.state(),
                "auto_accident_still_under_care": fake.boolean(),
                "auto_accident_subscriber_address": fake.address(),
                "auto_accident_subscriber_city": fake.city(),
                "auto_accident_subscriber_date_of_birth": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "auto_accident_subscriber_first_name": fake.first_name(),
                "auto_accident_subscriber_last_name": fake.last_name(),
                "auto_accident_subscriber_middle_name": fake.first_name(),
                "auto_accident_subscriber_phone_number": fake.phone_number(),
                "auto_accident_subscriber_social_security": fake.ssn(),
                "auto_accident_subscriber_state": fake.state(),
                "auto_accident_subscriber_suffix": fake.suffix(),
                "auto_accident_subscriber_zip_code": fake.zipcode(),
                "auto_accident_treatment_duration": fake.random_element(elements=('30 days', '60 days', '90 days', '120 days', '180 days', 'other')),
                "auto_accident_will_require_therapy": fake.boolean(),
                "auto_accident_will_require_therapy_rec": fake.boolean()
                },
            "cell_phone": fake.phone_number(),
            "chart_id": fake.numerify(text='######'),
            "city": fake.city(),
            "copay": fake.numerify(text='##'),
            "custom_demographics": [
                {
                "field_type": fake.random_element(elements=('text', 'number', 'date', 'boolean')),
                "updated_at": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "value": fake.text(),
                }
            ],
            "date_of_birth": fake.date_time_between(start_date=dob_startdate, end_date=dob_enddate).isoformat(),
            "date_of_first_appointment": fake.date_time_between(start_date=appnt_firstdate, end_date=appnt_firstenddate).isoformat(),
            "date_of_last_appointment": fake.date_time_between(start_date=appnt_lastdate, end_date=appnt_lastenddate).isoformat(),
            "default_pharmacy": fake.company(),
            "disable_sms_messages": fake.boolean(),
            "doctor": fake.random_element(elements=doc_ids),
            "email": fake.email(),
            "emergency_contact_name": fake.name(),
            "emergency_contact_phone": fake.phone_number(),
            "emergency_contact_relation": fake.random_element(elements=('self', 'spouse', 'child', 'other')),
            "employer": fake.company(),
            "employer_address": fake.address(),
            "employer_city": fake.city(),
            "employer_state": fake.state(),
            "employer_zip_code": fake.zipcode(),
            "ethnicity": fake.random_element(elements=('hispanic', 'not_hispanic', 'unknown')),
            "first_name": fake.first_name(),
            "gender": fake.random_element(elements=('Male', 'Female', 'Queer', 'Transgender', 'Other')),
            "home_phone": fake.phone_number(),
            "id": fake.numerify(text='######'),
            "last_name": fake.last_name(),
            "middle_name": fake.first_name(),
            "nick_name": fake.first_name(),
            "office_phone": fake.phone_number(),
            "offices": [
                fake.numerify(text='######'),
            ],
            "patient_flags": [
                {
                "archived": fake.boolean(),
                "color": fake.color(),
                "created_at": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "doctor": fake.numerify(text='######'),
                "id": fake.numerify(text='######'),
                "name": fake.name(),
                "priority": fake.numerify(text='##'),
                "updated_at": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                }
            ],
            "patient_flags_attached": [
                {
                "archived": fake.boolean(),
                "created_at": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "flag_text": fake.text(),
                "flag_type": fake.random_element(elements=('patient', 'appointment')),
                "id": fake.numerify(text='######'),
                "updated_at": "string"
                }
            ],
            "patient_payment_profile": fake.random_elements(elements=('cash', 'credit_card', 'insurance', 'other')),
            "patient_photo": fake.image_url(),
            "patient_photo_date": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
            "patient_status": fake.random_element(elements=('active', 'inactive', 'pending')),
            "preferred_language": fake.random_element(elements=('english', 'spanish', 'french', 'german', 'other')),
            "primary_care_physician": fake.numerify(text='######'),
            "primary_insurance": {
                "insurance_claim_office_number": fake.numerify(text='######'),
                "insurance_company": fake.company(),
                "insurance_group_name": fake.company(),
                "insurance_group_number": fake.numerify(text='######'),
                "insurance_id_number": fake.numerify(text='######'),
                "insurance_payer_id": fake.numerify(text='######'),
                "insurance_plan_name": fake.company(),
                "insurance_plan_type": fake.random_element(elements=('HMO', 'PPO', 'POS', 'EPO', 'other')),
                "is_subscriber_the_patient": fake.boolean(),
                "patient_relationship_to_subscriber": fake.random_element(elements=('self', 'spouse', 'child', 'other')),
                "photo_back": fake.image_url(),
                "photo_front": fake.image_url(),
                "subscriber_address": fake.address(),
                "subscriber_city": fake.city(),
                "subscriber_country": fake.country(),
                "subscriber_date_of_birth": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "subscriber_first_name": fake.first_name(),
                "subscriber_gender": fake.random_element(elements=('Male', 'Female', 'Transgender', 'Other')),
                "subscriber_last_name": fake.last_name(),
                "subscriber_middle_name": fake.first_name(),
                "subscriber_social_security": fake.ssn(),
                "subscriber_state": fake.state(),
                "subscriber_suffix": fake.suffix(),
                "subscriber_zip_code": fake.zipcode()
            },
            "race": fake.random_element(elements=('white', 'black', 'asian', 'hispanic', 'other')),
            "referring_doctor": {
                "address": fake.address(),
                "email": fake.email(),
                "fax": fake.phone_number(),
                "first_name": fake.first_name(),
                "last_name": fake.last_name(),
                "middle_name": fake.first_name(),
                "npi": fake.numerify(text='##########'),
                "phone": fake.phone_number(),
                "provider_number": fake.numerify(text='######'),
                "provider_qualifier": fake.random_element(elements=('MD', 'DO', 'PA', 'NP', 'other')),
                "specialty": fake.random_element(elements=('general_practice', 'internal_medicine', 'pediatrics', 'other')),
                "suffix": fake.suffix(),
            },
            "referring_source": fake.random_element(elements=('self', 'spouse', 'child', 'other')),
            "responsible_party_email": fake.email(),
            "responsible_party_name": fake.name(),
            "responsible_party_phone": fake.phone_number(),
            "responsible_party_relation": fake.random_element(elements=('self', 'spouse', 'child', 'other')),
            "secondary_insurance": {
                "insurance_claim_office_number": fake.phone_number(),
                "insurance_company": fake.company(),
                "insurance_group_name": fake.company(),
                "insurance_group_number": fake.numerify(text='######'),
                "insurance_id_number": fake.numerify(text='######'),
                "insurance_payer_id": fake.numerify(text='#########'),
                "insurance_plan_name": fake.company(),
                "insurance_plan_type": fake.random_element(elements=('HMO', 'PPO', 'POS', 'EPO', 'other')),
                "is_subscriber_the_patient": fake.boolean(),
                "patient_relationship_to_subscriber": fake.random_element(elements=('self', 'spouse', 'child', 'other')),
                "photo_back": fake.image_url(),
                "photo_front": fake.image_url(),
                "subscriber_address": fake.address(),
                "subscriber_city": fake.city(),
                "subscriber_country": fake.country(),
                "subscriber_date_of_birth": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "subscriber_first_name": fake.first_name(),
                "subscriber_gender": fake.random_element(elements=('Male', 'Female', 'Transgender', 'Queer', 'Other')),
                "subscriber_last_name": fake.last_name(),
                "subscriber_middle_name": fake.first_name(),
                "subscriber_social_security": fake.ssn(),
                "subscriber_state": fake.state(),
                "subscriber_suffix": fake.suffix(),
                "subscriber_zip_code": fake.zipcode()
            },
            "social_security_number": fake.ssn(),
            "state": fake.state(),
            "tertiary_insurance": {
                "insurance_claim_office_number": fake.phone_number(),
                "insurance_company": fake.company(),
                "insurance_group_name": fake.company(),
                "insurance_group_number": fake.numerify(text='#########'),
                "insurance_id_number": fake.numerify(text='#######'),
                "insurance_payer_id": fake.numerify(text='############'),
                "insurance_plan_name": fake.company(),
                "insurance_plan_type": fake.random_element(elements=('HMO', 'PPO', 'POS', 'EPO', 'other')),
                "is_subscriber_the_patient": fake.boolean(),
                "patient_relationship_to_subscriber": fake.random_element(elements=('self', 'spouse', 'child', 'other')),
                "photo_back": fake.image_url(),
                "photo_front": fake.image_url(),
                "subscriber_address": fake.address(),
                "subscriber_city": fake.city(),
                "subscriber_country": fake.country(),
                "subscriber_date_of_birth": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "subscriber_first_name": fake.first_name(),
                "subscriber_gender": fake.random_elements(elements=('Male', 'Female', 'Transgender', 'Queer', 'Other')),
                "subscriber_last_name": fake.last_name(),
                "subscriber_middle_name": fake.first_name(),
                "subscriber_social_security": fake.ssn(),
                "subscriber_state": fake.state(),
                "subscriber_suffix": fake.suffix(),
                "subscriber_zip_code": fake.zipcode()
            },
            "updated_at": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
            "workers_comp_insurance": {
                "property_and_casualty_agency_claim_number": fake.numerify(text='#########'),
                "workers_comp_carrier_code": fake.numerify(text='#########'),
                "workers_comp_case_number": fake.numerify(text='######'),
                "workers_comp_company": fake.company(),
                "workers_comp_date_of_accident": fake.date_time_between(start_date=start_date, end_date=end_date).isoformat(),
                "workers_comp_group_name": fake.company(),
                "workers_comp_group_number": fake.numerify(text='#########'),
                "workers_comp_notes": fake.text(),
                "workers_comp_payer_address": fake.address(),
                "workers_comp_payer_city": fake.city(),
                "workers_comp_payer_id": fake.numerify(text='#########'),
                "workers_comp_payer_state": fake.state(),
                "workers_comp_payer_zip": fake.zipcode(),
                "workers_comp_state_of_occurrence": fake.state(),
                "workers_comp_wcb": fake.numerify(text='#########'),
                "workers_comp_wcb_rating_code": fake.numerify(text='###')
            },
            "zip_code": fake.zipcode()
        }

        list_response.append(dictionaryResponse)

    return list_response

    