# Developer Certificate of Origin

We respect intellectual property rights and want to make sure that all incoming
contributions are correctly attributed and licensed. The Developer Certificate of Origin
(or "DCO" for short) is a lightweight mechanism to help us do this. In essence, the DCO
ensures that every contribution to this project:

1. Is originally authored by the person contributing it, and/or
2. Is submitted with the understanding that the person contributing it has the
   appropriate rights to do so.

The full text of the DCO can be found [below](#dco-v11-full-text) or at its official
source: <http://developercertificate.org>

## Our Process

In the body of every pull request that you submit to this repository, you'll be prompted
to check a box that looks like this:

> - [x] This contribution fully complies with the Developer Certificate of Origin.

Checking that box signifies that you've read through the **full text** of the DCO and
that it holds true for the **entire** contents of your pull request. Every single PR
made to this project **must** have that box checked before it can be reviewed, accepted,
and merged into our codebase.

Conventionally, projects that use the DCO require contributors to "sign off" on every
`git commit`, and often enforce the use of real names and/or email addresses. While it's
true that those policies are advantageous for legal reasons, we don't feel that it's
necessary to impose those requirements on contributors to this particular project.
Pseudonyms and anonymity are acceptable, and we'll take your word for it when you check
the box that affirms your compliance with the DCO.

## Further Reading

If you'd like to learn more about the DCO, how it protects contributors, or why we (and
many other projects) have chosen to use it, these are some great articles to read:

- [The Developer Certificate of Origin is a great alternative to a CLA](https://drewdevault.com/2021/04/12/DCO.html)
- [Developer Certificate of Origin versus Contributor License Agreements](https://julien.ponge.org/blog/developer-certificate-of-origin-versus-contributor-license-agreements/)
- [The most powerful contributor agreement](https://lwn.net/Articles/592503/)

## DCO v1.1 Full Text

```text
Developer Certificate of Origin
Version 1.1

Copyright (C) 2004, 2006 The Linux Foundation and its contributors.

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.


Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.
```
