"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_lambda_1 = require("monocdk/aws-lambda");
/**
 * Lambda functions are created within VPCs - (Control IDs: AC-4, SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_lambda_1.CfnFunction) {
        //Check for a VPC configuration
        const vpcConfig = monocdk_1.Stack.of(node).resolve(node.vpcConfig);
        if (vpcConfig == undefined) {
            return false;
        }
        else {
            const secgroups = monocdk_1.Stack.of(node).resolve(vpcConfig.securityGroupIds);
            const subnets = monocdk_1.Stack.of(node).resolve(vpcConfig.subnetIds);
            //Does this function exist within at least one VPC security group or subnet?
            if (secgroups == undefined || secgroups.length == 0) {
                if (subnets == undefined || subnets.length == 0) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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