"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_logs_1 = require("monocdk/aws-logs");
/**
 * CloudWatch Log Groups are encrypted with KMS Customer Master Keys (CMK) - (Control IDs: AU-9, SC-13, SC-28)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_logs_1.CfnLogGroup) {
        if (node.kmsKeyId == undefined) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzQ2xvdWRXYXRjaExvZ0dyb3VwRW5jcnlwdGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL05JU1QtODAwLTUzL3J1bGVzL2Nsb3Vkd2F0Y2gvbmlzdDgwMDUzQ2xvdWRXYXRjaExvZ0dyb3VwRW5jcnlwdGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0VBR0U7O0FBR0YsK0NBQStDO0FBRS9DOzs7R0FHRztBQUNILG1CQUF5QixJQUFnQjtJQUN2QyxJQUFJLElBQUksWUFBWSxzQkFBVyxFQUFFO1FBQy9CLElBQUksSUFBSSxDQUFDLFFBQVEsSUFBSSxTQUFTLEVBQUU7WUFDOUIsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBUEQsNEJBT0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cblxuaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuTG9nR3JvdXAgfSBmcm9tICdtb25vY2RrL2F3cy1sb2dzJztcblxuLyoqXG4gKiBDbG91ZFdhdGNoIExvZyBHcm91cHMgYXJlIGVuY3J5cHRlZCB3aXRoIEtNUyBDdXN0b21lciBNYXN0ZXIgS2V5cyAoQ01LKSAtIChDb250cm9sIElEczogQVUtOSwgU0MtMTMsIFNDLTI4KVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBJQ29uc3RydWN0KTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuTG9nR3JvdXApIHtcbiAgICBpZiAobm9kZS5rbXNLZXlJZCA9PSB1bmRlZmluZWQpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=