"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
/**
 * S3 Buckets should have public access restricted and blocked.
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        if (node.publicAccessBlockConfiguration == undefined) {
            return false;
        }
        const publicAccess = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        if (publicAccess.blockPublicAcls == undefined ||
            publicAccess.blockPublicPolicy == undefined ||
            publicAccess.ignorePublicAcls == undefined ||
            publicAccess.restrictPublicBuckets == undefined) {
            return false;
        }
        const blockPublicAcls = monocdk_1.Stack.of(node).resolve(publicAccess.blockPublicAcls);
        const blockPublicPolicy = monocdk_1.Stack.of(node).resolve(publicAccess.blockPublicPolicy);
        const ignorePublicAcls = monocdk_1.Stack.of(node).resolve(publicAccess.ignorePublicAcls);
        const restrictPublicBuckets = monocdk_1.Stack.of(node).resolve(publicAccess.restrictPublicBuckets);
        if (blockPublicAcls == false ||
            blockPublicPolicy == false ||
            ignorePublicAcls == false ||
            restrictPublicBuckets == false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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