"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_mediastore_1 = require("monocdk/aws-mediastore");
/**
 * Media Store containers define metric policies to send metrics to CloudWatch
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_mediastore_1.CfnContainer) {
        const metricPolicy = monocdk_1.Stack.of(node).resolve(node.metricPolicy);
        if (metricPolicy == undefined) {
            return false;
        }
        const containerLevelMetrics = monocdk_1.Stack.of(node).resolve(metricPolicy.containerLevelMetrics);
        if (containerLevelMetrics != 'ENABLED') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTVM0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9tZWRpYV9zZXJ2aWNlcy9NUzQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNEM7QUFDNUMsMkRBQXNEO0FBRXREOzs7R0FHRztBQUNILG1CQUF5QixJQUFnQjtJQUN2QyxJQUFJLElBQUksWUFBWSw2QkFBWSxFQUFFO1FBQ2hDLE1BQU0sWUFBWSxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUMvRCxJQUFJLFlBQVksSUFBSSxTQUFTLEVBQUU7WUFDN0IsT0FBTyxLQUFLLENBQUM7U0FDZDtRQUNELE1BQU0scUJBQXFCLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ2xELFlBQVksQ0FBQyxxQkFBcUIsQ0FDbkMsQ0FBQztRQUNGLElBQUkscUJBQXFCLElBQUksU0FBUyxFQUFFO1lBQ3RDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWRELDRCQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBJQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuQ29udGFpbmVyIH0gZnJvbSAnbW9ub2Nkay9hd3MtbWVkaWFzdG9yZSc7XG5cbi8qKlxuICogTWVkaWEgU3RvcmUgY29udGFpbmVycyBkZWZpbmUgbWV0cmljIHBvbGljaWVzIHRvIHNlbmQgbWV0cmljcyB0byBDbG91ZFdhdGNoXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IElDb25zdHJ1Y3QpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5Db250YWluZXIpIHtcbiAgICBjb25zdCBtZXRyaWNQb2xpY3kgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKG5vZGUubWV0cmljUG9saWN5KTtcbiAgICBpZiAobWV0cmljUG9saWN5ID09IHVuZGVmaW5lZCkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgICBjb25zdCBjb250YWluZXJMZXZlbE1ldHJpY3MgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgbWV0cmljUG9saWN5LmNvbnRhaW5lckxldmVsTWV0cmljcyxcbiAgICApO1xuICAgIGlmIChjb250YWluZXJMZXZlbE1ldHJpY3MgIT0gJ0VOQUJMRUQnKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19