"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
/**
 * Auto Scaling Groups have properly configured health checks
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        const healthCheckType = monocdk_1.Stack.of(node).resolve(node.healthCheckType);
        const healthCheckGracePeriod = monocdk_1.Stack.of(node).resolve(node.healthCheckGracePeriod);
        if (healthCheckType != undefined &&
            healthCheckType == 'ELB' &&
            healthCheckGracePeriod == undefined) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQVMyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9tYW5hZ2VtZW50X2FuZF9nb3Zlcm5hbmNlL0FTMi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHFDQUE0QztBQUM1Qyw2REFBOEQ7QUFFOUQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWdCO0lBQ3ZDLElBQUksSUFBSSxZQUFZLHFDQUFtQixFQUFFO1FBQ3ZDLE1BQU0sZUFBZSxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUNyRSxNQUFNLHNCQUFzQixHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUNuRCxJQUFJLENBQUMsc0JBQXNCLENBQzVCLENBQUM7UUFDRixJQUNFLGVBQWUsSUFBSSxTQUFTO1lBQzVCLGVBQWUsSUFBSSxLQUFLO1lBQ3hCLHNCQUFzQixJQUFJLFNBQVMsRUFDbkM7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFmRCw0QkFlQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgSUNvbnN0cnVjdCwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkF1dG9TY2FsaW5nR3JvdXAgfSBmcm9tICdtb25vY2RrL2F3cy1hdXRvc2NhbGluZyc7XG5cbi8qKlxuICogQXV0byBTY2FsaW5nIEdyb3VwcyBoYXZlIHByb3Blcmx5IGNvbmZpZ3VyZWQgaGVhbHRoIGNoZWNrc1xuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBJQ29uc3RydWN0KTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuQXV0b1NjYWxpbmdHcm91cCkge1xuICAgIGNvbnN0IGhlYWx0aENoZWNrVHlwZSA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5oZWFsdGhDaGVja1R5cGUpO1xuICAgIGNvbnN0IGhlYWx0aENoZWNrR3JhY2VQZXJpb2QgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgbm9kZS5oZWFsdGhDaGVja0dyYWNlUGVyaW9kLFxuICAgICk7XG4gICAgaWYgKFxuICAgICAgaGVhbHRoQ2hlY2tUeXBlICE9IHVuZGVmaW5lZCAmJlxuICAgICAgaGVhbHRoQ2hlY2tUeXBlID09ICdFTEInICYmXG4gICAgICBoZWFsdGhDaGVja0dyYWNlUGVyaW9kID09IHVuZGVmaW5lZFxuICAgICkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==