# coding: utf-8

"""
    EdgeGallery MEC Service Management API

    The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI  # noqa: E501

    OpenAPI spec version: 2.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from edgegallery_sdk_mep.api_client import ApiClient


class AppServicesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_services_get(self, app_instance_id, **kwargs):  # noqa: E501
        """app_services_get  # noqa: E501

        This method retrieves information about a list of mecService resources. This method is typically used in \"service availability query\" procedure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_get(app_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param list[str] ser_instance_id: A MEC application instance may use multiple ser_instance_ids as an input parameter to query the availability of a list of MEC service instances. Either \"ser_instance_id\" or \"ser_name\" or \"ser_category_id\" or none of them shall be present.
        :param list[str] ser_name: A MEC application instance may use multiple ser_names as an input parameter to query the availability of a list of MEC service instances. Either \"ser_instance_id\" or \"ser_name\" or \"ser_category_id\" or none of them shall be present.
        :param str ser_category_id: A MEC application instance may use ser_category_id as an input parameter to query the availability of a list of MEC service instances in a serCategory. Either \"ser_instance_id\" or \"ser_name\" or \"ser_category_id\" or none of them shall be present.
        :param bool consumed_local_only: Indicate whether the service can only be consumed by the MEC  applications located in the same locality (as defined by  scopeOfLocality) as this service instance.
        :param bool is_local: Indicate whether the service is located in the same locality (as  defined by scopeOfLocality) as the consuming MEC application.
        :param str scope_of_locality: A MEC application instance may use scope_of_locality as an input  parameter to query the availability of a list of MEC service instances  with a certain scope of locality.
        :return: list[ServiceInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.app_services_get_with_http_info(app_instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.app_services_get_with_http_info(app_instance_id, **kwargs)  # noqa: E501
            return data

    def app_services_get_with_http_info(self, app_instance_id, **kwargs):  # noqa: E501
        """app_services_get  # noqa: E501

        This method retrieves information about a list of mecService resources. This method is typically used in \"service availability query\" procedure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_get_with_http_info(app_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param list[str] ser_instance_id: A MEC application instance may use multiple ser_instance_ids as an input parameter to query the availability of a list of MEC service instances. Either \"ser_instance_id\" or \"ser_name\" or \"ser_category_id\" or none of them shall be present.
        :param list[str] ser_name: A MEC application instance may use multiple ser_names as an input parameter to query the availability of a list of MEC service instances. Either \"ser_instance_id\" or \"ser_name\" or \"ser_category_id\" or none of them shall be present.
        :param str ser_category_id: A MEC application instance may use ser_category_id as an input parameter to query the availability of a list of MEC service instances in a serCategory. Either \"ser_instance_id\" or \"ser_name\" or \"ser_category_id\" or none of them shall be present.
        :param bool consumed_local_only: Indicate whether the service can only be consumed by the MEC  applications located in the same locality (as defined by  scopeOfLocality) as this service instance.
        :param bool is_local: Indicate whether the service is located in the same locality (as  defined by scopeOfLocality) as the consuming MEC application.
        :param str scope_of_locality: A MEC application instance may use scope_of_locality as an input  parameter to query the availability of a list of MEC service instances  with a certain scope of locality.
        :return: list[ServiceInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['app_instance_id', 'ser_instance_id', 'ser_name', 'ser_category_id', 'consumed_local_only', 'is_local', 'scope_of_locality']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_services_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'app_instance_id' is set
        if ('app_instance_id' not in params or
                params['app_instance_id'] is None):
            raise ValueError("Missing the required parameter `app_instance_id` when calling `app_services_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_instance_id' in params:
            path_params['appInstanceId'] = params['app_instance_id']  # noqa: E501

        query_params = []
        if 'ser_instance_id' in params:
            query_params.append(('ser_instance_id', params['ser_instance_id']))  # noqa: E501
            collection_formats['ser_instance_id'] = 'multi'  # noqa: E501
        if 'ser_name' in params:
            query_params.append(('ser_name', params['ser_name']))  # noqa: E501
            collection_formats['ser_name'] = 'multi'  # noqa: E501
        if 'ser_category_id' in params:
            query_params.append(('ser_category_id', params['ser_category_id']))  # noqa: E501
        if 'consumed_local_only' in params:
            query_params.append(('consumed_local_only', params['consumed_local_only']))  # noqa: E501
        if 'is_local' in params:
            query_params.append(('is_local', params['is_local']))  # noqa: E501
        if 'scope_of_locality' in params:
            query_params.append(('scope_of_locality', params['scope_of_locality']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ServiceInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_services_post(self, body, app_instance_id, **kwargs):  # noqa: E501
        """app_services_post  # noqa: E501

        This method is used to create a mecService resource. This method is typically used in \"service availability update and new service registration\" procedure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_post(body, app_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServiceInfoPost body: New ServiceInfo with updated "state" is included as entity body of the request (required)
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :return: ServiceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.app_services_post_with_http_info(body, app_instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.app_services_post_with_http_info(body, app_instance_id, **kwargs)  # noqa: E501
            return data

    def app_services_post_with_http_info(self, body, app_instance_id, **kwargs):  # noqa: E501
        """app_services_post  # noqa: E501

        This method is used to create a mecService resource. This method is typically used in \"service availability update and new service registration\" procedure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_post_with_http_info(body, app_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServiceInfoPost body: New ServiceInfo with updated "state" is included as entity body of the request (required)
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :return: ServiceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'app_instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_services_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `app_services_post`")  # noqa: E501
        # verify the required parameter 'app_instance_id' is set
        if ('app_instance_id' not in params or
                params['app_instance_id'] is None):
            raise ValueError("Missing the required parameter `app_instance_id` when calling `app_services_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_instance_id' in params:
            path_params['appInstanceId'] = params['app_instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_services_service_id_delete(self, app_instance_id, service_id, **kwargs):  # noqa: E501
        """app_services_service_id_delete  # noqa: E501

        This method deletes a mecService resource. This method is typically used in the service deregistration procedure.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_service_id_delete(app_instance_id, service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str service_id: Represents a MEC service instance. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.app_services_service_id_delete_with_http_info(app_instance_id, service_id, **kwargs)  # noqa: E501
        else:
            (data) = self.app_services_service_id_delete_with_http_info(app_instance_id, service_id, **kwargs)  # noqa: E501
            return data

    def app_services_service_id_delete_with_http_info(self, app_instance_id, service_id, **kwargs):  # noqa: E501
        """app_services_service_id_delete  # noqa: E501

        This method deletes a mecService resource. This method is typically used in the service deregistration procedure.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_service_id_delete_with_http_info(app_instance_id, service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str service_id: Represents a MEC service instance. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['app_instance_id', 'service_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_services_service_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'app_instance_id' is set
        if ('app_instance_id' not in params or
                params['app_instance_id'] is None):
            raise ValueError("Missing the required parameter `app_instance_id` when calling `app_services_service_id_delete`")  # noqa: E501
        # verify the required parameter 'service_id' is set
        if ('service_id' not in params or
                params['service_id'] is None):
            raise ValueError("Missing the required parameter `service_id` when calling `app_services_service_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_instance_id' in params:
            path_params['appInstanceId'] = params['app_instance_id']  # noqa: E501
        if 'service_id' in params:
            path_params['serviceId'] = params['service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/problem+json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services/{serviceId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_services_service_id_get(self, app_instance_id, service_id, **kwargs):  # noqa: E501
        """app_services_service_id_get  # noqa: E501

        This method retrieves information about a mecService resource. This method is typically used in \"service availability query\" procedure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_service_id_get(app_instance_id, service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str service_id: Represents a MEC service instance. (required)
        :return: ServiceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.app_services_service_id_get_with_http_info(app_instance_id, service_id, **kwargs)  # noqa: E501
        else:
            (data) = self.app_services_service_id_get_with_http_info(app_instance_id, service_id, **kwargs)  # noqa: E501
            return data

    def app_services_service_id_get_with_http_info(self, app_instance_id, service_id, **kwargs):  # noqa: E501
        """app_services_service_id_get  # noqa: E501

        This method retrieves information about a mecService resource. This method is typically used in \"service availability query\" procedure  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_service_id_get_with_http_info(app_instance_id, service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str service_id: Represents a MEC service instance. (required)
        :return: ServiceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['app_instance_id', 'service_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_services_service_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'app_instance_id' is set
        if ('app_instance_id' not in params or
                params['app_instance_id'] is None):
            raise ValueError("Missing the required parameter `app_instance_id` when calling `app_services_service_id_get`")  # noqa: E501
        # verify the required parameter 'service_id' is set
        if ('service_id' not in params or
                params['service_id'] is None):
            raise ValueError("Missing the required parameter `service_id` when calling `app_services_service_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_instance_id' in params:
            path_params['appInstanceId'] = params['app_instance_id']  # noqa: E501
        if 'service_id' in params:
            path_params['serviceId'] = params['service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services/{serviceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_services_service_id_put(self, body, app_instance_id, service_id, **kwargs):  # noqa: E501
        """app_services_service_id_put  # noqa: E501

        This method updates the information about a mecService resource  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_service_id_put(body, app_instance_id, service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServiceInfo body: New ServiceInfo with updated "state" is included as entity body of the request (required)
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str service_id: Represents a MEC service instance. (required)
        :return: ServiceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.app_services_service_id_put_with_http_info(body, app_instance_id, service_id, **kwargs)  # noqa: E501
        else:
            (data) = self.app_services_service_id_put_with_http_info(body, app_instance_id, service_id, **kwargs)  # noqa: E501
            return data

    def app_services_service_id_put_with_http_info(self, body, app_instance_id, service_id, **kwargs):  # noqa: E501
        """app_services_service_id_put  # noqa: E501

        This method updates the information about a mecService resource  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_services_service_id_put_with_http_info(body, app_instance_id, service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServiceInfo body: New ServiceInfo with updated "state" is included as entity body of the request (required)
        :param str app_instance_id: Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager. (required)
        :param str service_id: Represents a MEC service instance. (required)
        :return: ServiceInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'app_instance_id', 'service_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_services_service_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `app_services_service_id_put`")  # noqa: E501
        # verify the required parameter 'app_instance_id' is set
        if ('app_instance_id' not in params or
                params['app_instance_id'] is None):
            raise ValueError("Missing the required parameter `app_instance_id` when calling `app_services_service_id_put`")  # noqa: E501
        # verify the required parameter 'service_id' is set
        if ('service_id' not in params or
                params['service_id'] is None):
            raise ValueError("Missing the required parameter `service_id` when calling `app_services_service_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_instance_id' in params:
            path_params['appInstanceId'] = params['app_instance_id']  # noqa: E501
        if 'service_id' in params:
            path_params['serviceId'] = params['service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services/{serviceId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
