# edgegallery_sdk_mep
The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.1.1
- Package version: 1.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import edgegallery_sdk_mep 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import edgegallery_sdk_mep
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import edgegallery_sdk_mep
from edgegallery_sdk_mep.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = edgegallery_sdk_mep.AppServicesApi(edgegallery_sdk_mep.ApiClient(configuration))
app_instance_id = 'app_instance_id_example' # str | Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager.
ser_instance_id = ['ser_instance_id_example'] # list[str] | A MEC application instance may use multiple ser_instance_ids as an input parameter to query the availability of a list of MEC service instances. Either \"ser_instance_id\" or \"ser_name\" or \"ser_category_id\" or none of them shall be present. (optional)
ser_name = ['ser_name_example'] # list[str] | A MEC application instance may use multiple ser_names as an input parameter to query the availability of a list of MEC service instances. Either \"ser_instance_id\" or \"ser_name\" or \"ser_category_id\" or none of them shall be present. (optional)
ser_category_id = 'ser_category_id_example' # str | A MEC application instance may use ser_category_id as an input parameter to query the availability of a list of MEC service instances in a serCategory. Either \"ser_instance_id\" or \"ser_name\" or \"ser_category_id\" or none of them shall be present. (optional)
consumed_local_only = true # bool | Indicate whether the service can only be consumed by the MEC  applications located in the same locality (as defined by  scopeOfLocality) as this service instance. (optional)
is_local = true # bool | Indicate whether the service is located in the same locality (as  defined by scopeOfLocality) as the consuming MEC application. (optional)
scope_of_locality = 'scope_of_locality_example' # str | A MEC application instance may use scope_of_locality as an input  parameter to query the availability of a list of MEC service instances  with a certain scope of locality. (optional)

try:
    api_response = api_instance.app_services_get(app_instance_id, ser_instance_id=ser_instance_id, ser_name=ser_name, ser_category_id=ser_category_id, consumed_local_only=consumed_local_only, is_local=is_local, scope_of_locality=scope_of_locality)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AppServicesApi->app_services_get: %s\n" % e)

# create an instance of the API class
api_instance = edgegallery_sdk_mep.AppServicesApi(edgegallery_sdk_mep.ApiClient(configuration))
body = edgegallery_sdk_mep.ServiceInfoPost() # ServiceInfoPost | New ServiceInfo with updated "state" is included as entity body of the request
app_instance_id = 'app_instance_id_example' # str | Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager.

try:
    api_response = api_instance.app_services_post(body, app_instance_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AppServicesApi->app_services_post: %s\n" % e)

# create an instance of the API class
api_instance = edgegallery_sdk_mep.AppServicesApi(edgegallery_sdk_mep.ApiClient(configuration))
app_instance_id = 'app_instance_id_example' # str | Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager.
service_id = 'service_id_example' # str | Represents a MEC service instance.

try:
    api_instance.app_services_service_id_delete(app_instance_id, service_id)
except ApiException as e:
    print("Exception when calling AppServicesApi->app_services_service_id_delete: %s\n" % e)

# create an instance of the API class
api_instance = edgegallery_sdk_mep.AppServicesApi(edgegallery_sdk_mep.ApiClient(configuration))
app_instance_id = 'app_instance_id_example' # str | Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager.
service_id = 'service_id_example' # str | Represents a MEC service instance.

try:
    api_response = api_instance.app_services_service_id_get(app_instance_id, service_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AppServicesApi->app_services_service_id_get: %s\n" % e)

# create an instance of the API class
api_instance = edgegallery_sdk_mep.AppServicesApi(edgegallery_sdk_mep.ApiClient(configuration))
body = edgegallery_sdk_mep.ServiceInfo() # ServiceInfo | New ServiceInfo with updated "state" is included as entity body of the request
app_instance_id = 'app_instance_id_example' # str | Represents a MEC application instance. Note that the appInstanceId is allocated by the MEC platform manager.
service_id = 'service_id_example' # str | Represents a MEC service instance.

try:
    api_response = api_instance.app_services_service_id_put(body, app_instance_id, service_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AppServicesApi->app_services_service_id_put: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://{apigw_ip}:{apigw_port}*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AppServicesApi* | [**app_services_get**](docs/AppServicesApi.md#app_services_get) | **GET** /mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services | 
*AppServicesApi* | [**app_services_post**](docs/AppServicesApi.md#app_services_post) | **POST** /mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services | 
*AppServicesApi* | [**app_services_service_id_delete**](docs/AppServicesApi.md#app_services_service_id_delete) | **DELETE** /mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services/{serviceId} | 
*AppServicesApi* | [**app_services_service_id_get**](docs/AppServicesApi.md#app_services_service_id_get) | **GET** /mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services/{serviceId} | 
*AppServicesApi* | [**app_services_service_id_put**](docs/AppServicesApi.md#app_services_service_id_put) | **PUT** /mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/services/{serviceId} | 
*AppSubscriptionsApi* | [**applications_subscription_delete**](docs/AppSubscriptionsApi.md#applications_subscription_delete) | **DELETE** /mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/subscriptions/{subscriptionId} | 
*AppSubscriptionsApi* | [**applications_subscription_get**](docs/AppSubscriptionsApi.md#applications_subscription_get) | **GET** /mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/subscriptions/{subscriptionId} | 
*AppSubscriptionsApi* | [**applications_subscriptions_get**](docs/AppSubscriptionsApi.md#applications_subscriptions_get) | **GET** /mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/subscriptions | 
*AppSubscriptionsApi* | [**applications_subscriptions_post**](docs/AppSubscriptionsApi.md#applications_subscriptions_post) | **POST** /mepserver/mec_service_mgmt/v1/applications/{appInstanceId}/subscriptions | 
*ServicesApi* | [**services_get**](docs/ServicesApi.md#services_get) | **GET** /mepserver/mec_service_mgmt/v1/services | 
*ServicesApi* | [**services_service_id_get**](docs/ServicesApi.md#services_service_id_get) | **GET** /mepserver/mec_service_mgmt/v1/services/{serviceId} | 
*TokenApi* | [**mepauth_mepauth_v1_token_post**](docs/TokenApi.md#mepauth_mepauth_v1_token_post) | **POST** /mepauth/mepauth/v1/token | 

## Documentation For Models

 - [CategoryRef](docs/CategoryRef.md)
 - [CategoryRefHref](docs/CategoryRefHref.md)
 - [CategoryRefId](docs/CategoryRefId.md)
 - [CategoryRefName](docs/CategoryRefName.md)
 - [CategoryRefVersion](docs/CategoryRefVersion.md)
 - [CategoryRefs](docs/CategoryRefs.md)
 - [Empty](docs/Empty.md)
 - [EndPointInfoAddress](docs/EndPointInfoAddress.md)
 - [EndPointInfoAddressHost](docs/EndPointInfoAddressHost.md)
 - [EndPointInfoAddressPort](docs/EndPointInfoAddressPort.md)
 - [EndPointInfoAddresses](docs/EndPointInfoAddresses.md)
 - [EndPointInfoAlternative](docs/EndPointInfoAlternative.md)
 - [EndPointInfoUri](docs/EndPointInfoUri.md)
 - [EndPointInfoUris](docs/EndPointInfoUris.md)
 - [Href](docs/Href.md)
 - [LinkType](docs/LinkType.md)
 - [LocalityType](docs/LocalityType.md)
 - [MecServiceMgmtApiSubscriptionLinkList](docs/MecServiceMgmtApiSubscriptionLinkList.md)
 - [MecServiceMgmtApiSubscriptionLinkListLinks](docs/MecServiceMgmtApiSubscriptionLinkListLinks.md)
 - [MecServiceMgmtApiSubscriptionLinkListSubscription](docs/MecServiceMgmtApiSubscriptionLinkListSubscription.md)
 - [ModelSelf](docs/ModelSelf.md)
 - [OneOfServiceInfoPost](docs/OneOfServiceInfoPost.md)
 - [OneOfTransportInfoEndpoint](docs/OneOfTransportInfoEndpoint.md)
 - [ProblemDetail](docs/ProblemDetail.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [ProblemInstance](docs/ProblemInstance.md)
 - [ProblemStatus](docs/ProblemStatus.md)
 - [ProblemTitle](docs/ProblemTitle.md)
 - [ProblemType](docs/ProblemType.md)
 - [SecurityInfo](docs/SecurityInfo.md)
 - [SecurityInfoOAuth2Info](docs/SecurityInfoOAuth2Info.md)
 - [SecurityInfoOAuth2InfoGrantType](docs/SecurityInfoOAuth2InfoGrantType.md)
 - [SecurityInfoOAuth2InfoGrantTypes](docs/SecurityInfoOAuth2InfoGrantTypes.md)
 - [SecurityInfoOAuth2InfoTokenEndpoint](docs/SecurityInfoOAuth2InfoTokenEndpoint.md)
 - [SerAvailabilityNotificationSubscription](docs/SerAvailabilityNotificationSubscription.md)
 - [SerAvailabilityNotificationSubscriptionCallbackReference](docs/SerAvailabilityNotificationSubscriptionCallbackReference.md)
 - [SerAvailabilityNotificationSubscriptionFilteringCriteria](docs/SerAvailabilityNotificationSubscriptionFilteringCriteria.md)
 - [SerAvailabilityNotificationSubscriptionSubscriptionType](docs/SerAvailabilityNotificationSubscriptionSubscriptionType.md)
 - [SerInstanceIds](docs/SerInstanceIds.md)
 - [SerNames](docs/SerNames.md)
 - [SerializerType](docs/SerializerType.md)
 - [ServiceAvailabilityNotification](docs/ServiceAvailabilityNotification.md)
 - [ServiceAvailabilityNotificationChangeType](docs/ServiceAvailabilityNotificationChangeType.md)
 - [ServiceAvailabilityNotificationServiceReferences](docs/ServiceAvailabilityNotificationServiceReferences.md)
 - [ServiceInfo](docs/ServiceInfo.md)
 - [ServiceInfoConsumedLocalOnly](docs/ServiceInfoConsumedLocalOnly.md)
 - [ServiceInfoIsLocal](docs/ServiceInfoIsLocal.md)
 - [ServiceInfoPost](docs/ServiceInfoPost.md)
 - [ServiceInfoSerInstanceId](docs/ServiceInfoSerInstanceId.md)
 - [ServiceInfoSerName](docs/ServiceInfoSerName.md)
 - [ServiceInfoTransportId](docs/ServiceInfoTransportId.md)
 - [ServiceInfoVersion](docs/ServiceInfoVersion.md)
 - [ServiceState](docs/ServiceState.md)
 - [ServiceStates](docs/ServiceStates.md)
 - [Subscription](docs/Subscription.md)
 - [TokenInfo](docs/TokenInfo.md)
 - [TransportInfo](docs/TransportInfo.md)
 - [TransportInfoDescription](docs/TransportInfoDescription.md)
 - [TransportInfoId](docs/TransportInfoId.md)
 - [TransportInfoImplSpecificInfo](docs/TransportInfoImplSpecificInfo.md)
 - [TransportInfoName](docs/TransportInfoName.md)
 - [TransportInfoProtocol](docs/TransportInfoProtocol.md)
 - [TransportInfoVersion](docs/TransportInfoVersion.md)
 - [TransportType](docs/TransportType.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author


