import * as sns from '@aws-cdk/aws-sns';
import { SubscriptionProps } from './subscription';
/**
 * Options for SMS subscriptions.
 *
 * @stability stable
 */
export interface SmsSubscriptionProps extends SubscriptionProps {
}
/**
 * Use an sms address as a subscription target.
 *
 * @stability stable
 */
export declare class SmsSubscription implements sns.ITopicSubscription {
    private readonly phoneNumber;
    private readonly props;
    /**
     * @stability stable
     */
    constructor(phoneNumber: string, props?: SmsSubscriptionProps);
    /**
     * Returns a configuration used to subscribe to an SNS topic.
     *
     * @stability stable
     */
    bind(_topic: sns.ITopic): sns.TopicSubscriptionConfig;
}
