# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class NetworkComminglingTransactionEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'transaction_type': 'str',
        'posted_date': 'ModelDate',
        'net_co_transaction_id': 'str',
        'swap_reason': 'str',
        'asin': 'str',
        'marketplace_id': 'str',
        'tax_exclusive_amount': 'Currency',
        'tax_amount': 'Currency'
    }

    attribute_map = {
        'transaction_type': 'TransactionType',
        'posted_date': 'PostedDate',
        'net_co_transaction_id': 'NetCoTransactionID',
        'swap_reason': 'SwapReason',
        'asin': 'ASIN',
        'marketplace_id': 'MarketplaceId',
        'tax_exclusive_amount': 'TaxExclusiveAmount',
        'tax_amount': 'TaxAmount'
    }

    def __init__(self, transaction_type=None, posted_date=None, net_co_transaction_id=None, swap_reason=None, asin=None, marketplace_id=None, tax_exclusive_amount=None, tax_amount=None):  # noqa: E501
        """NetworkComminglingTransactionEvent - a model defined in Swagger"""  # noqa: E501
        self._transaction_type = None
        self._posted_date = None
        self._net_co_transaction_id = None
        self._swap_reason = None
        self._asin = None
        self._marketplace_id = None
        self._tax_exclusive_amount = None
        self._tax_amount = None
        self.discriminator = None
        if transaction_type is not None:
            self.transaction_type = transaction_type
        if posted_date is not None:
            self.posted_date = posted_date
        if net_co_transaction_id is not None:
            self.net_co_transaction_id = net_co_transaction_id
        if swap_reason is not None:
            self.swap_reason = swap_reason
        if asin is not None:
            self.asin = asin
        if marketplace_id is not None:
            self.marketplace_id = marketplace_id
        if tax_exclusive_amount is not None:
            self.tax_exclusive_amount = tax_exclusive_amount
        if tax_amount is not None:
            self.tax_amount = tax_amount

    @property
    def transaction_type(self):
        """Gets the transaction_type of this NetworkComminglingTransactionEvent.  # noqa: E501

        The type of network item swap.  Possible values:  * NetCo - A Fulfillment by Amazon inventory pooling transaction. Available only in the India marketplace.  * ComminglingVAT - A commingling VAT transaction. Available only in the UK, Spain, France, Germany, and Italy marketplaces.  # noqa: E501

        :return: The transaction_type of this NetworkComminglingTransactionEvent.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this NetworkComminglingTransactionEvent.

        The type of network item swap.  Possible values:  * NetCo - A Fulfillment by Amazon inventory pooling transaction. Available only in the India marketplace.  * ComminglingVAT - A commingling VAT transaction. Available only in the UK, Spain, France, Germany, and Italy marketplaces.  # noqa: E501

        :param transaction_type: The transaction_type of this NetworkComminglingTransactionEvent.  # noqa: E501
        :type: str
        """

        self._transaction_type = transaction_type

    @property
    def posted_date(self):
        """Gets the posted_date of this NetworkComminglingTransactionEvent.  # noqa: E501


        :return: The posted_date of this NetworkComminglingTransactionEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this NetworkComminglingTransactionEvent.


        :param posted_date: The posted_date of this NetworkComminglingTransactionEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def net_co_transaction_id(self):
        """Gets the net_co_transaction_id of this NetworkComminglingTransactionEvent.  # noqa: E501

        The identifier for the network item swap.  # noqa: E501

        :return: The net_co_transaction_id of this NetworkComminglingTransactionEvent.  # noqa: E501
        :rtype: str
        """
        return self._net_co_transaction_id

    @net_co_transaction_id.setter
    def net_co_transaction_id(self, net_co_transaction_id):
        """Sets the net_co_transaction_id of this NetworkComminglingTransactionEvent.

        The identifier for the network item swap.  # noqa: E501

        :param net_co_transaction_id: The net_co_transaction_id of this NetworkComminglingTransactionEvent.  # noqa: E501
        :type: str
        """

        self._net_co_transaction_id = net_co_transaction_id

    @property
    def swap_reason(self):
        """Gets the swap_reason of this NetworkComminglingTransactionEvent.  # noqa: E501

        The reason for the network item swap.  # noqa: E501

        :return: The swap_reason of this NetworkComminglingTransactionEvent.  # noqa: E501
        :rtype: str
        """
        return self._swap_reason

    @swap_reason.setter
    def swap_reason(self, swap_reason):
        """Sets the swap_reason of this NetworkComminglingTransactionEvent.

        The reason for the network item swap.  # noqa: E501

        :param swap_reason: The swap_reason of this NetworkComminglingTransactionEvent.  # noqa: E501
        :type: str
        """

        self._swap_reason = swap_reason

    @property
    def asin(self):
        """Gets the asin of this NetworkComminglingTransactionEvent.  # noqa: E501

        The Amazon Standard Identification Number (ASIN) of the swapped item.  # noqa: E501

        :return: The asin of this NetworkComminglingTransactionEvent.  # noqa: E501
        :rtype: str
        """
        return self._asin

    @asin.setter
    def asin(self, asin):
        """Sets the asin of this NetworkComminglingTransactionEvent.

        The Amazon Standard Identification Number (ASIN) of the swapped item.  # noqa: E501

        :param asin: The asin of this NetworkComminglingTransactionEvent.  # noqa: E501
        :type: str
        """

        self._asin = asin

    @property
    def marketplace_id(self):
        """Gets the marketplace_id of this NetworkComminglingTransactionEvent.  # noqa: E501

        The marketplace in which the event took place.  # noqa: E501

        :return: The marketplace_id of this NetworkComminglingTransactionEvent.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_id

    @marketplace_id.setter
    def marketplace_id(self, marketplace_id):
        """Sets the marketplace_id of this NetworkComminglingTransactionEvent.

        The marketplace in which the event took place.  # noqa: E501

        :param marketplace_id: The marketplace_id of this NetworkComminglingTransactionEvent.  # noqa: E501
        :type: str
        """

        self._marketplace_id = marketplace_id

    @property
    def tax_exclusive_amount(self):
        """Gets the tax_exclusive_amount of this NetworkComminglingTransactionEvent.  # noqa: E501


        :return: The tax_exclusive_amount of this NetworkComminglingTransactionEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._tax_exclusive_amount

    @tax_exclusive_amount.setter
    def tax_exclusive_amount(self, tax_exclusive_amount):
        """Sets the tax_exclusive_amount of this NetworkComminglingTransactionEvent.


        :param tax_exclusive_amount: The tax_exclusive_amount of this NetworkComminglingTransactionEvent.  # noqa: E501
        :type: Currency
        """

        self._tax_exclusive_amount = tax_exclusive_amount

    @property
    def tax_amount(self):
        """Gets the tax_amount of this NetworkComminglingTransactionEvent.  # noqa: E501


        :return: The tax_amount of this NetworkComminglingTransactionEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._tax_amount

    @tax_amount.setter
    def tax_amount(self, tax_amount):
        """Sets the tax_amount of this NetworkComminglingTransactionEvent.


        :param tax_amount: The tax_amount of this NetworkComminglingTransactionEvent.  # noqa: E501
        :type: Currency
        """

        self._tax_amount = tax_amount

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NetworkComminglingTransactionEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkComminglingTransactionEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
