"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBStreamToLambdaToElasticSearchAndKibana = void 0;
const aws_dynamodb_stream_lambda_1 = require("@aws-solutions-constructs/aws-dynamodb-stream-lambda");
const aws_lambda_elasticsearch_kibana_1 = require("@aws-solutions-constructs/aws-lambda-elasticsearch-kibana");
const core_1 = require("@aws-cdk/core");
class DynamoDBStreamToLambdaToElasticSearchAndKibana extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {DynamoDBStreamToLambdaToElasticSearchAndKibanaProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const _props1 = {
            deployLambda: props.deployLambda,
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            dynamoEventSourceProps: props.dynamoEventSourceProps,
            dynamoTableProps: props.dynamoTableProps
        };
        this.dynamoDBStreamToLambda = new aws_dynamodb_stream_lambda_1.DynamoDBStreamToLambda(this, 'DynamoDBStreamToLambda', _props1);
        this.lambdaFunction = this.dynamoDBStreamToLambda.lambdaFunction;
        const _props2 = {
            deployLambda: false,
            existingLambdaObj: this.lambdaFunction,
            domainName: props.domainName,
            esDomainProps: props.esDomainProps
        };
        this.lambdaToElasticSearchAndKibana = new aws_lambda_elasticsearch_kibana_1.LambdaToElasticSearchAndKibana(this, 'LambdaToElasticSearch', _props2);
        this.dynamoTable = this.dynamoDBStreamToLambda.dynamoTable;
        this.userPool = this.lambdaToElasticSearchAndKibana.userPool;
        this.userPoolClient = this.lambdaToElasticSearchAndKibana.userPoolClient;
        this.identityPool = this.lambdaToElasticSearchAndKibana.identityPool;
        this.elasticsearchDomain = this.lambdaToElasticSearchAndKibana.elasticsearchDomain;
        this.cloudwatchAlarms = this.lambdaToElasticSearchAndKibana.cloudwatchAlarms;
    }
}
exports.DynamoDBStreamToLambdaToElasticSearchAndKibana = DynamoDBStreamToLambdaToElasticSearchAndKibana;
//# sourceMappingURL=data:application/json;base64,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