import copy
import os
import pickle
import lief
import magic
from secml.array import CArray
from secml_malware.attack.blackbox.c_blackbox_problem import CBlackBoxProblem
from secml_malware.attack.blackbox.c_wrapper_phi import CWrapperPhi


class CGammaEvasionProblem(CBlackBoxProblem):
	def __init__(self,
				 section_population: list,
				 model_wrapper: CWrapperPhi,
				 population_size: int,
				 penalty_regularizer: float,
				 iterations: int,
				 seed: int = None,
				 is_debug: bool = False,
				 hard_label: bool = False,
				 threshold: float = 0.5,
				 loss: str = 'l1'):
		super(CGammaEvasionProblem, self).__init__(model_wrapper,
												   len(section_population),
												   population_size,
												   penalty_regularizer,
												   iterations,
												   seed,
												   is_debug,
												   hard_label,
												   threshold,
												   loss)

		self.section_population = section_population
		self.payload_max_size = sum([len(s) for s in section_population])

	# def compute_penalty_term(self, original_x : CArray, adv_x :CArray, par: float) -> float:
	# 	return par * abs(adv_x.shape[-1] - original_x.shape[-1]) / self.payload_max_size

	def apply_feasible_manipulations(self, t, x: CArray) -> CArray:
		x_adv = copy.deepcopy(x)
		for i in range(t.shape[-1]):
			content = self.section_population[i]
			content_to_append = content[:int(round(len(content) * t[i]))]
			x_adv = x_adv.append(content_to_append)
		x_adv = x_adv.reshape((1, x_adv.shape[-1]))
		return x_adv

	@classmethod
	def create_section_population_from_list(cls, folder, what_from_who):
		section_population = []
		for entry in what_from_who:
			what, who = entry
			path = os.path.join(folder, who)
			lief_pe_file = lief.PE.parse(path)
			for s in lief_pe_file.sections:
				if s.name == what:
					section_population.append(s.content)
		return section_population

	@classmethod
	def create_section_population_from_folder(cls, folder, how_many, sections_to_extract=None, cache_file=None,
											  size_lower_bound=None) -> (
			list, list):
		if sections_to_extract is None:
			sections_to_extract = [".data"]
		section_population = []
		counter = 0
		what_from_who = []
		if cache_file and os.path.isfile(cache_file):
			with open(cache_file, 'rb') as section_file:
				file_to_consider = pickle.load(section_file)
				file_to_consider = [f[1] for f in file_to_consider]
		else:
			file_to_consider = os.listdir(folder)
		for filename in file_to_consider:
			path = os.path.join(folder, filename)
			if "PE" not in magic.from_file(path):
				continue
			lief_pe_file = lief.PE.parse(path)
			for s in lief_pe_file.sections:
				if s.name in sections_to_extract:
					if size_lower_bound and len(s.content) < size_lower_bound:
						continue
					section_population.append(s.content)
					what_from_who.append((s.name, filename))
					counter += 1
			if counter >= how_many:
				break
		section_population = section_population[:how_many]
		if cache_file and not os.path.isfile(cache_file):
			with open(cache_file, 'wb') as section_file:
				pickle.dump(what_from_who, section_file)
		return section_population, what_from_who
