import struct
from copy import copy, deepcopy

from secml.array import CArray
from secml_malware.attack.blackbox.c_blackbox_problem import CBlackBoxProblem
from secml_malware.attack.blackbox.c_wrapper_phi import CWrapperPhi
import numpy as np

class CBlackBoxPaddingEvasionProblem(CBlackBoxProblem):
	def __init__(
			self,
			model_wrapper: CWrapperPhi,
			population_size: int,
			how_many_padding_bytes : int,
			iterations: int = 100,
			is_debug: bool = False,
			penalty_regularizer: float = 0,
			invalid_value: int = 256
	):
		super(CBlackBoxPaddingEvasionProblem, self).__init__(model_wrapper,
															latent_space_size=how_many_padding_bytes,
															iterations=iterations,
															population_size=population_size,
															is_debug=is_debug,
															penalty_regularizer=penalty_regularizer)

		self.invalid_value = invalid_value
		self.indexes_to_perturb = list(range(how_many_padding_bytes))

	def init_starting_point(self, x : CArray):
		self._original_x = x

	def apply_feasible_manipulations(self, t, x : CArray):
		byte_values = (t * 255).astype(np.int)
		x_adv = x.append(byte_values)
		return x_adv