"""tssc.StepImplementers for the 'security-static-code-analysis' TSSC step.

Step Configuration
------------------
All tssc.StepImplementers for this step should
accept minimally the following configuration options.

| Key               | Description
|-------------------|------------
| `url`             | URL to access the scanner tool

Results
-------
All tssc.StepImplementers for this step should
minimally produce the following step results.

| Result             | Description
|--------------------|------------
| `result`           | A dictionary describing the results of this step
| `report-artifacts` | An array of dictionaries describing artifacts \
                       generated by this step

"""

from .sonarqube import SonarQube

__all__ = [
    'sonarqube'
]
