#!/usr/bin/env python
# -*- coding: ascii -*-
# This Python Source Code Generated by XYmath

import numpy as np

def cd_nasa_8120( RupThroat ):
    '''
    Curve Fit Results from XYmath 10/17/2020
    Can be called with RupThroat=float or RupThroat=numpy array

    y = c0 + c1/RupThroat + c2/RupThroat**2 + c3/RupThroat**3
        c0 = 1.0022637143996103
        c1 = -0.017059016193610527
        c2 = 0.01277626158190225
        c3 = -0.006961923032422116
        RupThroat = RupThroat
        y = Y
        Correlation Coefficient = 0.9999737211640648
        Standard Deviation = 1.743637267837353e-05
        Percent Standard Deviation = 0.0017568504180035332%
    y = 1.0022637143996103 - 0.017059016193610527/RupThroat + 0.01277626158190225/RupThroat**2 - 0.006961923032422116/RupThroat**3

     (RupThroat,y) Data Pairs from 10/17/2020 Used in Curve Fit 
     (RupThroat,y) = (0.983842,0.990779),(1.02912,0.991402),(1.10426,0.992146),
        (1.19513,0.992848),(1.30025,0.993511),(1.4248,0.994162),
        (1.56628,0.994769),(1.73606,0.99535),(1.92025,0.995887),
        (2.13445,0.996363),(2.36017,0.996794),(2.59887,0.997187),
        (2.84453,0.997541),(3.0978,0.997852),(3.35741,0.998135),
        (3.62608,0.998385)

    '''
    try:
        if RupThroat<0.9838418704932093 or RupThroat>3.626081061574584:
            print( 'WARNING... RupThroat is outside range in cd_nasa_8120' )
            print( '  RupThroat =',RupThroat,' RupThroat range = (0.9838418704932093 to 3.626081061574584)' )
    except:
        if np.min(RupThroat)<0.9838418704932093 or np.max(RupThroat)>3.626081061574584:
            print( 'WARNING... RupThroat array contains elements outside data range in cd_nasa_8120' )
            outsideArr = RupThroat[ (RupThroat<0.9838418704932093) | (RupThroat>3.626081061574584) ]
            print( '  RupThroat violations =',outsideArr,' RupThroat range = (0.9838418704932093 to 3.626081061574584)' )
    
    return 1.0022637143996103 - 0.017059016193610527/RupThroat + 0.01277626158190225/RupThroat**2 - 0.006961923032422116/RupThroat**3

if __name__=='__main__':
    
    print( '='*44 )
    RuptestL = [0.9838418704932093, 2.304961466033897, 3.626081061574584, -0.01615812950679074, 4.626081061574585]
    yansL  = [0.9908132941763736, 0.9966989919545902, 0.9983848527771073, 1701.2668907886105, 0.9991028227936093]
    for RupThroat, ans in zip(RuptestL, yansL):
        y_test = cd_nasa_8120( RupThroat )
        print( 'y_test  =',y_test,' for Rup_test =',RupThroat, type(RupThroat))
        print( '     ans=',ans, type(ans) )
        print( '='*44 )
    RuptestArr = np.array( RuptestL )
    yansArr  = np.array( yansL )
    y_test   = cd_nasa_8120( RuptestArr )
    ans = np.array( yansL )
    print( 'y_testArr  =',y_test)
    print( '       ans =',ans, type(ans) )
    print( '  RuptestArr =',RuptestArr, type(RuptestArr))
    print( '='*44 )

