"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_vpc_1 = require("@pepperize/cdk-vpc");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
/**
 * Network settings for the manager and runners
 *
 *  All EC2 instances should belong to the same subnet, availability zone and vpc.
 */
class Network extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.vpc =
            props?.vpc ??
                new cdk_vpc_1.CheapVpc(scope, `Vpc`, {
                    maxAzs: 1,
                });
        this.subnet = this.findSubnet(this.vpc, props?.subnetSelection);
        this.availabilityZone = this.subnet.availabilityZone;
        if (!this.hasPrivateSubnets()) {
            aws_cdk_lib_1.Annotations.of(this).addWarning(`No private network found in ${this.vpc.vpcId}, using public addresses.`);
        }
    }
    hasPrivateSubnets() {
        return !!this.vpc.privateSubnets.length;
    }
    /**
     * Returns the first private or public subnet. Optionally filters by AZ.
     *
     * @exception Throws an error if no private or public is found.
     */
    findSubnet(vpc, subnetSelection) {
        const selectedSubnets = vpc.selectSubnets(subnetSelection || {
            subnetType: this.hasPrivateSubnets() ? aws_ec2_1.SubnetType.PRIVATE_WITH_NAT : aws_ec2_1.SubnetType.PUBLIC,
            availabilityZones: vpc.availabilityZones,
        });
        const subnet = selectedSubnets.subnets.find(() => true);
        if (!subnet) {
            throw new Error(`Neither a private nor a public subnet is found in ${vpc.vpcId}`);
        }
        return subnet;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Network", version: "0.2.122" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmV0d29yay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9ydW5uZXIvbmV0d29yay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGdEQUE4QztBQUM5Qyw2Q0FBaUQ7QUFDakQsaURBQWlGO0FBQ2pGLDJDQUF1QztBQW9CdkM7Ozs7R0FJRztBQUNILE1BQWEsT0FBUSxTQUFRLHNCQUFTO0lBS3BDLFlBQVksS0FBWSxFQUFFLEVBQVUsRUFBRSxLQUFvQjtRQUN4RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxHQUFHO1lBQ04sS0FBSyxFQUFFLEdBQUc7Z0JBQ1YsSUFBSSxrQkFBUSxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUU7b0JBQ3pCLE1BQU0sRUFBRSxDQUFDO2lCQUNWLENBQUMsQ0FBQztRQUVMLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLEtBQUssRUFBRSxlQUFlLENBQUMsQ0FBQztRQUVoRSxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUVyRCxJQUFJLENBQUMsSUFBSSxDQUFDLGlCQUFpQixFQUFFLEVBQUU7WUFDN0IseUJBQVcsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsVUFBVSxDQUFDLCtCQUErQixJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssMkJBQTJCLENBQUMsQ0FBQztTQUMzRztJQUNILENBQUM7SUFFTSxpQkFBaUI7UUFDdEIsT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsTUFBTSxDQUFDO0lBQzFDLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ssVUFBVSxDQUFDLEdBQVMsRUFBRSxlQUFpQztRQUM3RCxNQUFNLGVBQWUsR0FBRyxHQUFHLENBQUMsYUFBYSxDQUN2QyxlQUFlLElBQUk7WUFDakIsVUFBVSxFQUFFLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLENBQUMsQ0FBQyxvQkFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxvQkFBVSxDQUFDLE1BQU07WUFDdEYsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQjtTQUN6QyxDQUNGLENBQUM7UUFFRixNQUFNLE1BQU0sR0FBRyxlQUFlLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUV4RCxJQUFJLENBQUMsTUFBTSxFQUFFO1lBQ1gsTUFBTSxJQUFJLEtBQUssQ0FBQyxxREFBcUQsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUM7U0FDbkY7UUFFRCxPQUFPLE1BQU0sQ0FBQztJQUNoQixDQUFDOztBQS9DSCwwQkFnREMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDaGVhcFZwYyB9IGZyb20gXCJAcGVwcGVyaXplL2Nkay12cGNcIjtcbmltcG9ydCB7IEFubm90YXRpb25zLCBTdGFjayB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuaW1wb3J0IHsgSVN1Ym5ldCwgSVZwYywgU3VibmV0U2VsZWN0aW9uLCBTdWJuZXRUeXBlIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1lYzJcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgTmV0d29ya1Byb3BzIHtcbiAgLyoqXG4gICAqIElmIG5vIGV4aXN0aW5nIFZQQyBpcyBwcm92aWRlZCwgYSBkZWZhdWx0IFZwYyB3aWxsIGJlIGNyZWF0ZWQuXG4gICAqL1xuICByZWFkb25seSB2cGM/OiBJVnBjO1xuXG4gIC8qKlxuICAgKiBUaGUgR2l0TGFiIFJ1bm5lcidzIHN1Ym5ldHMuIEl0IHNob3VsZCBiZSBlaXRoZXIgcHVibGljIG9yIHByaXZhdGUuIElmIG1vcmUgdGhlbiBzdWJuZXQgaXMgc2VsZWN0ZWQsIHRoZW4gdGhlIGZpcnN0IGZvdW5kIChwcml2YXRlKSBzdWJuZXQgd2lsbCBiZSB1c2VkLlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jZGsvYXBpL2xhdGVzdC9kb2NzL0Bhd3MtY2RrX2F3cy1lYzIuU3VibmV0U2VsZWN0aW9uLmh0bWxcbiAgICpcbiAgICogQSBuZXR3b3JrIGlzIGNvbnNpZGVyZWQgcHJpdmF0ZSwgaWZcbiAgICogIC0gdGFnZ2VkIGJ5ICdhd3MtY2RrOnN1Ym5ldC10eXBlJ1xuICAgKiAgLSBkb2Vzbid0IHJvdXRlIHRvIGFuIEludGVybmV0IEdhdGV3YXkgKG5vdCBwdWJsaWMpXG4gICAqICAtIGhhcyBhbiBOYXQgR2F0ZXdheVxuICAgKi9cbiAgcmVhZG9ubHkgc3VibmV0U2VsZWN0aW9uPzogU3VibmV0U2VsZWN0aW9uO1xufVxuXG4vKipcbiAqIE5ldHdvcmsgc2V0dGluZ3MgZm9yIHRoZSBtYW5hZ2VyIGFuZCBydW5uZXJzXG4gKlxuICogIEFsbCBFQzIgaW5zdGFuY2VzIHNob3VsZCBiZWxvbmcgdG8gdGhlIHNhbWUgc3VibmV0LCBhdmFpbGFiaWxpdHkgem9uZSBhbmQgdnBjLlxuICovXG5leHBvcnQgY2xhc3MgTmV0d29yayBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHJlYWRvbmx5IHZwYzogSVZwYztcbiAgcmVhZG9ubHkgYXZhaWxhYmlsaXR5Wm9uZTogc3RyaW5nO1xuICByZWFkb25seSBzdWJuZXQ6IElTdWJuZXQ7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IFN0YWNrLCBpZDogc3RyaW5nLCBwcm9wcz86IE5ldHdvcmtQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnZwYyA9XG4gICAgICBwcm9wcz8udnBjID8/XG4gICAgICBuZXcgQ2hlYXBWcGMoc2NvcGUsIGBWcGNgLCB7XG4gICAgICAgIG1heEF6czogMSxcbiAgICAgIH0pO1xuXG4gICAgdGhpcy5zdWJuZXQgPSB0aGlzLmZpbmRTdWJuZXQodGhpcy52cGMsIHByb3BzPy5zdWJuZXRTZWxlY3Rpb24pO1xuXG4gICAgdGhpcy5hdmFpbGFiaWxpdHlab25lID0gdGhpcy5zdWJuZXQuYXZhaWxhYmlsaXR5Wm9uZTtcblxuICAgIGlmICghdGhpcy5oYXNQcml2YXRlU3VibmV0cygpKSB7XG4gICAgICBBbm5vdGF0aW9ucy5vZih0aGlzKS5hZGRXYXJuaW5nKGBObyBwcml2YXRlIG5ldHdvcmsgZm91bmQgaW4gJHt0aGlzLnZwYy52cGNJZH0sIHVzaW5nIHB1YmxpYyBhZGRyZXNzZXMuYCk7XG4gICAgfVxuICB9XG5cbiAgcHVibGljIGhhc1ByaXZhdGVTdWJuZXRzKCk6IGJvb2xlYW4ge1xuICAgIHJldHVybiAhIXRoaXMudnBjLnByaXZhdGVTdWJuZXRzLmxlbmd0aDtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSBmaXJzdCBwcml2YXRlIG9yIHB1YmxpYyBzdWJuZXQuIE9wdGlvbmFsbHkgZmlsdGVycyBieSBBWi5cbiAgICpcbiAgICogQGV4Y2VwdGlvbiBUaHJvd3MgYW4gZXJyb3IgaWYgbm8gcHJpdmF0ZSBvciBwdWJsaWMgaXMgZm91bmQuXG4gICAqL1xuICBwcml2YXRlIGZpbmRTdWJuZXQodnBjOiBJVnBjLCBzdWJuZXRTZWxlY3Rpb24/OiBTdWJuZXRTZWxlY3Rpb24pOiBJU3VibmV0IHtcbiAgICBjb25zdCBzZWxlY3RlZFN1Ym5ldHMgPSB2cGMuc2VsZWN0U3VibmV0cyhcbiAgICAgIHN1Ym5ldFNlbGVjdGlvbiB8fCB7XG4gICAgICAgIHN1Ym5ldFR5cGU6IHRoaXMuaGFzUHJpdmF0ZVN1Ym5ldHMoKSA/IFN1Ym5ldFR5cGUuUFJJVkFURV9XSVRIX05BVCA6IFN1Ym5ldFR5cGUuUFVCTElDLFxuICAgICAgICBhdmFpbGFiaWxpdHlab25lczogdnBjLmF2YWlsYWJpbGl0eVpvbmVzLFxuICAgICAgfVxuICAgICk7XG5cbiAgICBjb25zdCBzdWJuZXQgPSBzZWxlY3RlZFN1Ym5ldHMuc3VibmV0cy5maW5kKCgpID0+IHRydWUpO1xuXG4gICAgaWYgKCFzdWJuZXQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgTmVpdGhlciBhIHByaXZhdGUgbm9yIGEgcHVibGljIHN1Ym5ldCBpcyBmb3VuZCBpbiAke3ZwYy52cGNJZH1gKTtcbiAgICB9XG5cbiAgICByZXR1cm4gc3VibmV0O1xuICB9XG59XG4iXX0=