import { Construct } from 'constructs';
import { SignalCatalog } from './signalcatalog';
export declare class VehicleInterface {
    protected intf: object;
    constructor();
    toObject(): object;
}
export declare class CanVehicleInterface extends VehicleInterface {
    constructor(interfaceId: string, name: string);
}
export declare class VehicleSignal {
    protected signal: object;
    constructor();
    toObject(): object;
}
export declare class CanVehicleSignal extends VehicleSignal {
    constructor(fullyQualifiedName: string, interfaceId: string, messageId: number, factor: number, isBigEndian: boolean, isSigned: boolean, length: number, offset: number, startBit: number);
}
export declare class NetworkFileDefinition {
    protected definition: object;
    constructor();
    toObject(): object;
}
export declare class CanDefinition extends NetworkFileDefinition {
    constructor(networkInterface: string, signalsMap: Record<string, string>, canDbcFiles: Array<string>);
}
export interface VehicleModelProps {
    readonly signalCatalog: SignalCatalog;
    readonly name: string;
    readonly description?: string;
    readonly networkInterfaces: VehicleInterface[];
    readonly signals?: VehicleSignal[];
    readonly networkFileDefinitions?: NetworkFileDefinition[];
}
export declare class VehicleModel extends Construct {
    readonly name: string;
    readonly signalCatalog: SignalCatalog;
    constructor(scope: Construct, id: string, props: VehicleModelProps);
}
