"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Vehicle = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const handler_1 = require("./handler");
const provider_1 = require("./provider");
/**
 * The vehicle of a specific type from which IoT FleetWise collect signals.
 */
class Vehicle extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.vehicleModel = {};
        this.vehicleName = '';
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:vehicle/${props.vehicleName}`;
        this.vehicleModel = props.vehicleModel;
        this.vehicleName = props.vehicleName;
        const handler = new handler_1.Handler(this, 'Handler', {
            handler: 'vehiclehandler.on_event',
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider_1.Provider.getOrCreate(this, handler).provider.serviceToken,
            properties: {
                vehicle_name: props.vehicleName,
                create_iot_thing: props.createIotThing,
                decoder_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:decoder-manifest/${props.vehicleModel.name}`,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${props.vehicleModel.name}`,
            },
        });
        resource.node.addDependency(this.vehicleModel);
        if (props.createIotThing) {
            this.endpointAddress = resource.getAtt('endpointAddress').toString();
            this.certificateId = resource.getAtt('certificateId').toString();
            this.certificateArn = resource.getAtt('certificateArn').toString();
            this.certificatePem = resource.getAtt('certificatePem').toString();
            this.privateKey = resource.getAtt('privateKey').toString();
            const policy = new aws_cdk_lib_1.aws_iot.CfnPolicy(this, 'Policy', {
                policyName: `${props.vehicleName}-policy`,
                policyDocument: {
                    Version: '2012-10-17',
                    Statement: [{
                            Effect: 'Allow',
                            Action: [
                                'iot:Connect',
                                'iot:Subscribe',
                                'iot:Publish',
                                'iot:Receive',
                            ],
                            Resource: [
                                `arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:client/${props.vehicleName}*`,
                                `arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:topic/*`,
                                `arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:topicfilter/*`,
                            ],
                        }],
                },
            });
            policy.node.addDependency(resource);
            const policy_attachement = new aws_cdk_lib_1.aws_iot.CfnPolicyPrincipalAttachment(this, 'Attachment', {
                policyName: policy.policyName,
                principal: this.certificateArn,
            });
            policy_attachement.node.addDependency(policy);
            const thing_attachment = new aws_cdk_lib_1.aws_iot.CfnThingPrincipalAttachment(this, 'ThingAttachment', {
                thingName: props.vehicleName,
                principal: this.certificateArn,
            });
            thing_attachment.node.addDependency(policy_attachement);
        }
    }
}
exports.Vehicle = Vehicle;
_a = JSII_RTTI_SYMBOL_1;
Vehicle[_a] = { fqn: "cdk-aws-iotfleetwise.Vehicle", version: "0.2.13" };
//# sourceMappingURL=data:application/json;base64,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