"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignalCatalog = exports.SignalCatalogSensor = exports.SignalCatalogBranch = exports.SignalCatalogNode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const handler_1 = require("./handler");
const provider_1 = require("./provider");
class SignalCatalogNode {
    constructor() {
        this.node = {};
    }
    toObject() {
        return (this.node);
    }
}
exports.SignalCatalogNode = SignalCatalogNode;
_a = JSII_RTTI_SYMBOL_1;
SignalCatalogNode[_a] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogNode", version: "0.2.13" };
class SignalCatalogBranch extends SignalCatalogNode {
    constructor(fullyQualifiedName, description) {
        super();
        this.node = {
            branch: {
                fullyQualifiedName: fullyQualifiedName,
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogBranch = SignalCatalogBranch;
_b = JSII_RTTI_SYMBOL_1;
SignalCatalogBranch[_b] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogBranch", version: "0.2.13" };
class SignalCatalogSensor extends SignalCatalogNode {
    constructor(fullyQualifiedName, dataType, unit, min, max, description) {
        super();
        this.node = {
            sensor: {
                fullyQualifiedName,
                dataType,
                ...unit && { unit },
                ...min && { min },
                ...max && { max },
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogSensor = SignalCatalogSensor;
_c = JSII_RTTI_SYMBOL_1;
SignalCatalogSensor[_c] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogSensor", version: "0.2.13" };
/**
 * The Signal Catalog represents the list of all signals that you want to collect from all
 * the vehicles.
 *
 *
 * The AWS IoT Fleetwise preview can only support a single Signal Catalog per account.
 *
 */
class SignalCatalog extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name || 'default';
        this.description = props.description;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:signal-catalog/${this.name}`;
        const handler = new handler_1.Handler(this, 'Handler', {
            handler: 'servicehandler.on_event',
        });
        const isCompleteHandler = new handler_1.Handler(this, 'IsCompleteHandler', {
            handler: 'servicehandler.is_complete',
        });
        const provider = provider_1.Provider.getOrCreate(this, handler, isCompleteHandler);
        const serviceResource = new cdk.CustomResource(this, 'ServiceResource', {
            serviceToken: provider.provider.serviceToken,
            properties: {
                database_name: props.database.databaseName,
                table_name: props.table.tableName,
            },
        });
        const serviceCatalogHandler = new handler_1.Handler(this, 'ServiceCatalogHandler', {
            handler: 'signalcataloghandler.on_event',
        });
        const resourceCatalog = new cdk.CustomResource(this, 'CatalogResource', {
            serviceToken: provider_1.Provider.getOrCreate(this, serviceCatalogHandler).provider.serviceToken,
            properties: {
                name: this.name,
                description: this.description,
                nodes: JSON.stringify(props.nodes.map(node => node.toObject())),
            },
        });
        resourceCatalog.node.addDependency(serviceResource);
    }
}
exports.SignalCatalog = SignalCatalog;
_d = JSII_RTTI_SYMBOL_1;
SignalCatalog[_d] = { fqn: "cdk-aws-iotfleetwise.SignalCatalog", version: "0.2.13" };
//# sourceMappingURL=data:application/json;base64,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