"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Provider = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class Provider extends constructs_1.Construct {
    constructor(scope, id, eventHandler, isCompleteHandler) {
        super(scope, id);
        this.provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: eventHandler,
            ...isCompleteHandler && ({ isCompleteHandler: isCompleteHandler }),
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
    }
    static getOrCreate(scope, eventHandler, isCompleteHandler) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = `${eventHandler.handler}-provider`;
        return stack.node.tryFindChild(id) || new Provider(stack, id, eventHandler, isCompleteHandler);
    }
}
exports.Provider = Provider;
//# sourceMappingURL=data:application/json;base64,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