"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ifw = require(".");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'integ-stack', { env });
        const databaseName = 'FleetWise';
        const tableName = 'FleetWise';
        const database = new aws_cdk_lib_1.aws_timestream.CfnDatabase(stack, 'Database', {
            databaseName,
        });
        const table = new aws_cdk_lib_1.aws_timestream.CfnTable(stack, 'Table', {
            databaseName,
            tableName,
        });
        table.node.addDependency(database);
        const signalCatalog = new ifw.SignalCatalog(stack, 'SignalCatalog', {
            database,
            table,
            description: 'my signal catalog',
            nodes: [
                new ifw.SignalCatalogBranch('Vehicle'),
                new ifw.SignalCatalogSensor('Vehicle.EngineTorque', 'DOUBLE'),
            ],
        });
        const model_a = new ifw.VehicleModel(stack, 'ModelA', {
            signalCatalog,
            name: 'modelA',
            description: 'Model A vehicle',
            networkInterfaces: [new ifw.CanVehicleInterface('1', 'vcan0')],
            signals: [
                new ifw.CanVehicleSignal('Vehicle.EngineTorque', '1', 401, // messageId
                1.0, // factor
                true, // isBigEndian
                false, // isSigned
                8, // length
                0.0, // offset
                9),
            ],
        });
        const vin100 = new ifw.Vehicle(stack, 'vin100', {
            vehicleName: 'vin100',
            vehicleModel: model_a,
            createIotThing: true,
        });
        const vin200 = new ifw.Vehicle(stack, 'vin200', {
            vehicleName: 'vin200',
            vehicleModel: model_a,
            createIotThing: true,
        });
        new ifw.Campaign(stack, 'Campaign1', {
            name: 'FwTimeBasedCampaign1',
            target: vin100,
            collectionScheme: new ifw.TimeBasedCollectionScheme(cdk.Duration.seconds(10)),
            signals: [
                new ifw.CampaignSignal('Vehicle.EngineTorque'),
            ],
            autoApprove: true,
        });
        new ifw.Fleet(stack, 'Fleet1', {
            fleetId: 'fleet1',
            signalCatalog,
            vehicles: [vin100, vin200],
        });
        new ifw.Fleet(stack, 'Fleet2', {
            fleetId: 'fleet2',
            signalCatalog,
            vehicles: [vin100],
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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