"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const fs = require("fs");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ifw = require(".");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'integ-stack', { env });
        const databaseName = 'FleetWise';
        const tableName = 'FleetWise';
        const database = new aws_cdk_lib_1.aws_timestream.CfnDatabase(stack, 'Database', {
            databaseName,
        });
        const table = new aws_cdk_lib_1.aws_timestream.CfnTable(stack, 'Table', {
            databaseName,
            tableName,
        });
        table.node.addDependency(database);
        const canDbc = fs.readFileSync(path.join(__dirname, '/../hscan.dbc'), 'utf8');
        const nodes = [new ifw.SignalCatalogBranch('Vehicle', 'Vehicle')];
        canDbc.split('\n').filter(line => /^\s+SG_\s+\w+/.test(line)).map(line => {
            const signal_name = line.split(/\s+/)[2];
            nodes.push(new ifw.SignalCatalogSensor(`Vehicle.${signal_name}`, 'DOUBLE'));
        });
        const signalCatalog = new ifw.SignalCatalog(stack, 'SignalCatalog', {
            database,
            table,
            description: 'my signal catalog',
            nodes,
        });
        const signalsMap = {};
        canDbc.split('\n').filter(line => /^\s+SG_\s+\w+/.test(line)).map(line => {
            const signal_name = line.split(/\s+/)[2];
            signalsMap[signal_name] = `Vehicle.${signal_name}`;
        });
        const model_a = new ifw.VehicleModel(stack, 'ModelA', {
            signalCatalog,
            name: 'modelA',
            description: 'Model A vehicle',
            networkInterfaces: [new ifw.CanVehicleInterface('1', 'vcan0')],
            networkFileDefinitions: [new ifw.CanDefinition('1', signalsMap, [canDbc])],
        });
        const vin100 = new ifw.Vehicle(stack, 'vin100', {
            vehicleName: 'vin100',
            vehicleModel: model_a,
            createIotThing: true,
        });
        new cdk.CfnOutput(stack, 'certificateId', { value: vin100.certificateId });
        new ifw.Fleet(stack, 'fleet1', {
            fleetId: 'fleet1',
            signalCatalog: signalCatalog,
            description: 'my fleet1',
            vehicles: [vin100],
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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