"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Boto3LayerVersion = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class Boto3LayerVersion extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.lambdaLayer = new aws_cdk_lib_1.aws_lambda.LayerVersion(this, 'Boto3', {
            description: 'Boto3 Library with Iot Fleetwise Support',
            compatibleRuntimes: [aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9],
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../layer.zip')),
        });
    }
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = 'iot-fleetwise-layer-version';
        return stack.node.tryFindChild(id) || new Boto3LayerVersion(stack, id);
    }
}
exports.Boto3LayerVersion = Boto3LayerVersion;
//# sourceMappingURL=data:application/json;base64,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