import { ApiObject, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
/**
 *
 *
 * @schema GrafanaDataSource
 */
export declare class GrafanaDataSource extends ApiObject {
    /**
     * Returns the apiVersion and kind for "GrafanaDataSource"
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "GrafanaDataSource".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props
     */
    static manifest(props?: GrafanaDataSourceProps): any;
    /**
     * Defines a "GrafanaDataSource" API object
     * @param scope the scope in which to define this object
     * @param id a scope-local name for the object
     * @param props initialization props
     */
    constructor(scope: Construct, id: string, props?: GrafanaDataSourceProps);
}
/**
 * @schema GrafanaDataSource
 */
export interface GrafanaDataSourceProps {
    /**
     * @schema GrafanaDataSource#metadata
     */
    readonly metadata?: any;
    /**
     * @schema GrafanaDataSource#spec
     */
    readonly spec?: GrafanaDataSourceSpec;
}
/**
 * @schema GrafanaDataSourceSpec
 */
export interface GrafanaDataSourceSpec {
    /**
     * @schema GrafanaDataSourceSpec#name
     */
    readonly name: string;
    /**
     * @schema GrafanaDataSourceSpec#datasources
     */
    readonly datasources: any[];
}
//# sourceMappingURL=grafana-datasource.d.ts.map