"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const grafana_dashboard_1 = require("./imports/grafana-dashboard");
/**
 * A Grafana dashboard.
 * @see https://grafana.com/docs/grafana/latest/http_api/dashboard/
 */
class Dashboard extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        this.plugins = [];
        const refreshRate = (_b = props.refreshRate) !== null && _b !== void 0 ? _b : cdk8s_1.Duration.seconds(5);
        const timeRange = (_c = props.timeRange) !== null && _c !== void 0 ? _c : cdk8s_1.Duration.hours(6);
        const dataSources = Object.entries((_d = props.dataSourceVariables) !== null && _d !== void 0 ? _d : {}).map(([variable, name]) => ({ datasourceName: name, inputName: variable }));
        const defaults = {
            title: props.title,
            id: null,
            tags: [],
            style: 'dark',
            timezone: 'browser',
            editable: true,
            hideControls: false,
            graphTooltip: 1,
            panels: [],
            time: {
                from: `now-${timeRange.toSeconds()}s`,
                to: 'now',
            },
            timepicker: {
                time_options: [],
                refresh_intervals: [],
            },
            templating: {
                list: [],
            },
            annotations: {
                list: [],
            },
            refresh: `${refreshRate.toSeconds()}s`,
            schemaVersion: 17,
            version: 0,
            links: [],
        };
        new grafana_dashboard_1.GrafanaDashboard(this, 'Resource', {
            metadata: {
                labels: props.labels,
                namespace: props.namespace,
            },
            spec: {
                customFolderName: props.folder,
                datasources: dataSources,
                plugins: this.plugins,
                json: JSON.stringify({
                    ...defaults,
                    ...props.jsonModel,
                }, null, 2),
            },
        });
        if (props.plugins) {
            this.addPlugins(...props.plugins);
        }
    }
    /**
     * Adds one or more plugins.
     */
    addPlugins(...plugins) {
        for (const plugin of plugins) {
            this.plugins.push(plugin);
        }
    }
}
exports.Dashboard = Dashboard;
_a = JSII_RTTI_SYMBOL_1;
Dashboard[_a] = { fqn: "cdk8s-grafana.Dashboard", version: "0.1.133" };
//# sourceMappingURL=data:application/json;base64,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