# Generated by Django 3.2.10 on 2021-12-28 05:38

import django.db.models.deletion

from django.db import migrations
from django.db import models

import enumeration.const


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Counter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                ("period", models.DateField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name="Sequence",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("format", models.CharField(max_length=255)),
                (
                    "reset_period",
                    models.CharField(
                        default="never",
                        max_length=30,
                        verbose_name=enumeration.const.ResetPeriod,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Gap",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField()),
                (
                    "counter",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="gaps",
                        to="enumeration.counter",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="counter",
            name="sequence",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="counters",
                to="enumeration.sequence",
            ),
        ),
        migrations.AddConstraint(
            model_name="counter",
            constraint=models.UniqueConstraint(
                condition=models.Q(("period__isnull", True)),
                fields=("sequence",),
                name="unique_counter_for_no_period",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="counter",
            unique_together={("sequence", "period")},
        ),
    ]
