# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.0
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError('Python 2.7 or later required')

# Import the low-level C/C++ module
if __package__ or '.' in __name__:
    from . import _libcolgraph
else:
    import _libcolgraph

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if name == "thisown":
        return self.this.own(value)
    if name == "this":
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if not static:
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if name == "thisown":
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcolgraph.delete_SwigPyIterator

    def value(self):
        return _libcolgraph.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _libcolgraph.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _libcolgraph.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _libcolgraph.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _libcolgraph.SwigPyIterator_equal(self, x)

    def copy(self):
        return _libcolgraph.SwigPyIterator_copy(self)

    def next(self):
        return _libcolgraph.SwigPyIterator_next(self)

    def __next__(self):
        return _libcolgraph.SwigPyIterator___next__(self)

    def previous(self):
        return _libcolgraph.SwigPyIterator_previous(self)

    def advance(self, n):
        return _libcolgraph.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _libcolgraph.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _libcolgraph.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _libcolgraph.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _libcolgraph.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _libcolgraph.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _libcolgraph.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _libcolgraph:
_libcolgraph.SwigPyIterator_swigregister(SwigPyIterator)

class _IntVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _libcolgraph._IntVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _libcolgraph._IntVector___nonzero__(self)

    def __bool__(self):
        return _libcolgraph._IntVector___bool__(self)

    def __len__(self):
        return _libcolgraph._IntVector___len__(self)

    def __getslice__(self, i, j):
        return _libcolgraph._IntVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _libcolgraph._IntVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _libcolgraph._IntVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _libcolgraph._IntVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _libcolgraph._IntVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _libcolgraph._IntVector___setitem__(self, *args)

    def pop(self):
        return _libcolgraph._IntVector_pop(self)

    def append(self, x):
        return _libcolgraph._IntVector_append(self, x)

    def empty(self):
        return _libcolgraph._IntVector_empty(self)

    def size(self):
        return _libcolgraph._IntVector_size(self)

    def swap(self, v):
        return _libcolgraph._IntVector_swap(self, v)

    def begin(self):
        return _libcolgraph._IntVector_begin(self)

    def end(self):
        return _libcolgraph._IntVector_end(self)

    def rbegin(self):
        return _libcolgraph._IntVector_rbegin(self)

    def rend(self):
        return _libcolgraph._IntVector_rend(self)

    def clear(self):
        return _libcolgraph._IntVector_clear(self)

    def get_allocator(self):
        return _libcolgraph._IntVector_get_allocator(self)

    def pop_back(self):
        return _libcolgraph._IntVector_pop_back(self)

    def erase(self, *args):
        return _libcolgraph._IntVector_erase(self, *args)

    def __init__(self, *args):
        _libcolgraph._IntVector_swiginit(self, _libcolgraph.new__IntVector(*args))

    def push_back(self, x):
        return _libcolgraph._IntVector_push_back(self, x)

    def front(self):
        return _libcolgraph._IntVector_front(self)

    def back(self):
        return _libcolgraph._IntVector_back(self)

    def assign(self, n, x):
        return _libcolgraph._IntVector_assign(self, n, x)

    def resize(self, *args):
        return _libcolgraph._IntVector_resize(self, *args)

    def insert(self, *args):
        return _libcolgraph._IntVector_insert(self, *args)

    def reserve(self, n):
        return _libcolgraph._IntVector_reserve(self, n)

    def capacity(self):
        return _libcolgraph._IntVector_capacity(self)
    __swig_destroy__ = _libcolgraph.delete__IntVector

# Register _IntVector in _libcolgraph:
_libcolgraph._IntVector_swigregister(_IntVector)

class _LongVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _libcolgraph._LongVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _libcolgraph._LongVector___nonzero__(self)

    def __bool__(self):
        return _libcolgraph._LongVector___bool__(self)

    def __len__(self):
        return _libcolgraph._LongVector___len__(self)

    def __getslice__(self, i, j):
        return _libcolgraph._LongVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _libcolgraph._LongVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _libcolgraph._LongVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _libcolgraph._LongVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _libcolgraph._LongVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _libcolgraph._LongVector___setitem__(self, *args)

    def pop(self):
        return _libcolgraph._LongVector_pop(self)

    def append(self, x):
        return _libcolgraph._LongVector_append(self, x)

    def empty(self):
        return _libcolgraph._LongVector_empty(self)

    def size(self):
        return _libcolgraph._LongVector_size(self)

    def swap(self, v):
        return _libcolgraph._LongVector_swap(self, v)

    def begin(self):
        return _libcolgraph._LongVector_begin(self)

    def end(self):
        return _libcolgraph._LongVector_end(self)

    def rbegin(self):
        return _libcolgraph._LongVector_rbegin(self)

    def rend(self):
        return _libcolgraph._LongVector_rend(self)

    def clear(self):
        return _libcolgraph._LongVector_clear(self)

    def get_allocator(self):
        return _libcolgraph._LongVector_get_allocator(self)

    def pop_back(self):
        return _libcolgraph._LongVector_pop_back(self)

    def erase(self, *args):
        return _libcolgraph._LongVector_erase(self, *args)

    def __init__(self, *args):
        _libcolgraph._LongVector_swiginit(self, _libcolgraph.new__LongVector(*args))

    def push_back(self, x):
        return _libcolgraph._LongVector_push_back(self, x)

    def front(self):
        return _libcolgraph._LongVector_front(self)

    def back(self):
        return _libcolgraph._LongVector_back(self)

    def assign(self, n, x):
        return _libcolgraph._LongVector_assign(self, n, x)

    def resize(self, *args):
        return _libcolgraph._LongVector_resize(self, *args)

    def insert(self, *args):
        return _libcolgraph._LongVector_insert(self, *args)

    def reserve(self, n):
        return _libcolgraph._LongVector_reserve(self, n)

    def capacity(self):
        return _libcolgraph._LongVector_capacity(self)
    __swig_destroy__ = _libcolgraph.delete__LongVector

# Register _LongVector in _libcolgraph:
_libcolgraph._LongVector_swigregister(_LongVector)

class _IntVectorVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _libcolgraph._IntVectorVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _libcolgraph._IntVectorVector___nonzero__(self)

    def __bool__(self):
        return _libcolgraph._IntVectorVector___bool__(self)

    def __len__(self):
        return _libcolgraph._IntVectorVector___len__(self)

    def __getslice__(self, i, j):
        return _libcolgraph._IntVectorVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _libcolgraph._IntVectorVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _libcolgraph._IntVectorVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _libcolgraph._IntVectorVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _libcolgraph._IntVectorVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _libcolgraph._IntVectorVector___setitem__(self, *args)

    def pop(self):
        return _libcolgraph._IntVectorVector_pop(self)

    def append(self, x):
        return _libcolgraph._IntVectorVector_append(self, x)

    def empty(self):
        return _libcolgraph._IntVectorVector_empty(self)

    def size(self):
        return _libcolgraph._IntVectorVector_size(self)

    def swap(self, v):
        return _libcolgraph._IntVectorVector_swap(self, v)

    def begin(self):
        return _libcolgraph._IntVectorVector_begin(self)

    def end(self):
        return _libcolgraph._IntVectorVector_end(self)

    def rbegin(self):
        return _libcolgraph._IntVectorVector_rbegin(self)

    def rend(self):
        return _libcolgraph._IntVectorVector_rend(self)

    def clear(self):
        return _libcolgraph._IntVectorVector_clear(self)

    def get_allocator(self):
        return _libcolgraph._IntVectorVector_get_allocator(self)

    def pop_back(self):
        return _libcolgraph._IntVectorVector_pop_back(self)

    def erase(self, *args):
        return _libcolgraph._IntVectorVector_erase(self, *args)

    def __init__(self, *args):
        _libcolgraph._IntVectorVector_swiginit(self, _libcolgraph.new__IntVectorVector(*args))

    def push_back(self, x):
        return _libcolgraph._IntVectorVector_push_back(self, x)

    def front(self):
        return _libcolgraph._IntVectorVector_front(self)

    def back(self):
        return _libcolgraph._IntVectorVector_back(self)

    def assign(self, n, x):
        return _libcolgraph._IntVectorVector_assign(self, n, x)

    def resize(self, *args):
        return _libcolgraph._IntVectorVector_resize(self, *args)

    def insert(self, *args):
        return _libcolgraph._IntVectorVector_insert(self, *args)

    def reserve(self, n):
        return _libcolgraph._IntVectorVector_reserve(self, n)

    def capacity(self):
        return _libcolgraph._IntVectorVector_capacity(self)
    __swig_destroy__ = _libcolgraph.delete__IntVectorVector

# Register _IntVectorVector in _libcolgraph:
_libcolgraph._IntVectorVector_swigregister(_IntVectorVector)

class _BaseGraphVertexIterator(object):
    r"""


    Attributes
    ----------
    * `it` : `std::unordered_map< long, V * >::iterator`  

    * `len` : `long`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    it = property(_libcolgraph._BaseGraphVertexIterator_it_get, _libcolgraph._BaseGraphVertexIterator_it_set)
    len = property(_libcolgraph._BaseGraphVertexIterator_len_get, _libcolgraph._BaseGraphVertexIterator_len_set)

    def __init__(self, *args):
        r"""

        `GraphVertexIterator()`  
        `GraphVertexIterator(typename std::unordered_map< long, V * >::iterator it_,
            long len_)`  

        Overloaded function
        -------------------
        * `GraphVertexIterator()`  

        * `GraphVertexIterator(typename std::unordered_map< long, V * >::iterator it_,
            long len_)`  

        """
        _libcolgraph._BaseGraphVertexIterator_swiginit(self, _libcolgraph.new__BaseGraphVertexIterator(*args))
    __swig_destroy__ = _libcolgraph.delete__BaseGraphVertexIterator

    def next(self):
        r"""

        `next() -> V`  

        """
        return _libcolgraph._BaseGraphVertexIterator_next(self)

    def __next__(self):
        r"""

        `__next__() -> V`  

        """
        return _libcolgraph._BaseGraphVertexIterator___next__(self)

    def hasnext(self):
        r"""

        `hasnext() -> bool`  

        """
        return _libcolgraph._BaseGraphVertexIterator_hasnext(self)

    def __iter__(self):
        r"""

        `__iter__() -> GraphVertexIterator< V > *`  

        """
        return _libcolgraph._BaseGraphVertexIterator___iter__(self)

# Register _BaseGraphVertexIterator in _libcolgraph:
_libcolgraph._BaseGraphVertexIterator_swigregister(_BaseGraphVertexIterator)

class _ColoringGraphVertexIterator(object):
    r"""


    Attributes
    ----------
    * `it` : `std::unordered_map< long, V * >::iterator`  

    * `len` : `long`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    it = property(_libcolgraph._ColoringGraphVertexIterator_it_get, _libcolgraph._ColoringGraphVertexIterator_it_set)
    len = property(_libcolgraph._ColoringGraphVertexIterator_len_get, _libcolgraph._ColoringGraphVertexIterator_len_set)

    def __init__(self, *args):
        r"""

        `GraphVertexIterator()`  
        `GraphVertexIterator(typename std::unordered_map< long, V * >::iterator it_,
            long len_)`  

        Overloaded function
        -------------------
        * `GraphVertexIterator()`  

        * `GraphVertexIterator(typename std::unordered_map< long, V * >::iterator it_,
            long len_)`  

        """
        _libcolgraph._ColoringGraphVertexIterator_swiginit(self, _libcolgraph.new__ColoringGraphVertexIterator(*args))
    __swig_destroy__ = _libcolgraph.delete__ColoringGraphVertexIterator

    def next(self):
        r"""

        `next() -> V`  

        """
        return _libcolgraph._ColoringGraphVertexIterator_next(self)

    def __next__(self):
        r"""

        `__next__() -> V`  

        """
        return _libcolgraph._ColoringGraphVertexIterator___next__(self)

    def hasnext(self):
        r"""

        `hasnext() -> bool`  

        """
        return _libcolgraph._ColoringGraphVertexIterator_hasnext(self)

    def __iter__(self):
        r"""

        `__iter__() -> GraphVertexIterator< V > *`  

        """
        return _libcolgraph._ColoringGraphVertexIterator___iter__(self)

# Register _ColoringGraphVertexIterator in _libcolgraph:
_libcolgraph._ColoringGraphVertexIterator_swigregister(_ColoringGraphVertexIterator)

class _MetaGraphVertexIterator(object):
    r"""


    Attributes
    ----------
    * `it` : `std::unordered_map< long, V * >::iterator`  

    * `len` : `long`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    it = property(_libcolgraph._MetaGraphVertexIterator_it_get, _libcolgraph._MetaGraphVertexIterator_it_set)
    len = property(_libcolgraph._MetaGraphVertexIterator_len_get, _libcolgraph._MetaGraphVertexIterator_len_set)

    def __init__(self, *args):
        r"""

        `GraphVertexIterator()`  
        `GraphVertexIterator(typename std::unordered_map< long, V * >::iterator it_,
            long len_)`  

        Overloaded function
        -------------------
        * `GraphVertexIterator()`  

        * `GraphVertexIterator(typename std::unordered_map< long, V * >::iterator it_,
            long len_)`  

        """
        _libcolgraph._MetaGraphVertexIterator_swiginit(self, _libcolgraph.new__MetaGraphVertexIterator(*args))
    __swig_destroy__ = _libcolgraph.delete__MetaGraphVertexIterator

    def next(self):
        r"""

        `next() -> V`  

        """
        return _libcolgraph._MetaGraphVertexIterator_next(self)

    def __next__(self):
        r"""

        `__next__() -> V`  

        """
        return _libcolgraph._MetaGraphVertexIterator___next__(self)

    def hasnext(self):
        r"""

        `hasnext() -> bool`  

        """
        return _libcolgraph._MetaGraphVertexIterator_hasnext(self)

    def __iter__(self):
        r"""

        `__iter__() -> GraphVertexIterator< V > *`  

        """
        return _libcolgraph._MetaGraphVertexIterator___iter__(self)

# Register _MetaGraphVertexIterator in _libcolgraph:
_libcolgraph._MetaGraphVertexIterator_swigregister(_MetaGraphVertexIterator)

class _BaseVertexNeighborIterator(object):
    r"""


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcolgraph.delete__BaseVertexNeighborIterator

    def next(self):
        r"""

        `next()=0 -> long`  

        """
        return _libcolgraph._BaseVertexNeighborIterator_next(self)

    def __next__(self):
        r"""

        `__next__() -> long`  

        """
        return _libcolgraph._BaseVertexNeighborIterator___next__(self)

    def hasnext(self):
        r"""

        `hasnext()=0 -> bool`  

        """
        return _libcolgraph._BaseVertexNeighborIterator_hasnext(self)

    def __iter__(self):
        r"""

        `__iter__() -> VertexNeighborIterator< V > *`  

        """
        return _libcolgraph._BaseVertexNeighborIterator___iter__(self)

# Register _BaseVertexNeighborIterator in _libcolgraph:
_libcolgraph._BaseVertexNeighborIterator_swigregister(_BaseVertexNeighborIterator)

class _ColoringVertexNeighborIterator(object):
    r"""


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcolgraph.delete__ColoringVertexNeighborIterator

    def next(self):
        r"""

        `next()=0 -> long`  

        """
        return _libcolgraph._ColoringVertexNeighborIterator_next(self)

    def __next__(self):
        r"""

        `__next__() -> long`  

        """
        return _libcolgraph._ColoringVertexNeighborIterator___next__(self)

    def hasnext(self):
        r"""

        `hasnext()=0 -> bool`  

        """
        return _libcolgraph._ColoringVertexNeighborIterator_hasnext(self)

    def __iter__(self):
        r"""

        `__iter__() -> VertexNeighborIterator< V > *`  

        """
        return _libcolgraph._ColoringVertexNeighborIterator___iter__(self)

# Register _ColoringVertexNeighborIterator in _libcolgraph:
_libcolgraph._ColoringVertexNeighborIterator_swigregister(_ColoringVertexNeighborIterator)

class _MetaVertexNeighborIterator(object):
    r"""


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libcolgraph.delete__MetaVertexNeighborIterator

    def next(self):
        r"""

        `next()=0 -> long`  

        """
        return _libcolgraph._MetaVertexNeighborIterator_next(self)

    def __next__(self):
        r"""

        `__next__() -> long`  

        """
        return _libcolgraph._MetaVertexNeighborIterator___next__(self)

    def hasnext(self):
        r"""

        `hasnext()=0 -> bool`  

        """
        return _libcolgraph._MetaVertexNeighborIterator_hasnext(self)

    def __iter__(self):
        r"""

        `__iter__() -> VertexNeighborIterator< V > *`  

        """
        return _libcolgraph._MetaVertexNeighborIterator___iter__(self)

# Register _MetaVertexNeighborIterator in _libcolgraph:
_libcolgraph._MetaVertexNeighborIterator_swigregister(_MetaVertexNeighborIterator)

class _BaseGraph(object):
    r"""


    Attributes
    ----------
    * `vertices` : `std::unordered_map< long, V * >`  
        stores a mapping of vertex names to pointers to vertex instances. in case of
        `BaseGraph` and `MetaGraph`, it is simply the numeric id of the vertex. in
        case of `ColoringGraph`, it is the encoded coloring of some `BaseGraph`  

    * `connected` : `bool`  

    * `biconnected` : `bool`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    vertices = property(_libcolgraph._BaseGraph_vertices_get, _libcolgraph._BaseGraph_vertices_set)
    connected = property(_libcolgraph._BaseGraph_connected_get, _libcolgraph._BaseGraph_connected_set)
    biconnected = property(_libcolgraph._BaseGraph_biconnected_get, _libcolgraph._BaseGraph_biconnected_set)
    __swig_destroy__ = _libcolgraph.delete__BaseGraph

    def load_txt(self, path):
        r"""

        `load_txt(char *path)`  

        """
        return _libcolgraph._BaseGraph_load_txt(self, path)

    def save_txt(self):
        r"""

        `save_txt()`  

        """
        return _libcolgraph._BaseGraph_save_txt(self)

    def size(self):
        r"""

        `size() -> long`  

        """
        return _libcolgraph._BaseGraph_size(self)

    def is_connected(self):
        r"""

        `is_connected() -> bool`  

        """
        return _libcolgraph._BaseGraph_is_connected(self)

    def is_biconnected(self):
        r"""

        `is_biconnected() -> bool`  

        """
        return _libcolgraph._BaseGraph_is_biconnected(self)

    def add_vertex(self, name):
        r"""

        `add_vertex(long name)=0`  

        """
        return _libcolgraph._BaseGraph_add_vertex(self, name)

    def get_vertex(self, name):
        r"""

        `get_vertex(long name) -> V &`  

        """
        return _libcolgraph._BaseGraph_get_vertex(self, name)

    def get_some_vertex(self):
        r"""

        `get_some_vertex() -> V &`  

        """
        return _libcolgraph._BaseGraph_get_some_vertex(self)

    def __iter__(self):
        r"""

        `__iter__()=0 -> const GraphVertexIterator< V > *`  

        """
        return _libcolgraph._BaseGraph___iter__(self)

    def get_vertices(self):
        r"""

        `get_vertices()=0 -> const GraphVertexIterator< V > *`  

        """
        return _libcolgraph._BaseGraph_get_vertices(self)

    def tarjans(self):
        r"""

        `tarjans() -> MetaGraph *`  

        """
        return _libcolgraph._BaseGraph_tarjans(self)

    def __str__(self):
        '''
        Returns
        -------
        str
        	a short string representation of Graph instance
        '''
        return '<Graph (size={}) of {} >'.format(len(self), type(self))

    def __repr__(self):
        return self.__str__()

    def __len__(self):
        '''
        Returns
        -------
        int
        	output of size() of graph, represents number of vertices
        '''
        return self.size()

    def pretty_print(self):
        '''
        Returns
        -------
        str
        	a nicely formatted complete representation of Graph instance
        '''

        print('INFO: pretty_printing', self, 'vertices followed by their '
                                             'neighbors')
        for v in sorted(self.get_vertices(), key=lambda v: v.get_name()):
            print('\t', v.get_name(), ':  ',
                  *[n for n in sorted(v.get_neighbors())])


# Register _BaseGraph in _libcolgraph:
_libcolgraph._BaseGraph_swigregister(_BaseGraph)

class _ColoringGraph(object):
    r"""


    Attributes
    ----------
    * `vertices` : `std::unordered_map< long, V * >`  
        stores a mapping of vertex names to pointers to vertex instances. in case of
        `BaseGraph` and `MetaGraph`, it is simply the numeric id of the vertex. in
        case of `ColoringGraph`, it is the encoded coloring of some `BaseGraph`  

    * `connected` : `bool`  

    * `biconnected` : `bool`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    vertices = property(_libcolgraph._ColoringGraph_vertices_get, _libcolgraph._ColoringGraph_vertices_set)
    connected = property(_libcolgraph._ColoringGraph_connected_get, _libcolgraph._ColoringGraph_connected_set)
    biconnected = property(_libcolgraph._ColoringGraph_biconnected_get, _libcolgraph._ColoringGraph_biconnected_set)
    __swig_destroy__ = _libcolgraph.delete__ColoringGraph

    def load_txt(self, path):
        r"""

        `load_txt(char *path)`  

        """
        return _libcolgraph._ColoringGraph_load_txt(self, path)

    def save_txt(self):
        r"""

        `save_txt()`  

        """
        return _libcolgraph._ColoringGraph_save_txt(self)

    def size(self):
        r"""

        `size() -> long`  

        """
        return _libcolgraph._ColoringGraph_size(self)

    def is_connected(self):
        r"""

        `is_connected() -> bool`  

        """
        return _libcolgraph._ColoringGraph_is_connected(self)

    def is_biconnected(self):
        r"""

        `is_biconnected() -> bool`  

        """
        return _libcolgraph._ColoringGraph_is_biconnected(self)

    def add_vertex(self, name):
        r"""

        `add_vertex(long name)=0`  

        """
        return _libcolgraph._ColoringGraph_add_vertex(self, name)

    def get_vertex(self, name):
        r"""

        `get_vertex(long name) -> V &`  

        """
        return _libcolgraph._ColoringGraph_get_vertex(self, name)

    def get_some_vertex(self):
        r"""

        `get_some_vertex() -> V &`  

        """
        return _libcolgraph._ColoringGraph_get_some_vertex(self)

    def __iter__(self):
        r"""

        `__iter__()=0 -> const GraphVertexIterator< V > *`  

        """
        return _libcolgraph._ColoringGraph___iter__(self)

    def get_vertices(self):
        r"""

        `get_vertices()=0 -> const GraphVertexIterator< V > *`  

        """
        return _libcolgraph._ColoringGraph_get_vertices(self)

    def tarjans(self):
        r"""

        `tarjans() -> MetaGraph *`  

        """
        return _libcolgraph._ColoringGraph_tarjans(self)

    def __str__(self):
        '''
        Returns
        -------
        str
        	a short string representation of Graph instance
        '''
        return '<Graph (size={}) of {} >'.format(len(self), type(self))

    def __repr__(self):
        return self.__str__()

    def __len__(self):
        '''
        Returns
        -------
        int
        	output of size() of graph, represents number of vertices
        '''
        return self.size()

    def pretty_print(self):
        '''
        Returns
        -------
        str
        	a nicely formatted complete representation of Graph instance
        '''

        print('INFO: pretty_printing', self, 'vertices followed by their '
                                             'neighbors')
        for v in sorted(self.get_vertices(), key=lambda v: v.get_name()):
            print('\t', v.get_name(), ':  ',
                  *[n for n in sorted(v.get_neighbors())])


# Register _ColoringGraph in _libcolgraph:
_libcolgraph._ColoringGraph_swigregister(_ColoringGraph)

class _MetaGraph(object):
    r"""


    Attributes
    ----------
    * `vertices` : `std::unordered_map< long, V * >`  
        stores a mapping of vertex names to pointers to vertex instances. in case of
        `BaseGraph` and `MetaGraph`, it is simply the numeric id of the vertex. in
        case of `ColoringGraph`, it is the encoded coloring of some `BaseGraph`  

    * `connected` : `bool`  

    * `biconnected` : `bool`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    vertices = property(_libcolgraph._MetaGraph_vertices_get, _libcolgraph._MetaGraph_vertices_set)
    connected = property(_libcolgraph._MetaGraph_connected_get, _libcolgraph._MetaGraph_connected_set)
    biconnected = property(_libcolgraph._MetaGraph_biconnected_get, _libcolgraph._MetaGraph_biconnected_set)
    __swig_destroy__ = _libcolgraph.delete__MetaGraph

    def load_txt(self, path):
        r"""

        `load_txt(char *path)`  

        """
        return _libcolgraph._MetaGraph_load_txt(self, path)

    def save_txt(self):
        r"""

        `save_txt()`  

        """
        return _libcolgraph._MetaGraph_save_txt(self)

    def size(self):
        r"""

        `size() -> long`  

        """
        return _libcolgraph._MetaGraph_size(self)

    def is_connected(self):
        r"""

        `is_connected() -> bool`  

        """
        return _libcolgraph._MetaGraph_is_connected(self)

    def is_biconnected(self):
        r"""

        `is_biconnected() -> bool`  

        """
        return _libcolgraph._MetaGraph_is_biconnected(self)

    def add_vertex(self, name):
        r"""

        `add_vertex(long name)=0`  

        """
        return _libcolgraph._MetaGraph_add_vertex(self, name)

    def get_vertex(self, name):
        r"""

        `get_vertex(long name) -> V &`  

        """
        return _libcolgraph._MetaGraph_get_vertex(self, name)

    def get_some_vertex(self):
        r"""

        `get_some_vertex() -> V &`  

        """
        return _libcolgraph._MetaGraph_get_some_vertex(self)

    def __iter__(self):
        r"""

        `__iter__()=0 -> const GraphVertexIterator< V > *`  

        """
        return _libcolgraph._MetaGraph___iter__(self)

    def get_vertices(self):
        r"""

        `get_vertices()=0 -> const GraphVertexIterator< V > *`  

        """
        return _libcolgraph._MetaGraph_get_vertices(self)

    def tarjans(self):
        r"""

        `tarjans() -> MetaGraph *`  

        """
        return _libcolgraph._MetaGraph_tarjans(self)

    def __str__(self):
        '''
        Returns
        -------
        str
        	a short string representation of Graph instance
        '''
        return '<Graph (size={}) of {} >'.format(len(self), type(self))

    def __repr__(self):
        return self.__str__()

    def __len__(self):
        '''
        Returns
        -------
        int
        	output of size() of graph, represents number of vertices
        '''
        return self.size()

    def pretty_print(self):
        '''
        Returns
        -------
        str
        	a nicely formatted complete representation of Graph instance
        '''

        print('INFO: pretty_printing', self, 'vertices followed by their '
                                             'neighbors')
        for v in sorted(self.get_vertices(), key=lambda v: v.get_name()):
            print('\t', v.get_name(), ':  ',
                  *[n for n in sorted(v.get_neighbors())])


# Register _MetaGraph in _libcolgraph:
_libcolgraph._MetaGraph_swigregister(_MetaGraph)

class BaseGraphVertexIterator(_BaseGraphVertexIterator):
    r"""

    `BaseGraphVertexIterator()`  
    `BaseGraphVertexIterator(typename std::unordered_map< long, BaseVertex *
        >::iterator it_, long len_)`  

    Constructors
    ------------
    * `BaseGraphVertexIterator()`  

    * `BaseGraphVertexIterator(typename std::unordered_map< long, BaseVertex *
        >::iterator it_, long len_)`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        `BaseGraphVertexIterator()`  
        `BaseGraphVertexIterator(typename std::unordered_map< long, BaseVertex *
            >::iterator it_, long len_)`  

        Overloaded function
        -------------------
        * `BaseGraphVertexIterator()`  

        * `BaseGraphVertexIterator(typename std::unordered_map< long, BaseVertex *
            >::iterator it_, long len_)`  

        """
        _libcolgraph.BaseGraphVertexIterator_swiginit(self, _libcolgraph.new_BaseGraphVertexIterator(*args))
    __swig_destroy__ = _libcolgraph.delete_BaseGraphVertexIterator

# Register BaseGraphVertexIterator in _libcolgraph:
_libcolgraph.BaseGraphVertexIterator_swigregister(BaseGraphVertexIterator)

class ColoringGraphVertexIterator(_ColoringGraphVertexIterator):
    r"""

    `ColoringGraphVertexIterator()`  
    `ColoringGraphVertexIterator(typename std::unordered_map< long, ColoringVertex *
        >::iterator it_, long len_)`  

    Constructors
    ------------
    * `ColoringGraphVertexIterator()`  

    * `ColoringGraphVertexIterator(typename std::unordered_map< long, ColoringVertex
        * >::iterator it_, long len_)`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        `ColoringGraphVertexIterator()`  
        `ColoringGraphVertexIterator(typename std::unordered_map< long, ColoringVertex *
            >::iterator it_, long len_)`  

        Overloaded function
        -------------------
        * `ColoringGraphVertexIterator()`  

        * `ColoringGraphVertexIterator(typename std::unordered_map< long, ColoringVertex
            * >::iterator it_, long len_)`  

        """
        _libcolgraph.ColoringGraphVertexIterator_swiginit(self, _libcolgraph.new_ColoringGraphVertexIterator(*args))
    __swig_destroy__ = _libcolgraph.delete_ColoringGraphVertexIterator

# Register ColoringGraphVertexIterator in _libcolgraph:
_libcolgraph.ColoringGraphVertexIterator_swigregister(ColoringGraphVertexIterator)

class MetaGraphVertexIterator(_MetaGraphVertexIterator):
    r"""

    `MetaGraphVertexIterator()`  
    `MetaGraphVertexIterator(typename std::unordered_map< long, MetaVertex *
        >::iterator it_, long len_)`  

    Constructors
    ------------
    * `MetaGraphVertexIterator()`  

    * `MetaGraphVertexIterator(typename std::unordered_map< long, MetaVertex *
        >::iterator it_, long len_)`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        `MetaGraphVertexIterator()`  
        `MetaGraphVertexIterator(typename std::unordered_map< long, MetaVertex *
            >::iterator it_, long len_)`  

        Overloaded function
        -------------------
        * `MetaGraphVertexIterator()`  

        * `MetaGraphVertexIterator(typename std::unordered_map< long, MetaVertex *
            >::iterator it_, long len_)`  

        """
        _libcolgraph.MetaGraphVertexIterator_swiginit(self, _libcolgraph.new_MetaGraphVertexIterator(*args))
    __swig_destroy__ = _libcolgraph.delete_MetaGraphVertexIterator

# Register MetaGraphVertexIterator in _libcolgraph:
_libcolgraph.MetaGraphVertexIterator_swigregister(MetaGraphVertexIterator)

class BaseGraph(_BaseGraph):
    r"""

    `BaseGraph()`  

    Constructors
    ------------
    * `BaseGraph()`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        r"""

        `BaseGraph()`  

        """
        _libcolgraph.BaseGraph_swiginit(self, _libcolgraph.new_BaseGraph())

    def load_txt(self, path):
        r"""

        `load_txt(char *path)`  

        """
        return _libcolgraph.BaseGraph_load_txt(self, path)

    def reset(self):
        r"""

        `reset()`  

        resets the graph by clearing its hashed collection of vertices  

        """
        return _libcolgraph.BaseGraph_reset(self)

    def add_vertex(self, name):
        r"""

        `add_vertex(long name)`  

        """
        return _libcolgraph.BaseGraph_add_vertex(self, name)

    def make_edge(self, a, b):
        r"""

        `make_edge(long a, long b)`  

        """
        return _libcolgraph.BaseGraph_make_edge(self, a, b)

    def is_valid_coloring(self, coloring, k):
        r"""

        `is_valid_coloring(long coloring, int k) -> bool`  

        """
        return _libcolgraph.BaseGraph_is_valid_coloring(self, coloring, k)

    def get_vertex_color(self, coloring, name, k):
        r"""

        `get_vertex_color(long coloring, long name, int k) -> int`  

        """
        return _libcolgraph.BaseGraph_get_vertex_color(self, coloring, name, k)

    def build_coloring_graph(self, k):
        r"""

        `build_coloring_graph(int k) -> ColoringGraph *`  

        """
        return _libcolgraph.BaseGraph_build_coloring_graph(self, k)

    def find_all_colorings(self, current, k, cg, coloring):
        r"""

        `find_all_colorings(int current, int k, ColoringGraph *cg, std::vector< int >
            coloring)`  

        """
        return _libcolgraph.BaseGraph_find_all_colorings(self, current, k, cg, coloring)

    def load_next_coloring(self, current, k, coloring):
        r"""

        `load_next_coloring(int current, int k, std::vector< int > &coloring)`  

        """
        return _libcolgraph.BaseGraph_load_next_coloring(self, current, k, coloring)

    def encode(self, coloring, k):
        r"""

        `encode(std::vector< int > &coloring, int k) -> long`  

        """
        return _libcolgraph.BaseGraph_encode(self, coloring, k)

    def __iter__(self):
        r"""

        `__iter__() -> const BaseGraphVertexIterator *`  

        """
        return _libcolgraph.BaseGraph___iter__(self)

    def get_vertices(self):
        r"""

        `get_vertices() -> const BaseGraphVertexIterator *`  

        """
        return _libcolgraph.BaseGraph_get_vertices(self)

    def load_from_nx(self, g=None):
        '''
        method that accepts an instance of a networkx graph
        and loads that graph into this instance of BaseGraph

        Parameters
        ----------
        g: networkx graph object
            an instantiated networkx graph to load from

        '''
        import networkx as nx

        self.reset() # first clear existing graph

        lookup = dict()
        for i, (v, adjdict) in enumerate(g.adjacency()):
            lookup[v] = i
            self.add_vertex(i)
        for i, (v, adjdict) in enumerate(g.adjacency()):
            for otherv in adjdict:
                self.make_edge(lookup[v], lookup[otherv])


    def generate_random(self, v:int, p:float):
        '''
        method that creates a random graph at the current BaseGraph
        instance using the Erdos-Reyni random graph model

        Parameters
        ----------
        v : int
        	how many vertices the graph should have
        p : float[0,1]
            what probability to use while generating edges between pairs 
            of vertices
        '''
        import networkx as nx

        assert 0. <= p <= 1., ValueError('invalid probabilities')
        assert 0 <= v, ValueError('bad number of vertices')

        g = nx.erdos_renyi_graph(v, p)
        self.load_from_nx(g) 

    __swig_destroy__ = _libcolgraph.delete_BaseGraph

# Register BaseGraph in _libcolgraph:
_libcolgraph.BaseGraph_swigregister(BaseGraph)

class ColoringGraph(_ColoringGraph):
    r"""

    `ColoringGraph(int k, BaseGraph *bg)`  

    Constructors
    ------------
    * `ColoringGraph(int k, BaseGraph *bg)`  

    Attributes
    ----------
    * `colors` : `const int`  

    * `base` : `BaseGraph *`  

    * `precompexp` : `std::vector< std::vector< long > >`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    colors = property(_libcolgraph.ColoringGraph_colors_get)
    base = property(_libcolgraph.ColoringGraph_base_get, _libcolgraph.ColoringGraph_base_set)
    precompexp = property(_libcolgraph.ColoringGraph_precompexp_get, _libcolgraph.ColoringGraph_precompexp_set)

    def __init__(self, k, bg):
        r"""

        `ColoringGraph(int k, BaseGraph *bg)`  

        """
        _libcolgraph.ColoringGraph_swiginit(self, _libcolgraph.new_ColoringGraph(k, bg))

    def add_vertex(self, name):
        r"""

        `add_vertex(long name)`  

        """
        return _libcolgraph.ColoringGraph_add_vertex(self, name)

    def is_isomorphic(self, a, b):
        r"""

        `is_isomorphic(long a, long b) -> bool`  

        """
        return _libcolgraph.ColoringGraph_is_isomorphic(self, a, b)

    def get_possible_colors(self, vertexgroup):
        r"""

        `get_possible_colors(std::vector< long > vertexgroup) -> std::vector<
            std::vector< int > >`  

        """
        return _libcolgraph.ColoringGraph_get_possible_colors(self, vertexgroup)

    def __iter__(self):
        r"""

        `__iter__() -> const ColoringGraphVertexIterator *`  

        """
        return _libcolgraph.ColoringGraph___iter__(self)

    def get_vertices(self):
        r"""

        `get_vertices() -> const ColoringGraphVertexIterator *`  

        """
        return _libcolgraph.ColoringGraph_get_vertices(self)

    def tarjans(self):
        r"""

        `tarjans() -> MetaGraph *`  

        """
        return _libcolgraph.ColoringGraph_tarjans(self)
    __swig_destroy__ = _libcolgraph.delete_ColoringGraph

# Register ColoringGraph in _libcolgraph:
_libcolgraph.ColoringGraph_swigregister(ColoringGraph)

class MetaGraph(_MetaGraph):
    r"""

    `MetaGraph()`  

    Constructors
    ------------
    * `MetaGraph()`  

    Attributes
    ----------
    * `colors` : `int`  

    * `base` : `BaseGraph *`  

    * `cut_vertices` : `std::unordered_set< long >`  

    * `unique_cut_vertices` : `std::unordered_set< long >`  

    * `mothership_cut_vertices` : `std::unordered_set< long >`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    colors = property(_libcolgraph.MetaGraph_colors_get, _libcolgraph.MetaGraph_colors_set)
    base = property(_libcolgraph.MetaGraph_base_get, _libcolgraph.MetaGraph_base_set)
    cut_vertices = property(_libcolgraph.MetaGraph_cut_vertices_get, _libcolgraph.MetaGraph_cut_vertices_set)
    unique_cut_vertices = property(_libcolgraph.MetaGraph_unique_cut_vertices_get, _libcolgraph.MetaGraph_unique_cut_vertices_set)
    mothership_cut_vertices = property(_libcolgraph.MetaGraph_mothership_cut_vertices_get, _libcolgraph.MetaGraph_mothership_cut_vertices_set)

    def __init__(self):
        r"""

        `MetaGraph()`  

        """
        _libcolgraph.MetaGraph_swiginit(self, _libcolgraph.new_MetaGraph())

    def add_vertex(self, *args):
        r"""

        `add_vertex(long name)`  
        `add_vertex() -> MetaVertex *`  

        Overloaded function
        -------------------
        * `add_vertex(long name)`  

        * `add_vertex() -> MetaVertex *`  

        """
        return _libcolgraph.MetaGraph_add_vertex(self, *args)

    def remove_vertex(self, m):
        r"""

        `remove_vertex(MetaVertex *m)`  

        """
        return _libcolgraph.MetaGraph_remove_vertex(self, m)

    def __iter__(self):
        r"""

        `__iter__() -> const MetaGraphVertexIterator *`  

        """
        return _libcolgraph.MetaGraph___iter__(self)

    def get_vertices(self):
        r"""

        `get_vertices() -> const MetaGraphVertexIterator *`  

        """
        return _libcolgraph.MetaGraph_get_vertices(self)

    def get_cut_vertices(self):
        r"""

        `get_cut_vertices() -> const MetaGraphCutVertexIterator *`  

        """
        return _libcolgraph.MetaGraph_get_cut_vertices(self)

    def get_mothership_cut_vertices(self):
        r"""

        `get_mothership_cut_vertices() -> const MetaGraphCutVertexIterator *`  

        """
        return _libcolgraph.MetaGraph_get_mothership_cut_vertices(self)

    def _DFS_and_add(self, cg, itercg, name, mothership):
        r"""

        `_DFS_and_add(ColoringGraph *cg, ColoringGraph *itercg, long name,
            std::unordered_set< long > &mothership)`  

        """
        return _libcolgraph.MetaGraph__DFS_and_add(self, cg, itercg, name, mothership)

    def identify_mothership(self):
        r"""

        `identify_mothership() -> long`  

        """
        return _libcolgraph.MetaGraph_identify_mothership(self)

    def rebuild_partial_graph(self):
        r"""

        `rebuild_partial_graph() -> ColoringGraph *`  

        """
        return _libcolgraph.MetaGraph_rebuild_partial_graph(self)
    __swig_destroy__ = _libcolgraph.delete_MetaGraph

# Register MetaGraph in _libcolgraph:
_libcolgraph.MetaGraph_swigregister(MetaGraph)

class BaseVertexNeighborIterator(_BaseVertexNeighborIterator):
    r"""

    `BaseVertexNeighborIterator()`  
    `BaseVertexNeighborIterator(std::unordered_set< long >::iterator it_, long
        len_)`  

    Constructors
    ------------
    * `BaseVertexNeighborIterator()`  

    * `BaseVertexNeighborIterator(std::unordered_set< long >::iterator it_, long
        len_)`  

    Attributes
    ----------
    * `it` : `std::unordered_set< long >::iterator`  

    * `len` : `long`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    it = property(_libcolgraph.BaseVertexNeighborIterator_it_get, _libcolgraph.BaseVertexNeighborIterator_it_set)
    len = property(_libcolgraph.BaseVertexNeighborIterator_len_get, _libcolgraph.BaseVertexNeighborIterator_len_set)

    def __init__(self, *args):
        r"""

        `BaseVertexNeighborIterator()`  
        `BaseVertexNeighborIterator(std::unordered_set< long >::iterator it_, long
            len_)`  

        Overloaded function
        -------------------
        * `BaseVertexNeighborIterator()`  

        * `BaseVertexNeighborIterator(std::unordered_set< long >::iterator it_, long
            len_)`  

        """
        _libcolgraph.BaseVertexNeighborIterator_swiginit(self, _libcolgraph.new_BaseVertexNeighborIterator(*args))

    def next(self):
        r"""

        `next() -> long`  

        """
        return _libcolgraph.BaseVertexNeighborIterator_next(self)

    def hasnext(self):
        r"""

        `hasnext() -> bool`  

        """
        return _libcolgraph.BaseVertexNeighborIterator_hasnext(self)
    __swig_destroy__ = _libcolgraph.delete_BaseVertexNeighborIterator

# Register BaseVertexNeighborIterator in _libcolgraph:
_libcolgraph.BaseVertexNeighborIterator_swigregister(BaseVertexNeighborIterator)

class ColoringVertexNeighborIterator(_ColoringVertexNeighborIterator):
    r"""

    `ColoringVertexNeighborIterator()`  
    `ColoringVertexNeighborIterator(long name_, int colors_, ColoringGraph *graph_)`  

    Constructors
    ------------
    * `ColoringVertexNeighborIterator()`  

    * `ColoringVertexNeighborIterator(long name_, int colors_, ColoringGraph
        *graph_)`  

    Attributes
    ----------
    * `name` : `long`  

    * `colors` : `int`  

    * `graph` : `ColoringGraph *`  

    * `outerpos` : `int`  

    * `positionctr` : `int`  

    * `colorctr` : `int`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    name = property(_libcolgraph.ColoringVertexNeighborIterator_name_get, _libcolgraph.ColoringVertexNeighborIterator_name_set)
    colors = property(_libcolgraph.ColoringVertexNeighborIterator_colors_get, _libcolgraph.ColoringVertexNeighborIterator_colors_set)
    graph = property(_libcolgraph.ColoringVertexNeighborIterator_graph_get, _libcolgraph.ColoringVertexNeighborIterator_graph_set)
    outerpos = property(_libcolgraph.ColoringVertexNeighborIterator_outerpos_get, _libcolgraph.ColoringVertexNeighborIterator_outerpos_set)
    positionctr = property(_libcolgraph.ColoringVertexNeighborIterator_positionctr_get, _libcolgraph.ColoringVertexNeighborIterator_positionctr_set)
    colorctr = property(_libcolgraph.ColoringVertexNeighborIterator_colorctr_get, _libcolgraph.ColoringVertexNeighborIterator_colorctr_set)

    def __init__(self, *args):
        r"""

        `ColoringVertexNeighborIterator()`  
        `ColoringVertexNeighborIterator(long name_, int colors_, ColoringGraph *graph_)`  

        Overloaded function
        -------------------
        * `ColoringVertexNeighborIterator()`  

        * `ColoringVertexNeighborIterator(long name_, int colors_, ColoringGraph
            *graph_)`  

        """
        _libcolgraph.ColoringVertexNeighborIterator_swiginit(self, _libcolgraph.new_ColoringVertexNeighborIterator(*args))

    def next(self):
        r"""

        `next() -> long`  

        """
        return _libcolgraph.ColoringVertexNeighborIterator_next(self)

    def hasnext(self):
        r"""

        `hasnext() -> bool`  

        """
        return _libcolgraph.ColoringVertexNeighborIterator_hasnext(self)
    __swig_destroy__ = _libcolgraph.delete_ColoringVertexNeighborIterator

# Register ColoringVertexNeighborIterator in _libcolgraph:
_libcolgraph.ColoringVertexNeighborIterator_swigregister(ColoringVertexNeighborIterator)

class MetaVertexNeighborIterator(_MetaVertexNeighborIterator):
    r"""

    `MetaVertexNeighborIterator()`  
    `MetaVertexNeighborIterator(std::unordered_set< long >::iterator it_, long
        len_)`  

    Constructors
    ------------
    * `MetaVertexNeighborIterator()`  

    * `MetaVertexNeighborIterator(std::unordered_set< long >::iterator it_, long
        len_)`  

    Attributes
    ----------
    * `it` : `std::unordered_set< long >::iterator`  

    * `len` : `long`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    it = property(_libcolgraph.MetaVertexNeighborIterator_it_get, _libcolgraph.MetaVertexNeighborIterator_it_set)
    len = property(_libcolgraph.MetaVertexNeighborIterator_len_get, _libcolgraph.MetaVertexNeighborIterator_len_set)

    def __init__(self, *args):
        r"""

        `MetaVertexNeighborIterator()`  
        `MetaVertexNeighborIterator(std::unordered_set< long >::iterator it_, long
            len_)`  

        Overloaded function
        -------------------
        * `MetaVertexNeighborIterator()`  

        * `MetaVertexNeighborIterator(std::unordered_set< long >::iterator it_, long
            len_)`  

        """
        _libcolgraph.MetaVertexNeighborIterator_swiginit(self, _libcolgraph.new_MetaVertexNeighborIterator(*args))

    def next(self):
        r"""

        `next() -> long`  

        """
        return _libcolgraph.MetaVertexNeighborIterator_next(self)

    def hasnext(self):
        r"""

        `hasnext() -> bool`  

        """
        return _libcolgraph.MetaVertexNeighborIterator_hasnext(self)
    __swig_destroy__ = _libcolgraph.delete_MetaVertexNeighborIterator

# Register MetaVertexNeighborIterator in _libcolgraph:
_libcolgraph.MetaVertexNeighborIterator_swigregister(MetaVertexNeighborIterator)

class MetaGraphCutVertexIterator(MetaVertexNeighborIterator):
    r"""

    `MetaGraphCutVertexIterator()`  
    `MetaGraphCutVertexIterator(std::unordered_set< long >::iterator it_, long
        len_)`  

    Constructors
    ------------
    * `MetaGraphCutVertexIterator()`  

    * `MetaGraphCutVertexIterator(std::unordered_set< long >::iterator it_, long
        len_)`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        `MetaGraphCutVertexIterator()`  
        `MetaGraphCutVertexIterator(std::unordered_set< long >::iterator it_, long
            len_)`  

        Overloaded function
        -------------------
        * `MetaGraphCutVertexIterator()`  

        * `MetaGraphCutVertexIterator(std::unordered_set< long >::iterator it_, long
            len_)`  

        """
        _libcolgraph.MetaGraphCutVertexIterator_swiginit(self, _libcolgraph.new_MetaGraphCutVertexIterator(*args))
    __swig_destroy__ = _libcolgraph.delete_MetaGraphCutVertexIterator

# Register MetaGraphCutVertexIterator in _libcolgraph:
_libcolgraph.MetaGraphCutVertexIterator_swigregister(MetaGraphCutVertexIterator)

class MetaVertexStoredVerticesIterator(MetaVertexNeighborIterator):
    r"""

    `MetaVertexStoredVerticesIterator(std::unordered_set< long >::iterator it_, long
        len_)`  

    Constructors
    ------------
    * `MetaVertexStoredVerticesIterator(std::unordered_set< long >::iterator it_,
        long len_)`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, it_, len_):
        r"""

        `MetaVertexStoredVerticesIterator(std::unordered_set< long >::iterator it_, long
            len_)`  

        """
        _libcolgraph.MetaVertexStoredVerticesIterator_swiginit(self, _libcolgraph.new_MetaVertexStoredVerticesIterator(it_, len_))
    __swig_destroy__ = _libcolgraph.delete_MetaVertexStoredVerticesIterator

# Register MetaVertexStoredVerticesIterator in _libcolgraph:
_libcolgraph.MetaVertexStoredVerticesIterator_swigregister(MetaVertexStoredVerticesIterator)

class Vertex(object):
    r"""

    `Vertex()`  
    `Vertex(long name_)`  

    Constructors
    ------------
    * `Vertex()`  

    * `Vertex(long name_)`  

    Attributes
    ----------
    * `name` : `long`  

    * `depth` : `int`  

    * `lowpoint` : `int`  

    * `parent` : `std::list< long >::iterator`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    name = property(_libcolgraph.Vertex_name_get, _libcolgraph.Vertex_name_set)
    depth = property(_libcolgraph.Vertex_depth_get, _libcolgraph.Vertex_depth_set)
    lowpoint = property(_libcolgraph.Vertex_lowpoint_get, _libcolgraph.Vertex_lowpoint_set)
    parent = property(_libcolgraph.Vertex_parent_get, _libcolgraph.Vertex_parent_set)
    __swig_destroy__ = _libcolgraph.delete_Vertex

    def __eq__(self, other):
        return _libcolgraph.Vertex___eq__(self, other)

    def size(self):
        r"""

        `size() -> int`  

        """
        return _libcolgraph.Vertex_size(self)

    def get_next_neighbor(self):
        r"""

        `get_next_neighbor()=0 -> long`  

        """
        return _libcolgraph.Vertex_get_next_neighbor(self)

    def reset_neighbor_track(self):
        r"""

        `reset_neighbor_track()=0`  

        """
        return _libcolgraph.Vertex_reset_neighbor_track(self)

    def has_next_neighbor(self):
        r"""

        `has_next_neighbor()=0 -> bool`  

        """
        return _libcolgraph.Vertex_has_next_neighbor(self)

    def get_name(self):
        r"""

        `get_name() const  -> long`  

        """
        return _libcolgraph.Vertex_get_name(self)

    def __str__(self):
        '''
        Returns
        ---
        str
        	a short string representation of Vertex instance
        '''
        return '<Vertex [{}, size:{}] of {} >'.format(self.get_name(),
                                                      self.size(), 
                                                      type(self))

    def __repr__(self):
        return self.__str__()

    def __len__(self):
        '''
        Returns
        -------
        int
            output of size() of vertex, represents number of vertices in a
            metavertex, or 1 in case of a BaseVertex, or ColoringVertex 
            instance
        '''
        return self.size()


# Register Vertex in _libcolgraph:
_libcolgraph.Vertex_swigregister(Vertex)

class BaseVertex(Vertex):
    r"""

    `BaseVertex()`  
    `BaseVertex(long name_)`  

    Constructors
    ------------
    * `BaseVertex()`  

    * `BaseVertex(long name_)`  

    Attributes
    ----------
    * `neighbors` : `std::unordered_set< long >`  

    * `nt` : `BaseVertexNeighborIterator *`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    neighbors = property(_libcolgraph.BaseVertex_neighbors_get, _libcolgraph.BaseVertex_neighbors_set)
    nt = property(_libcolgraph.BaseVertex_nt_get, _libcolgraph.BaseVertex_nt_set)

    def __init__(self, *args):
        r"""

        `BaseVertex()`  
        `BaseVertex(long name_)`  

        Overloaded function
        -------------------
        * `BaseVertex()`  

        * `BaseVertex(long name_)`  

        """
        _libcolgraph.BaseVertex_swiginit(self, _libcolgraph.new_BaseVertex(*args))

    def add_neighbor(self, other):
        r"""

        `add_neighbor(Vertex &other)`  

        """
        return _libcolgraph.BaseVertex_add_neighbor(self, other)

    def get_next_neighbor(self):
        r"""

        `get_next_neighbor() -> long`  

        """
        return _libcolgraph.BaseVertex_get_next_neighbor(self)

    def reset_neighbor_track(self):
        r"""

        `reset_neighbor_track()`  

        """
        return _libcolgraph.BaseVertex_reset_neighbor_track(self)

    def has_next_neighbor(self):
        r"""

        `has_next_neighbor() -> bool`  

        """
        return _libcolgraph.BaseVertex_has_next_neighbor(self)

    def __iter__(self):
        r"""

        `__iter__() -> BaseVertexNeighborIterator *`  

        """
        return _libcolgraph.BaseVertex___iter__(self)

    def get_neighbors(self):
        r"""

        `get_neighbors() -> BaseVertexNeighborIterator *`  

        """
        return _libcolgraph.BaseVertex_get_neighbors(self)
    __swig_destroy__ = _libcolgraph.delete_BaseVertex

# Register BaseVertex in _libcolgraph:
_libcolgraph.BaseVertex_swigregister(BaseVertex)

class ColoringVertex(Vertex):
    r"""

    `ColoringVertex(long name_, int k, ColoringGraph *graph_)`  

    Constructors
    ------------
    * `ColoringVertex(long name_, int k, ColoringGraph *graph_)`  

    Attributes
    ----------
    * `colors` : `const int`  

    * `graph` : `ColoringGraph *`  

    * `nt` : `ColoringVertexNeighborIterator *`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    colors = property(_libcolgraph.ColoringVertex_colors_get)
    graph = property(_libcolgraph.ColoringVertex_graph_get, _libcolgraph.ColoringVertex_graph_set)
    nt = property(_libcolgraph.ColoringVertex_nt_get, _libcolgraph.ColoringVertex_nt_set)

    def __init__(self, name_, k, graph_):
        r"""

        `ColoringVertex(long name_, int k, ColoringGraph *graph_)`  

        """
        _libcolgraph.ColoringVertex_swiginit(self, _libcolgraph.new_ColoringVertex(name_, k, graph_))

    def get_next_neighbor(self):
        r"""

        `get_next_neighbor() -> long`  

        """
        return _libcolgraph.ColoringVertex_get_next_neighbor(self)

    def reset_neighbor_track(self):
        r"""

        `reset_neighbor_track()`  

        """
        return _libcolgraph.ColoringVertex_reset_neighbor_track(self)

    def has_next_neighbor(self):
        r"""

        `has_next_neighbor() -> bool`  

        """
        return _libcolgraph.ColoringVertex_has_next_neighbor(self)

    def __iter__(self):
        r"""

        `__iter__() -> ColoringVertexNeighborIterator *`  

        """
        return _libcolgraph.ColoringVertex___iter__(self)

    def get_neighbors(self):
        r"""

        `get_neighbors() -> ColoringVertexNeighborIterator *`  

        """
        return _libcolgraph.ColoringVertex_get_neighbors(self)
    __swig_destroy__ = _libcolgraph.delete_ColoringVertex

# Register ColoringVertex in _libcolgraph:
_libcolgraph.ColoringVertex_swigregister(ColoringVertex)

class MetaVertex(Vertex):
    r"""

    `MetaVertex(long name_)`  

    Constructors
    ------------
    * `MetaVertex(long name_)`  

    Attributes
    ----------
    * `neighbors` : `std::unordered_set< long >`  

    * `vertices` : `std::unordered_set< long >`  

    * `nt` : `MetaVertexNeighborIterator *`  

    * `identity` : `long`  

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    neighbors = property(_libcolgraph.MetaVertex_neighbors_get, _libcolgraph.MetaVertex_neighbors_set)
    vertices = property(_libcolgraph.MetaVertex_vertices_get, _libcolgraph.MetaVertex_vertices_set)
    nt = property(_libcolgraph.MetaVertex_nt_get, _libcolgraph.MetaVertex_nt_set)
    identity = property(_libcolgraph.MetaVertex_identity_get, _libcolgraph.MetaVertex_identity_set)

    def __init__(self, name_):
        r"""

        `MetaVertex(long name_)`  

        """
        _libcolgraph.MetaVertex_swiginit(self, _libcolgraph.new_MetaVertex(name_))
    __swig_destroy__ = _libcolgraph.delete_MetaVertex

    def size(self):
        r"""

        `size() -> int`  

        """
        return _libcolgraph.MetaVertex_size(self)

    def add_neighbor(self, other):
        r"""

        `add_neighbor(MetaVertex &other)`  

        """
        return _libcolgraph.MetaVertex_add_neighbor(self, other)

    def connect(self, v):
        r"""

        `connect(MetaVertex *v)`  

        """
        return _libcolgraph.MetaVertex_connect(self, v)

    def disconnect(self, v):
        r"""

        `disconnect(MetaVertex *v)`  

        """
        return _libcolgraph.MetaVertex_disconnect(self, v)

    def get_next_neighbor(self):
        r"""

        `get_next_neighbor() -> long`  

        """
        return _libcolgraph.MetaVertex_get_next_neighbor(self)

    def reset_neighbor_track(self):
        r"""

        `reset_neighbor_track()`  

        """
        return _libcolgraph.MetaVertex_reset_neighbor_track(self)

    def has_next_neighbor(self):
        r"""

        `has_next_neighbor() -> bool`  

        """
        return _libcolgraph.MetaVertex_has_next_neighbor(self)

    def __iter__(self):
        r"""

        `__iter__() -> MetaVertexNeighborIterator *`  

        """
        return _libcolgraph.MetaVertex___iter__(self)

    def get_neighbors(self):
        r"""

        `get_neighbors() -> MetaVertexNeighborIterator *`  

        """
        return _libcolgraph.MetaVertex_get_neighbors(self)

    def get_vertices(self):
        r"""

        `get_vertices() -> MetaVertexStoredVerticesIterator *`  

        """
        return _libcolgraph.MetaVertex_get_vertices(self)

# Register MetaVertex in _libcolgraph:
_libcolgraph.MetaVertex_swigregister(MetaVertex)



