# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openeo_processes_dask',
 'openeo_processes_dask.process_implementations',
 'openeo_processes_dask.process_implementations.cubes',
 'openeo_processes_dask.process_implementations.ml']

package_data = \
{'': ['*']}

install_requires = \
['dask-geopandas>=0.2.0,<1',
 'dask[array]>=2022.11.1',
 'datacube>=1.8.4,<2.0.0',
 'geopandas>=0.12.1,<1',
 'odc-algo>=0.2.3,<1',
 'openeo-pg-parser-networkx>=2022.11.0',
 'rasterio>=1.3.4,<2.0.0',
 'rioxarray>=0.12.0,<1',
 'xarray>=2022.11.0',
 'xgboost>=1.5.1,<2.0.0']

setup_kwargs = {
    'name': 'openeo-processes-dask',
    'version': '2022.12.2',
    'description': 'Python implementations of many OpenEO processes, dask-friendly by default.',
    'long_description': "# OpenEO Processes Dask\n\n[![codecov](https://codecov.io/github/Open-EO/openeo-processes-dask/branch/main/graph/badge.svg?token=RA82MUN9RZ)](https://codecov.io/github/Open-EO/openeo-processes-dask)\n\n## Development environment\nopeneo-processes-dask requires poetry >1.2, see their [docs](https://python-poetry.org/docs/#installation) for installation instructions.\n\nTo setup the python venv and install this project into it run:\n```\npoetry install\n```\n\nTo add a new core dependency run:\n```\npoetry add some_new_dependency\n```\n\nTo add a new development dependency run:\n```\npoetry add some_new_dependency --group dev\n```\n\nTo run the test suite run:\n```\npoetry run python -m pytest\n```\n\nNote that you can also use the virtual environment that's generated by poetry as the kernel for the ipynb notebooks.\n\n**Pre-commit hooks**\n\nThis repo makes use of [pre-commit](https://pre-commit.com/) hooks to enforce linting & a few sanity checks. In a fresh development setup, install the hooks using `poetry run pre-commit install`. These will then automatically be checked against your changes before making the commit.\n",
    'author': 'Lukas Weidenholzer',
    'author_email': 'lukas.weidenholzer@eodc.eu',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Open-EO/openeo-processes-dask',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<3.10',
}


setup(**setup_kwargs)
