# OpenEO Processes Dask

[![codecov](https://codecov.io/github/Open-EO/openeo-processes-dask/branch/main/graph/badge.svg?token=RA82MUN9RZ)](https://codecov.io/github/Open-EO/openeo-processes-dask)

## Development environment
openeo-processes-dask requires poetry >1.2, see their [docs](https://python-poetry.org/docs/#installation) for installation instructions.

To setup the python venv and install this project into it run:
```
poetry install
```

To add a new core dependency run:
```
poetry add some_new_dependency
```

To add a new development dependency run:
```
poetry add some_new_dependency --group dev
```

To run the test suite run:
```
poetry run python -m pytest
```

Note that you can also use the virtual environment that's generated by poetry as the kernel for the ipynb notebooks.

**Pre-commit hooks**

This repo makes use of [pre-commit](https://pre-commit.com/) hooks to enforce linting & a few sanity checks. In a fresh development setup, install the hooks using `poetry run pre-commit install`. These will then automatically be checked against your changes before making the commit.
