# coding: utf-8

"""
    videoapi

    The video APIs help you convert, encode, and transcode videos.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class NsfwResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'successful': 'bool',
        'highest_classification_result': 'str',
        'highest_score': 'float',
        'total_racy_frames': 'int',
        'total_nsfw_frames': 'int',
        'total_frames': 'int',
        'nsfw_scanned_frames': 'list[NsfwScannedFrame]'
    }

    attribute_map = {
        'successful': 'Successful',
        'highest_classification_result': 'HighestClassificationResult',
        'highest_score': 'HighestScore',
        'total_racy_frames': 'TotalRacyFrames',
        'total_nsfw_frames': 'TotalNsfwFrames',
        'total_frames': 'TotalFrames',
        'nsfw_scanned_frames': 'NsfwScannedFrames'
    }

    def __init__(self, successful=None, highest_classification_result=None, highest_score=None, total_racy_frames=None, total_nsfw_frames=None, total_frames=None, nsfw_scanned_frames=None):  # noqa: E501
        """NsfwResult - a model defined in Swagger"""  # noqa: E501

        self._successful = None
        self._highest_classification_result = None
        self._highest_score = None
        self._total_racy_frames = None
        self._total_nsfw_frames = None
        self._total_frames = None
        self._nsfw_scanned_frames = None
        self.discriminator = None

        if successful is not None:
            self.successful = successful
        if highest_classification_result is not None:
            self.highest_classification_result = highest_classification_result
        if highest_score is not None:
            self.highest_score = highest_score
        if total_racy_frames is not None:
            self.total_racy_frames = total_racy_frames
        if total_nsfw_frames is not None:
            self.total_nsfw_frames = total_nsfw_frames
        if total_frames is not None:
            self.total_frames = total_frames
        if nsfw_scanned_frames is not None:
            self.nsfw_scanned_frames = nsfw_scanned_frames

    @property
    def successful(self):
        """Gets the successful of this NsfwResult.  # noqa: E501

        True if the operation was successful, false otherwise  # noqa: E501

        :return: The successful of this NsfwResult.  # noqa: E501
        :rtype: bool
        """
        return self._successful

    @successful.setter
    def successful(self, successful):
        """Sets the successful of this NsfwResult.

        True if the operation was successful, false otherwise  # noqa: E501

        :param successful: The successful of this NsfwResult.  # noqa: E501
        :type: bool
        """

        self._successful = successful

    @property
    def highest_classification_result(self):
        """Gets the highest_classification_result of this NsfwResult.  # noqa: E501

        The highest NSFW classification of the video  # noqa: E501

        :return: The highest_classification_result of this NsfwResult.  # noqa: E501
        :rtype: str
        """
        return self._highest_classification_result

    @highest_classification_result.setter
    def highest_classification_result(self, highest_classification_result):
        """Sets the highest_classification_result of this NsfwResult.

        The highest NSFW classification of the video  # noqa: E501

        :param highest_classification_result: The highest_classification_result of this NsfwResult.  # noqa: E501
        :type: str
        """

        self._highest_classification_result = highest_classification_result

    @property
    def highest_score(self):
        """Gets the highest_score of this NsfwResult.  # noqa: E501

        The highest NSFW score out of all frames scanned  # noqa: E501

        :return: The highest_score of this NsfwResult.  # noqa: E501
        :rtype: float
        """
        return self._highest_score

    @highest_score.setter
    def highest_score(self, highest_score):
        """Sets the highest_score of this NsfwResult.

        The highest NSFW score out of all frames scanned  # noqa: E501

        :param highest_score: The highest_score of this NsfwResult.  # noqa: E501
        :type: float
        """

        self._highest_score = highest_score

    @property
    def total_racy_frames(self):
        """Gets the total_racy_frames of this NsfwResult.  # noqa: E501

        The total number of potentially \"racy\" frames.  # noqa: E501

        :return: The total_racy_frames of this NsfwResult.  # noqa: E501
        :rtype: int
        """
        return self._total_racy_frames

    @total_racy_frames.setter
    def total_racy_frames(self, total_racy_frames):
        """Sets the total_racy_frames of this NsfwResult.

        The total number of potentially \"racy\" frames.  # noqa: E501

        :param total_racy_frames: The total_racy_frames of this NsfwResult.  # noqa: E501
        :type: int
        """

        self._total_racy_frames = total_racy_frames

    @property
    def total_nsfw_frames(self):
        """Gets the total_nsfw_frames of this NsfwResult.  # noqa: E501

        The total number of frames with high probability of NSFW.  # noqa: E501

        :return: The total_nsfw_frames of this NsfwResult.  # noqa: E501
        :rtype: int
        """
        return self._total_nsfw_frames

    @total_nsfw_frames.setter
    def total_nsfw_frames(self, total_nsfw_frames):
        """Sets the total_nsfw_frames of this NsfwResult.

        The total number of frames with high probability of NSFW.  # noqa: E501

        :param total_nsfw_frames: The total_nsfw_frames of this NsfwResult.  # noqa: E501
        :type: int
        """

        self._total_nsfw_frames = total_nsfw_frames

    @property
    def total_frames(self):
        """Gets the total_frames of this NsfwResult.  # noqa: E501

        The total number of frames scanned  # noqa: E501

        :return: The total_frames of this NsfwResult.  # noqa: E501
        :rtype: int
        """
        return self._total_frames

    @total_frames.setter
    def total_frames(self, total_frames):
        """Sets the total_frames of this NsfwResult.

        The total number of frames scanned  # noqa: E501

        :param total_frames: The total_frames of this NsfwResult.  # noqa: E501
        :type: int
        """

        self._total_frames = total_frames

    @property
    def nsfw_scanned_frames(self):
        """Gets the nsfw_scanned_frames of this NsfwResult.  # noqa: E501

        The NSFW scanning results for each frame  # noqa: E501

        :return: The nsfw_scanned_frames of this NsfwResult.  # noqa: E501
        :rtype: list[NsfwScannedFrame]
        """
        return self._nsfw_scanned_frames

    @nsfw_scanned_frames.setter
    def nsfw_scanned_frames(self, nsfw_scanned_frames):
        """Sets the nsfw_scanned_frames of this NsfwResult.

        The NSFW scanning results for each frame  # noqa: E501

        :param nsfw_scanned_frames: The nsfw_scanned_frames of this NsfwResult.  # noqa: E501
        :type: list[NsfwScannedFrame]
        """

        self._nsfw_scanned_frames = nsfw_scanned_frames

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NsfwResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NsfwResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
