# `TC202` - Verbose reraise

## Why is it bad

It's easy to silent major issues by wrapping `Exception` and never be aware of.
Consider at least logging the exception.

## How it looks like

```py
try:
    ...
except CustomException:
    pass
except Exception:
    pass
```

## How it should be

```py
try:
    ...
except CustomException:
    pass
except Exception:
    logger.exception("Something unexpected happen")
```
