# gooddata-metadata-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0
- Package version: 1.0.1a1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import gooddata_metadata_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import gooddata_metadata_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import gooddata_metadata_client
from pprint import pprint
from gooddata_metadata_client.api import actions_api
from gooddata_metadata_client.model.declarative_model import DeclarativeModel
from gooddata_metadata_client.model.generate_ldm_request import GenerateLdmRequest
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = gooddata_metadata_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with gooddata_metadata_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = actions_api.ActionsApi(api_client)
    data_source_id = "dataSourceId_example" # str | 
    generate_ldm_request = GenerateLdmRequest(
        date_granularities="all",
        denorm_prefix="dr",
        fact_prefix="f",
        generate_long_ids=True,
        grain_prefix="g",
        grain_reference_prefix="gr",
        primary_label_prefix="pl",
        reference_prefix="r",
        secondary_label_prefix="sl",
        separator="__",
        table_prefix="out_table",
        view_prefix="out_view",
        wdf_prefix="wdf",
    ) # GenerateLdmRequest | 

    try:
        # Generate logical data model (LDM) from physical data model (PDM)
        api_response = api_instance.generate_logical_model(data_source_id, generate_ldm_request)
        pprint(api_response)
    except gooddata_metadata_client.ApiException as e:
        print("Exception when calling ActionsApi->generate_logical_model: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActionsApi* | [**generate_logical_model**](docs/ActionsApi.md#generate_logical_model) | **POST** /api/v1/actions/dataSources/{dataSourceId}/generateLogicalModel | Generate logical data model (LDM) from physical data model (PDM)
*ActionsApi* | [**register_upload_notification**](docs/ActionsApi.md#register_upload_notification) | **POST** /api/v1/actions/dataSources/{dataSourceId}/uploadNotification | Register an upload notification
*EntitiesApi* | [**create_entity_analytical_dashboards**](docs/EntitiesApi.md#create_entity_analytical_dashboards) | **POST** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | 
*EntitiesApi* | [**create_entity_api_tokens**](docs/EntitiesApi.md#create_entity_api_tokens) | **POST** /api/v1/entities/users/{userId}/apiTokens | 
*EntitiesApi* | [**create_entity_dashboard_plugins**](docs/EntitiesApi.md#create_entity_dashboard_plugins) | **POST** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | 
*EntitiesApi* | [**create_entity_data_sources**](docs/EntitiesApi.md#create_entity_data_sources) | **POST** /api/v1/entities/dataSources | 
*EntitiesApi* | [**create_entity_filter_contexts**](docs/EntitiesApi.md#create_entity_filter_contexts) | **POST** /api/v1/entities/workspaces/{workspaceId}/filterContexts | 
*EntitiesApi* | [**create_entity_metrics**](docs/EntitiesApi.md#create_entity_metrics) | **POST** /api/v1/entities/workspaces/{workspaceId}/metrics | 
*EntitiesApi* | [**create_entity_user_groups**](docs/EntitiesApi.md#create_entity_user_groups) | **POST** /api/v1/entities/userGroups | 
*EntitiesApi* | [**create_entity_users**](docs/EntitiesApi.md#create_entity_users) | **POST** /api/v1/entities/users | 
*EntitiesApi* | [**create_entity_visualization_objects**](docs/EntitiesApi.md#create_entity_visualization_objects) | **POST** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | 
*EntitiesApi* | [**create_entity_workspace_data_filters**](docs/EntitiesApi.md#create_entity_workspace_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | 
*EntitiesApi* | [**create_entity_workspaces**](docs/EntitiesApi.md#create_entity_workspaces) | **POST** /api/v1/entities/workspaces | 
*EntitiesApi* | [**delete_entity_analytical_dashboards**](docs/EntitiesApi.md#delete_entity_analytical_dashboards) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*EntitiesApi* | [**delete_entity_api_tokens**](docs/EntitiesApi.md#delete_entity_api_tokens) | **DELETE** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*EntitiesApi* | [**delete_entity_dashboard_plugins**](docs/EntitiesApi.md#delete_entity_dashboard_plugins) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*EntitiesApi* | [**delete_entity_data_sources**](docs/EntitiesApi.md#delete_entity_data_sources) | **DELETE** /api/v1/entities/dataSources/{id} | 
*EntitiesApi* | [**delete_entity_filter_contexts**](docs/EntitiesApi.md#delete_entity_filter_contexts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*EntitiesApi* | [**delete_entity_metrics**](docs/EntitiesApi.md#delete_entity_metrics) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*EntitiesApi* | [**delete_entity_user_groups**](docs/EntitiesApi.md#delete_entity_user_groups) | **DELETE** /api/v1/entities/userGroups/{id} | 
*EntitiesApi* | [**delete_entity_users**](docs/EntitiesApi.md#delete_entity_users) | **DELETE** /api/v1/entities/users/{id} | 
*EntitiesApi* | [**delete_entity_visualization_objects**](docs/EntitiesApi.md#delete_entity_visualization_objects) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*EntitiesApi* | [**delete_entity_workspace_data_filters**](docs/EntitiesApi.md#delete_entity_workspace_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*EntitiesApi* | [**delete_entity_workspaces**](docs/EntitiesApi.md#delete_entity_workspaces) | **DELETE** /api/v1/entities/workspaces/{id} | 
*EntitiesApi* | [**get_all_entities_analytical_dashboards**](docs/EntitiesApi.md#get_all_entities_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | 
*EntitiesApi* | [**get_all_entities_api_tokens**](docs/EntitiesApi.md#get_all_entities_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens | 
*EntitiesApi* | [**get_all_entities_attributes**](docs/EntitiesApi.md#get_all_entities_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes | 
*EntitiesApi* | [**get_all_entities_dashboard_plugins**](docs/EntitiesApi.md#get_all_entities_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | 
*EntitiesApi* | [**get_all_entities_data_source_identifiers**](docs/EntitiesApi.md#get_all_entities_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers | 
*EntitiesApi* | [**get_all_entities_data_source_tables**](docs/EntitiesApi.md#get_all_entities_data_source_tables) | **GET** /api/v1/entities/dataSources/{dataSourceId}/dataSourceTables | 
*EntitiesApi* | [**get_all_entities_data_sources**](docs/EntitiesApi.md#get_all_entities_data_sources) | **GET** /api/v1/entities/dataSources | 
*EntitiesApi* | [**get_all_entities_datasets**](docs/EntitiesApi.md#get_all_entities_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets | 
*EntitiesApi* | [**get_all_entities_entitlements**](docs/EntitiesApi.md#get_all_entities_entitlements) | **GET** /api/v1/entities/entitlements | 
*EntitiesApi* | [**get_all_entities_facts**](docs/EntitiesApi.md#get_all_entities_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts | 
*EntitiesApi* | [**get_all_entities_filter_contexts**](docs/EntitiesApi.md#get_all_entities_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts | 
*EntitiesApi* | [**get_all_entities_labels**](docs/EntitiesApi.md#get_all_entities_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels | 
*EntitiesApi* | [**get_all_entities_metrics**](docs/EntitiesApi.md#get_all_entities_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics | 
*EntitiesApi* | [**get_all_entities_user_groups**](docs/EntitiesApi.md#get_all_entities_user_groups) | **GET** /api/v1/entities/userGroups | 
*EntitiesApi* | [**get_all_entities_users**](docs/EntitiesApi.md#get_all_entities_users) | **GET** /api/v1/entities/users | 
*EntitiesApi* | [**get_all_entities_visualization_objects**](docs/EntitiesApi.md#get_all_entities_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | 
*EntitiesApi* | [**get_all_entities_workspace_data_filter_settings**](docs/EntitiesApi.md#get_all_entities_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | 
*EntitiesApi* | [**get_all_entities_workspace_data_filters**](docs/EntitiesApi.md#get_all_entities_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | 
*EntitiesApi* | [**get_all_entities_workspaces**](docs/EntitiesApi.md#get_all_entities_workspaces) | **GET** /api/v1/entities/workspaces | 
*EntitiesApi* | [**get_all_options**](docs/EntitiesApi.md#get_all_options) | **GET** /api/v1/options | Links for all configuration options
*EntitiesApi* | [**get_data_source_drivers**](docs/EntitiesApi.md#get_data_source_drivers) | **GET** /api/v1/options/availableDrivers | Get all available data source drivers
*EntitiesApi* | [**get_entity_analytical_dashboards**](docs/EntitiesApi.md#get_entity_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*EntitiesApi* | [**get_entity_api_tokens**](docs/EntitiesApi.md#get_entity_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*EntitiesApi* | [**get_entity_attributes**](docs/EntitiesApi.md#get_entity_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes/{objectId} | 
*EntitiesApi* | [**get_entity_cookie_security_configurations**](docs/EntitiesApi.md#get_entity_cookie_security_configurations) | **GET** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*EntitiesApi* | [**get_entity_dashboard_plugins**](docs/EntitiesApi.md#get_entity_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*EntitiesApi* | [**get_entity_data_source_identifiers**](docs/EntitiesApi.md#get_entity_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers/{id} | 
*EntitiesApi* | [**get_entity_data_source_tables**](docs/EntitiesApi.md#get_entity_data_source_tables) | **GET** /api/v1/entities/dataSources/{dataSourceId}/dataSourceTables/{id} | 
*EntitiesApi* | [**get_entity_data_sources**](docs/EntitiesApi.md#get_entity_data_sources) | **GET** /api/v1/entities/dataSources/{id} | 
*EntitiesApi* | [**get_entity_datasets**](docs/EntitiesApi.md#get_entity_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets/{objectId} | 
*EntitiesApi* | [**get_entity_entitlements**](docs/EntitiesApi.md#get_entity_entitlements) | **GET** /api/v1/entities/entitlements/{id} | 
*EntitiesApi* | [**get_entity_facts**](docs/EntitiesApi.md#get_entity_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts/{objectId} | 
*EntitiesApi* | [**get_entity_filter_contexts**](docs/EntitiesApi.md#get_entity_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*EntitiesApi* | [**get_entity_labels**](docs/EntitiesApi.md#get_entity_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels/{objectId} | 
*EntitiesApi* | [**get_entity_metrics**](docs/EntitiesApi.md#get_entity_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*EntitiesApi* | [**get_entity_organizations**](docs/EntitiesApi.md#get_entity_organizations) | **GET** /api/v1/entities/admin/organizations/{id} | 
*EntitiesApi* | [**get_entity_user_groups**](docs/EntitiesApi.md#get_entity_user_groups) | **GET** /api/v1/entities/userGroups/{id} | 
*EntitiesApi* | [**get_entity_users**](docs/EntitiesApi.md#get_entity_users) | **GET** /api/v1/entities/users/{id} | 
*EntitiesApi* | [**get_entity_visualization_objects**](docs/EntitiesApi.md#get_entity_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*EntitiesApi* | [**get_entity_workspace_data_filter_settings**](docs/EntitiesApi.md#get_entity_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | 
*EntitiesApi* | [**get_entity_workspace_data_filters**](docs/EntitiesApi.md#get_entity_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*EntitiesApi* | [**get_entity_workspaces**](docs/EntitiesApi.md#get_entity_workspaces) | **GET** /api/v1/entities/workspaces/{id} | 
*EntitiesApi* | [**get_organization**](docs/EntitiesApi.md#get_organization) | **GET** /api/v1/entities/organization | Get current organization info
*EntitiesApi* | [**patch_entity_analytical_dashboards**](docs/EntitiesApi.md#patch_entity_analytical_dashboards) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*EntitiesApi* | [**patch_entity_cookie_security_configurations**](docs/EntitiesApi.md#patch_entity_cookie_security_configurations) | **PATCH** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*EntitiesApi* | [**patch_entity_dashboard_plugins**](docs/EntitiesApi.md#patch_entity_dashboard_plugins) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*EntitiesApi* | [**patch_entity_data_sources**](docs/EntitiesApi.md#patch_entity_data_sources) | **PATCH** /api/v1/entities/dataSources/{id} | 
*EntitiesApi* | [**patch_entity_filter_contexts**](docs/EntitiesApi.md#patch_entity_filter_contexts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*EntitiesApi* | [**patch_entity_metrics**](docs/EntitiesApi.md#patch_entity_metrics) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*EntitiesApi* | [**patch_entity_organizations**](docs/EntitiesApi.md#patch_entity_organizations) | **PATCH** /api/v1/entities/admin/organizations/{id} | 
*EntitiesApi* | [**patch_entity_user_groups**](docs/EntitiesApi.md#patch_entity_user_groups) | **PATCH** /api/v1/entities/userGroups/{id} | 
*EntitiesApi* | [**patch_entity_users**](docs/EntitiesApi.md#patch_entity_users) | **PATCH** /api/v1/entities/users/{id} | 
*EntitiesApi* | [**patch_entity_visualization_objects**](docs/EntitiesApi.md#patch_entity_visualization_objects) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*EntitiesApi* | [**patch_entity_workspace_data_filters**](docs/EntitiesApi.md#patch_entity_workspace_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*EntitiesApi* | [**patch_entity_workspaces**](docs/EntitiesApi.md#patch_entity_workspaces) | **PATCH** /api/v1/entities/workspaces/{id} | 
*EntitiesApi* | [**update_entity_analytical_dashboards**](docs/EntitiesApi.md#update_entity_analytical_dashboards) | **PUT** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*EntitiesApi* | [**update_entity_cookie_security_configurations**](docs/EntitiesApi.md#update_entity_cookie_security_configurations) | **PUT** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*EntitiesApi* | [**update_entity_dashboard_plugins**](docs/EntitiesApi.md#update_entity_dashboard_plugins) | **PUT** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*EntitiesApi* | [**update_entity_data_sources**](docs/EntitiesApi.md#update_entity_data_sources) | **PUT** /api/v1/entities/dataSources/{id} | 
*EntitiesApi* | [**update_entity_filter_contexts**](docs/EntitiesApi.md#update_entity_filter_contexts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*EntitiesApi* | [**update_entity_metrics**](docs/EntitiesApi.md#update_entity_metrics) | **PUT** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*EntitiesApi* | [**update_entity_organizations**](docs/EntitiesApi.md#update_entity_organizations) | **PUT** /api/v1/entities/admin/organizations/{id} | 
*EntitiesApi* | [**update_entity_user_groups**](docs/EntitiesApi.md#update_entity_user_groups) | **PUT** /api/v1/entities/userGroups/{id} | 
*EntitiesApi* | [**update_entity_users**](docs/EntitiesApi.md#update_entity_users) | **PUT** /api/v1/entities/users/{id} | 
*EntitiesApi* | [**update_entity_visualization_objects**](docs/EntitiesApi.md#update_entity_visualization_objects) | **PUT** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*EntitiesApi* | [**update_entity_workspace_data_filters**](docs/EntitiesApi.md#update_entity_workspace_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*EntitiesApi* | [**update_entity_workspaces**](docs/EntitiesApi.md#update_entity_workspaces) | **PUT** /api/v1/entities/workspaces/{id} | 
*LayoutApi* | [**get_analytics_model**](docs/LayoutApi.md#get_analytics_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Get analytics model
*LayoutApi* | [**get_data_sources_layout**](docs/LayoutApi.md#get_data_sources_layout) | **GET** /api/v1/layout/dataSources | Get all data sources
*LayoutApi* | [**get_logical_model**](docs/LayoutApi.md#get_logical_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Get logical model
*LayoutApi* | [**get_organization_layout**](docs/LayoutApi.md#get_organization_layout) | **GET** /api/v1/layout/organization | Get organization layout
*LayoutApi* | [**get_pdm_layout**](docs/LayoutApi.md#get_pdm_layout) | **GET** /api/v1/layout/dataSources/{dataSourceId}/physicalModel | Get data source physical model layout
*LayoutApi* | [**get_user_groups_layout**](docs/LayoutApi.md#get_user_groups_layout) | **GET** /api/v1/layout/userGroups | Get all user groups
*LayoutApi* | [**get_users_layout**](docs/LayoutApi.md#get_users_layout) | **GET** /api/v1/layout/users | Get all users
*LayoutApi* | [**get_users_user_groups_layout**](docs/LayoutApi.md#get_users_user_groups_layout) | **GET** /api/v1/layout/usersAndUserGroups | Get all users and user groups
*LayoutApi* | [**get_workspace_data_filters_layout**](docs/LayoutApi.md#get_workspace_data_filters_layout) | **GET** /api/v1/layout/workspaceDataFilters | Get workspace data filters for all workspaces
*LayoutApi* | [**get_workspace_layout**](docs/LayoutApi.md#get_workspace_layout) | **GET** /api/v1/layout/workspaces/{workspaceId} | Get workspace layout
*LayoutApi* | [**get_workspace_permissions**](docs/LayoutApi.md#get_workspace_permissions) | **GET** /api/v1/layout/workspaces/{workspaceId}/permissions | Get permissions for the workspace
*LayoutApi* | [**get_workspaces_layout**](docs/LayoutApi.md#get_workspaces_layout) | **GET** /api/v1/layout/workspaces | Get all workspaces layout
*LayoutApi* | [**put_data_sources_layout**](docs/LayoutApi.md#put_data_sources_layout) | **PUT** /api/v1/layout/dataSources | Put all data sources
*LayoutApi* | [**put_user_groups_layout**](docs/LayoutApi.md#put_user_groups_layout) | **PUT** /api/v1/layout/userGroups | Put all user groups
*LayoutApi* | [**put_users_layout**](docs/LayoutApi.md#put_users_layout) | **PUT** /api/v1/layout/users | Put all users
*LayoutApi* | [**put_users_user_groups_layout**](docs/LayoutApi.md#put_users_user_groups_layout) | **PUT** /api/v1/layout/usersAndUserGroups | Put all users and user groups
*LayoutApi* | [**put_workspace_layout**](docs/LayoutApi.md#put_workspace_layout) | **PUT** /api/v1/layout/workspaces/{workspaceId} | Set workspace layout
*LayoutApi* | [**set_analytics_model**](docs/LayoutApi.md#set_analytics_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Set analytics model
*LayoutApi* | [**set_logical_model**](docs/LayoutApi.md#set_logical_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Set logical model
*LayoutApi* | [**set_organization_layout**](docs/LayoutApi.md#set_organization_layout) | **PUT** /api/v1/layout/organization | Set organization layout
*LayoutApi* | [**set_pdm_layout**](docs/LayoutApi.md#set_pdm_layout) | **PUT** /api/v1/layout/dataSources/{dataSourceId}/physicalModel | Set data source physical model layout
*LayoutApi* | [**set_workspace_data_filters_layout**](docs/LayoutApi.md#set_workspace_data_filters_layout) | **PUT** /api/v1/layout/workspaceDataFilters | Set all workspace data filters
*LayoutApi* | [**set_workspace_permissions**](docs/LayoutApi.md#set_workspace_permissions) | **PUT** /api/v1/layout/workspaces/{workspaceId}/permissions | Set permissions for the workspace
*LayoutApi* | [**set_workspaces_layout**](docs/LayoutApi.md#set_workspaces_layout) | **PUT** /api/v1/layout/workspaces | Set all workspaces layout


## Documentation For Models

 - [AssigneeIdentifier](docs/AssigneeIdentifier.md)
 - [DataSourceTableIdentifier](docs/DataSourceTableIdentifier.md)
 - [DatasetReferenceIdentifier](docs/DatasetReferenceIdentifier.md)
 - [DeclarativeAnalyticalDashboard](docs/DeclarativeAnalyticalDashboard.md)
 - [DeclarativeAnalytics](docs/DeclarativeAnalytics.md)
 - [DeclarativeAnalyticsLayer](docs/DeclarativeAnalyticsLayer.md)
 - [DeclarativeAttribute](docs/DeclarativeAttribute.md)
 - [DeclarativeColumn](docs/DeclarativeColumn.md)
 - [DeclarativeDashboardPlugin](docs/DeclarativeDashboardPlugin.md)
 - [DeclarativeDataSource](docs/DeclarativeDataSource.md)
 - [DeclarativeDataSourcePermission](docs/DeclarativeDataSourcePermission.md)
 - [DeclarativeDataSources](docs/DeclarativeDataSources.md)
 - [DeclarativeDataset](docs/DeclarativeDataset.md)
 - [DeclarativeDateDataset](docs/DeclarativeDateDataset.md)
 - [DeclarativeFact](docs/DeclarativeFact.md)
 - [DeclarativeFilterContext](docs/DeclarativeFilterContext.md)
 - [DeclarativeLabel](docs/DeclarativeLabel.md)
 - [DeclarativeLdm](docs/DeclarativeLdm.md)
 - [DeclarativeMetric](docs/DeclarativeMetric.md)
 - [DeclarativeModel](docs/DeclarativeModel.md)
 - [DeclarativeOrganization](docs/DeclarativeOrganization.md)
 - [DeclarativeOrganizationInfo](docs/DeclarativeOrganizationInfo.md)
 - [DeclarativeOrganizationPermission](docs/DeclarativeOrganizationPermission.md)
 - [DeclarativePdm](docs/DeclarativePdm.md)
 - [DeclarativeReference](docs/DeclarativeReference.md)
 - [DeclarativeSingleWorkspacePermission](docs/DeclarativeSingleWorkspacePermission.md)
 - [DeclarativeTable](docs/DeclarativeTable.md)
 - [DeclarativeTables](docs/DeclarativeTables.md)
 - [DeclarativeUser](docs/DeclarativeUser.md)
 - [DeclarativeUserGroup](docs/DeclarativeUserGroup.md)
 - [DeclarativeUserGroups](docs/DeclarativeUserGroups.md)
 - [DeclarativeUsers](docs/DeclarativeUsers.md)
 - [DeclarativeUsersUserGroups](docs/DeclarativeUsersUserGroups.md)
 - [DeclarativeVisualizationObject](docs/DeclarativeVisualizationObject.md)
 - [DeclarativeWorkspace](docs/DeclarativeWorkspace.md)
 - [DeclarativeWorkspaceDataFilter](docs/DeclarativeWorkspaceDataFilter.md)
 - [DeclarativeWorkspaceDataFilterSetting](docs/DeclarativeWorkspaceDataFilterSetting.md)
 - [DeclarativeWorkspaceDataFilters](docs/DeclarativeWorkspaceDataFilters.md)
 - [DeclarativeWorkspaceHierarchyPermission](docs/DeclarativeWorkspaceHierarchyPermission.md)
 - [DeclarativeWorkspaceModel](docs/DeclarativeWorkspaceModel.md)
 - [DeclarativeWorkspacePermissions](docs/DeclarativeWorkspacePermissions.md)
 - [DeclarativeWorkspaces](docs/DeclarativeWorkspaces.md)
 - [GenerateLdmRequest](docs/GenerateLdmRequest.md)
 - [GrainIdentifier](docs/GrainIdentifier.md)
 - [GranularitiesFormatting](docs/GranularitiesFormatting.md)
 - [JsonApiAnalyticalDashboardIn](docs/JsonApiAnalyticalDashboardIn.md)
 - [JsonApiAnalyticalDashboardInAttributes](docs/JsonApiAnalyticalDashboardInAttributes.md)
 - [JsonApiAnalyticalDashboardInDocument](docs/JsonApiAnalyticalDashboardInDocument.md)
 - [JsonApiAnalyticalDashboardLinkage](docs/JsonApiAnalyticalDashboardLinkage.md)
 - [JsonApiAnalyticalDashboardOut](docs/JsonApiAnalyticalDashboardOut.md)
 - [JsonApiAnalyticalDashboardOutDocument](docs/JsonApiAnalyticalDashboardOutDocument.md)
 - [JsonApiAnalyticalDashboardOutIncludes](docs/JsonApiAnalyticalDashboardOutIncludes.md)
 - [JsonApiAnalyticalDashboardOutList](docs/JsonApiAnalyticalDashboardOutList.md)
 - [JsonApiAnalyticalDashboardOutRelationships](docs/JsonApiAnalyticalDashboardOutRelationships.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsAnalyticalDashboards](docs/JsonApiAnalyticalDashboardOutRelationshipsAnalyticalDashboards.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsDashboardPlugins](docs/JsonApiAnalyticalDashboardOutRelationshipsDashboardPlugins.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsDatasets](docs/JsonApiAnalyticalDashboardOutRelationshipsDatasets.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsFilterContexts](docs/JsonApiAnalyticalDashboardOutRelationshipsFilterContexts.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsLabels](docs/JsonApiAnalyticalDashboardOutRelationshipsLabels.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsMetrics](docs/JsonApiAnalyticalDashboardOutRelationshipsMetrics.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsVisualizationObjects](docs/JsonApiAnalyticalDashboardOutRelationshipsVisualizationObjects.md)
 - [JsonApiAnalyticalDashboardOutWithLinks](docs/JsonApiAnalyticalDashboardOutWithLinks.md)
 - [JsonApiAnalyticalDashboardPatch](docs/JsonApiAnalyticalDashboardPatch.md)
 - [JsonApiAnalyticalDashboardPatchDocument](docs/JsonApiAnalyticalDashboardPatchDocument.md)
 - [JsonApiAnalyticalDashboardToManyLinkage](docs/JsonApiAnalyticalDashboardToManyLinkage.md)
 - [JsonApiApiTokenIn](docs/JsonApiApiTokenIn.md)
 - [JsonApiApiTokenInDocument](docs/JsonApiApiTokenInDocument.md)
 - [JsonApiApiTokenOut](docs/JsonApiApiTokenOut.md)
 - [JsonApiApiTokenOutAttributes](docs/JsonApiApiTokenOutAttributes.md)
 - [JsonApiApiTokenOutDocument](docs/JsonApiApiTokenOutDocument.md)
 - [JsonApiApiTokenOutList](docs/JsonApiApiTokenOutList.md)
 - [JsonApiApiTokenOutWithLinks](docs/JsonApiApiTokenOutWithLinks.md)
 - [JsonApiAttributeLinkage](docs/JsonApiAttributeLinkage.md)
 - [JsonApiAttributeOut](docs/JsonApiAttributeOut.md)
 - [JsonApiAttributeOutAttributes](docs/JsonApiAttributeOutAttributes.md)
 - [JsonApiAttributeOutDocument](docs/JsonApiAttributeOutDocument.md)
 - [JsonApiAttributeOutIncludes](docs/JsonApiAttributeOutIncludes.md)
 - [JsonApiAttributeOutList](docs/JsonApiAttributeOutList.md)
 - [JsonApiAttributeOutRelationships](docs/JsonApiAttributeOutRelationships.md)
 - [JsonApiAttributeOutRelationshipsDataset](docs/JsonApiAttributeOutRelationshipsDataset.md)
 - [JsonApiAttributeOutRelationshipsDefaultView](docs/JsonApiAttributeOutRelationshipsDefaultView.md)
 - [JsonApiAttributeOutWithLinks](docs/JsonApiAttributeOutWithLinks.md)
 - [JsonApiAttributeToManyLinkage](docs/JsonApiAttributeToManyLinkage.md)
 - [JsonApiAttributeToOneLinkage](docs/JsonApiAttributeToOneLinkage.md)
 - [JsonApiCookieSecurityConfigurationIn](docs/JsonApiCookieSecurityConfigurationIn.md)
 - [JsonApiCookieSecurityConfigurationInAttributes](docs/JsonApiCookieSecurityConfigurationInAttributes.md)
 - [JsonApiCookieSecurityConfigurationInDocument](docs/JsonApiCookieSecurityConfigurationInDocument.md)
 - [JsonApiCookieSecurityConfigurationOut](docs/JsonApiCookieSecurityConfigurationOut.md)
 - [JsonApiCookieSecurityConfigurationOutDocument](docs/JsonApiCookieSecurityConfigurationOutDocument.md)
 - [JsonApiCookieSecurityConfigurationPatch](docs/JsonApiCookieSecurityConfigurationPatch.md)
 - [JsonApiCookieSecurityConfigurationPatchDocument](docs/JsonApiCookieSecurityConfigurationPatchDocument.md)
 - [JsonApiDashboardPluginIn](docs/JsonApiDashboardPluginIn.md)
 - [JsonApiDashboardPluginInAttributes](docs/JsonApiDashboardPluginInAttributes.md)
 - [JsonApiDashboardPluginInDocument](docs/JsonApiDashboardPluginInDocument.md)
 - [JsonApiDashboardPluginLinkage](docs/JsonApiDashboardPluginLinkage.md)
 - [JsonApiDashboardPluginOut](docs/JsonApiDashboardPluginOut.md)
 - [JsonApiDashboardPluginOutDocument](docs/JsonApiDashboardPluginOutDocument.md)
 - [JsonApiDashboardPluginOutList](docs/JsonApiDashboardPluginOutList.md)
 - [JsonApiDashboardPluginOutWithLinks](docs/JsonApiDashboardPluginOutWithLinks.md)
 - [JsonApiDashboardPluginPatch](docs/JsonApiDashboardPluginPatch.md)
 - [JsonApiDashboardPluginPatchDocument](docs/JsonApiDashboardPluginPatchDocument.md)
 - [JsonApiDashboardPluginToManyLinkage](docs/JsonApiDashboardPluginToManyLinkage.md)
 - [JsonApiDataSourceIdentifierOut](docs/JsonApiDataSourceIdentifierOut.md)
 - [JsonApiDataSourceIdentifierOutAttributes](docs/JsonApiDataSourceIdentifierOutAttributes.md)
 - [JsonApiDataSourceIdentifierOutDocument](docs/JsonApiDataSourceIdentifierOutDocument.md)
 - [JsonApiDataSourceIdentifierOutList](docs/JsonApiDataSourceIdentifierOutList.md)
 - [JsonApiDataSourceIdentifierOutMeta](docs/JsonApiDataSourceIdentifierOutMeta.md)
 - [JsonApiDataSourceIdentifierOutWithLinks](docs/JsonApiDataSourceIdentifierOutWithLinks.md)
 - [JsonApiDataSourceIn](docs/JsonApiDataSourceIn.md)
 - [JsonApiDataSourceInAttributes](docs/JsonApiDataSourceInAttributes.md)
 - [JsonApiDataSourceInDocument](docs/JsonApiDataSourceInDocument.md)
 - [JsonApiDataSourceOut](docs/JsonApiDataSourceOut.md)
 - [JsonApiDataSourceOutAttributes](docs/JsonApiDataSourceOutAttributes.md)
 - [JsonApiDataSourceOutDocument](docs/JsonApiDataSourceOutDocument.md)
 - [JsonApiDataSourceOutList](docs/JsonApiDataSourceOutList.md)
 - [JsonApiDataSourceOutWithLinks](docs/JsonApiDataSourceOutWithLinks.md)
 - [JsonApiDataSourcePatch](docs/JsonApiDataSourcePatch.md)
 - [JsonApiDataSourcePatchAttributes](docs/JsonApiDataSourcePatchAttributes.md)
 - [JsonApiDataSourcePatchDocument](docs/JsonApiDataSourcePatchDocument.md)
 - [JsonApiDataSourceTableOut](docs/JsonApiDataSourceTableOut.md)
 - [JsonApiDataSourceTableOutAttributes](docs/JsonApiDataSourceTableOutAttributes.md)
 - [JsonApiDataSourceTableOutAttributesColumnsInner](docs/JsonApiDataSourceTableOutAttributesColumnsInner.md)
 - [JsonApiDataSourceTableOutDocument](docs/JsonApiDataSourceTableOutDocument.md)
 - [JsonApiDataSourceTableOutList](docs/JsonApiDataSourceTableOutList.md)
 - [JsonApiDataSourceTableOutWithLinks](docs/JsonApiDataSourceTableOutWithLinks.md)
 - [JsonApiDatasetLinkage](docs/JsonApiDatasetLinkage.md)
 - [JsonApiDatasetOut](docs/JsonApiDatasetOut.md)
 - [JsonApiDatasetOutAttributes](docs/JsonApiDatasetOutAttributes.md)
 - [JsonApiDatasetOutAttributesGrainInner](docs/JsonApiDatasetOutAttributesGrainInner.md)
 - [JsonApiDatasetOutAttributesReferencePropertiesInner](docs/JsonApiDatasetOutAttributesReferencePropertiesInner.md)
 - [JsonApiDatasetOutDocument](docs/JsonApiDatasetOutDocument.md)
 - [JsonApiDatasetOutIncludes](docs/JsonApiDatasetOutIncludes.md)
 - [JsonApiDatasetOutList](docs/JsonApiDatasetOutList.md)
 - [JsonApiDatasetOutRelationships](docs/JsonApiDatasetOutRelationships.md)
 - [JsonApiDatasetOutRelationshipsAttributes](docs/JsonApiDatasetOutRelationshipsAttributes.md)
 - [JsonApiDatasetOutRelationshipsFacts](docs/JsonApiDatasetOutRelationshipsFacts.md)
 - [JsonApiDatasetOutWithLinks](docs/JsonApiDatasetOutWithLinks.md)
 - [JsonApiDatasetToManyLinkage](docs/JsonApiDatasetToManyLinkage.md)
 - [JsonApiDatasetToOneLinkage](docs/JsonApiDatasetToOneLinkage.md)
 - [JsonApiEntitlementOut](docs/JsonApiEntitlementOut.md)
 - [JsonApiEntitlementOutAttributes](docs/JsonApiEntitlementOutAttributes.md)
 - [JsonApiEntitlementOutDocument](docs/JsonApiEntitlementOutDocument.md)
 - [JsonApiEntitlementOutList](docs/JsonApiEntitlementOutList.md)
 - [JsonApiEntitlementOutWithLinks](docs/JsonApiEntitlementOutWithLinks.md)
 - [JsonApiFactLinkage](docs/JsonApiFactLinkage.md)
 - [JsonApiFactOut](docs/JsonApiFactOut.md)
 - [JsonApiFactOutAttributes](docs/JsonApiFactOutAttributes.md)
 - [JsonApiFactOutDocument](docs/JsonApiFactOutDocument.md)
 - [JsonApiFactOutList](docs/JsonApiFactOutList.md)
 - [JsonApiFactOutRelationships](docs/JsonApiFactOutRelationships.md)
 - [JsonApiFactOutWithLinks](docs/JsonApiFactOutWithLinks.md)
 - [JsonApiFactToManyLinkage](docs/JsonApiFactToManyLinkage.md)
 - [JsonApiFilterContextIn](docs/JsonApiFilterContextIn.md)
 - [JsonApiFilterContextInDocument](docs/JsonApiFilterContextInDocument.md)
 - [JsonApiFilterContextLinkage](docs/JsonApiFilterContextLinkage.md)
 - [JsonApiFilterContextOut](docs/JsonApiFilterContextOut.md)
 - [JsonApiFilterContextOutDocument](docs/JsonApiFilterContextOutDocument.md)
 - [JsonApiFilterContextOutIncludes](docs/JsonApiFilterContextOutIncludes.md)
 - [JsonApiFilterContextOutList](docs/JsonApiFilterContextOutList.md)
 - [JsonApiFilterContextOutRelationships](docs/JsonApiFilterContextOutRelationships.md)
 - [JsonApiFilterContextOutWithLinks](docs/JsonApiFilterContextOutWithLinks.md)
 - [JsonApiFilterContextPatch](docs/JsonApiFilterContextPatch.md)
 - [JsonApiFilterContextPatchDocument](docs/JsonApiFilterContextPatchDocument.md)
 - [JsonApiFilterContextToManyLinkage](docs/JsonApiFilterContextToManyLinkage.md)
 - [JsonApiLabelLinkage](docs/JsonApiLabelLinkage.md)
 - [JsonApiLabelOut](docs/JsonApiLabelOut.md)
 - [JsonApiLabelOutAttributes](docs/JsonApiLabelOutAttributes.md)
 - [JsonApiLabelOutDocument](docs/JsonApiLabelOutDocument.md)
 - [JsonApiLabelOutList](docs/JsonApiLabelOutList.md)
 - [JsonApiLabelOutRelationships](docs/JsonApiLabelOutRelationships.md)
 - [JsonApiLabelOutRelationshipsAttribute](docs/JsonApiLabelOutRelationshipsAttribute.md)
 - [JsonApiLabelOutWithLinks](docs/JsonApiLabelOutWithLinks.md)
 - [JsonApiLabelToManyLinkage](docs/JsonApiLabelToManyLinkage.md)
 - [JsonApiLabelToOneLinkage](docs/JsonApiLabelToOneLinkage.md)
 - [JsonApiMetricIn](docs/JsonApiMetricIn.md)
 - [JsonApiMetricInAttributes](docs/JsonApiMetricInAttributes.md)
 - [JsonApiMetricInAttributesContent](docs/JsonApiMetricInAttributesContent.md)
 - [JsonApiMetricInDocument](docs/JsonApiMetricInDocument.md)
 - [JsonApiMetricLinkage](docs/JsonApiMetricLinkage.md)
 - [JsonApiMetricOut](docs/JsonApiMetricOut.md)
 - [JsonApiMetricOutDocument](docs/JsonApiMetricOutDocument.md)
 - [JsonApiMetricOutIncludes](docs/JsonApiMetricOutIncludes.md)
 - [JsonApiMetricOutList](docs/JsonApiMetricOutList.md)
 - [JsonApiMetricOutRelationships](docs/JsonApiMetricOutRelationships.md)
 - [JsonApiMetricOutWithLinks](docs/JsonApiMetricOutWithLinks.md)
 - [JsonApiMetricPatch](docs/JsonApiMetricPatch.md)
 - [JsonApiMetricPatchAttributes](docs/JsonApiMetricPatchAttributes.md)
 - [JsonApiMetricPatchDocument](docs/JsonApiMetricPatchDocument.md)
 - [JsonApiMetricToManyLinkage](docs/JsonApiMetricToManyLinkage.md)
 - [JsonApiOrganizationIn](docs/JsonApiOrganizationIn.md)
 - [JsonApiOrganizationInAttributes](docs/JsonApiOrganizationInAttributes.md)
 - [JsonApiOrganizationInDocument](docs/JsonApiOrganizationInDocument.md)
 - [JsonApiOrganizationOut](docs/JsonApiOrganizationOut.md)
 - [JsonApiOrganizationOutAttributes](docs/JsonApiOrganizationOutAttributes.md)
 - [JsonApiOrganizationOutDocument](docs/JsonApiOrganizationOutDocument.md)
 - [JsonApiOrganizationOutIncludes](docs/JsonApiOrganizationOutIncludes.md)
 - [JsonApiOrganizationOutMeta](docs/JsonApiOrganizationOutMeta.md)
 - [JsonApiOrganizationOutRelationships](docs/JsonApiOrganizationOutRelationships.md)
 - [JsonApiOrganizationOutRelationshipsBootstrapUser](docs/JsonApiOrganizationOutRelationshipsBootstrapUser.md)
 - [JsonApiOrganizationOutRelationshipsBootstrapUserGroup](docs/JsonApiOrganizationOutRelationshipsBootstrapUserGroup.md)
 - [JsonApiOrganizationPatch](docs/JsonApiOrganizationPatch.md)
 - [JsonApiOrganizationPatchDocument](docs/JsonApiOrganizationPatchDocument.md)
 - [JsonApiUserGroupIn](docs/JsonApiUserGroupIn.md)
 - [JsonApiUserGroupInDocument](docs/JsonApiUserGroupInDocument.md)
 - [JsonApiUserGroupInRelationships](docs/JsonApiUserGroupInRelationships.md)
 - [JsonApiUserGroupInRelationshipsParents](docs/JsonApiUserGroupInRelationshipsParents.md)
 - [JsonApiUserGroupLinkage](docs/JsonApiUserGroupLinkage.md)
 - [JsonApiUserGroupOut](docs/JsonApiUserGroupOut.md)
 - [JsonApiUserGroupOutDocument](docs/JsonApiUserGroupOutDocument.md)
 - [JsonApiUserGroupOutList](docs/JsonApiUserGroupOutList.md)
 - [JsonApiUserGroupOutWithLinks](docs/JsonApiUserGroupOutWithLinks.md)
 - [JsonApiUserGroupPatch](docs/JsonApiUserGroupPatch.md)
 - [JsonApiUserGroupPatchDocument](docs/JsonApiUserGroupPatchDocument.md)
 - [JsonApiUserGroupToManyLinkage](docs/JsonApiUserGroupToManyLinkage.md)
 - [JsonApiUserGroupToOneLinkage](docs/JsonApiUserGroupToOneLinkage.md)
 - [JsonApiUserIn](docs/JsonApiUserIn.md)
 - [JsonApiUserInAttributes](docs/JsonApiUserInAttributes.md)
 - [JsonApiUserInDocument](docs/JsonApiUserInDocument.md)
 - [JsonApiUserInRelationships](docs/JsonApiUserInRelationships.md)
 - [JsonApiUserLinkage](docs/JsonApiUserLinkage.md)
 - [JsonApiUserOut](docs/JsonApiUserOut.md)
 - [JsonApiUserOutDocument](docs/JsonApiUserOutDocument.md)
 - [JsonApiUserOutList](docs/JsonApiUserOutList.md)
 - [JsonApiUserOutWithLinks](docs/JsonApiUserOutWithLinks.md)
 - [JsonApiUserPatch](docs/JsonApiUserPatch.md)
 - [JsonApiUserPatchDocument](docs/JsonApiUserPatchDocument.md)
 - [JsonApiUserToOneLinkage](docs/JsonApiUserToOneLinkage.md)
 - [JsonApiVisualizationObjectIn](docs/JsonApiVisualizationObjectIn.md)
 - [JsonApiVisualizationObjectInDocument](docs/JsonApiVisualizationObjectInDocument.md)
 - [JsonApiVisualizationObjectLinkage](docs/JsonApiVisualizationObjectLinkage.md)
 - [JsonApiVisualizationObjectOut](docs/JsonApiVisualizationObjectOut.md)
 - [JsonApiVisualizationObjectOutDocument](docs/JsonApiVisualizationObjectOutDocument.md)
 - [JsonApiVisualizationObjectOutList](docs/JsonApiVisualizationObjectOutList.md)
 - [JsonApiVisualizationObjectOutWithLinks](docs/JsonApiVisualizationObjectOutWithLinks.md)
 - [JsonApiVisualizationObjectPatch](docs/JsonApiVisualizationObjectPatch.md)
 - [JsonApiVisualizationObjectPatchDocument](docs/JsonApiVisualizationObjectPatchDocument.md)
 - [JsonApiVisualizationObjectToManyLinkage](docs/JsonApiVisualizationObjectToManyLinkage.md)
 - [JsonApiWorkspaceDataFilterIn](docs/JsonApiWorkspaceDataFilterIn.md)
 - [JsonApiWorkspaceDataFilterInAttributes](docs/JsonApiWorkspaceDataFilterInAttributes.md)
 - [JsonApiWorkspaceDataFilterInDocument](docs/JsonApiWorkspaceDataFilterInDocument.md)
 - [JsonApiWorkspaceDataFilterInRelationships](docs/JsonApiWorkspaceDataFilterInRelationships.md)
 - [JsonApiWorkspaceDataFilterInRelationshipsFilterSettings](docs/JsonApiWorkspaceDataFilterInRelationshipsFilterSettings.md)
 - [JsonApiWorkspaceDataFilterLinkage](docs/JsonApiWorkspaceDataFilterLinkage.md)
 - [JsonApiWorkspaceDataFilterOut](docs/JsonApiWorkspaceDataFilterOut.md)
 - [JsonApiWorkspaceDataFilterOutDocument](docs/JsonApiWorkspaceDataFilterOutDocument.md)
 - [JsonApiWorkspaceDataFilterOutList](docs/JsonApiWorkspaceDataFilterOutList.md)
 - [JsonApiWorkspaceDataFilterOutWithLinks](docs/JsonApiWorkspaceDataFilterOutWithLinks.md)
 - [JsonApiWorkspaceDataFilterPatch](docs/JsonApiWorkspaceDataFilterPatch.md)
 - [JsonApiWorkspaceDataFilterPatchDocument](docs/JsonApiWorkspaceDataFilterPatchDocument.md)
 - [JsonApiWorkspaceDataFilterSettingLinkage](docs/JsonApiWorkspaceDataFilterSettingLinkage.md)
 - [JsonApiWorkspaceDataFilterSettingOut](docs/JsonApiWorkspaceDataFilterSettingOut.md)
 - [JsonApiWorkspaceDataFilterSettingOutAttributes](docs/JsonApiWorkspaceDataFilterSettingOutAttributes.md)
 - [JsonApiWorkspaceDataFilterSettingOutDocument](docs/JsonApiWorkspaceDataFilterSettingOutDocument.md)
 - [JsonApiWorkspaceDataFilterSettingOutList](docs/JsonApiWorkspaceDataFilterSettingOutList.md)
 - [JsonApiWorkspaceDataFilterSettingOutRelationships](docs/JsonApiWorkspaceDataFilterSettingOutRelationships.md)
 - [JsonApiWorkspaceDataFilterSettingOutRelationshipsWorkspaceDataFilter](docs/JsonApiWorkspaceDataFilterSettingOutRelationshipsWorkspaceDataFilter.md)
 - [JsonApiWorkspaceDataFilterSettingOutWithLinks](docs/JsonApiWorkspaceDataFilterSettingOutWithLinks.md)
 - [JsonApiWorkspaceDataFilterSettingToManyLinkage](docs/JsonApiWorkspaceDataFilterSettingToManyLinkage.md)
 - [JsonApiWorkspaceDataFilterToOneLinkage](docs/JsonApiWorkspaceDataFilterToOneLinkage.md)
 - [JsonApiWorkspaceIn](docs/JsonApiWorkspaceIn.md)
 - [JsonApiWorkspaceInAttributes](docs/JsonApiWorkspaceInAttributes.md)
 - [JsonApiWorkspaceInDocument](docs/JsonApiWorkspaceInDocument.md)
 - [JsonApiWorkspaceInRelationships](docs/JsonApiWorkspaceInRelationships.md)
 - [JsonApiWorkspaceInRelationshipsParent](docs/JsonApiWorkspaceInRelationshipsParent.md)
 - [JsonApiWorkspaceLinkage](docs/JsonApiWorkspaceLinkage.md)
 - [JsonApiWorkspaceOut](docs/JsonApiWorkspaceOut.md)
 - [JsonApiWorkspaceOutDocument](docs/JsonApiWorkspaceOutDocument.md)
 - [JsonApiWorkspaceOutList](docs/JsonApiWorkspaceOutList.md)
 - [JsonApiWorkspaceOutMeta](docs/JsonApiWorkspaceOutMeta.md)
 - [JsonApiWorkspaceOutMetaConfig](docs/JsonApiWorkspaceOutMetaConfig.md)
 - [JsonApiWorkspaceOutWithLinks](docs/JsonApiWorkspaceOutWithLinks.md)
 - [JsonApiWorkspacePatch](docs/JsonApiWorkspacePatch.md)
 - [JsonApiWorkspacePatchDocument](docs/JsonApiWorkspacePatchDocument.md)
 - [JsonApiWorkspaceToOneLinkage](docs/JsonApiWorkspaceToOneLinkage.md)
 - [LabelIdentifier](docs/LabelIdentifier.md)
 - [ListLinks](docs/ListLinks.md)
 - [ListLinksAllOf](docs/ListLinksAllOf.md)
 - [ObjectLinks](docs/ObjectLinks.md)
 - [ObjectLinksContainer](docs/ObjectLinksContainer.md)
 - [ReferenceIdentifier](docs/ReferenceIdentifier.md)
 - [UserGroupIdentifier](docs/UserGroupIdentifier.md)
 - [WorkspaceIdentifier](docs/WorkspaceIdentifier.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

support@gooddata.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in gooddata_metadata_client.apis and gooddata_metadata_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from gooddata_metadata_client.api.default_api import DefaultApi`
- `from gooddata_metadata_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import gooddata_metadata_client
from gooddata_metadata_client.apis import *
from gooddata_metadata_client.models import *
```

