# 学习制作网易云音乐客户端。
# 此文件实现登陆查询等一系列功能。
__author__ = 'weiy'
"""
4.10日。
"""
import urllib.parse
import requests
import hashlib
import json


def shotlist(lst):
    """列表去重。"""
    temp1 = sorted(list(set(lst)))
    return temp1


class WebApi:
    """一些功能。"""
    default_timeout = 10
    headers = {
        'Accept': '*/*',
        'Accept-Encoding': 'gzip,deflate,sdch',
        'Accept-Language': 'zh-CN,zh;q=0.8',
        'Proxy-Connection': 'keep-alive',
        'Content-Type': 'application/x-www-form-urlencoded',
        'Host': 'music.163.com',
        'Referer': 'http://music.163.com/',
        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36'
    }

    def __init__(self):
        self.cookies = {
            'appver': '1.6.1.82809',
            'os': 'pc'
        }

    def httpRequest(self, action, method="GET", add=None, data=None, headers=headers, cookies='',\
                    timeout=default_timeout, urlencode='utf-8'):
        """
            默认以get方式请求，
            GET方式附加内容用add参数，POST方式提交内容用data参数。
            编码用urlencode参数，默认utf-8。
            GET方式返回json形式请求的内容。
            POST方式返回cookies和json形式的内容。(0,1)
            默认cookies为空。
        """
        if method.upper() == 'GET':
            if add:
                html = requests.get(action, params=add, headers=headers, cookies=cookies, timeout=timeout)
            else:
                html = requests.get(action, headers=headers, cookies=cookies, timeout=timeout)
            html.encoding = urlencode
            return json.loads(html.text)
        elif method.upper() == 'POST':
            if data:
                html = requests.post(action, data=data, headers=headers, cookies=cookies, timeout=timeout)
            else:
                html = requests.post(action, headers=headers, cookies=cookies, timeout=timeout)
            html.encoding = urlencode
            return html.cookies, json.loads(html.text)

    def login(self, username, password):
        """
            以网易账号登陆，其他的登陆待写。返回cookies和json形式内容。
        """
        data = {
            'username': username,
            'password': hashlib.md5(password.encode('utf-8')).hexdigest(),
            'remeberLogin': 'true'
        }
        cki = self.httpRequest('http://music.163.com/api/login', method="POST", data=data)
        cki[0].set('appver', self.cookies['appver'], domain='music.163.com')
        cki[0].set('os', self.cookies['os'], domain='music.163.com')  
        return cki[0], cki[1]

    def user_playlist(self, uid, offset=0):
        """
            个人歌单。
        """
        url = 'http://music.163.com/api/user/playlist/?offset=%s&limit=1000&uid=%s' % (offset, uid)
        html = self.httpRequest(url, method='GET', cookies=self.cookies)
        return html['playlist']

    def all_playlist(self, cat='全部歌单', types='all', offset=0, index=1):
        """
            全部歌单。列表字典形式。
        """
        url = 'http://music.163.com/api/playlist/list?cat=%s&type=%s&order=%s&offset=%d&total=true&limit=30&index=%d)'\
            % (urllib.parse.quote(cat), types, types, offset, index)
        html = self.httpRequest(url, method='GET', cookies=self.cookies)
        return html['playlists']
    def details_playlist(self,id):
        return '''{
	"result": {
		"subscribers": [],
		"subscribed": false,
		"creator": {
			"defaultAvatar": false,
			"province": 110000,
			"authStatus": 1,
			"followed": false,
			"avatarUrl": "http://p1.music.126.net/QWMV-Ru_6149AKe0mCBXKg==/1420569024374784.jpg",
			"accountStatus": 0,
			"gender": 1,
			"city": 110101,
			"birthday": -2209017600000,
			"userId": 1,
			"userType": 2,
			"nickname": "网易云音乐",
			"signature": "欢迎使用网易云音乐，有任何问题可以联系@云音乐客服， 我们会尽快答复。有关独立音乐人和独立厂牌请站内私信@原创君。",
			"description": "网易云音乐官方账号",
			"detailDescription": "网易云音乐官方账号",
			"avatarImgId": 1420569024374784,
			"backgroundImgId": 2002210674180202,
			"backgroundUrl": "http://p1.music.126.net/pmHS4fcQtcNEGewNb5HRhg==/2002210674180202.jpg",
			"authority": 3,
			"mutual": false,
			"expertTags": null,
			"experts": null,
			"djStatus": 10,
			"vipType": 11,
			"remarkName": null,
			"avatarImgIdStr": "1420569024374784",
			"backgroundImgIdStr": "2002210674180202"
		},
		"artists": null,
		"tracks": [{
			"name": "火焰小溪",
			"id": 1297750771,
			"position": 1,
			"alias": ["\"声音，你好\"公益活动主题曲"],
			"status": 0,
			"fee": 8,
			"copyrightId": 677020,
			"disc": "",
			"no": 1,
			"artists": [{
				"name": "林宥嘉",
				"id": 3685,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "火焰小溪",
				"id": 72071867,
				"type": "EP/Single",
				"size": 2,
				"picId": 109951163440625910,
				"blurPicUrl": "http://p2.music.126.net/HeSyftZftDogVH1VkFqN1A==/109951163440625910.jpg",
				"companyId": 0,
				"pic": 109951163440625910,
				"picUrl": "http://p2.music.126.net/HeSyftZftDogVH1VkFqN1A==/109951163440625910.jpg",
				"publishTime": 1533398400007,
				"description": "",
				"tags": "",
				"company": "华研",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": ["\"声音，你好\"公益活动主题曲"],
				"status": 1,
				"copyrightId": 677020,
				"commentThreadId": "R_AL_3_72071867",
				"artists": [{
					"name": "林宥嘉",
					"id": 3685,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "109951163440625910"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 274997,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_1297750771",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 0,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": "",
				"id": 3419924588,
				"size": 11002819,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 274997,
				"volumeDelta": -2.0
			},
			"mMusic": {
				"name": "",
				"id": 3419924589,
				"size": 6601709,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 192000,
				"playTime": 274997,
				"volumeDelta": -2.0
			},
			"lMusic": {
				"name": "",
				"id": 3419924590,
				"size": 4401154,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 274997,
				"volumeDelta": -1.0
			},
			"bMusic": {
				"name": "",
				"id": 3419924590,
				"size": 4401154,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 274997,
				"volumeDelta": -1.0
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5965315
		}, {
			"name": "说谎",
			"id": 108390,
			"position": 6,
			"alias": [],
			"status": 0,
			"fee": 8,
			"copyrightId": 677020,
			"disc": "1",
			"no": 6,
			"artists": [{
				"name": "林宥嘉",
				"id": 3685,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "感官/世界",
				"id": 10764,
				"type": "专辑",
				"size": 11,
				"picId": 109951163187404137,
				"blurPicUrl": "http://p2.music.126.net/mMZNB-jhYsw29K61QtopJA==/109951163187404137.jpg",
				"companyId": 0,
				"pic": 109951163187404137,
				"picUrl": "http://p2.music.126.net/mMZNB-jhYsw29K61QtopJA==/109951163187404137.jpg",
				"publishTime": 1256832000000,
				"description": "",
				"tags": "",
				"company": "华研国际",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 40,
				"copyrightId": 1004,
				"commentThreadId": "R_AL_3_10764",
				"artists": [{
					"name": "林宥嘉",
					"id": 3685,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "109951163187404137"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 264160,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": "600902000009129439",
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_108390",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": "",
				"id": 1426514912,
				"size": 10569187,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 264160,
				"volumeDelta": 0.0
			},
			"mMusic": {
				"name": "",
				"id": 1426514913,
				"size": 6341529,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 192000,
				"playTime": 264160,
				"volumeDelta": 0.0
			},
			"lMusic": {
				"name": "",
				"id": 1426514914,
				"size": 4227701,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 264160,
				"volumeDelta": 0.0
			},
			"bMusic": {
				"name": "",
				"id": 1426514914,
				"size": 4227701,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 264160,
				"volumeDelta": 0.0
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5842732
		}, {
			"name": "Perfect",
			"id": 460043703,
			"position": 5,
			"alias": [],
			"status": 0,
			"fee": 8,
			"copyrightId": 7002,
			"disc": "1",
			"no": 5,
			"artists": [{
				"name": "Ed Sheeran",
				"id": 33184,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "÷ (Deluxe)",
				"id": 35150843,
				"type": "专辑",
				"size": 16,
				"picId": 18810444929762432,
				"blurPicUrl": "http://p2.music.126.net/ARJwzJcDmmd0PYArKnmGCg==/18810444929762432.jpg",
				"companyId": 0,
				"pic": 18810444929762432,
				"picUrl": "http://p2.music.126.net/ARJwzJcDmmd0PYArKnmGCg==/18810444929762432.jpg",
				"publishTime": 1488470400007,
				"description": "",
				"tags": "",
				"company": "华纳唱片",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 3,
				"copyrightId": 7002,
				"commentThreadId": "R_AL_3_35150843",
				"artists": [{
					"name": "Ed Sheeran",
					"id": 33184,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "18810444929762432"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 263400,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_460043703",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1286918421,
				"size": 10538885,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 263400,
				"volumeDelta": -1.2,
				"dfsId_str": null
			},
			"mMusic": {
				"name": null,
				"id": 1286918422,
				"size": 5269465,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 263400,
				"volumeDelta": -0.76,
				"dfsId_str": null
			},
			"lMusic": {
				"name": null,
				"id": 1286918423,
				"size": 3161697,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 263400,
				"volumeDelta": -0.79,
				"dfsId_str": null
			},
			"bMusic": {
				"name": null,
				"id": 1286918423,
				"size": 3161697,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 263400,
				"volumeDelta": -0.79,
				"dfsId_str": null
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5725016
		}, {
			"name": "River",
			"id": 523250559,
			"position": 3,
			"alias": [],
			"status": 0,
			"fee": 4,
			"copyrightId": 7003,
			"disc": "1",
			"no": 5,
			"artists": [{
				"name": "Eminem",
				"id": 32665,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}, {
				"name": "Ed Sheeran",
				"id": 33184,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "Revival",
				"id": 36952205,
				"type": "专辑",
				"size": 19,
				"picId": 18448705602723085,
				"blurPicUrl": "http://p2.music.126.net/v-c-6B2aS4sZ_G-i97uiUg==/18448705602723085.jpg",
				"companyId": 0,
				"pic": 18448705602723085,
				"picUrl": "http://p2.music.126.net/v-c-6B2aS4sZ_G-i97uiUg==/18448705602723085.jpg",
				"publishTime": 1513296000000,
				"description": "",
				"tags": "",
				"company": "环球唱片",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": -4,
				"copyrightId": 7003,
				"commentThreadId": "R_AL_3_36952205",
				"artists": [{
					"name": "Eminem",
					"id": 32665,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "18448705602723085"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 221013,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_523250559",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": "",
				"id": 1398129440,
				"size": 8843015,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 221013,
				"volumeDelta": -1.0
			},
			"mMusic": {
				"name": "",
				"id": 1398129441,
				"size": 5305826,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 192000,
				"playTime": 221013,
				"volumeDelta": -1.0
			},
			"lMusic": {
				"name": "",
				"id": 1398129442,
				"size": 3537232,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 221013,
				"volumeDelta": -1.0
			},
			"bMusic": {
				"name": "",
				"id": 1398129442,
				"size": 3537232,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 221013,
				"volumeDelta": -1.0
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5841160
		}, {
			"name": "Best of 2017 Medley",
			"id": 526652668,
			"position": 1,
			"alias": [],
			"status": 0,
			"fee": 0,
			"copyrightId": 0,
			"disc": "1",
			"no": 1,
			"artists": [{
				"name": "Anthem Lights",
				"id": 86862,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "Best of 2017 Medley",
				"id": 37099076,
				"type": "EP/Single",
				"size": 1,
				"picId": 109951163095074756,
				"blurPicUrl": "http://p2.music.126.net/0dLExQOaZRizEGO4XQ45eA==/109951163095074756.jpg",
				"companyId": 0,
				"pic": 109951163095074756,
				"picUrl": "http://p2.music.126.net/0dLExQOaZRizEGO4XQ45eA==/109951163095074756.jpg",
				"publishTime": 1513872000000,
				"description": "",
				"tags": "",
				"company": "Wavy Records",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 0,
				"copyrightId": 0,
				"commentThreadId": "R_AL_3_37099076",
				"artists": [{
					"name": "Anthem Lights",
					"id": 86862,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "109951163095074756"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 145998,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_526652668",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 0,
			"transName": null,
			"sign": null,
			"hMusic": null,
			"mMusic": {
				"name": "",
				"id": 1402340446,
				"size": 3504631,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 192000,
				"playTime": 145998,
				"volumeDelta": 0.0
			},
			"lMusic": {
				"name": "",
				"id": 1402340447,
				"size": 2336435,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 145998,
				"volumeDelta": 0.0
			},
			"bMusic": {
				"name": "",
				"id": 1402340447,
				"size": 2336435,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 145998,
				"volumeDelta": 0.0
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5796031
		}, {
			"name": "极美",
			"id": 516657215,
			"position": 10,
			"alias": [],
			"status": 0,
			"fee": 4,
			"copyrightId": 7003,
			"disc": "1",
			"no": 10,
			"artists": [{
				"name": "孙燕姿",
				"id": 9272,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "孙燕姿No. 13作品：跳舞的梵谷",
				"id": 36714070,
				"type": "专辑",
				"size": 10,
				"picId": 18357446138140955,
				"blurPicUrl": "http://p2.music.126.net/_VjuIgInJqwxdyoy4FF3IA==/18357446138140955.jpg",
				"companyId": 0,
				"pic": 18357446138140955,
				"picUrl": "http://p2.music.126.net/_VjuIgInJqwxdyoy4FF3IA==/18357446138140955.jpg",
				"publishTime": 1510185600000,
				"description": "",
				"tags": "",
				"company": "环球唱片",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": -4,
				"copyrightId": 7003,
				"commentThreadId": "R_AL_3_36714070",
				"artists": [{
					"name": "孙燕姿",
					"id": 9272,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "18357446138140955"
			},
			"starred": false,
			"popularity": 95.0,
			"score": 95,
			"starredNum": 0,
			"duration": 211613,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_516657215",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": "",
				"id": 1402501222,
				"size": 8466852,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 211613,
				"volumeDelta": 0.0
			},
			"mMusic": {
				"name": "",
				"id": 1402501223,
				"size": 5080129,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 192000,
				"playTime": 211613,
				"volumeDelta": 0.0
			},
			"lMusic": {
				"name": "",
				"id": 1402501224,
				"size": 3386767,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 211613,
				"volumeDelta": 0.0
			},
			"bMusic": {
				"name": "",
				"id": 1402501224,
				"size": 3386767,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 211613,
				"volumeDelta": 0.0
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5810580
		}, {
			"name": "连名带姓",
			"id": 522352195,
			"position": 3,
			"alias": [],
			"status": 0,
			"fee": 4,
			"copyrightId": 7003,
			"disc": "",
			"no": 6,
			"artists": [{
				"name": "张惠妹",
				"id": 10559,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "偷故事的人 ",
				"id": 36941045,
				"type": "专辑",
				"size": 10,
				"picId": 109951163079119875,
				"blurPicUrl": "http://p2.music.126.net/SbJdGLDz9V1_sLffpjMU8g==/109951163079119875.jpg",
				"companyId": 0,
				"pic": 109951163079119875,
				"picUrl": "http://p2.music.126.net/SbJdGLDz9V1_sLffpjMU8g==/109951163079119875.jpg",
				"publishTime": 1513008000007,
				"description": "",
				"tags": "",
				"company": "环球唱片",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": -4,
				"copyrightId": 7003,
				"commentThreadId": "R_AL_3_36941045",
				"artists": [{
					"name": "张惠妹",
					"id": 10559,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "109951163079119875"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 333549,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_522352195",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": "",
				"id": 1404214114,
				"size": 13344436,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 333549,
				"volumeDelta": 0.0
			},
			"mMusic": {
				"name": "",
				"id": 1404214115,
				"size": 8006679,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 192000,
				"playTime": 333549,
				"volumeDelta": 0.0
			},
			"lMusic": {
				"name": "",
				"id": 1404214116,
				"size": 5337800,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 333549,
				"volumeDelta": 0.0
			},
			"bMusic": {
				"name": "",
				"id": 1404214116,
				"size": 5337800,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 333549,
				"volumeDelta": 0.0
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5764014
		}, {
			"name": "Look What You Made Me Do",
			"id": 501133611,
			"position": 3,
			"alias": [],
			"status": 0,
			"fee": 4,
			"copyrightId": 7003,
			"disc": "1",
			"no": 6,
			"artists": [{
				"name": "Taylor Swift",
				"id": 44266,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "reputation",
				"id": 36709029,
				"type": "专辑",
				"size": 15,
				"picId": 109951163054654501,
				"blurPicUrl": "http://p2.music.126.net/fdh0myRe6FD87QNJtvGe_A==/109951163054654501.jpg",
				"companyId": 0,
				"pic": 109951163054654501,
				"picUrl": "http://p2.music.126.net/fdh0myRe6FD87QNJtvGe_A==/109951163054654501.jpg",
				"publishTime": 1510243200007,
				"description": "",
				"tags": "",
				"company": "环球唱片",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": -4,
				"copyrightId": 7003,
				"commentThreadId": "R_AL_3_36709029",
				"artists": [{
					"name": "Taylor Swift",
					"id": 44266,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "109951163054654501"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 211859,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_501133611",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": "",
				"id": 1350204242,
				"size": 8477301,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 211859,
				"volumeDelta": -2.0
			},
			"mMusic": {
				"name": "",
				"id": 1350204243,
				"size": 5086398,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 192000,
				"playTime": 211859,
				"volumeDelta": -2.0
			},
			"lMusic": {
				"name": "",
				"id": 1350204244,
				"size": 3390946,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 211859,
				"volumeDelta": -1.0
			},
			"bMusic": {
				"name": "",
				"id": 1350204244,
				"size": 3390946,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 211859,
				"volumeDelta": -1.0
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5647227
		}, {
			"name": "ニア",
			"id": 478920777,
			"position": 2,
			"alias": [],
			"status": 0,
			"fee": 0,
			"copyrightId": 663018,
			"disc": "1",
			"no": 2,
			"artists": [{
				"name": "夏代孝明",
				"id": 963529,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "トランジット",
				"id": 35498460,
				"type": "EP/Single",
				"size": 6,
				"picId": 19168885718782298,
				"blurPicUrl": "http://p2.music.126.net/YQy-MQSV1uwoj3tOUxPEcw==/19168885718782298.jpg",
				"companyId": 0,
				"pic": 19168885718782298,
				"picUrl": "http://p2.music.126.net/YQy-MQSV1uwoj3tOUxPEcw==/19168885718782298.jpg",
				"publishTime": 1494950400000,
				"description": "",
				"tags": "",
				"company": "TOHO animation RECORDS",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 0,
				"copyrightId": 0,
				"commentThreadId": "R_AL_3_35498460",
				"artists": [{
					"name": "夏代孝明",
					"id": 963529,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "19168885718782298"
			},
			"starred": false,
			"popularity": 65.0,
			"score": 65,
			"starredNum": 0,
			"duration": 248241,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_478920777",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 0,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1313669864,
				"size": 9930754,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 248241,
				"volumeDelta": -3.44,
				"dfsId_str": null
			},
			"mMusic": {
				"name": null,
				"id": 1313669865,
				"size": 4965400,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 248241,
				"volumeDelta": -3.03,
				"dfsId_str": null
			},
			"lMusic": {
				"name": null,
				"id": 1313669866,
				"size": 2979258,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 248241,
				"volumeDelta": -3.1,
				"dfsId_str": null
			},
			"bMusic": {
				"name": null,
				"id": 1313669866,
				"size": 2979258,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 248241,
				"volumeDelta": -3.1,
				"dfsId_str": null
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5580116
		}, {
			"name": "잘하고 있잖아",
			"id": 475279662,
			"position": 1,
			"alias": [],
			"status": 0,
			"fee": 0,
			"copyrightId": 0,
			"disc": "1",
			"no": 1,
			"artists": [{
				"name": "Mi-Yu",
				"id": 1066121,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}, {
				"name": "田锡万",
				"id": 12080207,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "잘하고 있잖아",
				"id": 35449204,
				"type": "EP/Single",
				"size": 1,
				"picId": 18676304511884390,
				"blurPicUrl": "http://p2.music.126.net/QMNFpTfXCT6JExllxQDcHA==/18676304511884390.jpg",
				"companyId": 0,
				"pic": 18676304511884390,
				"picUrl": "http://p2.music.126.net/QMNFpTfXCT6JExllxQDcHA==/18676304511884390.jpg",
				"publishTime": 1493308800007,
				"description": "",
				"tags": "",
				"company": "포크라노스",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 0,
				"copyrightId": 0,
				"commentThreadId": "R_AL_3_35449204",
				"artists": [{
					"name": "Mi-Yu",
					"id": 1066121,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "18676304511884390"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 229616,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_475279662",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 0,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1308489150,
				"size": 9185742,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 229616,
				"volumeDelta": -2.22,
				"dfsId_str": null
			},
			"mMusic": {
				"name": null,
				"id": 1308489151,
				"size": 4592894,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 229616,
				"volumeDelta": -1.78,
				"dfsId_str": null
			},
			"lMusic": {
				"name": null,
				"id": 1308489152,
				"size": 2755754,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 229616,
				"volumeDelta": -1.8,
				"dfsId_str": null
			},
			"bMusic": {
				"name": null,
				"id": 1308489152,
				"size": 2755754,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 229616,
				"volumeDelta": -1.8,
				"dfsId_str": null
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5896040
		}, {
			"name": "空",
			"id": 488256353,
			"position": 5,
			"alias": [],
			"status": 0,
			"fee": 8,
			"copyrightId": 457010,
			"disc": "1",
			"no": 5,
			"artists": [{
				"name": "GENERATIONS from EXILE TRIBE",
				"id": 711243,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "涙を流せないピエロは太陽も月もない空を見上げた",
				"id": 35695351,
				"type": "专辑",
				"size": 13,
				"picId": 18743374720672509,
				"blurPicUrl": "http://p2.music.126.net/XJ_gxymu79GfmyNQhC-2MA==/18743374720672509.jpg",
				"companyId": 0,
				"pic": 18743374720672509,
				"picUrl": "http://p2.music.126.net/XJ_gxymu79GfmyNQhC-2MA==/18743374720672509.jpg",
				"publishTime": 1499184000007,
				"description": "",
				"tags": "",
				"company": "(P)2017 AVEX ENTERTAINMENT INC.",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 1,
				"copyrightId": 457010,
				"commentThreadId": "R_AL_3_35695351",
				"artists": [{
					"name": "GENERATIONS from EXILE TRIBE",
					"id": 711243,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": "无法流泪的PIERROT仰望不见日月的天空",
				"picId_str": "18743374720672509",
				"transNames": ["无法流泪的PIERROT仰望不见日月的天空"]
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 310133,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_488256353",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": "电影《哥哥太爱我了怎么办》主题曲",
			"sign": null,
			"hMusic": {
				"name": "",
				"id": 1328805427,
				"size": 12408207,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 310133,
				"volumeDelta": -3.0
			},
			"mMusic": {
				"name": "",
				"id": 1328805428,
				"size": 7444942,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 192000,
				"playTime": 310133,
				"volumeDelta": -3.0
			},
			"lMusic": {
				"name": "",
				"id": 1328805429,
				"size": 4963309,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 310133,
				"volumeDelta": -2.0
			},
			"bMusic": {
				"name": "",
				"id": 1328805429,
				"size": 4963309,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 128000,
				"playTime": 310133,
				"volumeDelta": -2.0
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5579137,
			"transNames": ["电影《哥哥太爱我了怎么办》主题曲"]
		}, {
			"name": "Forever young",
			"id": 475073278,
			"position": 4,
			"alias": [],
			"status": 0,
			"fee": 8,
			"copyrightId": 502011,
			"disc": "1",
			"no": 7,
			"artists": [{
				"name": "朴树",
				"id": 4721,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "猎户星座",
				"id": 35444067,
				"type": "专辑",
				"size": 11,
				"picId": 18885211718782327,
				"blurPicUrl": "http://p2.music.126.net/W_5XiCv3rGS1-J7EXpHSCQ==/18885211718782327.jpg",
				"companyId": 0,
				"pic": 18885211718782327,
				"picUrl": "http://p2.music.126.net/W_5XiCv3rGS1-J7EXpHSCQ==/18885211718782327.jpg",
				"publishTime": 1493481600007,
				"description": "",
				"tags": "",
				"company": "不晚音乐/地球娱乐",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 1,
				"copyrightId": 502011,
				"commentThreadId": "R_AL_3_35444067",
				"artists": [{
					"name": "朴树",
					"id": 4721,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "18885211718782327"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 320431,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_475073278",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 1,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1307505124,
				"size": 12819897,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 320431,
				"volumeDelta": -1.8,
				"dfsId_str": null
			},
			"mMusic": {
				"name": null,
				"id": 1307505125,
				"size": 6409971,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 320431,
				"volumeDelta": -1.38,
				"dfsId_str": null
			},
			"lMusic": {
				"name": null,
				"id": 1307505126,
				"size": 3846000,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 320431,
				"volumeDelta": -1.48,
				"dfsId_str": null
			},
			"bMusic": {
				"name": null,
				"id": 1307505126,
				"size": 3846000,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 320431,
				"volumeDelta": -1.48,
				"dfsId_str": null
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 0
		}, {
			"name": "I'm the One ",
			"id": 475207448,
			"position": 1,
			"alias": [],
			"status": 0,
			"fee": 8,
			"copyrightId": 7001,
			"disc": "1",
			"no": 1,
			"artists": [{
				"name": "DJ Khaled",
				"id": 31273,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}, {
				"name": "Justin Bieber",
				"id": 35531,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}, {
				"name": "Quavo",
				"id": 12086073,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}, {
				"name": "Chance The Rapper",
				"id": 749038,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}, {
				"name": "Lil Wayne",
				"id": 38118,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "I'm the One",
				"id": 35378000,
				"type": "EP/Single",
				"size": 1,
				"picId": 19025949207139508,
				"blurPicUrl": "http://p2.music.126.net/erD3reF4IABguYY-1eIabw==/19025949207139508.jpg",
				"companyId": 0,
				"pic": 19025949207139508,
				"picUrl": "http://p2.music.126.net/erD3reF4IABguYY-1eIabw==/19025949207139508.jpg",
				"publishTime": 1493308800007,
				"description": "",
				"tags": "",
				"company": "Sony Music Entertainment",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 3,
				"copyrightId": 7001,
				"commentThreadId": "R_AL_3_35378000",
				"artists": [{
					"name": "DJ Khaled",
					"id": 31273,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}, {
					"name": "Justin Bieber",
					"id": 35531,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}, {
					"name": "Quavo",
					"id": 12086073,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}, {
					"name": "Chance The Rapper",
					"id": 749038,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p2.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}, {
					"name": "Lil Wayne",
					"id": 38118,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "19025949207139508"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 288876,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_475207448",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1308751674,
				"size": 11557660,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 288876,
				"volumeDelta": -2.55,
				"dfsId_str": null
			},
			"mMusic": {
				"name": null,
				"id": 1308751675,
				"size": 5778853,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 288876,
				"volumeDelta": -2.15,
				"dfsId_str": null
			},
			"lMusic": {
				"name": null,
				"id": 1308751676,
				"size": 3467329,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 288876,
				"volumeDelta": -2.16,
				"dfsId_str": null
			},
			"bMusic": {
				"name": null,
				"id": 1308751676,
				"size": 3467329,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 288876,
				"volumeDelta": -2.16,
				"dfsId_str": null
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5509013
		}, {
			"name": "八十年代的歌",
			"id": 447925066,
			"position": 7,
			"alias": ["Song Of The 80s"],
			"status": 0,
			"fee": 8,
			"copyrightId": 36016,
			"disc": "1",
			"no": 9,
			"artists": [{
				"name": "赵雷",
				"id": 6731,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "无法长大",
				"id": 35069014,
				"type": "专辑",
				"size": 10,
				"picId": 18548761162235571,
				"blurPicUrl": "http://p1.music.126.net/BJgUd9aD9gpougZFASRTTw==/18548761162235571.jpg",
				"companyId": 0,
				"pic": 18548761162235571,
				"picUrl": "http://p1.music.126.net/BJgUd9aD9gpougZFASRTTw==/18548761162235571.jpg",
				"publishTime": 1482249600007,
				"description": "",
				"tags": "",
				"company": "StreetVoice",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 1,
				"copyrightId": 36016,
				"commentThreadId": "R_AL_3_35069014",
				"artists": [{
					"name": "赵雷",
					"id": 6731,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "18548761162235571"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 271092,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_447925066",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1272627523,
				"size": 10846085,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 271092,
				"volumeDelta": -2.65076E-4,
				"dfsId_str": null
			},
			"mMusic": {
				"name": null,
				"id": 1272627524,
				"size": 5423065,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 271092,
				"volumeDelta": -2.65076E-4,
				"dfsId_str": null
			},
			"lMusic": {
				"name": null,
				"id": 1272627525,
				"size": 3253857,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 271092,
				"volumeDelta": -2.65076E-4,
				"dfsId_str": null
			},
			"bMusic": {
				"name": null,
				"id": 1272627525,
				"size": 3253857,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 271092,
				"volumeDelta": -2.65076E-4,
				"dfsId_str": null
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5895025
		}, {
			"name": "Shape of You",
			"id": 451703096,
			"position": 1,
			"alias": [],
			"status": 0,
			"fee": 8,
			"copyrightId": 7002,
			"disc": "1",
			"no": 1,
			"artists": [{
				"name": "Ed Sheeran",
				"id": 33184,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "Shape Of You",
				"id": 35114127,
				"type": "EP/Single",
				"size": 2,
				"picId": 18832435162240436,
				"blurPicUrl": "http://p1.music.126.net/5Zs51JS6cQzvQclW5u_J1g==/18832435162240436.jpg",
				"companyId": 0,
				"pic": 18832435162240436,
				"picUrl": "http://p1.music.126.net/5Zs51JS6cQzvQclW5u_J1g==/18832435162240436.jpg",
				"publishTime": 1483632000007,
				"description": "",
				"tags": "",
				"company": "华纳唱片",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 3,
				"copyrightId": 7002,
				"commentThreadId": "R_AL_3_35114127",
				"artists": [{
					"name": "Ed Sheeran",
					"id": 33184,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null,
				"picId_str": "18832435162240436"
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 231037,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_451703096",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1272480451,
				"size": 9244256,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 231037,
				"volumeDelta": -3.94,
				"dfsId_str": null
			},
			"mMusic": {
				"name": null,
				"id": 1272480452,
				"size": 4622151,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 231037,
				"volumeDelta": -3.51,
				"dfsId_str": null
			},
			"lMusic": {
				"name": null,
				"id": 1272480453,
				"size": 2773308,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 231037,
				"volumeDelta": -3.53,
				"dfsId_str": null
			},
			"bMusic": {
				"name": null,
				"id": 1272480453,
				"size": 2773308,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 231037,
				"volumeDelta": -3.53,
				"dfsId_str": null
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5439044
		}, {
			"name": "我好像在哪见过你",
			"id": 417859631,
			"position": 3,
			"alias": ["电影《精灵王座》主题曲"],
			"status": 0,
			"fee": 0,
			"copyrightId": 14026,
			"disc": "1",
			"no": 3,
			"artists": [{
				"name": "薛之谦",
				"id": 5781,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "初学者",
				"id": 34780271,
				"type": "专辑",
				"size": 10,
				"picId": 1369991500930171,
				"blurPicUrl": "http://p1.music.126.net/hti_a0LADoFMBHvOBwAtRA==/1369991500930171.jpg",
				"companyId": 0,
				"pic": 1369991500930171,
				"picUrl": "http://p1.music.126.net/hti_a0LADoFMBHvOBwAtRA==/1369991500930171.jpg",
				"publishTime": 1468771200007,
				"description": "",
				"tags": "",
				"company": "海蝶",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 0,
				"copyrightId": 14026,
				"commentThreadId": "R_AL_3_34780271",
				"artists": [{
					"name": "薛之谦",
					"id": 5781,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 279145,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_417859631",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1214810504,
				"size": 11168958,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 279145,
				"volumeDelta": -2.65076E-4
			},
			"mMusic": {
				"name": null,
				"id": 1214810505,
				"size": 5584502,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 279145,
				"volumeDelta": -2.65076E-4
			},
			"lMusic": {
				"name": null,
				"id": 1214810506,
				"size": 3350719,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 279145,
				"volumeDelta": -2.65076E-4
			},
			"bMusic": {
				"name": null,
				"id": 1214810506,
				"size": 3350719,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 279145,
				"volumeDelta": -2.65076E-4
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5342354
		}, {
			"name": "Still Got It ",
			"id": 416700171,
			"position": 1,
			"alias": [],
			"status": 0,
			"fee": 0,
			"copyrightId": 0,
			"disc": "1",
			"no": 1,
			"artists": [{
				"name": "Usher",
				"id": 45564,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}, {
				"name": "Migos",
				"id": 776824,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "Still Got It",
				"id": 34726659,
				"type": "EP/Single",
				"size": 1,
				"picId": 3442570909054815,
				"blurPicUrl": "http://p1.music.126.net/JqMXnIiVyVSEtbk9Oi5xPQ==/3442570909054815.jpg",
				"companyId": 0,
				"pic": 3442570909054815,
				"picUrl": "http://p1.music.126.net/JqMXnIiVyVSEtbk9Oi5xPQ==/3442570909054815.jpg",
				"publishTime": 1465142400007,
				"description": "",
				"tags": "",
				"company": "Wild Ginger",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 0,
				"copyrightId": 0,
				"commentThreadId": "R_AL_3_34726659",
				"artists": [{
					"name": "Usher",
					"id": 45564,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null
			},
			"starred": false,
			"popularity": 50.0,
			"score": 50,
			"starredNum": 0,
			"duration": 213019,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_416700171",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1212146916,
				"size": 8521186,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 213019,
				"volumeDelta": -2.65076E-4
			},
			"mMusic": {
				"name": null,
				"id": 1212146918,
				"size": 4260615,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 213019,
				"volumeDelta": -2.65076E-4
			},
			"lMusic": {
				"name": null,
				"id": 1212146919,
				"size": 2556386,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 213019,
				"volumeDelta": -2.65076E-4
			},
			"bMusic": {
				"name": null,
				"id": 1212146919,
				"size": 2556386,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 213019,
				"volumeDelta": -2.65076E-4
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 0
		}, {
			"name": "All for One",
			"id": 412911234,
			"position": 1,
			"alias": [],
			"status": 0,
			"fee": 8,
			"copyrightId": 7003,
			"disc": "1",
			"no": 1,
			"artists": [{
				"name": "The Stone Roses",
				"id": 102012,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "All for One",
				"id": 34702052,
				"type": "EP/Single",
				"size": 1,
				"picId": 1400777823776478,
				"blurPicUrl": "http://p1.music.126.net/WCivGASQol8CHD6t8SPtPA==/1400777823776478.jpg",
				"companyId": 0,
				"pic": 1400777823776478,
				"picUrl": "http://p1.music.126.net/WCivGASQol8CHD6t8SPtPA==/1400777823776478.jpg",
				"publishTime": 1463068800007,
				"description": "",
				"tags": "",
				"company": "环球唱片",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 3,
				"copyrightId": 564038,
				"commentThreadId": "R_AL_3_34702052",
				"artists": [{
					"name": "The Stone Roses",
					"id": 102012,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null
			},
			"starred": false,
			"popularity": 55.0,
			"score": 55,
			"starredNum": 0,
			"duration": 216409,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_412911234",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 0,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 1206752055,
				"size": 8657022,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 216409,
				"volumeDelta": -0.21
			},
			"mMusic": {
				"name": null,
				"id": 1206752057,
				"size": 4328533,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 216409,
				"volumeDelta": 0.21
			},
			"lMusic": {
				"name": null,
				"id": 1206752058,
				"size": 2597137,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 216409,
				"volumeDelta": -2.65076E-4
			},
			"bMusic": {
				"name": null,
				"id": 1206752058,
				"size": 2597137,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 216409,
				"volumeDelta": -2.65076E-4
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 0
		}, {
			"name": "Shimotsui Bushi",
			"id": 28302536,
			"position": 2,
			"alias": [],
			"status": 0,
			"fee": 0,
			"copyrightId": 663018,
			"disc": "1",
			"no": 2,
			"artists": [{
				"name": "OMODAKA",
				"id": 20890,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "Bridge Song",
				"id": 2767874,
				"type": "专辑",
				"size": 12,
				"picId": 6031920790092738,
				"blurPicUrl": "http://p1.music.126.net/KuicLkZZeUOh9u-v0wpd_A==/6031920790092738.jpg",
				"companyId": 0,
				"pic": 6031920790092738,
				"picUrl": "http://p1.music.126.net/KuicLkZZeUOh9u-v0wpd_A==/6031920790092738.jpg",
				"publishTime": 1394553600007,
				"description": "",
				"tags": "",
				"company": "Far East Recording",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 0,
				"copyrightId": 0,
				"commentThreadId": "R_AL_3_2767874",
				"artists": [{
					"name": "OMODAKA",
					"id": 20890,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null
			},
			"starred": false,
			"popularity": 45.0,
			"score": 45,
			"starredNum": 0,
			"duration": 282000,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": "",
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_28302536",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": "Shimotsui Bushi",
				"id": 46513025,
				"size": 11358974,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 282000,
				"volumeDelta": -4.84
			},
			"mMusic": {
				"name": "Shimotsui Bushi",
				"id": 46513026,
				"size": 5699808,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 282000,
				"volumeDelta": -4.4
			},
			"lMusic": {
				"name": "Shimotsui Bushi",
				"id": 46513027,
				"size": 3436141,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 282000,
				"volumeDelta": -4.48
			},
			"bMusic": {
				"name": "Shimotsui Bushi",
				"id": 46513027,
				"size": 3436141,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 282000,
				"volumeDelta": -4.48
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 0
		}, {
			"name": "A thousand miles(At Yokohama Stadium) - Live",
			"id": 31704050,
			"position": 1,
			"alias": [],
			"status": 0,
			"fee": 0,
			"copyrightId": 0,
			"disc": "",
			"no": 1,
			"artists": [{
				"name": "ONE OK ROCK",
				"id": 20878,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "最新热歌慢摇96",
				"id": 3120092,
				"type": null,
				"size": 104,
				"picId": 3384296791681736,
				"blurPicUrl": "http://p1.music.126.net/mGoCYYbELhOYlXnXqkhGng==/3384296791681736.jpg",
				"companyId": 0,
				"pic": 3384296791681736,
				"picUrl": "http://p1.music.126.net/mGoCYYbELhOYlXnXqkhGng==/3384296791681736.jpg",
				"publishTime": 1388505600004,
				"description": "",
				"tags": "",
				"company": "",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 2,
				"copyrightId": 0,
				"commentThreadId": "R_AL_3_3120092",
				"artists": [{
					"name": "Various Artists",
					"id": 104700,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null
			},
			"starred": false,
			"popularity": 95.0,
			"score": 95,
			"starredNum": 0,
			"duration": 291000,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_31704050",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": "Live",
			"hMusic": {
				"name": null,
				"id": 61156468,
				"size": 6997281,
				"extension": "mp3",
				"sr": 48000,
				"dfsId": 0,
				"bitrate": 192000,
				"playTime": 291000,
				"volumeDelta": 0.0
			},
			"mMusic": {
				"name": null,
				"id": 61156469,
				"size": 5831797,
				"extension": "mp3",
				"sr": 48000,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 291000,
				"volumeDelta": 0.0
			},
			"lMusic": {
				"name": null,
				"id": 61156470,
				"size": 3499189,
				"extension": "mp3",
				"sr": 48000,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 291000,
				"volumeDelta": 0.0
			},
			"bMusic": {
				"name": null,
				"id": 61156470,
				"size": 3499189,
				"extension": "mp3",
				"sr": 48000,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 291000,
				"volumeDelta": 0.0
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 5557195
		}, {
			"name": "Try",
			"id": 28639182,
			"position": 4,
			"alias": [],
			"status": 0,
			"fee": 8,
			"copyrightId": 7003,
			"disc": "1",
			"no": 4,
			"artists": [{
				"name": "Colbie Caillat",
				"id": 50890,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "Gypsy Heart Side A",
				"id": 2860926,
				"type": "EP/Single",
				"size": 5,
				"picId": 5930765720512200,
				"blurPicUrl": "http://p1.music.126.net/QBQvSe84znaWIm2PrhQ_ng==/5930765720512200.jpg",
				"companyId": 0,
				"pic": 5930765720512200,
				"picUrl": "http://p1.music.126.net/QBQvSe84znaWIm2PrhQ_ng==/5930765720512200.jpg",
				"publishTime": 1402243200007,
				"description": "",
				"tags": "",
				"company": "环球唱片",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 0,
				"copyrightId": 7003,
				"commentThreadId": "R_AL_3_2860926",
				"artists": [{
					"name": "Colbie Caillat",
					"id": 50890,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 224626,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": "",
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_28639182",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": "Try",
				"id": 47485427,
				"size": 9014551,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 224626,
				"volumeDelta": 0.32
			},
			"mMusic": {
				"name": "Try",
				"id": 47485428,
				"size": 4520968,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 224626,
				"volumeDelta": 0.77
			},
			"lMusic": {
				"name": "Try",
				"id": 47485429,
				"size": 2723535,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 224626,
				"volumeDelta": 0.631285
			},
			"bMusic": {
				"name": "Try",
				"id": 47485429,
				"size": 2723535,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 224626,
				"volumeDelta": 0.631285
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 288118
		}, {
			"name": "Adventure of a Lifetime",
			"id": 36308623,
			"position": 5,
			"alias": [],
			"status": 0,
			"fee": 8,
			"copyrightId": 14002,
			"disc": "1",
			"no": 1,
			"artists": [{
				"name": "Coldplay",
				"id": 89365,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "Adventure of a Lifetime",
				"id": 3395162,
				"type": "EP/Single",
				"size": 2,
				"picId": 1365593442720243,
				"blurPicUrl": "http://p1.music.126.net/a6OatooKiVqJf4ia4RG2ZQ==/1365593442720243.jpg",
				"companyId": 0,
				"pic": 1365593442720243,
				"picUrl": "http://p1.music.126.net/a6OatooKiVqJf4ia4RG2ZQ==/1365593442720243.jpg",
				"publishTime": 1446739200007,
				"description": "",
				"tags": "",
				"company": "华纳PLG",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": [],
				"status": 3,
				"copyrightId": 14002,
				"commentThreadId": "R_AL_3_3395162",
				"artists": [{
					"name": "Coldplay",
					"id": 89365,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 263848,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_36308623",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 1,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 110969622,
				"size": 10554557,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 263848,
				"volumeDelta": -2.48
			},
			"mMusic": {
				"name": null,
				"id": 110969624,
				"size": 5277301,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 263848,
				"volumeDelta": -2.07
			},
			"lMusic": {
				"name": null,
				"id": 110969625,
				"size": 3166398,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 263848,
				"volumeDelta": -2.1
			},
			"bMusic": {
				"name": null,
				"id": 110969625,
				"size": 3166398,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 263848,
				"volumeDelta": -2.1
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 509032
		}, {
			"name": "夜の国",
			"id": 33761678,
			"position": 1,
			"alias": ["TV动画《黑街》片尾曲 / TVアニメ「GANGSTA」EDテーマ"],
			"status": 0,
			"fee": 0,
			"copyrightId": 663018,
			"disc": "1",
			"no": 1,
			"artists": [{
				"name": "Annabel",
				"id": 16083,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "夜の国",
				"id": 3257226,
				"type": "EP/Single",
				"size": 4,
				"picId": 7982454419372966,
				"blurPicUrl": "http://p1.music.126.net/OYUAuPuQk52YLWmUw0K5GQ==/7982454419372966.jpg",
				"companyId": 0,
				"pic": 7982454419372966,
				"picUrl": "http://p1.music.126.net/OYUAuPuQk52YLWmUw0K5GQ==/7982454419372966.jpg",
				"publishTime": 1440518400000,
				"description": "",
				"tags": "",
				"company": "Lantis",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": ["TV动画《黑街》ED专辑"],
				"status": 0,
				"copyrightId": 0,
				"commentThreadId": "R_AL_3_3257226",
				"artists": [{
					"name": "Annabel",
					"id": 16083,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null
			},
			"starred": false,
			"popularity": 100.0,
			"score": 100,
			"starredNum": 0,
			"duration": 242106,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_33761678",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 102701202,
				"size": 9687292,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 242106,
				"volumeDelta": -0.75
			},
			"mMusic": {
				"name": null,
				"id": 102701203,
				"size": 4843668,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 242106,
				"volumeDelta": -0.32
			},
			"lMusic": {
				"name": null,
				"id": 102701204,
				"size": 2906218,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 242106,
				"volumeDelta": -0.35
			},
			"bMusic": {
				"name": null,
				"id": 102701204,
				"size": 2906218,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 242106,
				"volumeDelta": -0.35
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 0
		}, {
			"name": "ターミナル",
			"id": 33761679,
			"position": 2,
			"alias": [],
			"status": 0,
			"fee": 0,
			"copyrightId": 663018,
			"disc": "1",
			"no": 2,
			"artists": [{
				"name": "Annabel",
				"id": 16083,
				"picId": 0,
				"img1v1Id": 0,
				"briefDesc": "",
				"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
				"albumSize": 0,
				"alias": [],
				"trans": "",
				"musicSize": 0
			}],
			"album": {
				"name": "夜の国",
				"id": 3257226,
				"type": "EP/Single",
				"size": 4,
				"picId": 7982454419372966,
				"blurPicUrl": "http://p1.music.126.net/OYUAuPuQk52YLWmUw0K5GQ==/7982454419372966.jpg",
				"companyId": 0,
				"pic": 7982454419372966,
				"picUrl": "http://p1.music.126.net/OYUAuPuQk52YLWmUw0K5GQ==/7982454419372966.jpg",
				"publishTime": 1440518400000,
				"description": "",
				"tags": "",
				"company": "Lantis",
				"briefDesc": "",
				"artist": {
					"name": "",
					"id": 0,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				},
				"songs": [],
				"alias": ["TV动画《黑街》ED专辑"],
				"status": 0,
				"copyrightId": 0,
				"commentThreadId": "R_AL_3_3257226",
				"artists": [{
					"name": "Annabel",
					"id": 16083,
					"picId": 0,
					"img1v1Id": 0,
					"briefDesc": "",
					"picUrl": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"img1v1Url": "http://p1.music.126.net/6y-UleORITEDbvrOLV0Q8A==/5639395138885805.jpg",
					"albumSize": 0,
					"alias": [],
					"trans": "",
					"musicSize": 0
				}],
				"subType": "录音室版",
				"transName": null
			},
			"starred": false,
			"popularity": 85.0,
			"score": 85,
			"starredNum": 0,
			"duration": 256053,
			"playedNum": 0,
			"dayPlays": 0,
			"hearTime": 0,
			"ringtone": null,
			"crbt": null,
			"audition": null,
			"copyFrom": "",
			"commentThreadId": "R_SO_4_33761679",
			"rtUrl": null,
			"ftype": 0,
			"rtUrls": [],
			"copyright": 2,
			"transName": null,
			"sign": null,
			"hMusic": {
				"name": null,
				"id": 102701205,
				"size": 10245267,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 320000,
				"playTime": 256053,
				"volumeDelta": -0.9
			},
			"mMusic": {
				"name": null,
				"id": 102701206,
				"size": 5122656,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 160000,
				"playTime": 256053,
				"volumeDelta": -0.51
			},
			"lMusic": {
				"name": null,
				"id": 102701207,
				"size": 3073611,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 256053,
				"volumeDelta": -0.58
			},
			"bMusic": {
				"name": null,
				"id": 102701207,
				"size": 3073611,
				"extension": "mp3",
				"sr": 44100,
				"dfsId": 0,
				"bitrate": 96000,
				"playTime": 256053,
				"volumeDelta": -0.58
			},
			"mp3Url": null,
			"rtype": 0,
			"rurl": null,
			"mvid": 0
		}],
		"cloudTrackCount": 0,
		"subscribedCount": 9387,
		"totalDuration": 0,
		"trackCount": 24,
		"tags": [],
		"ordered": true,
		"userId": 1,
		"coverImgUrl": "http://p2.music.126.net/TpRmDebucTTX5UE-7W8png==/19016053603009403.jpg",
		"updateTime": 1537006513167,
		"commentThreadId": "A_PL_0_1",
		"coverImgId": 19016053603009403,
		"privacy": 0,
		"playCount": 2004106,
		"specialType": 5,
		"anonimous": false,
		"newImported": false,
		"trackUpdateTime": 1539056463198,
		"adType": 0,
		"trackNumberUpdateTime": 1537006502047,
		"status": 0,
		"description": null,
		"createTime": 1356607835546,
		"highQuality": false,
		"name": "网易云音乐喜欢的音乐",
		"id": 1,
		"shareCount": 158,
		"coverImgId_str": "19016053603009403",
		"commentCount": 2870
	},
	"code": 200
}'''
    # def details_playlist(self, id):
    #     """
    #         歌单详情。
    #     """
    #     url = 'http://music.163.com/api/playlist/detail?id=%d' % (id)
    #     html = self.httpRequest(url, method="GET", cookies=self.cookies)
    #     return html['result']

    def search(self, s, offset=0, limit=100, total='true', stype=1):
        """
            搜索.
            type类型: 单曲(1), 专辑(10), 歌手(100), 歌单(1000), 用户(1002)
        """
        url = 'http://music.163.com/api/search/get/web'
        data = {
            's': s,
            'offset': offset,
            'total': total,
            'limit': limit,
            'type': stype
        }
        html = self.httpRequest(url, method='POST', data=data, cookies=self.cookies)
        try:
            return html[1]['result']
        except:
            return "Not Found!"

    def details_search(self, id):
        """
            搜索结果详情，返回歌曲URL。
        """
        id = str(id)
        url = "http://music.163.com//api/song/detail/?id=%s&ids=%s" % (id, urllib.parse.quote('[%s]' % (id)))
        html = self.httpRequest(url, method='GET', cookies=self.cookies)
        return html['songs'][0]['mp3Url']

    def newsong(self, areaID=0, offset=0, total='true', limit=100):
        """
            最新音乐--新歌速递。
            areaID(0全部, 9华语, 96欧美, 16韩国, 8日本。)
        """
        url = 'http://music.163.com/api/discovery/new/songs?areaId=%d&offset=%d&total=%s&limit=%d' %\
              (areaID, offset, total, limit)
        html = self.httpRequest(url, method='GET', cookies=self.cookies)
        return html['data']

    def fnewsong(self, year=2015, month=4, area='ALL'):
        """
            最新音乐--新碟上架。
            area(ALL全部, ZH华语, EA欧美, KR韩国, 日本JP)
        """
        url = 'http://music.163.com/api/discovery/new/albums/area?year=%d&month=%d&area=%s&type=hot&offset=0&total=true&limit=20&rcmd=true' \
              % (year, month, area)
        html = self.httpRequest(url, method="GET", cookies=self.cookies)
        return html['monthData']

if __name__ == '__main__':
    main = WebApi()
    req = main.newsong()
    for i in req:
        print(i)
