# coding: utf-8

"""
    Verification API

    # Introduction  <span class=\"subtext\"> Welcome to the Passbase Verifications API docs. This documentation will help you understand our models and the Verification API with its endpoints. Based on this you can build your own system (i.e. verification) and hook it up to Passbase.  In case of feedback or questions you can reach us under this email address: [developer@passbase.com](mailto:developer@passbase.com). </span>  A User submits a video selfie and valid identifying __Resources__ during a __Verification__ guided by the Passbase client-side integration. Once all the necessary __Resources__ are submitted, __Data points__ are extracted, digitized, and authenticated. These Data points then becomes part of the User's __Identity__. The User then consents to share __Resources__ and/or __Data points__ from their Identity with you. This information is passed to you and can be used to make decisions about a User (e.g. activate account). This table below explains our terminology further.  | Term                                    | Description | |-----------------------------------------|-------------| | [Identity](#tag/identity_model)         | A set of Data points and Resources related to and owned by one single User. This data can be accessed by you through a Verification. | | Data points                             | Any data about a User extracted from a Resource (E.g. Passport Number, or Age). | | [Resource](#tag/resource_model)         | A source document used to generate the Data points for a User (E.g. Passport). | | [User](#tag/user_model)                 | The owner of an email address associated with an Identity. | | Verification                            | A transaction through which a User consents to share Data points with you. If the Data points you request are not already available in the User's Identity, the Passbase client will ask the User to submit the necessary Resource required to extract them. | | Re-authentication (login)               | A transaction through which a User can certify the ownership of Personal data previously shared through an Authentication. |   # Authentication  <span class=\"subtext\"> There are two forms of authentication for the API: <br/>&bull; API Key <br/>&bull; Bearer JWT Token  </span>   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WatchlistResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'clean': 'bool',
        'listings': 'object',
        'media': 'list[object]',
        'sources': 'list[str]',
        'types': 'list[str]'
    }

    attribute_map = {
        'clean': 'clean',
        'listings': 'listings',
        'media': 'media',
        'sources': 'sources',
        'types': 'types'
    }

    def __init__(self, clean=None, listings=None, media=None, sources=None, types=None):  # noqa: E501
        """WatchlistResponse - a model defined in Swagger"""  # noqa: E501
        self._clean = None
        self._listings = None
        self._media = None
        self._sources = None
        self._types = None
        self.discriminator = None
        if clean is not None:
            self.clean = clean
        if listings is not None:
            self.listings = listings
        if media is not None:
            self.media = media
        if sources is not None:
            self.sources = sources
        if types is not None:
            self.types = types

    @property
    def clean(self):
        """Gets the clean of this WatchlistResponse.  # noqa: E501

        Indicates whether the authentication watchlist check is clean or not  # noqa: E501

        :return: The clean of this WatchlistResponse.  # noqa: E501
        :rtype: bool
        """
        return self._clean

    @clean.setter
    def clean(self, clean):
        """Sets the clean of this WatchlistResponse.

        Indicates whether the authentication watchlist check is clean or not  # noqa: E501

        :param clean: The clean of this WatchlistResponse.  # noqa: E501
        :type: bool
        """

        self._clean = clean

    @property
    def listings(self):
        """Gets the listings of this WatchlistResponse.  # noqa: E501

        Watchlist check findings  # noqa: E501

        :return: The listings of this WatchlistResponse.  # noqa: E501
        :rtype: object
        """
        return self._listings

    @listings.setter
    def listings(self, listings):
        """Sets the listings of this WatchlistResponse.

        Watchlist check findings  # noqa: E501

        :param listings: The listings of this WatchlistResponse.  # noqa: E501
        :type: object
        """

        self._listings = listings

    @property
    def media(self):
        """Gets the media of this WatchlistResponse.  # noqa: E501

        List of media entries, with the date, title, and url parameters  # noqa: E501

        :return: The media of this WatchlistResponse.  # noqa: E501
        :rtype: list[object]
        """
        return self._media

    @media.setter
    def media(self, media):
        """Sets the media of this WatchlistResponse.

        List of media entries, with the date, title, and url parameters  # noqa: E501

        :param media: The media of this WatchlistResponse.  # noqa: E501
        :type: list[object]
        """

        self._media = media

    @property
    def sources(self):
        """Gets the sources of this WatchlistResponse.  # noqa: E501

        Array of listing sources (eg. sanction lists)  # noqa: E501

        :return: The sources of this WatchlistResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._sources

    @sources.setter
    def sources(self, sources):
        """Sets the sources of this WatchlistResponse.

        Array of listing sources (eg. sanction lists)  # noqa: E501

        :param sources: The sources of this WatchlistResponse.  # noqa: E501
        :type: list[str]
        """

        self._sources = sources

    @property
    def types(self):
        """Gets the types of this WatchlistResponse.  # noqa: E501

        What kind of alert or warning is associated with the entity (eg. sanction, pep, warning)  # noqa: E501

        :return: The types of this WatchlistResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._types

    @types.setter
    def types(self, types):
        """Sets the types of this WatchlistResponse.

        What kind of alert or warning is associated with the entity (eg. sanction, pep, warning)  # noqa: E501

        :param types: The types of this WatchlistResponse.  # noqa: E501
        :type: list[str]
        """

        self._types = types

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WatchlistResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WatchlistResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
