    updated: Wednesday, 6th April 2022

<div align=center>
    <a href="https://github.com/warmachine028/datastax">
    <img width=200 src="https://github.com/warmachine028/datastax/blob/main/assets/icon.png" alt="datastax"></a>
    <p style="font-family: roboto, calibri; font-size:12pt; font-style:italic"> Simplicity meets intelligence</p>
    <a href="https://pypi.org/project/datastax" ><img alt="PyPI" src="https://img.shields.io/pypi/v/datastax?color=blueviolet"></a>
    <a href="https://pypi.org/project/datastax/#files"><img alt="PyPI Downloads" src="https://img.shields.io/pypi/dm/datastax.svg?label=Pypi%20downloads"></a>
    <br>
    <a href="https://github.com/warmachine028/datastax/releases/"> <img src="https://img.shields.io/github/v/release/warmachine028/datastax?color=brightgreen"></a>
    <a href="https://github.com/warmachine028/datastax/releases/tag/"> <img src="https://img.shields.io/github/v/release/warmachine028/datastax?color=lightgreen&include_prereleases&label=pre%20release"> </a>
    <br>
    <img src="https://img.shields.io/github/stars/warmachine028/datastax">
    <a href= "https://github.com/warmachine028/datastax/blob/main/LICENSE"><img src="https://img.shields.io/github/license/warmachine028/datastax?color=orange"></a>
    <a href="https://github.com/warmachine028/datastax/network/members"><img src="https://img.shields.io/github/forks/warmachine028/datastax?color=cyan"></a>
    <br>
</div>

# [dataStax](https://github.com/warmachine028/datastax)

## What's New?

- Added Mandatory Keyword arguments to avoid confusion in:
  - Arrays 
  - ThreadedBinaryTree 
- Added High Quality PNGs in README.md

## Table of Contents

- [Introduction](#introduction)
- [Problem Statement](#problem-statement)
- [Benefits](#benefits)
- [Requirements](#requirements)
- [Installation](#installation)
- [Usage](#usage)
- [What's Next](#whats-next)

## Introduction

- This is a very simple yet powerful project to implement day to day abstract data structures
- A pure implementation of Python in representing Tree, Linkedlist and Array based datastructures in basic command
  prompt
- It helps visualize each data structure for better understanding
- Students can be beneficial in using this Package
- This project is still under construction

## Problem Statement

- Often at the beginning of B.Tech Course, CS students face a lot of problems understanding the internal architecture of
  complex ADTs.
- While solving coding challenges locally where test cases have to be written using these ADTs, it becomes really
  cumbersome to write these data structures from scratch.
- Also, when writing programs which implements these ADS, we encounter lots of errors just because we are unable to
  preview what's actually going on under the hood.

## Benefits

- Instant installation
- Quick Updates
- Very small size
- No extra modules required
- Written purely from scratch
- Easy Documentation [Upcoming]
- Command Line Demo

## Requirements

- Runs on latest Python 3.7+
- (WARNING: Though the module might run on py 3.7 error free, but it has been tested for 3.9+)
- (Suggesting you to always update to the latest python version)
- This Library requires no extra modules

## Installation

1. Use the python package manager [pip](https://pip.pypa.io/en/stable/) to install datastax.

```bash
pip install datastax
```

## Usage

### Demo

- To get a demo of the library use the following command
    - **Windows**:

  ```bash
  > py -m datastax 
  ```
    - **Unix based systems**:

  ```bash
  $ python3 -m datastax
  ```
    - _Result_
  ```bash
  Available modules are:
  1. LinkedLists
  2. Trees
  3. Arrays
  
  Usage
  > py datastax <data-structure> [data]
  Data Structures:
  ->  trees          Hierarchical DS
  ->  linkedlists    Linear DS
  ->  arrays         Fixed Size Linear DS

  ```
- Then follow as the instruction guides

```bash
> py -m datastax linkedlist 1 2 3 4
  Visuals for LinkedLists:

  1. Singly Linked List:
     HEAD                                         TAIL
 ┌─────╥────┐   ┌─────╥────┐   ┌─────╥────┐   ┌─────╥────┐
 │  1  ║  ----->│  2  ║  ----->│  3  ║  ----->│  4  ║  -----> NULL
 └─────╨────┘   └─────╨────┘   └─────╨────┘   └─────╨────┘


  2. Doubly Linked List:
               HEAD                                                        TAIL
         ┌────╥─────╥────┐   ┌────╥─────╥────┐   ┌────╥─────╥────┐   ┌────╥─────╥────┐
 NULL <-----  ║  1  ║  <------->  ║  2  ║  <------->  ║  3  ║  <------->  ║  4  ║  -----> NULL
         └────╨─────╨────┘   └────╨─────╨────┘   └────╨─────╨────┘   └────╨─────╨────┘
  ...
```

### Practical Usage

- **Queue**

![queue](./assets/Usage/queue.png)

![queue_output](./assets/Usage/queue_output.png)

---------------------------------------------------

- **BinaryTree**

![BinaryTree](./assets/Usage/binaryTree.png)

![BinaryTree_output](./assets/Usage/binaryTree_output.png)

---------------------------------------------------

- **MinHeapTree**

![MinHeapTree](./assets/Usage/mht.png)

![MinHeapTree_output](./assets/Usage/mht_output.png)

---------------------------------------------------

- **ThreadedBinaryTree**

![ThreadedBinaryTree](./assets/Usage/tbt.png)

![ThreadedBinaryTree_output](./assets/Usage/tbt_output.png)

---------------------------------------------------

- **SumSegmentTree**

![SumSegmentTree](./assets/Usage/sst.png)

![SumSegmentTree_Output](./assets/Usage/sst_output.png)

---------------------------------------------------

- **HuffmanTree**

![HuffmanTree](./assets/Usage/hft.png)

![HuffmanTree_Output](./assets/Usage/hft_output.png)

---------------------------------------------------

- **RedBlackTree**

![RedBlackTree](./assets/Usage/rbt.png)

![RedBlackTreeOutput](./assets/Usage/rbt_output.png)

## What's Next

- Enhanced Documentation
- Better TestCases for Huffman Tree
- Better TestCases for Segment Trees
- Test Cases for Fibonacci Tree
