# Generated by Django 2.0.4 on 2018-07-03 20:52

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('GLN13', models.CharField(db_index=True, help_text='The GLN (Global Location Number) provides a standard means to identify legal entities, trading parties and locations to support the requirements of electronic commerce. The GLN-13 is defined by GS1', max_length=13, null=True, unique=True, verbose_name='GLN13')),
                ('SGLN', models.CharField(db_index=True, help_text='The SGLN EPC scheme is used to assign a unique identity to a physical location or sub-location, such as a specific building or a specific unit of shelving within a warehouse.  TheSGLN is expressed as a URN value.', max_length=150, null=True, unique=True, verbose_name='SGLN')),
                ('name', models.CharField(db_index=True, help_text='A unique name for the location or party.', max_length=128, verbose_name='Name')),
                ('address1', models.CharField(help_text='For example, the name of the street and the number in the street or the name of a building', max_length=1000, null=True, verbose_name='Street Address One')),
                ('address2', models.CharField(help_text='The second free form line complements the first free form line to locate the party or location.', max_length=1000, null=True, verbose_name='Street Address Two')),
                ('address3', models.CharField(help_text='The third free form line complements the first and second free form lines where necessary.', max_length=1000, null=True, verbose_name='Street Address Three')),
                ('country', models.CharField(help_text='Country ISO 3166-1 alpha-2 Code', max_length=2, null=True, verbose_name='Country Code')),
                ('city', models.CharField(help_text='City', max_length=50, null=True, verbose_name='city')),
                ('state_province', models.CharField(help_text='One of the constituent units of a nation having a federal government.', max_length=20, null=True, verbose_name='State or Province')),
                ('postal_code', models.CharField(help_text='Postal Code', max_length=20, null=True, verbose_name='Postal Code')),
                ('latitude', models.DecimalField(decimal_places=6, help_text=' Latitude of the location, in degrees. Positive numbers are northern latitude; negative numbers are southern latitude.', max_digits=9, null=True, verbose_name='Latitude')),
                ('longitude', models.DecimalField(decimal_places=6, help_text='Longitude of the location, in degrees. Positive numbers are eastern longitude; negative numbers are western longitude.', max_digits=9, null=True, verbose_name='Longitude')),
                ('gs1_company_prefix', models.CharField(help_text='A GS1 Company Prefix is a unique string of four to twelve digits used to issue GS1 identification keys.', max_length=12, verbose_name='GS1 Company Prefix')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CompanyType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', models.CharField(db_index=True, help_text='The unique type identifier.', max_length=20, verbose_name='Identifier')),
                ('description', models.CharField(help_text='A brief description of the type.', max_length=400, verbose_name='Description')),
            ],
            options={
                'verbose_name': 'CompanyType',
                'verbose_name_plural': 'CompanyTypes',
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('GLN13', models.CharField(db_index=True, help_text='The GLN (Global Location Number) provides a standard means to identify legal entities, trading parties and locations to support the requirements of electronic commerce. The GLN-13 is defined by GS1', max_length=13, null=True, unique=True, verbose_name='GLN13')),
                ('SGLN', models.CharField(db_index=True, help_text='The SGLN EPC scheme is used to assign a unique identity to a physical location or sub-location, such as a specific building or a specific unit of shelving within a warehouse.  TheSGLN is expressed as a URN value.', max_length=150, null=True, unique=True, verbose_name='SGLN')),
                ('name', models.CharField(db_index=True, help_text='A unique name for the location or party.', max_length=128, verbose_name='Name')),
                ('address1', models.CharField(help_text='For example, the name of the street and the number in the street or the name of a building', max_length=1000, null=True, verbose_name='Street Address One')),
                ('address2', models.CharField(help_text='The second free form line complements the first free form line to locate the party or location.', max_length=1000, null=True, verbose_name='Street Address Two')),
                ('address3', models.CharField(help_text='The third free form line complements the first and second free form lines where necessary.', max_length=1000, null=True, verbose_name='Street Address Three')),
                ('country', models.CharField(help_text='Country ISO 3166-1 alpha-2 Code', max_length=2, null=True, verbose_name='Country Code')),
                ('city', models.CharField(help_text='City', max_length=50, null=True, verbose_name='city')),
                ('state_province', models.CharField(help_text='One of the constituent units of a nation having a federal government.', max_length=20, null=True, verbose_name='State or Province')),
                ('postal_code', models.CharField(help_text='Postal Code', max_length=20, null=True, verbose_name='Postal Code')),
                ('latitude', models.DecimalField(decimal_places=6, help_text=' Latitude of the location, in degrees. Positive numbers are northern latitude; negative numbers are southern latitude.', max_digits=9, null=True, verbose_name='Latitude')),
                ('longitude', models.DecimalField(decimal_places=6, help_text='Longitude of the location, in degrees. Positive numbers are eastern longitude; negative numbers are western longitude.', max_digits=9, null=True, verbose_name='Longitude')),
                ('icon', models.FileField(help_text='An icon to represent the location in a GUI or report.', null=True, upload_to='qu4rtetmasterdataimages/', verbose_name='Icon')),
                ('sst', models.SmallIntegerField(help_text='Sub-Site Type: describes the primary business function of the sub-site location. This master data attribute is only applicable to a sub-site location.  This value is expressed as a single numerical code.', null=True, verbose_name='Sub-Site Type')),
                ('ssa', models.CharField(help_text='Sub-Site Attribute: further qualifies the business function of the sub-site location. This master data attribute is only applicable to a sub-site location. Sub-site attributes are expressed as a comma- separated list of zero or more numerical codes', max_length=1000, null=True, verbose_name='Sub-Site Attribute')),
                ('company', models.ForeignKey(help_text='The company, if any, associated with this location.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='quartet_masterdata.Company', verbose_name='Company')),
            ],
            options={
                'verbose_name': 'Location',
                'verbose_name_plural': 'Locations',
            },
        ),
        migrations.CreateModel(
            name='LocationField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the field.', max_length=100, verbose_name='Name')),
                ('value', models.TextField(help_text='The value of the field.', verbose_name='Value')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('location', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='quartet_masterdata.Location')),
            ],
            options={
                'verbose_name': 'Location Field',
                'verbose_name_plural': 'Location Fields',
            },
        ),
        migrations.CreateModel(
            name='LocationIdentifier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', models.CharField(help_text='A unique identifier for a location such as a GLN or SGLN.', max_length=250, verbose_name='identifier')),
                ('identifier_type', models.CharField(help_text='The type of location identifier. For example: GLN-13, SGLN, etc.', max_length=50, verbose_name='identifier_type')),
                ('description', models.CharField(help_text='A brief description of what the identifier represents.', max_length=150, null=True, verbose_name='Description')),
                ('location', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='quartet_masterdata.Location')),
            ],
            options={
                'verbose_name': 'LocationIdentifier',
                'verbose_name_plural': 'LocationIdentifiers',
            },
        ),
        migrations.CreateModel(
            name='LocationType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', models.CharField(db_index=True, help_text='The unique type identifier.', max_length=20, verbose_name='Identifier')),
                ('description', models.CharField(help_text='A brief description of the type.', max_length=400, verbose_name='Description')),
            ],
            options={
                'verbose_name': 'Location Type',
                'verbose_name_plural': 'Location Types',
            },
        ),
        migrations.CreateModel(
            name='Measurement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('measurement', models.FloatField(help_text='The numerical value of the measurement', verbose_name='Measurement')),
                ('measurement_unit_code', models.CharField(help_text='The unit of measure for the measurement. The code list for this attribute is UN/ECE Recommendation 20', max_length=40, null=True, verbose_name='measurement_unit_code')),
            ],
        ),
        migrations.CreateModel(
            name='TradeItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('country_of_origin', models.CharField(help_text='Country from which the goods are supplied. The code list for this attribute is the ISO 3166-1 Alpha-2 list of 2-letter country codes', max_length=2, null=True, verbose_name='Country Of Origin')),
                ('drained_weight', models.FloatField(help_text='The weight of the trade item when drained of its liquid. For example 225 grm', null=True, verbose_name='Drained Weight')),
                ('drained_weight_uom', models.CharField(help_text='The unit of measure for the drained weight as defined inUN/ECE Recommendation 20.', max_length=5, null=True, verbose_name='Drained Weight UOM')),
                ('gross_weight', models.FloatField(help_text='Used to identify the gross weight of the trade item. The gross weight includes all packaging materials of the trade item.', null=True, verbose_name='Gross Weight')),
                ('gross_weight_uom', models.CharField(help_text='The unit of measure for the gross weight as defined inUN/ECE Recommendation 20.', max_length=5, null=True, verbose_name='Gross Weight UOM')),
                ('net_weight', models.FloatField(help_text='Used to identify the net weight of the trade item. Net weight excludes any packaging materials and applies to all levels but consumer unit level.', null=True, verbose_name='Net Weight')),
                ('net_weight_uom', models.CharField(help_text='The unit of measure for the net weight as defined inUN/ECE Recommendation 20.', max_length=5, null=True, verbose_name='NET Weight UOM')),
                ('image', models.FileField(help_text='An image to represent the product in a GUI or report.', null=True, upload_to='qu4rtetmasterdataimages/', verbose_name='Icon')),
                ('GTIN14', models.CharField(db_index=True, help_text='The GS1 GTIN-14 associated with the Trade Item.', max_length=14, unique=True, verbose_name='GTIN-14')),
                ('NDC', models.CharField(help_text='The national drug code for the product. US Only.', max_length=12, null=True, unique=True, verbose_name='NDC')),
                ('NDC_pattern', models.CharField(choices=[('4-4-2', '4-4-2'), ('5-3-2', '5-3-2'), ('4-5-1', '5-4-1')], help_text='The pattern of the NDC.  US Only.  Optional.', max_length=5, null=True, verbose_name='NDC_pattern')),
                ('additional_id', models.CharField(help_text='A trade item identifier that is in addition to the GTIN.', max_length=80, null=True, verbose_name='Additional ID')),
                ('additional_id_typecode', models.CharField(help_text='The code list for this attribute is defined in GS1 GDSN.', max_length=250, null=True, verbose_name='Additional ID TypeCode')),
                ('description_short', models.CharField(help_text='A free form short length description of the trade item that can be used to identify the trade item at point of sale.', max_length=35, null=True, verbose_name='description_short')),
                ('dosage_form_type', models.CharField(help_text='A dosage form is the physical form of a medication that identifies the form of the pharmaceutical item. For example: PILL', max_length=35, null=True, verbose_name='Dosage Form Type')),
                ('functional_name', models.CharField(help_text='Describes use of the product or service by the consumer. Should help clarify the product classification associated with the GTIN.', max_length=100, null=True, verbose_name='functional_name')),
                ('manufacturer_name', models.CharField(help_text='Party name information for the manufacturer of the trade item. Example: Acme Corporation', max_length=300, null=True, verbose_name='manufacturer_name')),
                ('net_content_description', models.CharField(help_text='Free text describing the amount of the trade item contained by a package, usually as claimed on the label. Example: 253 grams', max_length=500, null=True, verbose_name='Net Content Description')),
                ('label_description', models.CharField(help_text="A literal reproduction of the text featured on a product's label in the same word-by-word order in which it appears on the front of the product's packaging.", max_length=500, null=True, verbose_name='Label Description')),
                ('regulated_product_name', models.CharField(help_text='The prescribed, regulated or generic product name or denomination that describes the true nature of the product according to country specific regulation.', max_length=500, null=True, verbose_name='regulated_product_name')),
                ('strength_description', models.CharField(help_text='Free text describing the strength of the active ingredient(s) of the product. Example: 200mg/100mg', max_length=500, null=True, verbose_name='strength_description')),
                ('trade_item_description', models.CharField(help_text='An understandable and useable description of a trade item using brand and other descriptors.', max_length=200, null=True, verbose_name='Trade Item Description')),
                ('company', models.ForeignKey(help_text='The company, associated with this trade item.', on_delete=django.db.models.deletion.CASCADE, to='quartet_masterdata.Company', verbose_name='Company')),
            ],
            options={
                'verbose_name': 'Trade Item',
                'verbose_name_plural': 'Trade Items',
            },
        ),
        migrations.CreateModel(
            name='TradeItemField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the field.', max_length=100, verbose_name='Name')),
                ('value', models.TextField(help_text='The value of the field.', verbose_name='Value')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('trade_item', models.ForeignKey(help_text='The Related Trade Item', on_delete=django.db.models.deletion.CASCADE, to='quartet_masterdata.TradeItem', verbose_name='Trade Item')),
            ],
            options={
                'verbose_name': 'Trade Item Field',
                'verbose_name_plural': 'Trade Item Fields',
            },
        ),
        migrations.AddField(
            model_name='location',
            name='location_type',
            field=models.ForeignKey(help_text='An additional classifier that can be used to identifythe location outside of the CBV codes.  This can be an internal classifier or a human readable that lends further clarity to the location record.', null=True, on_delete=django.db.models.deletion.CASCADE, to='quartet_masterdata.LocationType', verbose_name='Location Type'),
        ),
        migrations.AddField(
            model_name='location',
            name='site',
            field=models.ForeignKey(help_text='Identifies the site in which this location is contained...if at all. For a Sub-site location, this is the identifier of the parent location.', null=True, on_delete=django.db.models.deletion.CASCADE, to='quartet_masterdata.Location', verbose_name='Site'),
        ),
        migrations.AddField(
            model_name='company',
            name='company_type',
            field=models.ForeignKey(help_text='Describes the type of company.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='quartet_masterdata.CompanyType', verbose_name='Type'),
        ),
    ]
