/*! For license information please see extension.js.LICENSE.txt */
define(["base/js/namespace","jquery"],((e,n)=>(()=>{var t={227:(e,n,t)=>{(n=t(352)(!1)).push([e.id,"#bxy-outer-control-panel {\r\n  position: absolute;\r\n  padding: 6px 6px 6px 4px;\r\n  top: 120px;\r\n  right: 16px;\r\n  background-color: rgba(245, 245, 245, 0.9);\r\n  border-radius: 4px;\r\n  border: 1px solid #aaa;\r\n  z-index: 110;\r\n  user-select: none;\r\n}\r\n\r\n#bxy-inner-control-panel {\r\n  display: flex;\r\n  /* cursor: grab; */\r\n}\r\n\r\n/* #bxy-inner-control-panel:active {\r\n  cursor: grabbing;\r\n} */\r\n\r\n/* \r\nhttp://www.patternify.com/\r\n*/\r\n.bxy-small-dot-pattern {\r\n  background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAADCAYAAABWKLW/AAAAF0lEQVQYV2NkYGD4z8DAwMgAI0AMDA4AI3EBBMY7CTgAAAAASUVORK5CYII=)\r\n    repeat;\r\n}\r\n\r\n#bxy-drag-handle {\r\n  cursor: grab;\r\n  margin-left: 0px;\r\n  margin-right: 4px;\r\n  width: 10px;\r\n}\r\n\r\n#bxy-drag-handle:active {\r\n  cursor: grabbing;\r\n}\r\n\r\n.bxy-control-panel {\r\n  display: none;\r\n  margin-top: 4px;\r\n}\r\n\r\n.bxy-control-panel .btn {\r\n  padding: 3px 4px;\r\n}\r\n\r\n#bxy-notifier {\r\n  max-width: 160px;\r\n  font-size: 0.9em;\r\n}\r\n\r\n#bxy-control-panel-title {\r\n  /* cursor: grab; */\r\n  display: flex;\r\n  align-items: center;\r\n  color: #666;\r\n  text-transform: uppercase;\r\n  text-align: center;\r\n  width: 100%;\r\n  margin-top: 0px;\r\n  margin-bottom: 0px;\r\n  font-size: 0.8em;\r\n}\r\n\r\n/* #bxy-control-panel-title:active {\r\n  cursor: grabbing;\r\n} */\r\n\r\n/* #bxy-control-panel-title div {\r\n  margin-right: 5px;\r\n} */\r\n\r\n#bxy-control-panel-title #bxy-logo-text {\r\n  /* transform: scale(1.05, 1.25); */\r\n  /* margin-left: 6px; */\r\n  /* margin-top: -4px; */\r\n  /* letter-spacing: 0.9em; */\r\n  width: 100%;\r\n  text-align-last: justify;\r\n}\r\n\r\n#bxy-control-panel-title img {\r\n  width: 22px;\r\n  padding: 0 2px 0 2px;\r\n}\r\n\r\n.bxy-config-title {\r\n  font-weight: bold;\r\n  /* font-size: 15px; */\r\n}\r\n\r\n.bxy-form-item {\r\n  display: flex;\r\n  align-items: center;\r\n  margin-top: 6px;\r\n  max-width: 200px;\r\n}\r\n\r\n.bxy-form-item span {\r\n  white-space: nowrap;\r\n  margin-right: 4px;\r\n}\r\n\r\n.bxy-sticker-inner {\r\n  /*  border:2px dashed red;*/\r\n  pointer-events: none;\r\n}\r\n\r\n.bxy-sticker-inner div {\r\n  position: absolute;\r\n  left: 0px;\r\n  top: 0px;\r\n  margin-top: 3px;\r\n  margin-left: 3px;\r\n}\r\n\r\n.bxy-right-side-marker {\r\n  opacity: 0.5;\r\n  cursor: pointer;\r\n}\r\n\r\n#bxy-config-btns {\r\n  display: flex;\r\n  justify-content: center;\r\n}\r\n\r\n#bxy-config-btns button {\r\n  margin: 4px 4px 0;\r\n}\r\n\r\ndetails {\r\n  display: inline-block;\r\n  background: #f9fafb;\r\n}\r\n\r\ndetails summary {\r\n  display: inline-block;\r\n  padding: 6px;\r\n  padding-left: 14px;\r\n  border-radius: 4px;\r\n  border: 1px solid #c4c6c8;\r\n  cursor: pointer;\r\n  width: auto;\r\n}\r\n\r\ndetails summary::after {\r\n  content: '';\r\n  display: inline-block;\r\n  width: 36px;\r\n  height: 18px;\r\n  margin-left: 6px;\r\n  transform: translateY(3px);\r\n  background-image: url('https://staticcdn.boyuai.com/user-assets/14398/dG7UTDzi5L6NqW3eCUqJQ3/hide.png');\r\n  background-size: cover;\r\n  transition: background 0.3s linear;\r\n}\r\n\r\ndetails[open] {\r\n  display: block;\r\n  border: 1px solid #c4c6c8;\r\n  border-radius: 4px;\r\n  padding: 14px;\r\n}\r\n\r\ndetails[open] summary {\r\n  display: flex;\r\n  justify-content: space-between;\r\n  padding: 0;\r\n  border: none;\r\n  padding-bottom: 6px;\r\n  margin-bottom: 6px;\r\n  border-bottom: 1px solid #e9ebed;\r\n}\r\n\r\ndetails[open] summary::after {\r\n  background-image: url('https://staticcdn.boyuai.com/user-assets/14398/2g1MVbqCQzFDejHtiLh6Ze/display.png');\r\n  margin: 0;\r\n}\r\n\r\ndetails summary::marker {\r\n  content: '';\r\n}\r\n\r\n.image-player {\r\n  width: 100%;\r\n  max-width: 850px;\r\n  margin: 0.4em auto;\r\n  background-color: #f9fafb;\r\n  border-radius: 4px;\r\n}\r\n\r\n.image-player .image-viewer {\r\n  width: 100%;\r\n  overflow: hidden;\r\n  object-fit: cover;\r\n  display: flex;\r\n  flex-wrap: wrap;\r\n  justify-content: space-between;\r\n  align-items: center;\r\n}\r\n\r\n.image-player .image-viewer img {\r\n  width: 30%;\r\n  border: 1px solid #f1f1f1;\r\n}\r\n\r\n.image-player .button-wrapper {\r\n  display: none;\r\n}\r\n\r\n.ipy-ali-player {\r\n  border: 1px solid #d2d2d2;\r\n  margin: 5px auto;\r\n  margin: 5px auto;\r\n  padding: 12px;\r\n  text-align: center;\r\n}\r\n\r\n.ipy-ali-player::after {\r\n  content: '视频将会在在这里显示';\r\n}",""]),e.exports=n},781:(e,n)=>{"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e,n){void 0===n&&(n="download");var t="data:text/plain;charset=utf-8,"+encodeURIComponent(JSON.stringify(e)),r=document.createElement("a");r.href=t,r.download=n+".ipynb",document.body.appendChild(r),r.click(),document.body.removeChild(r)}},270:(e,n)=>{"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.extractErrorMessage=n.ERROR_INFO_MAP=void 0,n.ERROR_INFO_MAP={SyntaxError:"#### 什么是 `SyntaxError` ?\n\n语法错误，情况比较复杂。下面列出一些可能的情况。\n\n* 示例代码\n\n```python\nif True\n    print(1)\n```\n\n**错误分析**：`if` 语句的冒号缺失\n\n* 示例代码\n\n```python\nprint(\"a string)\n```\n\n**错误分析**：`\"a string` 的引号缺失\n\n* 示例代码\n\n```python\nif 3 = 3:\n    print('True')\n```\n\n**错误分析**：使用 `=` 而非 `==` 判断相等",NameError:"#### 什么是 `NameError` ?\n\n访问未定义的对象\n\n* 示例代码\n\n```python\n>>> print(a)\nTraceback (most recent call last):\n    File \"<stdin>\", line 1, in <module>\nNameError: name 'a' is not defined\n```\n\n**错误分析**：变量 `a` 未定义\n\n* 示例代码\n\n```python\n>>> prnit(1)\nTraceback (most recent call last):\n    File \"<stdin>\", line 1, in <module>\nNameError: name 'prnit' is not defined\n```\n\n**错误分析**：输出函数拼写错误，`prnit` 在是一个未定义的函数",IndentationError:"#### 什么是 `IndentationError` ?\n\n代码缩进错误，检查是否有多余的空格。",TypeError:"#### 什么是 `TypeError` ?\n\n类型错误。\n\n* 示例代码\n\n```python\n>>> for i in len(a_list):\n>>>     print(i)\nTraceback (most recent call last):\n  File \"<stdin>\", line 1, in <module>\nTypeError: 'int' object is not iterable\n```\n\n**错误分析**：在 `for` 语句中遗漏了 `range`，而 `len(a_list)` 的类型是整数，是不可迭代的。",IndexError:'#### 什么是 `IndexError` ?\n\n访问列表或元组元素时，索引下标超出范围\n\n* 示例代码\n\n```python\n>>> a_list = [1, 2, 3]\n>>> print(a_list[4])\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nIndexError: list index out of range\n```\n\n**错误分析**：`a_list` 的合法下标是 0, 1, 2 （或者 -1, -2, -3），4 超出下标范围\n\n* 示例代码\n\n```python\n>>> a_tuple = (1, 2, 3)\n>>> print(a_tuple[4])\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nIndexError: tuple index out of range\n```\n\n**错误分析**：`a_tuple` 的合法下标是 0, 1, 2 （或者 -1, -2, -3），4 超出下标范围',KeyError:'#### 什么是 `KeyError` ?\n\n使用不存在的键访问字典中的元素\n\n* 示例代码\n\n```python\n>>> student = {"name": "Allen", "age": 16}\n>>> print(student["major"])\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nKeyError: \'major\'\n```\n\n**错误分析**：`"major"` 不是 `student`  中的键（key）',ModuleNotFoundError:"#### 什么是 `ModuleNotFoundError` ?\n\n导入未安装的第三方库\n\n* 示例代码\n\n```python\n>>> import pandas\nTraceback (most recent call last):\n  File \"<stdin>\", line 1, in <module>\nModuleNotFoundError: No module named 'pandas'\n```\n\n**错误分析**：尝试导入 `pandas` ，但实际上未安装这个库，需要先完成安装才能使用",ValueError:'#### 什么是 `ValueError` ?\n\n类型正确但是值不合适\n\n* 示例代码\n\n```python\n>>> import math\n>>> math.log(-1)\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nValueError: math domain error\n```\n\n**错误分析**：对于取对数函数 `log`，传入 `-1`，参数类型正确，但是不合法，因为参数需要是正数\n\n* 示例代码\n\n```python\n>>> int("123")\n123\n>>> int("123.0")\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nValueError: invalid literal for int() with base 10: \'123.0\'\n```\n\n**错误分析**：`int` 函数用于将字符串转换为整数，传入 `"123"` 可以完成转换，但传入 `"123.0"` 无法完成转换',ZeroDivisionError:'#### 什么是 `ZeroDivisionError` ?\n\n除数为 0\n\n* 示例代码\n\n```python\n>>> print(1 / 0)\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nZeroDivisionError: division by zero\n```\n\n**错误分析**：除法运算的除数不能为 0',FileNotFoundError:'##### 什么是 `FileNotFoundError` ?\n\n访问不存在的文件或目录\n\n* 示例代码\n\n```python\n>>> file = open("a.txt")\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nFileNotFoundError: [Errno 2] No such file or directory: \'a.txt\'\n```\n\n**错误分析**：当前目录下不存在文件 a.txt\n\n* 示例代码\n\n```python\n>>> import os\n>>> print(os.listdir("."))  # 列出当前目录的全部文件和目录\n[]\n>>> print(os.listdir("./tmp"))\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nFileNotFoundError: [Errno 2] No such file or directory: \'./tmp\'\n```\n\n**错误分析**：尝试列出 ./tmp（即当前目录下的 tmp 目录）中的全部文件和目录，然而当前目录下并不存在 tmp 目录',FileExistsError:'#### 什么是 `FileExistsError` ?\n\n文件或目录已存在\n\n* 示例代码\n\n```python\n>>> import os\n>>> print(os.listdir("."))\n[]\n>>> os.mkdir("./tmp")  # 在当前目录下创建tmp目录\n>>> print(os.listdir("."))\n[\'tmp\']\n>>> os.mkdir("./tmp")  # 再次创建tmp目录\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nFileExistsError: [Errno 17] File exists: \'./tmp\'\n```\n\n**错误分析**：在 ./tmp 目录存在的情况下，尝试创建 ./tmp 目录'},n.extractErrorMessage=function(e){if("error"!==e.output_type)throw Error("output must be error");return e.ename&&n.ERROR_INFO_MAP[e.ename]?{type:e.ename,explain:n.ERROR_INFO_MAP[e.ename]}:null}},419:function(e,n,t){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,n,t,r){void 0===r&&(r=t),Object.defineProperty(e,r,{enumerable:!0,get:function(){return n[t]}})}:function(e,n,t,r){void 0===r&&(r=t),e[r]=n[t]}),o=this&&this.__exportStar||function(e,n){for(var t in e)"default"===t||n.hasOwnProperty(t)||r(n,e,t)};Object.defineProperty(n,"__esModule",{value:!0}),o(t(498),n),o(t(830),n),o(t(393),n),o(t(549),n);var i=t(781);Object.defineProperty(n,"download",{enumerable:!0,get:function(){return i.default}})},970:(e,n)=>{"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.parseOJProblemIdsFromVerify=n.fixOverwrittenChars=n.autoLinkUrls=n.ansispan=void 0;var t=["ansi-black","ansi-red","ansi-green","ansi-yellow","ansi-blue","ansi-magenta","ansi-cyan","ansi-white","ansi-black-intense","ansi-red-intense","ansi-green-intense","ansi-yellow-intense","ansi-blue-intense","ansi-magenta-intense","ansi-cyan-intense","ansi-white-intense"];function r(e,n,r,o,i,a,l,c){var u;if(e){if(c)return void l.push(e);var s=[],f=[];o&&"number"==typeof n&&0<=n&&n<8&&(n+=8),a&&(n=(u=[r,n])[0],r=u[1]),"number"==typeof n?s.push(t[n]+"-fg"):n.length?f.push("color: rgb("+n+")"):a&&s.push("ansi-default-inverse-fg"),"number"==typeof r?s.push(t[r]+"-bg"):r.length?f.push("background-color: rgb("+r+")"):a&&s.push("ansi-default-inverse-bg"),o&&s.push("ansi-bold"),i&&s.push("ansi-underline"),s.length||f.length?(l.push("<span"),s.length&&l.push(' class="'+s.join(" ")+'"'),f.length&&l.push(' style="'+f.join("; ")+'"'),l.push(">"),l.push(e),l.push("</span>")):l.push(e)}}function o(e){var n,t,r,o=e.shift();if(2===o&&e.length>=3){if([n=e.shift(),t=e.shift(),r=e.shift()].some((function(e){return e<0||255<e})))throw new RangeError("Invalid range for RGB colors")}else{if(!(5===o&&e.length>=1))throw new RangeError("Invalid extended color specification");var i=e.shift();if(i<0)throw new RangeError("Color index must be >= 0");if(i<16)return i;if(i<232)n=(n=Math.floor((i-16)/36))>0?55+40*n:0,t=(t=Math.floor((i-16)%36/6))>0?55+40*t:0,r=(r=(i-16)%6)>0?55+40*r:0;else{if(!(i<256))throw new RangeError("Color index must be < 256");n=t=r=10*(i-232)+8}}return[n,t,r]}n.ansispan=function(e,n){void 0===n&&(n=!1);var t,i=/\x1b\[(.*?)([@-~])/g,a=[],l=[],c=!1,u=!1,s=!1,f=[],d=[],p=0;for(e+="[m";t=i.exec(e);){if("m"===t[2])for(var h=t[1].split(";"),v=0;v<h.length;v++){var g=h[v];if(""===g)d.push(0);else{if(-1===g.search(/^\d+$/)){d.length=0;break}d.push(parseInt(g))}}for(r(e.substring(p,t.index),a,l,c,u,s,f,n),p=i.lastIndex;d.length;){var m=d.shift();switch(m){case 0:a=l=[],c=!1,u=!1,s=!1;break;case 1:case 5:c=!0;break;case 4:u=!0;break;case 7:s=!0;break;case 21:case 22:c=!1;break;case 24:u=!1;break;case 27:s=!1;break;case 30:case 31:case 32:case 33:case 34:case 35:case 36:case 37:a=m-30;break;case 38:try{a=o(d)}catch(e){d.length=0}break;case 39:a=[];break;case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:l=m-40;break;case 48:try{l=o(d)}catch(e){d.length=0}break;case 49:l=[];break;case 90:case 91:case 92:case 93:case 94:case 95:case 96:case 97:a=m-90+8;break;case 100:case 101:case 102:case 103:case 104:case 105:case 106:case 107:l=m-100+8}}}return f.join("")},n.autoLinkUrls=function(e){return e.replace(/(^|\s)(https?|ftp)(:[^'"<>\s]+)/gi,'$1<a target="_blank" href="$2$3">$2$3</a>')},n.fixOverwrittenChars=function(e){return function(e){for(e=e.replace(/\r+\n/gm,"\n");e.search(/\r[^$]/g)>-1;){var n=e.match(/^(.*)\r+/m)[1],t=e.match(/\r+(.*)$/m)[1];t+=n.slice(t.length,n.length),e=e.replace(/\r+.*$/m,"\r").replace(/^.*\r/m,t)}return e}(function(e){var n=e;do{n=(e=n).replace(/[^\n]\x08/gm,"")}while(n.length<e.length);return e}(e))},n.parseOJProblemIdsFromVerify=function(e){var n=/ONLINE_JUDGE_PROBLEM_ID=([^;]*)/.exec(e),t=/ONLINE_JUDGE_PROBLEM_REAL_ID=([^;]*)/.exec(e);return!n&&!t||!(null==n?void 0:n[1])&&!(null==t?void 0:t[1])?[void 0,void 0]:[null==n?void 0:n[1],null==t?void 0:t[1]]}},498:(e,n)=>{"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.codeCellStringify=n.parseCodeCell=void 0,n.parseCodeCell=function(e){var n="string"==typeof e?e:e.join("");return n=n.replace(/^\/\/\s?platform-/g,"# platform-"),/^#\s?platform-edit-answer.*\n/.test(n)?{type:"edit-answer",code:n.replace(/^#\s?platform-edit-answer.*\n{1,2}/,"")}:/^#\s?platform-edit.*\n/.test(n)?{type:"edit",code:n.replace(/^#\s?platform-edit.*\n{1,2}/,"")}:/^#\s?platform-lock-hidden.*\n/.test(n)?{type:"lock-hidden",code:n.replace(/^#\s?platform-lock-hidden.*\n{1,2}/,"")}:/^#\s?platform-lock.*\n/.test(n)?{type:"lock",code:n.replace(/^#\s?platform-lock.*\n{1,2}/,"")}:/^#\s?platform-verify.*\n/.test(n)?{type:"verify",code:n.replace(/^#\s?platform-verify.*\n{1,2}/,"")}:/^#\s?platform-desc.*\n/.test(n)?{type:"desc",code:n.replace(/^#\s?platform-desc.*\n{1,2}/,"")}:/^#\s?platform-quiz.*\n/.test(n)?{type:"quiz",code:n.replace(/^#\s?platform-quiz.*\n{1,2}/,"")}:/^#\s?platform-blank-answer.*\n/.test(n)?{type:"blank-answer",code:n.replace(/^#\s?platform-blank-answer.*\n{1,2}/,"")}:/^#\s?platform-blank.*\n/.test(n)?{type:"blank",code:n.replace(/^#\s?platform-blank.*\n{1,2}/,"")}:{type:null,code:n}},n.codeCellStringify=function(e,n){void 0===n&&(n="#");var t=e.type,r=e.code;if(!t)return r;var o="";return"edit-answer"===t?o="platform-edit-answer":"edit"===t?o="platform-edit":"lock-hidden"===t?o="platform-lock-hidden":"lock"===t?o="platform-lock":"verify"===t?o="platform-verify":"desc"===t?o="platform-desc":"quiz"===t?o="platform-quiz":"blank-answer"===t?o="platform-blank-answer":"blank"===t&&(o="platform-blank"),n+" "+o+"\n\n"+r}},830:function(e,n,t){"use strict";var r,o=this&&this.__extends||(r=function(e,n){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,n){e.__proto__=n}||function(e,n){for(var t in n)n.hasOwnProperty(t)&&(e[t]=n[t])})(e,n)},function(e,n){function t(){this.constructor=e}r(e,n),e.prototype=null===n?Object.create(n):(t.prototype=n.prototype,new t)}),i=this&&this.__assign||function(){return(i=Object.assign||function(e){for(var n,t=1,r=arguments.length;t<r;t++)for(var o in n=arguments[t])Object.prototype.hasOwnProperty.call(n,o)&&(e[o]=n[o]);return e}).apply(this,arguments)};Object.defineProperty(n,"__esModule",{value:!0}),n.trimOutputs=n.parseStepsFromCells=n.ParseJupyterCellException=void 0;var a=t(498),l=t(270),c=t(970),u=function(e){function n(){var n=null!==e&&e.apply(this,arguments)||this;return n.isParseJupyterCellError=!0,n}return o(n,e),n}(Error);function s(e,t,r,o,i,a){var u=n.trimOutputs(e),s={result:!1},d=!1,p=!1;if("v1"===r.version)if(r.codeCells.some((function(e){return e[t]&&e[t].some((function(n){var t;return(d="error"===n.output_type)&&(s.result=!1,s.text="代码执行出错",s.errorExplainInfo=l.extractErrorMessage(n),s.errorMessage=c.ansispan(null===(t=n.traceback)||void 0===t?void 0:t.join("\n"),!0)),"verify"===e.$codeType&&(p=!0),d}))})),s.hasError=d,s.verifyCellError=p,!i&&o)s.result=!1;else if(!d)if(a&&a.outputs.length)try{var h=JSON.parse(a.outputs[a.outputs.length-1].text);s.result=h.result,s.text=h.displayResult}catch(e){try{var v=a.outputs[a.outputs.length-1].text.trim().split("\n");h=JSON.parse(v[v.length-1]),s.result=h.result,s.text=h.displayResult}catch(e){s.result=!1,s.text="验证函数执行出错"}}else if(r.verify){s.verifyType="verify",s.output=u.join("");var g=/ONLINE_JUDGE_RESULT=([^;]*)/.exec(s.output);if(g&&g[1]){var m=/ONLINE_JUDGE_SUBMISSION_ID=([^;]*)/.exec(s.output);m&&(s.submissionId=m[1]);var y=/ONLINE_JUDGE_STATUS=([^;]*)/.exec(s.output),x=y?y[1]:"WAITING";s.result="SUCCESS"===x;var b=/ONLINE_JUDGE_OUTPUTS=([^;]*)/.exec(s.output);b&&b[1]&&(s.ojOutputs=JSON.parse(b[1])),s.output=Number(g[1]),s.isOnlineJudge=!0}else{var _=n.trimOutputs([r.verify]).join("");s.result=f(s.output,_)}}else s.verifyType="empty",s.output=null==u?void 0:u.join(""),s.result=(null==u?void 0:u.length)>0;return s}n.ParseJupyterCellException=u,n.parseStepsFromCells=function(e,t,r){var o=[],l=-1,c=-1;e.cells.map((function(e){var n;return Array.isArray(e.source)?i(i({},e),{source:null===(n=null==e?void 0:e.source)||void 0===n?void 0:n.join("")}):e})).map((function(e){if(e.outputs){var n=e.outputs.map((function(e){return i(i({},e),{text:Array.isArray(e.text)?e.text.join(""):e.text})}));return i(i({},e),{outputs:n})}return e})).forEach((function(e,n){if("markdown"===e.cell_type&&/^###[^#]+/.test(e.source)){l++;var t=e.metadata;o[l]={version:"v1",metadata:t,$index:l,title:e.source.replace(/###\s*/,""),codeCells:[],codeAnswerCells:[],mdCells:[],descCodeCells:[]}}else if(-1!==l){var r=o[l];if(!r)throw new u("未知错误："+l+"的步骤不存在");if("v1"===r.version)if("markdown"===e.cell_type)r.mdCells.push(i(i({},e),{$cellIndex:n}));else if("code"===e.cell_type){var s=a.parseCodeCell(e.source),f=s.type,d=s.code;if(!f){var p=new u("错误的code cell格式");throw p.cellIndex=n,p}if("desc"===f)r.descCodeCells.push(i(i({},e),{$codeType:f,$code:d,$cellIndex:n}));else if("quiz"===f)r.quizCell=i(i({},e),{$codeType:f,$code:d,$cellIndex:n}),e.metadata.quizLog&&(r.quizLog=e.metadata.quizLog);else if("edit-answer"===f||"blank-answer"===f)r.codeAnswerCells.push(i(i({},e),{$codeType:f,$code:d,$cellIndex:n}));else{var h=i(i({},e),{$codeType:f,$code:d,$cellIndex:n,$codeIndex:"verify"===f?-1:++c});e.metadata.inputs&&(h.$inputs=e.metadata.inputs),r.codeCells.push(h)}}}})),(o=o.map((function(e){if("v1"===e.version){var n=e.codeCells.length&&e.codeCells[0].$cellIndex||0,t=e.codeCells.length&&e.codeCells[e.codeCells.length-1].$cellIndex||0,r=e.mdCells[0]?e.mdCells[0].source:"",o="",a=e.descCodeCells.find((function(e){return e.$code&&e.$code.indexOf("Player")>=0}));if(a){var l=/vid='(\w*)'/.exec(a.$code);l&&(o=l[1])}var c=e.mdCells.filter((function(e){return e.$cellIndex>n&&e.$cellIndex<t})),u=e.mdCells.find((function(e){return e.$cellIndex>t})),s=(null==u?void 0:u.source)||"";return i(i({},e),{desc:r,video:o,mdCells:c,verify:s,isOnlineJudge:/ONLINE_JUDGE_PROBLEM_ID=([^;]*)/.test(s)||/ONLINE_JUDGE_PROBLEM_REAL_ID=([^;]*)/.test(s)})}return e}))).forEach((function(e){if("v1"===e.version){var n;if(e.codeAnswerCells.length>e.codeCells.length)throw(n=new u("参考答案数量不能多于代码框数量")).stepIndex=e.$index,n;if(e.quizCell&&e.codeCells.length)throw(n=new u("步骤中不能同时包含quiz和代码")).stepIndex=e.$index,n;if(!e.quizCell&&!e.codeCells.length)throw(n=new u("步骤中需要包含quiz或代码")).stepIndex=e.$index,n;if(!e.title.length)throw(n=new u("步骤标题必须指定")).stepIndex=e.$index,n}}));var f=!1;if(!(o=o.map((function(e,o){var a,l,c,u;if("v1"===e.version){var d=e.codeCells.filter((function(e){return"verify"!==e.$codeType})),p=e.codeCells.find((function(e){return"verify"===e.$codeType})),h=null===(l=null===(a=d[d.length-1])||void 0===a?void 0:a.outputs)||void 0===l?void 0:l.filter((function(e){return"stdout"===e.name&&null!=e.text})).map((function(e){return e.text})),v=null===(u=null===(c=d[d.length-1])||void 0===c?void 0:c.$dryrunOutputs)||void 0===u?void 0:u.filter((function(e){return"stdout"===e.name&&null!=e.text})).map((function(e){return e.text})),g=s(h,"outputs",e,f,t,p),m=null==r?void 0:r[o],y=s(v||[],"$dryrunOutputs",i(i({},e),{verify:n.trimOutputs([null==m?void 0:m.dryrunOutput]).join("")}),!1);return e.quizCell&&e.quizLog&&e.quizLog.content&&(g.result=!0,g.verifyType="quiz"),e.quizCell||g.result||(f=!0),i(i({},e),{normalCodes:d,verifyCode:p,verifyResult:g,$dryrunVerifyResult:y,stepType:e.quizCell?"quiz":"code"})}return e}))).length)throw new u("至少需要包含一个步骤");return o},n.trimOutputs=function(e){if(!Array.isArray(e)||0===(null==e?void 0:e.length))return[];var n=e.filter((function(e){return"string"==typeof e})).join("").split("\n");if(!n.length)return[];String.prototype.trimEnd||(String.prototype.trimEnd=function(){return this.replace(new RegExp(/[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]+/.source+"$","g"),"")});var t=n.reverse().findIndex((function(e){return e&&e.trimEnd()})),r=n.slice(t).reverse();return r.map((function(e,n){return n===r.length-1?e.trimEnd():e.trimEnd()+"\n"}))};var f=function(e,n){return!(!e||!n)&&e===n}},966:function(e,n,t){"use strict";var r,o=this&&this.__extends||(r=function(e,n){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,n){e.__proto__=n}||function(e,n){for(var t in n)n.hasOwnProperty(t)&&(e[t]=n[t])})(e,n)},function(e,n){function t(){this.constructor=e}r(e,n),e.prototype=null===n?Object.create(n):(t.prototype=n.prototype,new t)}),i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.parseQuizOptionSlots=n.markQuizOptionSlots=n.RelParseError=n.getQuizAnswersFromCell=n.getCodeFromCell=n.getMaterials=void 0;var a=i(t(59)),l=t(498),c=t(830);n.getMaterials=function(e){var n={};return e.cells.forEach((function(e){var t=e.metadata.bxyPosterSlotId;t&&(n[t]=e)})),c.parseStepsFromCells(e).forEach((function(e){var t,r,o=null===(r=null===(t=e.quizCell)||void 0===t?void 0:t.metadata.bxyQuizStep)||void 0===r?void 0:r.options;o&&Object.values(o).forEach((function(t){t.posterSlotId&&(n[t.posterSlotId]=e.quizCell)}))})),n},n.getCodeFromCell=function(e){return e&&e.source?l.parseCodeCell(e.source).code.split("\n").filter((function(e){return e.indexOf("!blank-answer:")<0})).join("\n").trim():""},n.getQuizAnswersFromCell=function(e,n){var t;if(!e||!e.metadata.quizLog||!e.metadata.quizLog.content)return[];var r,o=null===(t=e.metadata.bxyQuizStep)||void 0===t?void 0:t.options;return o?(Object.entries(o).forEach((function(e){var t=e[0];e[1].posterSlotId===n&&(r=t)})),r?e.metadata.quizLog.content[r]:[]):[]};var u=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return o(n,e),n}(Error);n.RelParseError=u,n.markQuizOptionSlots=function(e,n){for(var t={},r=0,o=n.replaceAll("，",",").split(",").map((function(e){return e.trim()})).filter(Boolean);r<o.length;r++){var i=o[r],l=i.indexOf(":");if(l<=0||l>=i.length-1)throw new u("格式错误："+i);var c=i.slice(0,l).trim(),s=i.slice(l+1).trim();t[c]=s}var f=a.default.cloneDeep(e);return f.bxyQuizStep||(f.bxyQuizStep={options:{}}),f.bxyQuizStep.options||(f.bxyQuizStep.options={}),Object.values(f.bxyQuizStep.options).forEach((function(e){delete e.posterSlotId})),Object.entries(t).forEach((function(e){var n=e[0],t=e[1];f.bxyQuizStep.options[n]||(f.bxyQuizStep.options[n]={}),f.bxyQuizStep.options[n].posterSlotId=t})),f},n.parseQuizOptionSlots=function(e){var n,t="";return(null===(n=e.bxyQuizStep)||void 0===n?void 0:n.options)&&Object.entries(e.bxyQuizStep.options).forEach((function(e){var n=e[0],r=e[1];r.posterSlotId&&(t+=n+":"+r.posterSlotId+", ")})),t.endsWith(", ")&&(t=t.slice(0,t.length-2)),t}},471:(e,n)=>{"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.parseQuestionOptions=void 0,n.parseQuestionOptions=function(e){var n=[];return e?(Object.entries(e).forEach((function(e){var t=e[0],r=e[1];t.startsWith("option")&&"string"==typeof r&&n.push({value:t.charAt(t.length-1),text:r})})),n):n}},393:(e,n)=>{"use strict";Object.defineProperty(n,"__esModule",{value:!0})},549:function(e,n){"use strict";var t,r=this&&this.__awaiter||function(e,n,t,r){return new(t||(t=Promise))((function(o,i){function a(e){try{c(r.next(e))}catch(e){i(e)}}function l(e){try{c(r.throw(e))}catch(e){i(e)}}function c(e){var n;e.done?o(e.value):(n=e.value,n instanceof t?n:new t((function(e){e(n)}))).then(a,l)}c((r=r.apply(e,n||[])).next())}))},o=this&&this.__generator||function(e,n){var t,r,o,i,a={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return i={next:l(0),throw:l(1),return:l(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function l(i){return function(l){return function(i){if(t)throw new TypeError("Generator is already executing.");for(;a;)try{if(t=1,r&&(o=2&i[0]?r.return:i[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,i[1])).done)return o;switch(r=0,o&&(i=[2&i[0],o.value]),i[0]){case 0:case 1:o=i;break;case 4:return a.label++,{value:i[1],done:!1};case 5:a.label++,r=i[1],i=[0];continue;case 7:i=a.ops.pop(),a.trys.pop();continue;default:if(!((o=(o=a.trys).length>0&&o[o.length-1])||6!==i[0]&&2!==i[0])){a=0;continue}if(3===i[0]&&(!o||i[1]>o[0]&&i[1]<o[3])){a.label=i[1];break}if(6===i[0]&&a.label<o[1]){a.label=o[1],o=i;break}if(o&&a.label<o[2]){a.label=o[2],a.ops.push(i);break}o[2]&&a.ops.pop(),a.trys.pop();continue}i=n.call(e,a)}catch(e){i=[6,e],r=0}finally{t=o=0}if(5&i[0])throw i[1];return{value:i[0]?i[1]:void 0,done:!0}}([i,l])}}};Object.defineProperty(n,"__esModule",{value:!0}),n.validateStepPoints=void 0,function(e){e.FILL="FILL",e.SELECT="SELECT"}(t||(t={})),n.validateStepPoints=function(e){return e.steps,e.quizParser,r(this,void 0,void 0,(function(){return o(this,(function(e){return[2,{passed:!0}]}))}))}},352:e=>{"use strict";e.exports=function(e){var n=[];return n.toString=function(){return this.map((function(n){var t=function(e,n){var t,r,o,i=e[1]||"",a=e[3];if(!a)return i;if(n&&"function"==typeof btoa){var l=(t=a,r=btoa(unescape(encodeURIComponent(JSON.stringify(t)))),o="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(r),"/*# ".concat(o," */")),c=a.sources.map((function(e){return"/*# sourceURL=".concat(a.sourceRoot||"").concat(e," */")}));return[i].concat(c).concat([l]).join("\n")}return[i].join("\n")}(n,e);return n[2]?"@media ".concat(n[2]," {").concat(t,"}"):t})).join("")},n.i=function(e,t,r){"string"==typeof e&&(e=[[null,e,""]]);var o={};if(r)for(var i=0;i<this.length;i++){var a=this[i][0];null!=a&&(o[a]=!0)}for(var l=0;l<e.length;l++){var c=[].concat(e[l]);r&&o[c[0]]||(t&&(c[2]?c[2]="".concat(t," and ").concat(c[2]):c[2]=t),n.push(c))}},n}},59:function(e,n,t){var r;e=t.nmd(e),function(){var o,i="Expected a function",a="__lodash_hash_undefined__",l="__lodash_placeholder__",c=32,u=128,s=1/0,f=9007199254740991,d=NaN,p=4294967295,h=[["ary",u],["bind",1],["bindKey",2],["curry",8],["curryRight",16],["flip",512],["partial",c],["partialRight",64],["rearg",256]],v="[object Arguments]",g="[object Array]",m="[object Boolean]",y="[object Date]",x="[object Error]",b="[object Function]",_="[object GeneratorFunction]",w="[object Map]",k="[object Number]",C="[object Object]",A="[object Promise]",M="[object RegExp]",z="[object Set]",L="[object String]",S="[object Symbol]",I="[object WeakMap]",P="[object ArrayBuffer]",E="[object DataView]",O="[object Float32Array]",B="[object Float64Array]",j="[object Int8Array]",T="[object Int16Array]",R="[object Int32Array]",N="[object Uint8Array]",W="[object Uint8ClampedArray]",D="[object Uint16Array]",U="[object Uint32Array]",$=/\b__p \+= '';/g,F=/\b(__p \+=) '' \+/g,Q=/(__e\(.*?\)|\b__t\)) \+\n'';/g,q=/&(?:amp|lt|gt|quot|#39);/g,H=/[&<>"']/g,V=RegExp(q.source),G=RegExp(H.source),J=/<%-([\s\S]+?)%>/g,Z=/<%([\s\S]+?)%>/g,K=/<%=([\s\S]+?)%>/g,Y=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,X=/^\w*$/,ee=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,ne=/[\\^$.*+?()[\]{}|]/g,te=RegExp(ne.source),re=/^\s+/,oe=/\s/,ie=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,ae=/\{\n\/\* \[wrapped with (.+)\] \*/,le=/,? & /,ce=/[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g,ue=/[()=,{}\[\]\/\s]/,se=/\\(\\)?/g,fe=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,de=/\w*$/,pe=/^[-+]0x[0-9a-f]+$/i,he=/^0b[01]+$/i,ve=/^\[object .+?Constructor\]$/,ge=/^0o[0-7]+$/i,me=/^(?:0|[1-9]\d*)$/,ye=/[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g,xe=/($^)/,be=/['\n\r\u2028\u2029\\]/g,_e="\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff",we="a-z\\xdf-\\xf6\\xf8-\\xff",ke="A-Z\\xc0-\\xd6\\xd8-\\xde",Ce="\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2000-\\u206f \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",Ae="["+Ce+"]",Me="["+_e+"]",ze="\\d+",Le="["+we+"]",Se="[^\\ud800-\\udfff"+Ce+ze+"\\u2700-\\u27bf"+we+ke+"]",Ie="\\ud83c[\\udffb-\\udfff]",Pe="[^\\ud800-\\udfff]",Ee="(?:\\ud83c[\\udde6-\\uddff]){2}",Oe="[\\ud800-\\udbff][\\udc00-\\udfff]",Be="["+ke+"]",je="(?:"+Le+"|"+Se+")",Te="(?:"+Be+"|"+Se+")",Re="(?:['’](?:d|ll|m|re|s|t|ve))?",Ne="(?:['’](?:D|LL|M|RE|S|T|VE))?",We="(?:"+Me+"|"+Ie+")?",De="[\\ufe0e\\ufe0f]?",Ue=De+We+"(?:\\u200d(?:"+[Pe,Ee,Oe].join("|")+")"+De+We+")*",$e="(?:"+["[\\u2700-\\u27bf]",Ee,Oe].join("|")+")"+Ue,Fe="(?:"+[Pe+Me+"?",Me,Ee,Oe,"[\\ud800-\\udfff]"].join("|")+")",Qe=RegExp("['’]","g"),qe=RegExp(Me,"g"),He=RegExp(Ie+"(?="+Ie+")|"+Fe+Ue,"g"),Ve=RegExp([Be+"?"+Le+"+"+Re+"(?="+[Ae,Be,"$"].join("|")+")",Te+"+"+Ne+"(?="+[Ae,Be+je,"$"].join("|")+")",Be+"?"+je+"+"+Re,Be+"+"+Ne,"\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])","\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",ze,$e].join("|"),"g"),Ge=RegExp("[\\u200d\\ud800-\\udfff"+_e+"\\ufe0e\\ufe0f]"),Je=/[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,Ze=["Array","Buffer","DataView","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Map","Math","Object","Promise","RegExp","Set","String","Symbol","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","_","clearTimeout","isFinite","parseInt","setTimeout"],Ke=-1,Ye={};Ye[O]=Ye[B]=Ye[j]=Ye[T]=Ye[R]=Ye[N]=Ye[W]=Ye[D]=Ye[U]=!0,Ye[v]=Ye[g]=Ye[P]=Ye[m]=Ye[E]=Ye[y]=Ye[x]=Ye[b]=Ye[w]=Ye[k]=Ye[C]=Ye[M]=Ye[z]=Ye[L]=Ye[I]=!1;var Xe={};Xe[v]=Xe[g]=Xe[P]=Xe[E]=Xe[m]=Xe[y]=Xe[O]=Xe[B]=Xe[j]=Xe[T]=Xe[R]=Xe[w]=Xe[k]=Xe[C]=Xe[M]=Xe[z]=Xe[L]=Xe[S]=Xe[N]=Xe[W]=Xe[D]=Xe[U]=!0,Xe[x]=Xe[b]=Xe[I]=!1;var en={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"},nn=parseFloat,tn=parseInt,rn="object"==typeof t.g&&t.g&&t.g.Object===Object&&t.g,on="object"==typeof self&&self&&self.Object===Object&&self,an=rn||on||Function("return this")(),ln=n&&!n.nodeType&&n,cn=ln&&e&&!e.nodeType&&e,un=cn&&cn.exports===ln,sn=un&&rn.process,fn=function(){try{return cn&&cn.require&&cn.require("util").types||sn&&sn.binding&&sn.binding("util")}catch(e){}}(),dn=fn&&fn.isArrayBuffer,pn=fn&&fn.isDate,hn=fn&&fn.isMap,vn=fn&&fn.isRegExp,gn=fn&&fn.isSet,mn=fn&&fn.isTypedArray;function yn(e,n,t){switch(t.length){case 0:return e.call(n);case 1:return e.call(n,t[0]);case 2:return e.call(n,t[0],t[1]);case 3:return e.call(n,t[0],t[1],t[2])}return e.apply(n,t)}function xn(e,n,t,r){for(var o=-1,i=null==e?0:e.length;++o<i;){var a=e[o];n(r,a,t(a),e)}return r}function bn(e,n){for(var t=-1,r=null==e?0:e.length;++t<r&&!1!==n(e[t],t,e););return e}function _n(e,n){for(var t=null==e?0:e.length;t--&&!1!==n(e[t],t,e););return e}function wn(e,n){for(var t=-1,r=null==e?0:e.length;++t<r;)if(!n(e[t],t,e))return!1;return!0}function kn(e,n){for(var t=-1,r=null==e?0:e.length,o=0,i=[];++t<r;){var a=e[t];n(a,t,e)&&(i[o++]=a)}return i}function Cn(e,n){return!(null==e||!e.length)&&Bn(e,n,0)>-1}function An(e,n,t){for(var r=-1,o=null==e?0:e.length;++r<o;)if(t(n,e[r]))return!0;return!1}function Mn(e,n){for(var t=-1,r=null==e?0:e.length,o=Array(r);++t<r;)o[t]=n(e[t],t,e);return o}function zn(e,n){for(var t=-1,r=n.length,o=e.length;++t<r;)e[o+t]=n[t];return e}function Ln(e,n,t,r){var o=-1,i=null==e?0:e.length;for(r&&i&&(t=e[++o]);++o<i;)t=n(t,e[o],o,e);return t}function Sn(e,n,t,r){var o=null==e?0:e.length;for(r&&o&&(t=e[--o]);o--;)t=n(t,e[o],o,e);return t}function In(e,n){for(var t=-1,r=null==e?0:e.length;++t<r;)if(n(e[t],t,e))return!0;return!1}var Pn=Nn("length");function En(e,n,t){var r;return t(e,(function(e,t,o){if(n(e,t,o))return r=t,!1})),r}function On(e,n,t,r){for(var o=e.length,i=t+(r?1:-1);r?i--:++i<o;)if(n(e[i],i,e))return i;return-1}function Bn(e,n,t){return n==n?function(e,n,t){for(var r=t-1,o=e.length;++r<o;)if(e[r]===n)return r;return-1}(e,n,t):On(e,Tn,t)}function jn(e,n,t,r){for(var o=t-1,i=e.length;++o<i;)if(r(e[o],n))return o;return-1}function Tn(e){return e!=e}function Rn(e,n){var t=null==e?0:e.length;return t?Un(e,n)/t:d}function Nn(e){return function(n){return null==n?o:n[e]}}function Wn(e){return function(n){return null==e?o:e[n]}}function Dn(e,n,t,r,o){return o(e,(function(e,o,i){t=r?(r=!1,e):n(t,e,o,i)})),t}function Un(e,n){for(var t,r=-1,i=e.length;++r<i;){var a=n(e[r]);a!==o&&(t=t===o?a:t+a)}return t}function $n(e,n){for(var t=-1,r=Array(e);++t<e;)r[t]=n(t);return r}function Fn(e){return e?e.slice(0,lt(e)+1).replace(re,""):e}function Qn(e){return function(n){return e(n)}}function qn(e,n){return Mn(n,(function(n){return e[n]}))}function Hn(e,n){return e.has(n)}function Vn(e,n){for(var t=-1,r=e.length;++t<r&&Bn(n,e[t],0)>-1;);return t}function Gn(e,n){for(var t=e.length;t--&&Bn(n,e[t],0)>-1;);return t}function Jn(e,n){for(var t=e.length,r=0;t--;)e[t]===n&&++r;return r}var Zn=Wn({À:"A",Á:"A",Â:"A",Ã:"A",Ä:"A",Å:"A",à:"a",á:"a",â:"a",ã:"a",ä:"a",å:"a",Ç:"C",ç:"c",Ð:"D",ð:"d",È:"E",É:"E",Ê:"E",Ë:"E",è:"e",é:"e",ê:"e",ë:"e",Ì:"I",Í:"I",Î:"I",Ï:"I",ì:"i",í:"i",î:"i",ï:"i",Ñ:"N",ñ:"n",Ò:"O",Ó:"O",Ô:"O",Õ:"O",Ö:"O",Ø:"O",ò:"o",ó:"o",ô:"o",õ:"o",ö:"o",ø:"o",Ù:"U",Ú:"U",Û:"U",Ü:"U",ù:"u",ú:"u",û:"u",ü:"u",Ý:"Y",ý:"y",ÿ:"y",Æ:"Ae",æ:"ae",Þ:"Th",þ:"th",ß:"ss",Ā:"A",Ă:"A",Ą:"A",ā:"a",ă:"a",ą:"a",Ć:"C",Ĉ:"C",Ċ:"C",Č:"C",ć:"c",ĉ:"c",ċ:"c",č:"c",Ď:"D",Đ:"D",ď:"d",đ:"d",Ē:"E",Ĕ:"E",Ė:"E",Ę:"E",Ě:"E",ē:"e",ĕ:"e",ė:"e",ę:"e",ě:"e",Ĝ:"G",Ğ:"G",Ġ:"G",Ģ:"G",ĝ:"g",ğ:"g",ġ:"g",ģ:"g",Ĥ:"H",Ħ:"H",ĥ:"h",ħ:"h",Ĩ:"I",Ī:"I",Ĭ:"I",Į:"I",İ:"I",ĩ:"i",ī:"i",ĭ:"i",į:"i",ı:"i",Ĵ:"J",ĵ:"j",Ķ:"K",ķ:"k",ĸ:"k",Ĺ:"L",Ļ:"L",Ľ:"L",Ŀ:"L",Ł:"L",ĺ:"l",ļ:"l",ľ:"l",ŀ:"l",ł:"l",Ń:"N",Ņ:"N",Ň:"N",Ŋ:"N",ń:"n",ņ:"n",ň:"n",ŋ:"n",Ō:"O",Ŏ:"O",Ő:"O",ō:"o",ŏ:"o",ő:"o",Ŕ:"R",Ŗ:"R",Ř:"R",ŕ:"r",ŗ:"r",ř:"r",Ś:"S",Ŝ:"S",Ş:"S",Š:"S",ś:"s",ŝ:"s",ş:"s",š:"s",Ţ:"T",Ť:"T",Ŧ:"T",ţ:"t",ť:"t",ŧ:"t",Ũ:"U",Ū:"U",Ŭ:"U",Ů:"U",Ű:"U",Ų:"U",ũ:"u",ū:"u",ŭ:"u",ů:"u",ű:"u",ų:"u",Ŵ:"W",ŵ:"w",Ŷ:"Y",ŷ:"y",Ÿ:"Y",Ź:"Z",Ż:"Z",Ž:"Z",ź:"z",ż:"z",ž:"z",Ĳ:"IJ",ĳ:"ij",Œ:"Oe",œ:"oe",ŉ:"'n",ſ:"s"}),Kn=Wn({"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"});function Yn(e){return"\\"+en[e]}function Xn(e){return Ge.test(e)}function et(e){var n=-1,t=Array(e.size);return e.forEach((function(e,r){t[++n]=[r,e]})),t}function nt(e,n){return function(t){return e(n(t))}}function tt(e,n){for(var t=-1,r=e.length,o=0,i=[];++t<r;){var a=e[t];a!==n&&a!==l||(e[t]=l,i[o++]=t)}return i}function rt(e){var n=-1,t=Array(e.size);return e.forEach((function(e){t[++n]=e})),t}function ot(e){var n=-1,t=Array(e.size);return e.forEach((function(e){t[++n]=[e,e]})),t}function it(e){return Xn(e)?function(e){for(var n=He.lastIndex=0;He.test(e);)++n;return n}(e):Pn(e)}function at(e){return Xn(e)?function(e){return e.match(He)||[]}(e):function(e){return e.split("")}(e)}function lt(e){for(var n=e.length;n--&&oe.test(e.charAt(n)););return n}var ct=Wn({"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'"}),ut=function e(n){var t,r=(n=null==n?an:ut.defaults(an.Object(),n,ut.pick(an,Ze))).Array,oe=n.Date,_e=n.Error,we=n.Function,ke=n.Math,Ce=n.Object,Ae=n.RegExp,Me=n.String,ze=n.TypeError,Le=r.prototype,Se=we.prototype,Ie=Ce.prototype,Pe=n["__core-js_shared__"],Ee=Se.toString,Oe=Ie.hasOwnProperty,Be=0,je=(t=/[^.]+$/.exec(Pe&&Pe.keys&&Pe.keys.IE_PROTO||""))?"Symbol(src)_1."+t:"",Te=Ie.toString,Re=Ee.call(Ce),Ne=an._,We=Ae("^"+Ee.call(Oe).replace(ne,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),De=un?n.Buffer:o,Ue=n.Symbol,$e=n.Uint8Array,Fe=De?De.allocUnsafe:o,He=nt(Ce.getPrototypeOf,Ce),Ge=Ce.create,en=Ie.propertyIsEnumerable,rn=Le.splice,on=Ue?Ue.isConcatSpreadable:o,ln=Ue?Ue.iterator:o,cn=Ue?Ue.toStringTag:o,sn=function(){try{var e=si(Ce,"defineProperty");return e({},"",{}),e}catch(e){}}(),fn=n.clearTimeout!==an.clearTimeout&&n.clearTimeout,Pn=oe&&oe.now!==an.Date.now&&oe.now,Wn=n.setTimeout!==an.setTimeout&&n.setTimeout,st=ke.ceil,ft=ke.floor,dt=Ce.getOwnPropertySymbols,pt=De?De.isBuffer:o,ht=n.isFinite,vt=Le.join,gt=nt(Ce.keys,Ce),mt=ke.max,yt=ke.min,xt=oe.now,bt=n.parseInt,_t=ke.random,wt=Le.reverse,kt=si(n,"DataView"),Ct=si(n,"Map"),At=si(n,"Promise"),Mt=si(n,"Set"),zt=si(n,"WeakMap"),Lt=si(Ce,"create"),St=zt&&new zt,It={},Pt=Wi(kt),Et=Wi(Ct),Ot=Wi(At),Bt=Wi(Mt),jt=Wi(zt),Tt=Ue?Ue.prototype:o,Rt=Tt?Tt.valueOf:o,Nt=Tt?Tt.toString:o;function Wt(e){if(tl(e)&&!qa(e)&&!(e instanceof Ft)){if(e instanceof $t)return e;if(Oe.call(e,"__wrapped__"))return Di(e)}return new $t(e)}var Dt=function(){function e(){}return function(n){if(!nl(n))return{};if(Ge)return Ge(n);e.prototype=n;var t=new e;return e.prototype=o,t}}();function Ut(){}function $t(e,n){this.__wrapped__=e,this.__actions__=[],this.__chain__=!!n,this.__index__=0,this.__values__=o}function Ft(e){this.__wrapped__=e,this.__actions__=[],this.__dir__=1,this.__filtered__=!1,this.__iteratees__=[],this.__takeCount__=p,this.__views__=[]}function Qt(e){var n=-1,t=null==e?0:e.length;for(this.clear();++n<t;){var r=e[n];this.set(r[0],r[1])}}function qt(e){var n=-1,t=null==e?0:e.length;for(this.clear();++n<t;){var r=e[n];this.set(r[0],r[1])}}function Ht(e){var n=-1,t=null==e?0:e.length;for(this.clear();++n<t;){var r=e[n];this.set(r[0],r[1])}}function Vt(e){var n=-1,t=null==e?0:e.length;for(this.__data__=new Ht;++n<t;)this.add(e[n])}function Gt(e){var n=this.__data__=new qt(e);this.size=n.size}function Jt(e,n){var t=qa(e),r=!t&&Qa(e),o=!t&&!r&&Ja(e),i=!t&&!r&&!o&&sl(e),a=t||r||o||i,l=a?$n(e.length,Me):[],c=l.length;for(var u in e)!n&&!Oe.call(e,u)||a&&("length"==u||o&&("offset"==u||"parent"==u)||i&&("buffer"==u||"byteLength"==u||"byteOffset"==u)||mi(u,c))||l.push(u);return l}function Zt(e){var n=e.length;return n?e[Hr(0,n-1)]:o}function Kt(e,n){return Bi(Lo(e),ar(n,0,e.length))}function Yt(e){return Bi(Lo(e))}function Xt(e,n,t){(t!==o&&!Ua(e[n],t)||t===o&&!(n in e))&&or(e,n,t)}function er(e,n,t){var r=e[n];Oe.call(e,n)&&Ua(r,t)&&(t!==o||n in e)||or(e,n,t)}function nr(e,n){for(var t=e.length;t--;)if(Ua(e[t][0],n))return t;return-1}function tr(e,n,t,r){return fr(e,(function(e,o,i){n(r,e,t(e),i)})),r}function rr(e,n){return e&&So(n,El(n),e)}function or(e,n,t){"__proto__"==n&&sn?sn(e,n,{configurable:!0,enumerable:!0,value:t,writable:!0}):e[n]=t}function ir(e,n){for(var t=-1,i=n.length,a=r(i),l=null==e;++t<i;)a[t]=l?o:zl(e,n[t]);return a}function ar(e,n,t){return e==e&&(t!==o&&(e=e<=t?e:t),n!==o&&(e=e>=n?e:n)),e}function lr(e,n,t,r,i,a){var l,c=1&n,u=2&n,s=4&n;if(t&&(l=i?t(e,r,i,a):t(e)),l!==o)return l;if(!nl(e))return e;var f=qa(e);if(f){if(l=function(e){var n=e.length,t=new e.constructor(n);return n&&"string"==typeof e[0]&&Oe.call(e,"index")&&(t.index=e.index,t.input=e.input),t}(e),!c)return Lo(e,l)}else{var d=pi(e),p=d==b||d==_;if(Ja(e))return wo(e,c);if(d==C||d==v||p&&!i){if(l=u||p?{}:vi(e),!c)return u?function(e,n){return So(e,di(e),n)}(e,function(e,n){return e&&So(n,Ol(n),e)}(l,e)):function(e,n){return So(e,fi(e),n)}(e,rr(l,e))}else{if(!Xe[d])return i?e:{};l=function(e,n,t){var r,o=e.constructor;switch(n){case P:return ko(e);case m:case y:return new o(+e);case E:return function(e,n){var t=n?ko(e.buffer):e.buffer;return new e.constructor(t,e.byteOffset,e.byteLength)}(e,t);case O:case B:case j:case T:case R:case N:case W:case D:case U:return Co(e,t);case w:return new o;case k:case L:return new o(e);case M:return function(e){var n=new e.constructor(e.source,de.exec(e));return n.lastIndex=e.lastIndex,n}(e);case z:return new o;case S:return r=e,Rt?Ce(Rt.call(r)):{}}}(e,d,c)}}a||(a=new Gt);var h=a.get(e);if(h)return h;a.set(e,l),ll(e)?e.forEach((function(r){l.add(lr(r,n,t,r,e,a))})):rl(e)&&e.forEach((function(r,o){l.set(o,lr(r,n,t,o,e,a))}));var g=f?o:(s?u?ri:ti:u?Ol:El)(e);return bn(g||e,(function(r,o){g&&(r=e[o=r]),er(l,o,lr(r,n,t,o,e,a))})),l}function cr(e,n,t){var r=t.length;if(null==e)return!r;for(e=Ce(e);r--;){var i=t[r],a=n[i],l=e[i];if(l===o&&!(i in e)||!a(l))return!1}return!0}function ur(e,n,t){if("function"!=typeof e)throw new ze(i);return Ii((function(){e.apply(o,t)}),n)}function sr(e,n,t,r){var o=-1,i=Cn,a=!0,l=e.length,c=[],u=n.length;if(!l)return c;t&&(n=Mn(n,Qn(t))),r?(i=An,a=!1):n.length>=200&&(i=Hn,a=!1,n=new Vt(n));e:for(;++o<l;){var s=e[o],f=null==t?s:t(s);if(s=r||0!==s?s:0,a&&f==f){for(var d=u;d--;)if(n[d]===f)continue e;c.push(s)}else i(n,f,r)||c.push(s)}return c}Wt.templateSettings={escape:J,evaluate:Z,interpolate:K,variable:"",imports:{_:Wt}},Wt.prototype=Ut.prototype,Wt.prototype.constructor=Wt,$t.prototype=Dt(Ut.prototype),$t.prototype.constructor=$t,Ft.prototype=Dt(Ut.prototype),Ft.prototype.constructor=Ft,Qt.prototype.clear=function(){this.__data__=Lt?Lt(null):{},this.size=0},Qt.prototype.delete=function(e){var n=this.has(e)&&delete this.__data__[e];return this.size-=n?1:0,n},Qt.prototype.get=function(e){var n=this.__data__;if(Lt){var t=n[e];return t===a?o:t}return Oe.call(n,e)?n[e]:o},Qt.prototype.has=function(e){var n=this.__data__;return Lt?n[e]!==o:Oe.call(n,e)},Qt.prototype.set=function(e,n){var t=this.__data__;return this.size+=this.has(e)?0:1,t[e]=Lt&&n===o?a:n,this},qt.prototype.clear=function(){this.__data__=[],this.size=0},qt.prototype.delete=function(e){var n=this.__data__,t=nr(n,e);return!(t<0||(t==n.length-1?n.pop():rn.call(n,t,1),--this.size,0))},qt.prototype.get=function(e){var n=this.__data__,t=nr(n,e);return t<0?o:n[t][1]},qt.prototype.has=function(e){return nr(this.__data__,e)>-1},qt.prototype.set=function(e,n){var t=this.__data__,r=nr(t,e);return r<0?(++this.size,t.push([e,n])):t[r][1]=n,this},Ht.prototype.clear=function(){this.size=0,this.__data__={hash:new Qt,map:new(Ct||qt),string:new Qt}},Ht.prototype.delete=function(e){var n=ci(this,e).delete(e);return this.size-=n?1:0,n},Ht.prototype.get=function(e){return ci(this,e).get(e)},Ht.prototype.has=function(e){return ci(this,e).has(e)},Ht.prototype.set=function(e,n){var t=ci(this,e),r=t.size;return t.set(e,n),this.size+=t.size==r?0:1,this},Vt.prototype.add=Vt.prototype.push=function(e){return this.__data__.set(e,a),this},Vt.prototype.has=function(e){return this.__data__.has(e)},Gt.prototype.clear=function(){this.__data__=new qt,this.size=0},Gt.prototype.delete=function(e){var n=this.__data__,t=n.delete(e);return this.size=n.size,t},Gt.prototype.get=function(e){return this.__data__.get(e)},Gt.prototype.has=function(e){return this.__data__.has(e)},Gt.prototype.set=function(e,n){var t=this.__data__;if(t instanceof qt){var r=t.__data__;if(!Ct||r.length<199)return r.push([e,n]),this.size=++t.size,this;t=this.__data__=new Ht(r)}return t.set(e,n),this.size=t.size,this};var fr=Eo(xr),dr=Eo(br,!0);function pr(e,n){var t=!0;return fr(e,(function(e,r,o){return t=!!n(e,r,o)})),t}function hr(e,n,t){for(var r=-1,i=e.length;++r<i;){var a=e[r],l=n(a);if(null!=l&&(c===o?l==l&&!ul(l):t(l,c)))var c=l,u=a}return u}function vr(e,n){var t=[];return fr(e,(function(e,r,o){n(e,r,o)&&t.push(e)})),t}function gr(e,n,t,r,o){var i=-1,a=e.length;for(t||(t=gi),o||(o=[]);++i<a;){var l=e[i];n>0&&t(l)?n>1?gr(l,n-1,t,r,o):zn(o,l):r||(o[o.length]=l)}return o}var mr=Oo(),yr=Oo(!0);function xr(e,n){return e&&mr(e,n,El)}function br(e,n){return e&&yr(e,n,El)}function _r(e,n){return kn(n,(function(n){return Ya(e[n])}))}function wr(e,n){for(var t=0,r=(n=yo(n,e)).length;null!=e&&t<r;)e=e[Ni(n[t++])];return t&&t==r?e:o}function kr(e,n,t){var r=n(e);return qa(e)?r:zn(r,t(e))}function Cr(e){return null==e?e===o?"[object Undefined]":"[object Null]":cn&&cn in Ce(e)?function(e){var n=Oe.call(e,cn),t=e[cn];try{e[cn]=o;var r=!0}catch(e){}var i=Te.call(e);return r&&(n?e[cn]=t:delete e[cn]),i}(e):function(e){return Te.call(e)}(e)}function Ar(e,n){return e>n}function Mr(e,n){return null!=e&&Oe.call(e,n)}function zr(e,n){return null!=e&&n in Ce(e)}function Lr(e,n,t){for(var i=t?An:Cn,a=e[0].length,l=e.length,c=l,u=r(l),s=1/0,f=[];c--;){var d=e[c];c&&n&&(d=Mn(d,Qn(n))),s=yt(d.length,s),u[c]=!t&&(n||a>=120&&d.length>=120)?new Vt(c&&d):o}d=e[0];var p=-1,h=u[0];e:for(;++p<a&&f.length<s;){var v=d[p],g=n?n(v):v;if(v=t||0!==v?v:0,!(h?Hn(h,g):i(f,g,t))){for(c=l;--c;){var m=u[c];if(!(m?Hn(m,g):i(e[c],g,t)))continue e}h&&h.push(g),f.push(v)}}return f}function Sr(e,n,t){var r=null==(e=Mi(e,n=yo(n,e)))?e:e[Ni(Ki(n))];return null==r?o:yn(r,e,t)}function Ir(e){return tl(e)&&Cr(e)==v}function Pr(e,n,t,r,i){return e===n||(null==e||null==n||!tl(e)&&!tl(n)?e!=e&&n!=n:function(e,n,t,r,i,a){var l=qa(e),c=qa(n),u=l?g:pi(e),s=c?g:pi(n),f=(u=u==v?C:u)==C,d=(s=s==v?C:s)==C,p=u==s;if(p&&Ja(e)){if(!Ja(n))return!1;l=!0,f=!1}if(p&&!f)return a||(a=new Gt),l||sl(e)?ei(e,n,t,r,i,a):function(e,n,t,r,o,i,a){switch(t){case E:if(e.byteLength!=n.byteLength||e.byteOffset!=n.byteOffset)return!1;e=e.buffer,n=n.buffer;case P:return!(e.byteLength!=n.byteLength||!i(new $e(e),new $e(n)));case m:case y:case k:return Ua(+e,+n);case x:return e.name==n.name&&e.message==n.message;case M:case L:return e==n+"";case w:var l=et;case z:var c=1&r;if(l||(l=rt),e.size!=n.size&&!c)return!1;var u=a.get(e);if(u)return u==n;r|=2,a.set(e,n);var s=ei(l(e),l(n),r,o,i,a);return a.delete(e),s;case S:if(Rt)return Rt.call(e)==Rt.call(n)}return!1}(e,n,u,t,r,i,a);if(!(1&t)){var h=f&&Oe.call(e,"__wrapped__"),b=d&&Oe.call(n,"__wrapped__");if(h||b){var _=h?e.value():e,A=b?n.value():n;return a||(a=new Gt),i(_,A,t,r,a)}}return!!p&&(a||(a=new Gt),function(e,n,t,r,i,a){var l=1&t,c=ti(e),u=c.length;if(u!=ti(n).length&&!l)return!1;for(var s=u;s--;){var f=c[s];if(!(l?f in n:Oe.call(n,f)))return!1}var d=a.get(e),p=a.get(n);if(d&&p)return d==n&&p==e;var h=!0;a.set(e,n),a.set(n,e);for(var v=l;++s<u;){var g=e[f=c[s]],m=n[f];if(r)var y=l?r(m,g,f,n,e,a):r(g,m,f,e,n,a);if(!(y===o?g===m||i(g,m,t,r,a):y)){h=!1;break}v||(v="constructor"==f)}if(h&&!v){var x=e.constructor,b=n.constructor;x==b||!("constructor"in e)||!("constructor"in n)||"function"==typeof x&&x instanceof x&&"function"==typeof b&&b instanceof b||(h=!1)}return a.delete(e),a.delete(n),h}(e,n,t,r,i,a))}(e,n,t,r,Pr,i))}function Er(e,n,t,r){var i=t.length,a=i,l=!r;if(null==e)return!a;for(e=Ce(e);i--;){var c=t[i];if(l&&c[2]?c[1]!==e[c[0]]:!(c[0]in e))return!1}for(;++i<a;){var u=(c=t[i])[0],s=e[u],f=c[1];if(l&&c[2]){if(s===o&&!(u in e))return!1}else{var d=new Gt;if(r)var p=r(s,f,u,e,n,d);if(!(p===o?Pr(f,s,3,r,d):p))return!1}}return!0}function Or(e){return!(!nl(e)||(n=e,je&&je in n))&&(Ya(e)?We:ve).test(Wi(e));var n}function Br(e){return"function"==typeof e?e:null==e?oc:"object"==typeof e?qa(e)?Wr(e[0],e[1]):Nr(e):pc(e)}function jr(e){if(!wi(e))return gt(e);var n=[];for(var t in Ce(e))Oe.call(e,t)&&"constructor"!=t&&n.push(t);return n}function Tr(e,n){return e<n}function Rr(e,n){var t=-1,o=Va(e)?r(e.length):[];return fr(e,(function(e,r,i){o[++t]=n(e,r,i)})),o}function Nr(e){var n=ui(e);return 1==n.length&&n[0][2]?Ci(n[0][0],n[0][1]):function(t){return t===e||Er(t,e,n)}}function Wr(e,n){return xi(e)&&ki(n)?Ci(Ni(e),n):function(t){var r=zl(t,e);return r===o&&r===n?Ll(t,e):Pr(n,r,3)}}function Dr(e,n,t,r,i){e!==n&&mr(n,(function(a,l){if(i||(i=new Gt),nl(a))!function(e,n,t,r,i,a,l){var c=Li(e,t),u=Li(n,t),s=l.get(u);if(s)Xt(e,t,s);else{var f=a?a(c,u,t+"",e,n,l):o,d=f===o;if(d){var p=qa(u),h=!p&&Ja(u),v=!p&&!h&&sl(u);f=u,p||h||v?qa(c)?f=c:Ga(c)?f=Lo(c):h?(d=!1,f=wo(u,!0)):v?(d=!1,f=Co(u,!0)):f=[]:il(u)||Qa(u)?(f=c,Qa(c)?f=yl(c):nl(c)&&!Ya(c)||(f=vi(u))):d=!1}d&&(l.set(u,f),i(f,u,r,a,l),l.delete(u)),Xt(e,t,f)}}(e,n,l,t,Dr,r,i);else{var c=r?r(Li(e,l),a,l+"",e,n,i):o;c===o&&(c=a),Xt(e,l,c)}}),Ol)}function Ur(e,n){var t=e.length;if(t)return mi(n+=n<0?t:0,t)?e[n]:o}function $r(e,n,t){n=n.length?Mn(n,(function(e){return qa(e)?function(n){return wr(n,1===e.length?e[0]:e)}:e})):[oc];var r=-1;return n=Mn(n,Qn(li())),function(e,n){var r=e.length;for(e.sort((function(e,n){return function(e,n,t){for(var r=-1,o=e.criteria,i=n.criteria,a=o.length,l=t.length;++r<a;){var c=Ao(o[r],i[r]);if(c)return r>=l?c:c*("desc"==t[r]?-1:1)}return e.index-n.index}(e,n,t)}));r--;)e[r]=e[r].value;return e}(Rr(e,(function(e,t,o){return{criteria:Mn(n,(function(n){return n(e)})),index:++r,value:e}})))}function Fr(e,n,t){for(var r=-1,o=n.length,i={};++r<o;){var a=n[r],l=wr(e,a);t(l,a)&&Kr(i,yo(a,e),l)}return i}function Qr(e,n,t,r){var o=r?jn:Bn,i=-1,a=n.length,l=e;for(e===n&&(n=Lo(n)),t&&(l=Mn(e,Qn(t)));++i<a;)for(var c=0,u=n[i],s=t?t(u):u;(c=o(l,s,c,r))>-1;)l!==e&&rn.call(l,c,1),rn.call(e,c,1);return e}function qr(e,n){for(var t=e?n.length:0,r=t-1;t--;){var o=n[t];if(t==r||o!==i){var i=o;mi(o)?rn.call(e,o,1):uo(e,o)}}return e}function Hr(e,n){return e+ft(_t()*(n-e+1))}function Vr(e,n){var t="";if(!e||n<1||n>f)return t;do{n%2&&(t+=e),(n=ft(n/2))&&(e+=e)}while(n);return t}function Gr(e,n){return Pi(Ai(e,n,oc),e+"")}function Jr(e){return Zt(Ul(e))}function Zr(e,n){var t=Ul(e);return Bi(t,ar(n,0,t.length))}function Kr(e,n,t,r){if(!nl(e))return e;for(var i=-1,a=(n=yo(n,e)).length,l=a-1,c=e;null!=c&&++i<a;){var u=Ni(n[i]),s=t;if("__proto__"===u||"constructor"===u||"prototype"===u)return e;if(i!=l){var f=c[u];(s=r?r(f,u,c):o)===o&&(s=nl(f)?f:mi(n[i+1])?[]:{})}er(c,u,s),c=c[u]}return e}var Yr=St?function(e,n){return St.set(e,n),e}:oc,Xr=sn?function(e,n){return sn(e,"toString",{configurable:!0,enumerable:!1,value:nc(n),writable:!0})}:oc;function eo(e){return Bi(Ul(e))}function no(e,n,t){var o=-1,i=e.length;n<0&&(n=-n>i?0:i+n),(t=t>i?i:t)<0&&(t+=i),i=n>t?0:t-n>>>0,n>>>=0;for(var a=r(i);++o<i;)a[o]=e[o+n];return a}function to(e,n){var t;return fr(e,(function(e,r,o){return!(t=n(e,r,o))})),!!t}function ro(e,n,t){var r=0,o=null==e?r:e.length;if("number"==typeof n&&n==n&&o<=2147483647){for(;r<o;){var i=r+o>>>1,a=e[i];null!==a&&!ul(a)&&(t?a<=n:a<n)?r=i+1:o=i}return o}return oo(e,n,oc,t)}function oo(e,n,t,r){var i=0,a=null==e?0:e.length;if(0===a)return 0;for(var l=(n=t(n))!=n,c=null===n,u=ul(n),s=n===o;i<a;){var f=ft((i+a)/2),d=t(e[f]),p=d!==o,h=null===d,v=d==d,g=ul(d);if(l)var m=r||v;else m=s?v&&(r||p):c?v&&p&&(r||!h):u?v&&p&&!h&&(r||!g):!h&&!g&&(r?d<=n:d<n);m?i=f+1:a=f}return yt(a,4294967294)}function io(e,n){for(var t=-1,r=e.length,o=0,i=[];++t<r;){var a=e[t],l=n?n(a):a;if(!t||!Ua(l,c)){var c=l;i[o++]=0===a?0:a}}return i}function ao(e){return"number"==typeof e?e:ul(e)?d:+e}function lo(e){if("string"==typeof e)return e;if(qa(e))return Mn(e,lo)+"";if(ul(e))return Nt?Nt.call(e):"";var n=e+"";return"0"==n&&1/e==-1/0?"-0":n}function co(e,n,t){var r=-1,o=Cn,i=e.length,a=!0,l=[],c=l;if(t)a=!1,o=An;else if(i>=200){var u=n?null:Go(e);if(u)return rt(u);a=!1,o=Hn,c=new Vt}else c=n?[]:l;e:for(;++r<i;){var s=e[r],f=n?n(s):s;if(s=t||0!==s?s:0,a&&f==f){for(var d=c.length;d--;)if(c[d]===f)continue e;n&&c.push(f),l.push(s)}else o(c,f,t)||(c!==l&&c.push(f),l.push(s))}return l}function uo(e,n){return null==(e=Mi(e,n=yo(n,e)))||delete e[Ni(Ki(n))]}function so(e,n,t,r){return Kr(e,n,t(wr(e,n)),r)}function fo(e,n,t,r){for(var o=e.length,i=r?o:-1;(r?i--:++i<o)&&n(e[i],i,e););return t?no(e,r?0:i,r?i+1:o):no(e,r?i+1:0,r?o:i)}function po(e,n){var t=e;return t instanceof Ft&&(t=t.value()),Ln(n,(function(e,n){return n.func.apply(n.thisArg,zn([e],n.args))}),t)}function ho(e,n,t){var o=e.length;if(o<2)return o?co(e[0]):[];for(var i=-1,a=r(o);++i<o;)for(var l=e[i],c=-1;++c<o;)c!=i&&(a[i]=sr(a[i]||l,e[c],n,t));return co(gr(a,1),n,t)}function vo(e,n,t){for(var r=-1,i=e.length,a=n.length,l={};++r<i;){var c=r<a?n[r]:o;t(l,e[r],c)}return l}function go(e){return Ga(e)?e:[]}function mo(e){return"function"==typeof e?e:oc}function yo(e,n){return qa(e)?e:xi(e,n)?[e]:Ri(xl(e))}var xo=Gr;function bo(e,n,t){var r=e.length;return t=t===o?r:t,!n&&t>=r?e:no(e,n,t)}var _o=fn||function(e){return an.clearTimeout(e)};function wo(e,n){if(n)return e.slice();var t=e.length,r=Fe?Fe(t):new e.constructor(t);return e.copy(r),r}function ko(e){var n=new e.constructor(e.byteLength);return new $e(n).set(new $e(e)),n}function Co(e,n){var t=n?ko(e.buffer):e.buffer;return new e.constructor(t,e.byteOffset,e.length)}function Ao(e,n){if(e!==n){var t=e!==o,r=null===e,i=e==e,a=ul(e),l=n!==o,c=null===n,u=n==n,s=ul(n);if(!c&&!s&&!a&&e>n||a&&l&&u&&!c&&!s||r&&l&&u||!t&&u||!i)return 1;if(!r&&!a&&!s&&e<n||s&&t&&i&&!r&&!a||c&&t&&i||!l&&i||!u)return-1}return 0}function Mo(e,n,t,o){for(var i=-1,a=e.length,l=t.length,c=-1,u=n.length,s=mt(a-l,0),f=r(u+s),d=!o;++c<u;)f[c]=n[c];for(;++i<l;)(d||i<a)&&(f[t[i]]=e[i]);for(;s--;)f[c++]=e[i++];return f}function zo(e,n,t,o){for(var i=-1,a=e.length,l=-1,c=t.length,u=-1,s=n.length,f=mt(a-c,0),d=r(f+s),p=!o;++i<f;)d[i]=e[i];for(var h=i;++u<s;)d[h+u]=n[u];for(;++l<c;)(p||i<a)&&(d[h+t[l]]=e[i++]);return d}function Lo(e,n){var t=-1,o=e.length;for(n||(n=r(o));++t<o;)n[t]=e[t];return n}function So(e,n,t,r){var i=!t;t||(t={});for(var a=-1,l=n.length;++a<l;){var c=n[a],u=r?r(t[c],e[c],c,t,e):o;u===o&&(u=e[c]),i?or(t,c,u):er(t,c,u)}return t}function Io(e,n){return function(t,r){var o=qa(t)?xn:tr,i=n?n():{};return o(t,e,li(r,2),i)}}function Po(e){return Gr((function(n,t){var r=-1,i=t.length,a=i>1?t[i-1]:o,l=i>2?t[2]:o;for(a=e.length>3&&"function"==typeof a?(i--,a):o,l&&yi(t[0],t[1],l)&&(a=i<3?o:a,i=1),n=Ce(n);++r<i;){var c=t[r];c&&e(n,c,r,a)}return n}))}function Eo(e,n){return function(t,r){if(null==t)return t;if(!Va(t))return e(t,r);for(var o=t.length,i=n?o:-1,a=Ce(t);(n?i--:++i<o)&&!1!==r(a[i],i,a););return t}}function Oo(e){return function(n,t,r){for(var o=-1,i=Ce(n),a=r(n),l=a.length;l--;){var c=a[e?l:++o];if(!1===t(i[c],c,i))break}return n}}function Bo(e){return function(n){var t=Xn(n=xl(n))?at(n):o,r=t?t[0]:n.charAt(0),i=t?bo(t,1).join(""):n.slice(1);return r[e]()+i}}function jo(e){return function(n){return Ln(Yl(Ql(n).replace(Qe,"")),e,"")}}function To(e){return function(){var n=arguments;switch(n.length){case 0:return new e;case 1:return new e(n[0]);case 2:return new e(n[0],n[1]);case 3:return new e(n[0],n[1],n[2]);case 4:return new e(n[0],n[1],n[2],n[3]);case 5:return new e(n[0],n[1],n[2],n[3],n[4]);case 6:return new e(n[0],n[1],n[2],n[3],n[4],n[5]);case 7:return new e(n[0],n[1],n[2],n[3],n[4],n[5],n[6])}var t=Dt(e.prototype),r=e.apply(t,n);return nl(r)?r:t}}function Ro(e){return function(n,t,r){var i=Ce(n);if(!Va(n)){var a=li(t,3);n=El(n),t=function(e){return a(i[e],e,i)}}var l=e(n,t,r);return l>-1?i[a?n[l]:l]:o}}function No(e){return ni((function(n){var t=n.length,r=t,a=$t.prototype.thru;for(e&&n.reverse();r--;){var l=n[r];if("function"!=typeof l)throw new ze(i);if(a&&!c&&"wrapper"==ii(l))var c=new $t([],!0)}for(r=c?r:t;++r<t;){var u=ii(l=n[r]),s="wrapper"==u?oi(l):o;c=s&&bi(s[0])&&424==s[1]&&!s[4].length&&1==s[9]?c[ii(s[0])].apply(c,s[3]):1==l.length&&bi(l)?c[u]():c.thru(l)}return function(){var e=arguments,r=e[0];if(c&&1==e.length&&qa(r))return c.plant(r).value();for(var o=0,i=t?n[o].apply(this,e):r;++o<t;)i=n[o].call(this,i);return i}}))}function Wo(e,n,t,i,a,l,c,s,f,d){var p=n&u,h=1&n,v=2&n,g=24&n,m=512&n,y=v?o:To(e);return function o(){for(var u=arguments.length,x=r(u),b=u;b--;)x[b]=arguments[b];if(g)var _=ai(o),w=Jn(x,_);if(i&&(x=Mo(x,i,a,g)),l&&(x=zo(x,l,c,g)),u-=w,g&&u<d){var k=tt(x,_);return Ho(e,n,Wo,o.placeholder,t,x,k,s,f,d-u)}var C=h?t:this,A=v?C[e]:e;return u=x.length,s?x=zi(x,s):m&&u>1&&x.reverse(),p&&f<u&&(x.length=f),this&&this!==an&&this instanceof o&&(A=y||To(A)),A.apply(C,x)}}function Do(e,n){return function(t,r){return function(e,n,t,r){return xr(e,(function(e,o,i){n(r,t(e),o,i)})),r}(t,e,n(r),{})}}function Uo(e,n){return function(t,r){var i;if(t===o&&r===o)return n;if(t!==o&&(i=t),r!==o){if(i===o)return r;"string"==typeof t||"string"==typeof r?(t=lo(t),r=lo(r)):(t=ao(t),r=ao(r)),i=e(t,r)}return i}}function $o(e){return ni((function(n){return n=Mn(n,Qn(li())),Gr((function(t){var r=this;return e(n,(function(e){return yn(e,r,t)}))}))}))}function Fo(e,n){var t=(n=n===o?" ":lo(n)).length;if(t<2)return t?Vr(n,e):n;var r=Vr(n,st(e/it(n)));return Xn(n)?bo(at(r),0,e).join(""):r.slice(0,e)}function Qo(e){return function(n,t,i){return i&&"number"!=typeof i&&yi(n,t,i)&&(t=i=o),n=hl(n),t===o?(t=n,n=0):t=hl(t),function(e,n,t,o){for(var i=-1,a=mt(st((n-e)/(t||1)),0),l=r(a);a--;)l[o?a:++i]=e,e+=t;return l}(n,t,i=i===o?n<t?1:-1:hl(i),e)}}function qo(e){return function(n,t){return"string"==typeof n&&"string"==typeof t||(n=ml(n),t=ml(t)),e(n,t)}}function Ho(e,n,t,r,i,a,l,u,s,f){var d=8&n;n|=d?c:64,4&(n&=~(d?64:c))||(n&=-4);var p=[e,n,i,d?a:o,d?l:o,d?o:a,d?o:l,u,s,f],h=t.apply(o,p);return bi(e)&&Si(h,p),h.placeholder=r,Ei(h,e,n)}function Vo(e){var n=ke[e];return function(e,t){if(e=ml(e),(t=null==t?0:yt(vl(t),292))&&ht(e)){var r=(xl(e)+"e").split("e");return+((r=(xl(n(r[0]+"e"+(+r[1]+t)))+"e").split("e"))[0]+"e"+(+r[1]-t))}return n(e)}}var Go=Mt&&1/rt(new Mt([,-0]))[1]==s?function(e){return new Mt(e)}:uc;function Jo(e){return function(n){var t=pi(n);return t==w?et(n):t==z?ot(n):function(e,n){return Mn(n,(function(n){return[n,e[n]]}))}(n,e(n))}}function Zo(e,n,t,a,s,f,d,p){var h=2&n;if(!h&&"function"!=typeof e)throw new ze(i);var v=a?a.length:0;if(v||(n&=-97,a=s=o),d=d===o?d:mt(vl(d),0),p=p===o?p:vl(p),v-=s?s.length:0,64&n){var g=a,m=s;a=s=o}var y=h?o:oi(e),x=[e,n,t,a,s,g,m,f,d,p];if(y&&function(e,n){var t=e[1],r=n[1],o=t|r,i=o<131,a=r==u&&8==t||r==u&&256==t&&e[7].length<=n[8]||384==r&&n[7].length<=n[8]&&8==t;if(!i&&!a)return e;1&r&&(e[2]=n[2],o|=1&t?0:4);var c=n[3];if(c){var s=e[3];e[3]=s?Mo(s,c,n[4]):c,e[4]=s?tt(e[3],l):n[4]}(c=n[5])&&(s=e[5],e[5]=s?zo(s,c,n[6]):c,e[6]=s?tt(e[5],l):n[6]),(c=n[7])&&(e[7]=c),r&u&&(e[8]=null==e[8]?n[8]:yt(e[8],n[8])),null==e[9]&&(e[9]=n[9]),e[0]=n[0],e[1]=o}(x,y),e=x[0],n=x[1],t=x[2],a=x[3],s=x[4],!(p=x[9]=x[9]===o?h?0:e.length:mt(x[9]-v,0))&&24&n&&(n&=-25),n&&1!=n)b=8==n||16==n?function(e,n,t){var i=To(e);return function a(){for(var l=arguments.length,c=r(l),u=l,s=ai(a);u--;)c[u]=arguments[u];var f=l<3&&c[0]!==s&&c[l-1]!==s?[]:tt(c,s);return(l-=f.length)<t?Ho(e,n,Wo,a.placeholder,o,c,f,o,o,t-l):yn(this&&this!==an&&this instanceof a?i:e,this,c)}}(e,n,p):n!=c&&33!=n||s.length?Wo.apply(o,x):function(e,n,t,o){var i=1&n,a=To(e);return function n(){for(var l=-1,c=arguments.length,u=-1,s=o.length,f=r(s+c),d=this&&this!==an&&this instanceof n?a:e;++u<s;)f[u]=o[u];for(;c--;)f[u++]=arguments[++l];return yn(d,i?t:this,f)}}(e,n,t,a);else var b=function(e,n,t){var r=1&n,o=To(e);return function n(){return(this&&this!==an&&this instanceof n?o:e).apply(r?t:this,arguments)}}(e,n,t);return Ei((y?Yr:Si)(b,x),e,n)}function Ko(e,n,t,r){return e===o||Ua(e,Ie[t])&&!Oe.call(r,t)?n:e}function Yo(e,n,t,r,i,a){return nl(e)&&nl(n)&&(a.set(n,e),Dr(e,n,o,Yo,a),a.delete(n)),e}function Xo(e){return il(e)?o:e}function ei(e,n,t,r,i,a){var l=1&t,c=e.length,u=n.length;if(c!=u&&!(l&&u>c))return!1;var s=a.get(e),f=a.get(n);if(s&&f)return s==n&&f==e;var d=-1,p=!0,h=2&t?new Vt:o;for(a.set(e,n),a.set(n,e);++d<c;){var v=e[d],g=n[d];if(r)var m=l?r(g,v,d,n,e,a):r(v,g,d,e,n,a);if(m!==o){if(m)continue;p=!1;break}if(h){if(!In(n,(function(e,n){if(!Hn(h,n)&&(v===e||i(v,e,t,r,a)))return h.push(n)}))){p=!1;break}}else if(v!==g&&!i(v,g,t,r,a)){p=!1;break}}return a.delete(e),a.delete(n),p}function ni(e){return Pi(Ai(e,o,Hi),e+"")}function ti(e){return kr(e,El,fi)}function ri(e){return kr(e,Ol,di)}var oi=St?function(e){return St.get(e)}:uc;function ii(e){for(var n=e.name+"",t=It[n],r=Oe.call(It,n)?t.length:0;r--;){var o=t[r],i=o.func;if(null==i||i==e)return o.name}return n}function ai(e){return(Oe.call(Wt,"placeholder")?Wt:e).placeholder}function li(){var e=Wt.iteratee||ic;return e=e===ic?Br:e,arguments.length?e(arguments[0],arguments[1]):e}function ci(e,n){var t,r,o=e.__data__;return("string"==(r=typeof(t=n))||"number"==r||"symbol"==r||"boolean"==r?"__proto__"!==t:null===t)?o["string"==typeof n?"string":"hash"]:o.map}function ui(e){for(var n=El(e),t=n.length;t--;){var r=n[t],o=e[r];n[t]=[r,o,ki(o)]}return n}function si(e,n){var t=function(e,n){return null==e?o:e[n]}(e,n);return Or(t)?t:o}var fi=dt?function(e){return null==e?[]:(e=Ce(e),kn(dt(e),(function(n){return en.call(e,n)})))}:gc,di=dt?function(e){for(var n=[];e;)zn(n,fi(e)),e=He(e);return n}:gc,pi=Cr;function hi(e,n,t){for(var r=-1,o=(n=yo(n,e)).length,i=!1;++r<o;){var a=Ni(n[r]);if(!(i=null!=e&&t(e,a)))break;e=e[a]}return i||++r!=o?i:!!(o=null==e?0:e.length)&&el(o)&&mi(a,o)&&(qa(e)||Qa(e))}function vi(e){return"function"!=typeof e.constructor||wi(e)?{}:Dt(He(e))}function gi(e){return qa(e)||Qa(e)||!!(on&&e&&e[on])}function mi(e,n){var t=typeof e;return!!(n=null==n?f:n)&&("number"==t||"symbol"!=t&&me.test(e))&&e>-1&&e%1==0&&e<n}function yi(e,n,t){if(!nl(t))return!1;var r=typeof n;return!!("number"==r?Va(t)&&mi(n,t.length):"string"==r&&n in t)&&Ua(t[n],e)}function xi(e,n){if(qa(e))return!1;var t=typeof e;return!("number"!=t&&"symbol"!=t&&"boolean"!=t&&null!=e&&!ul(e))||X.test(e)||!Y.test(e)||null!=n&&e in Ce(n)}function bi(e){var n=ii(e),t=Wt[n];if("function"!=typeof t||!(n in Ft.prototype))return!1;if(e===t)return!0;var r=oi(t);return!!r&&e===r[0]}(kt&&pi(new kt(new ArrayBuffer(1)))!=E||Ct&&pi(new Ct)!=w||At&&pi(At.resolve())!=A||Mt&&pi(new Mt)!=z||zt&&pi(new zt)!=I)&&(pi=function(e){var n=Cr(e),t=n==C?e.constructor:o,r=t?Wi(t):"";if(r)switch(r){case Pt:return E;case Et:return w;case Ot:return A;case Bt:return z;case jt:return I}return n});var _i=Pe?Ya:mc;function wi(e){var n=e&&e.constructor;return e===("function"==typeof n&&n.prototype||Ie)}function ki(e){return e==e&&!nl(e)}function Ci(e,n){return function(t){return null!=t&&t[e]===n&&(n!==o||e in Ce(t))}}function Ai(e,n,t){return n=mt(n===o?e.length-1:n,0),function(){for(var o=arguments,i=-1,a=mt(o.length-n,0),l=r(a);++i<a;)l[i]=o[n+i];i=-1;for(var c=r(n+1);++i<n;)c[i]=o[i];return c[n]=t(l),yn(e,this,c)}}function Mi(e,n){return n.length<2?e:wr(e,no(n,0,-1))}function zi(e,n){for(var t=e.length,r=yt(n.length,t),i=Lo(e);r--;){var a=n[r];e[r]=mi(a,t)?i[a]:o}return e}function Li(e,n){if(("constructor"!==n||"function"!=typeof e[n])&&"__proto__"!=n)return e[n]}var Si=Oi(Yr),Ii=Wn||function(e,n){return an.setTimeout(e,n)},Pi=Oi(Xr);function Ei(e,n,t){var r=n+"";return Pi(e,function(e,n){var t=n.length;if(!t)return e;var r=t-1;return n[r]=(t>1?"& ":"")+n[r],n=n.join(t>2?", ":" "),e.replace(ie,"{\n/* [wrapped with "+n+"] */\n")}(r,function(e,n){return bn(h,(function(t){var r="_."+t[0];n&t[1]&&!Cn(e,r)&&e.push(r)})),e.sort()}(function(e){var n=e.match(ae);return n?n[1].split(le):[]}(r),t)))}function Oi(e){var n=0,t=0;return function(){var r=xt(),i=16-(r-t);if(t=r,i>0){if(++n>=800)return arguments[0]}else n=0;return e.apply(o,arguments)}}function Bi(e,n){var t=-1,r=e.length,i=r-1;for(n=n===o?r:n;++t<n;){var a=Hr(t,i),l=e[a];e[a]=e[t],e[t]=l}return e.length=n,e}var ji,Ti,Ri=(ji=ja((function(e){var n=[];return 46===e.charCodeAt(0)&&n.push(""),e.replace(ee,(function(e,t,r,o){n.push(r?o.replace(se,"$1"):t||e)})),n}),(function(e){return 500===Ti.size&&Ti.clear(),e})),Ti=ji.cache,ji);function Ni(e){if("string"==typeof e||ul(e))return e;var n=e+"";return"0"==n&&1/e==-1/0?"-0":n}function Wi(e){if(null!=e){try{return Ee.call(e)}catch(e){}try{return e+""}catch(e){}}return""}function Di(e){if(e instanceof Ft)return e.clone();var n=new $t(e.__wrapped__,e.__chain__);return n.__actions__=Lo(e.__actions__),n.__index__=e.__index__,n.__values__=e.__values__,n}var Ui=Gr((function(e,n){return Ga(e)?sr(e,gr(n,1,Ga,!0)):[]})),$i=Gr((function(e,n){var t=Ki(n);return Ga(t)&&(t=o),Ga(e)?sr(e,gr(n,1,Ga,!0),li(t,2)):[]})),Fi=Gr((function(e,n){var t=Ki(n);return Ga(t)&&(t=o),Ga(e)?sr(e,gr(n,1,Ga,!0),o,t):[]}));function Qi(e,n,t){var r=null==e?0:e.length;if(!r)return-1;var o=null==t?0:vl(t);return o<0&&(o=mt(r+o,0)),On(e,li(n,3),o)}function qi(e,n,t){var r=null==e?0:e.length;if(!r)return-1;var i=r-1;return t!==o&&(i=vl(t),i=t<0?mt(r+i,0):yt(i,r-1)),On(e,li(n,3),i,!0)}function Hi(e){return null!=e&&e.length?gr(e,1):[]}function Vi(e){return e&&e.length?e[0]:o}var Gi=Gr((function(e){var n=Mn(e,go);return n.length&&n[0]===e[0]?Lr(n):[]})),Ji=Gr((function(e){var n=Ki(e),t=Mn(e,go);return n===Ki(t)?n=o:t.pop(),t.length&&t[0]===e[0]?Lr(t,li(n,2)):[]})),Zi=Gr((function(e){var n=Ki(e),t=Mn(e,go);return(n="function"==typeof n?n:o)&&t.pop(),t.length&&t[0]===e[0]?Lr(t,o,n):[]}));function Ki(e){var n=null==e?0:e.length;return n?e[n-1]:o}var Yi=Gr(Xi);function Xi(e,n){return e&&e.length&&n&&n.length?Qr(e,n):e}var ea=ni((function(e,n){var t=null==e?0:e.length,r=ir(e,n);return qr(e,Mn(n,(function(e){return mi(e,t)?+e:e})).sort(Ao)),r}));function na(e){return null==e?e:wt.call(e)}var ta=Gr((function(e){return co(gr(e,1,Ga,!0))})),ra=Gr((function(e){var n=Ki(e);return Ga(n)&&(n=o),co(gr(e,1,Ga,!0),li(n,2))})),oa=Gr((function(e){var n=Ki(e);return n="function"==typeof n?n:o,co(gr(e,1,Ga,!0),o,n)}));function ia(e){if(!e||!e.length)return[];var n=0;return e=kn(e,(function(e){if(Ga(e))return n=mt(e.length,n),!0})),$n(n,(function(n){return Mn(e,Nn(n))}))}function aa(e,n){if(!e||!e.length)return[];var t=ia(e);return null==n?t:Mn(t,(function(e){return yn(n,o,e)}))}var la=Gr((function(e,n){return Ga(e)?sr(e,n):[]})),ca=Gr((function(e){return ho(kn(e,Ga))})),ua=Gr((function(e){var n=Ki(e);return Ga(n)&&(n=o),ho(kn(e,Ga),li(n,2))})),sa=Gr((function(e){var n=Ki(e);return n="function"==typeof n?n:o,ho(kn(e,Ga),o,n)})),fa=Gr(ia),da=Gr((function(e){var n=e.length,t=n>1?e[n-1]:o;return t="function"==typeof t?(e.pop(),t):o,aa(e,t)}));function pa(e){var n=Wt(e);return n.__chain__=!0,n}function ha(e,n){return n(e)}var va=ni((function(e){var n=e.length,t=n?e[0]:0,r=this.__wrapped__,i=function(n){return ir(n,e)};return!(n>1||this.__actions__.length)&&r instanceof Ft&&mi(t)?((r=r.slice(t,+t+(n?1:0))).__actions__.push({func:ha,args:[i],thisArg:o}),new $t(r,this.__chain__).thru((function(e){return n&&!e.length&&e.push(o),e}))):this.thru(i)})),ga=Io((function(e,n,t){Oe.call(e,t)?++e[t]:or(e,t,1)})),ma=Ro(Qi),ya=Ro(qi);function xa(e,n){return(qa(e)?bn:fr)(e,li(n,3))}function ba(e,n){return(qa(e)?_n:dr)(e,li(n,3))}var _a=Io((function(e,n,t){Oe.call(e,t)?e[t].push(n):or(e,t,[n])})),wa=Gr((function(e,n,t){var o=-1,i="function"==typeof n,a=Va(e)?r(e.length):[];return fr(e,(function(e){a[++o]=i?yn(n,e,t):Sr(e,n,t)})),a})),ka=Io((function(e,n,t){or(e,t,n)}));function Ca(e,n){return(qa(e)?Mn:Rr)(e,li(n,3))}var Aa=Io((function(e,n,t){e[t?0:1].push(n)}),(function(){return[[],[]]})),Ma=Gr((function(e,n){if(null==e)return[];var t=n.length;return t>1&&yi(e,n[0],n[1])?n=[]:t>2&&yi(n[0],n[1],n[2])&&(n=[n[0]]),$r(e,gr(n,1),[])})),za=Pn||function(){return an.Date.now()};function La(e,n,t){return n=t?o:n,n=e&&null==n?e.length:n,Zo(e,u,o,o,o,o,n)}function Sa(e,n){var t;if("function"!=typeof n)throw new ze(i);return e=vl(e),function(){return--e>0&&(t=n.apply(this,arguments)),e<=1&&(n=o),t}}var Ia=Gr((function(e,n,t){var r=1;if(t.length){var o=tt(t,ai(Ia));r|=c}return Zo(e,r,n,t,o)})),Pa=Gr((function(e,n,t){var r=3;if(t.length){var o=tt(t,ai(Pa));r|=c}return Zo(n,r,e,t,o)}));function Ea(e,n,t){var r,a,l,c,u,s,f=0,d=!1,p=!1,h=!0;if("function"!=typeof e)throw new ze(i);function v(n){var t=r,i=a;return r=a=o,f=n,c=e.apply(i,t)}function g(e){return f=e,u=Ii(y,n),d?v(e):c}function m(e){var t=e-s;return s===o||t>=n||t<0||p&&e-f>=l}function y(){var e=za();if(m(e))return x(e);u=Ii(y,function(e){var t=n-(e-s);return p?yt(t,l-(e-f)):t}(e))}function x(e){return u=o,h&&r?v(e):(r=a=o,c)}function b(){var e=za(),t=m(e);if(r=arguments,a=this,s=e,t){if(u===o)return g(s);if(p)return _o(u),u=Ii(y,n),v(s)}return u===o&&(u=Ii(y,n)),c}return n=ml(n)||0,nl(t)&&(d=!!t.leading,l=(p="maxWait"in t)?mt(ml(t.maxWait)||0,n):l,h="trailing"in t?!!t.trailing:h),b.cancel=function(){u!==o&&_o(u),f=0,r=s=a=u=o},b.flush=function(){return u===o?c:x(za())},b}var Oa=Gr((function(e,n){return ur(e,1,n)})),Ba=Gr((function(e,n,t){return ur(e,ml(n)||0,t)}));function ja(e,n){if("function"!=typeof e||null!=n&&"function"!=typeof n)throw new ze(i);var t=function(){var r=arguments,o=n?n.apply(this,r):r[0],i=t.cache;if(i.has(o))return i.get(o);var a=e.apply(this,r);return t.cache=i.set(o,a)||i,a};return t.cache=new(ja.Cache||Ht),t}function Ta(e){if("function"!=typeof e)throw new ze(i);return function(){var n=arguments;switch(n.length){case 0:return!e.call(this);case 1:return!e.call(this,n[0]);case 2:return!e.call(this,n[0],n[1]);case 3:return!e.call(this,n[0],n[1],n[2])}return!e.apply(this,n)}}ja.Cache=Ht;var Ra=xo((function(e,n){var t=(n=1==n.length&&qa(n[0])?Mn(n[0],Qn(li())):Mn(gr(n,1),Qn(li()))).length;return Gr((function(r){for(var o=-1,i=yt(r.length,t);++o<i;)r[o]=n[o].call(this,r[o]);return yn(e,this,r)}))})),Na=Gr((function(e,n){var t=tt(n,ai(Na));return Zo(e,c,o,n,t)})),Wa=Gr((function(e,n){var t=tt(n,ai(Wa));return Zo(e,64,o,n,t)})),Da=ni((function(e,n){return Zo(e,256,o,o,o,n)}));function Ua(e,n){return e===n||e!=e&&n!=n}var $a=qo(Ar),Fa=qo((function(e,n){return e>=n})),Qa=Ir(function(){return arguments}())?Ir:function(e){return tl(e)&&Oe.call(e,"callee")&&!en.call(e,"callee")},qa=r.isArray,Ha=dn?Qn(dn):function(e){return tl(e)&&Cr(e)==P};function Va(e){return null!=e&&el(e.length)&&!Ya(e)}function Ga(e){return tl(e)&&Va(e)}var Ja=pt||mc,Za=pn?Qn(pn):function(e){return tl(e)&&Cr(e)==y};function Ka(e){if(!tl(e))return!1;var n=Cr(e);return n==x||"[object DOMException]"==n||"string"==typeof e.message&&"string"==typeof e.name&&!il(e)}function Ya(e){if(!nl(e))return!1;var n=Cr(e);return n==b||n==_||"[object AsyncFunction]"==n||"[object Proxy]"==n}function Xa(e){return"number"==typeof e&&e==vl(e)}function el(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=f}function nl(e){var n=typeof e;return null!=e&&("object"==n||"function"==n)}function tl(e){return null!=e&&"object"==typeof e}var rl=hn?Qn(hn):function(e){return tl(e)&&pi(e)==w};function ol(e){return"number"==typeof e||tl(e)&&Cr(e)==k}function il(e){if(!tl(e)||Cr(e)!=C)return!1;var n=He(e);if(null===n)return!0;var t=Oe.call(n,"constructor")&&n.constructor;return"function"==typeof t&&t instanceof t&&Ee.call(t)==Re}var al=vn?Qn(vn):function(e){return tl(e)&&Cr(e)==M},ll=gn?Qn(gn):function(e){return tl(e)&&pi(e)==z};function cl(e){return"string"==typeof e||!qa(e)&&tl(e)&&Cr(e)==L}function ul(e){return"symbol"==typeof e||tl(e)&&Cr(e)==S}var sl=mn?Qn(mn):function(e){return tl(e)&&el(e.length)&&!!Ye[Cr(e)]},fl=qo(Tr),dl=qo((function(e,n){return e<=n}));function pl(e){if(!e)return[];if(Va(e))return cl(e)?at(e):Lo(e);if(ln&&e[ln])return function(e){for(var n,t=[];!(n=e.next()).done;)t.push(n.value);return t}(e[ln]());var n=pi(e);return(n==w?et:n==z?rt:Ul)(e)}function hl(e){return e?(e=ml(e))===s||e===-1/0?17976931348623157e292*(e<0?-1:1):e==e?e:0:0===e?e:0}function vl(e){var n=hl(e),t=n%1;return n==n?t?n-t:n:0}function gl(e){return e?ar(vl(e),0,p):0}function ml(e){if("number"==typeof e)return e;if(ul(e))return d;if(nl(e)){var n="function"==typeof e.valueOf?e.valueOf():e;e=nl(n)?n+"":n}if("string"!=typeof e)return 0===e?e:+e;e=Fn(e);var t=he.test(e);return t||ge.test(e)?tn(e.slice(2),t?2:8):pe.test(e)?d:+e}function yl(e){return So(e,Ol(e))}function xl(e){return null==e?"":lo(e)}var bl=Po((function(e,n){if(wi(n)||Va(n))So(n,El(n),e);else for(var t in n)Oe.call(n,t)&&er(e,t,n[t])})),_l=Po((function(e,n){So(n,Ol(n),e)})),wl=Po((function(e,n,t,r){So(n,Ol(n),e,r)})),kl=Po((function(e,n,t,r){So(n,El(n),e,r)})),Cl=ni(ir),Al=Gr((function(e,n){e=Ce(e);var t=-1,r=n.length,i=r>2?n[2]:o;for(i&&yi(n[0],n[1],i)&&(r=1);++t<r;)for(var a=n[t],l=Ol(a),c=-1,u=l.length;++c<u;){var s=l[c],f=e[s];(f===o||Ua(f,Ie[s])&&!Oe.call(e,s))&&(e[s]=a[s])}return e})),Ml=Gr((function(e){return e.push(o,Yo),yn(jl,o,e)}));function zl(e,n,t){var r=null==e?o:wr(e,n);return r===o?t:r}function Ll(e,n){return null!=e&&hi(e,n,zr)}var Sl=Do((function(e,n,t){null!=n&&"function"!=typeof n.toString&&(n=Te.call(n)),e[n]=t}),nc(oc)),Il=Do((function(e,n,t){null!=n&&"function"!=typeof n.toString&&(n=Te.call(n)),Oe.call(e,n)?e[n].push(t):e[n]=[t]}),li),Pl=Gr(Sr);function El(e){return Va(e)?Jt(e):jr(e)}function Ol(e){return Va(e)?Jt(e,!0):function(e){if(!nl(e))return function(e){var n=[];if(null!=e)for(var t in Ce(e))n.push(t);return n}(e);var n=wi(e),t=[];for(var r in e)("constructor"!=r||!n&&Oe.call(e,r))&&t.push(r);return t}(e)}var Bl=Po((function(e,n,t){Dr(e,n,t)})),jl=Po((function(e,n,t,r){Dr(e,n,t,r)})),Tl=ni((function(e,n){var t={};if(null==e)return t;var r=!1;n=Mn(n,(function(n){return n=yo(n,e),r||(r=n.length>1),n})),So(e,ri(e),t),r&&(t=lr(t,7,Xo));for(var o=n.length;o--;)uo(t,n[o]);return t})),Rl=ni((function(e,n){return null==e?{}:function(e,n){return Fr(e,n,(function(n,t){return Ll(e,t)}))}(e,n)}));function Nl(e,n){if(null==e)return{};var t=Mn(ri(e),(function(e){return[e]}));return n=li(n),Fr(e,t,(function(e,t){return n(e,t[0])}))}var Wl=Jo(El),Dl=Jo(Ol);function Ul(e){return null==e?[]:qn(e,El(e))}var $l=jo((function(e,n,t){return n=n.toLowerCase(),e+(t?Fl(n):n)}));function Fl(e){return Kl(xl(e).toLowerCase())}function Ql(e){return(e=xl(e))&&e.replace(ye,Zn).replace(qe,"")}var ql=jo((function(e,n,t){return e+(t?"-":"")+n.toLowerCase()})),Hl=jo((function(e,n,t){return e+(t?" ":"")+n.toLowerCase()})),Vl=Bo("toLowerCase"),Gl=jo((function(e,n,t){return e+(t?"_":"")+n.toLowerCase()})),Jl=jo((function(e,n,t){return e+(t?" ":"")+Kl(n)})),Zl=jo((function(e,n,t){return e+(t?" ":"")+n.toUpperCase()})),Kl=Bo("toUpperCase");function Yl(e,n,t){return e=xl(e),(n=t?o:n)===o?function(e){return Je.test(e)}(e)?function(e){return e.match(Ve)||[]}(e):function(e){return e.match(ce)||[]}(e):e.match(n)||[]}var Xl=Gr((function(e,n){try{return yn(e,o,n)}catch(e){return Ka(e)?e:new _e(e)}})),ec=ni((function(e,n){return bn(n,(function(n){n=Ni(n),or(e,n,Ia(e[n],e))})),e}));function nc(e){return function(){return e}}var tc=No(),rc=No(!0);function oc(e){return e}function ic(e){return Br("function"==typeof e?e:lr(e,1))}var ac=Gr((function(e,n){return function(t){return Sr(t,e,n)}})),lc=Gr((function(e,n){return function(t){return Sr(e,t,n)}}));function cc(e,n,t){var r=El(n),o=_r(n,r);null!=t||nl(n)&&(o.length||!r.length)||(t=n,n=e,e=this,o=_r(n,El(n)));var i=!(nl(t)&&"chain"in t&&!t.chain),a=Ya(e);return bn(o,(function(t){var r=n[t];e[t]=r,a&&(e.prototype[t]=function(){var n=this.__chain__;if(i||n){var t=e(this.__wrapped__),o=t.__actions__=Lo(this.__actions__);return o.push({func:r,args:arguments,thisArg:e}),t.__chain__=n,t}return r.apply(e,zn([this.value()],arguments))})})),e}function uc(){}var sc=$o(Mn),fc=$o(wn),dc=$o(In);function pc(e){return xi(e)?Nn(Ni(e)):function(e){return function(n){return wr(n,e)}}(e)}var hc=Qo(),vc=Qo(!0);function gc(){return[]}function mc(){return!1}var yc,xc=Uo((function(e,n){return e+n}),0),bc=Vo("ceil"),_c=Uo((function(e,n){return e/n}),1),wc=Vo("floor"),kc=Uo((function(e,n){return e*n}),1),Cc=Vo("round"),Ac=Uo((function(e,n){return e-n}),0);return Wt.after=function(e,n){if("function"!=typeof n)throw new ze(i);return e=vl(e),function(){if(--e<1)return n.apply(this,arguments)}},Wt.ary=La,Wt.assign=bl,Wt.assignIn=_l,Wt.assignInWith=wl,Wt.assignWith=kl,Wt.at=Cl,Wt.before=Sa,Wt.bind=Ia,Wt.bindAll=ec,Wt.bindKey=Pa,Wt.castArray=function(){if(!arguments.length)return[];var e=arguments[0];return qa(e)?e:[e]},Wt.chain=pa,Wt.chunk=function(e,n,t){n=(t?yi(e,n,t):n===o)?1:mt(vl(n),0);var i=null==e?0:e.length;if(!i||n<1)return[];for(var a=0,l=0,c=r(st(i/n));a<i;)c[l++]=no(e,a,a+=n);return c},Wt.compact=function(e){for(var n=-1,t=null==e?0:e.length,r=0,o=[];++n<t;){var i=e[n];i&&(o[r++]=i)}return o},Wt.concat=function(){var e=arguments.length;if(!e)return[];for(var n=r(e-1),t=arguments[0],o=e;o--;)n[o-1]=arguments[o];return zn(qa(t)?Lo(t):[t],gr(n,1))},Wt.cond=function(e){var n=null==e?0:e.length,t=li();return e=n?Mn(e,(function(e){if("function"!=typeof e[1])throw new ze(i);return[t(e[0]),e[1]]})):[],Gr((function(t){for(var r=-1;++r<n;){var o=e[r];if(yn(o[0],this,t))return yn(o[1],this,t)}}))},Wt.conforms=function(e){return function(e){var n=El(e);return function(t){return cr(t,e,n)}}(lr(e,1))},Wt.constant=nc,Wt.countBy=ga,Wt.create=function(e,n){var t=Dt(e);return null==n?t:rr(t,n)},Wt.curry=function e(n,t,r){var i=Zo(n,8,o,o,o,o,o,t=r?o:t);return i.placeholder=e.placeholder,i},Wt.curryRight=function e(n,t,r){var i=Zo(n,16,o,o,o,o,o,t=r?o:t);return i.placeholder=e.placeholder,i},Wt.debounce=Ea,Wt.defaults=Al,Wt.defaultsDeep=Ml,Wt.defer=Oa,Wt.delay=Ba,Wt.difference=Ui,Wt.differenceBy=$i,Wt.differenceWith=Fi,Wt.drop=function(e,n,t){var r=null==e?0:e.length;return r?no(e,(n=t||n===o?1:vl(n))<0?0:n,r):[]},Wt.dropRight=function(e,n,t){var r=null==e?0:e.length;return r?no(e,0,(n=r-(n=t||n===o?1:vl(n)))<0?0:n):[]},Wt.dropRightWhile=function(e,n){return e&&e.length?fo(e,li(n,3),!0,!0):[]},Wt.dropWhile=function(e,n){return e&&e.length?fo(e,li(n,3),!0):[]},Wt.fill=function(e,n,t,r){var i=null==e?0:e.length;return i?(t&&"number"!=typeof t&&yi(e,n,t)&&(t=0,r=i),function(e,n,t,r){var i=e.length;for((t=vl(t))<0&&(t=-t>i?0:i+t),(r=r===o||r>i?i:vl(r))<0&&(r+=i),r=t>r?0:gl(r);t<r;)e[t++]=n;return e}(e,n,t,r)):[]},Wt.filter=function(e,n){return(qa(e)?kn:vr)(e,li(n,3))},Wt.flatMap=function(e,n){return gr(Ca(e,n),1)},Wt.flatMapDeep=function(e,n){return gr(Ca(e,n),s)},Wt.flatMapDepth=function(e,n,t){return t=t===o?1:vl(t),gr(Ca(e,n),t)},Wt.flatten=Hi,Wt.flattenDeep=function(e){return null!=e&&e.length?gr(e,s):[]},Wt.flattenDepth=function(e,n){return null!=e&&e.length?gr(e,n=n===o?1:vl(n)):[]},Wt.flip=function(e){return Zo(e,512)},Wt.flow=tc,Wt.flowRight=rc,Wt.fromPairs=function(e){for(var n=-1,t=null==e?0:e.length,r={};++n<t;){var o=e[n];r[o[0]]=o[1]}return r},Wt.functions=function(e){return null==e?[]:_r(e,El(e))},Wt.functionsIn=function(e){return null==e?[]:_r(e,Ol(e))},Wt.groupBy=_a,Wt.initial=function(e){return null!=e&&e.length?no(e,0,-1):[]},Wt.intersection=Gi,Wt.intersectionBy=Ji,Wt.intersectionWith=Zi,Wt.invert=Sl,Wt.invertBy=Il,Wt.invokeMap=wa,Wt.iteratee=ic,Wt.keyBy=ka,Wt.keys=El,Wt.keysIn=Ol,Wt.map=Ca,Wt.mapKeys=function(e,n){var t={};return n=li(n,3),xr(e,(function(e,r,o){or(t,n(e,r,o),e)})),t},Wt.mapValues=function(e,n){var t={};return n=li(n,3),xr(e,(function(e,r,o){or(t,r,n(e,r,o))})),t},Wt.matches=function(e){return Nr(lr(e,1))},Wt.matchesProperty=function(e,n){return Wr(e,lr(n,1))},Wt.memoize=ja,Wt.merge=Bl,Wt.mergeWith=jl,Wt.method=ac,Wt.methodOf=lc,Wt.mixin=cc,Wt.negate=Ta,Wt.nthArg=function(e){return e=vl(e),Gr((function(n){return Ur(n,e)}))},Wt.omit=Tl,Wt.omitBy=function(e,n){return Nl(e,Ta(li(n)))},Wt.once=function(e){return Sa(2,e)},Wt.orderBy=function(e,n,t,r){return null==e?[]:(qa(n)||(n=null==n?[]:[n]),qa(t=r?o:t)||(t=null==t?[]:[t]),$r(e,n,t))},Wt.over=sc,Wt.overArgs=Ra,Wt.overEvery=fc,Wt.overSome=dc,Wt.partial=Na,Wt.partialRight=Wa,Wt.partition=Aa,Wt.pick=Rl,Wt.pickBy=Nl,Wt.property=pc,Wt.propertyOf=function(e){return function(n){return null==e?o:wr(e,n)}},Wt.pull=Yi,Wt.pullAll=Xi,Wt.pullAllBy=function(e,n,t){return e&&e.length&&n&&n.length?Qr(e,n,li(t,2)):e},Wt.pullAllWith=function(e,n,t){return e&&e.length&&n&&n.length?Qr(e,n,o,t):e},Wt.pullAt=ea,Wt.range=hc,Wt.rangeRight=vc,Wt.rearg=Da,Wt.reject=function(e,n){return(qa(e)?kn:vr)(e,Ta(li(n,3)))},Wt.remove=function(e,n){var t=[];if(!e||!e.length)return t;var r=-1,o=[],i=e.length;for(n=li(n,3);++r<i;){var a=e[r];n(a,r,e)&&(t.push(a),o.push(r))}return qr(e,o),t},Wt.rest=function(e,n){if("function"!=typeof e)throw new ze(i);return Gr(e,n=n===o?n:vl(n))},Wt.reverse=na,Wt.sampleSize=function(e,n,t){return n=(t?yi(e,n,t):n===o)?1:vl(n),(qa(e)?Kt:Zr)(e,n)},Wt.set=function(e,n,t){return null==e?e:Kr(e,n,t)},Wt.setWith=function(e,n,t,r){return r="function"==typeof r?r:o,null==e?e:Kr(e,n,t,r)},Wt.shuffle=function(e){return(qa(e)?Yt:eo)(e)},Wt.slice=function(e,n,t){var r=null==e?0:e.length;return r?(t&&"number"!=typeof t&&yi(e,n,t)?(n=0,t=r):(n=null==n?0:vl(n),t=t===o?r:vl(t)),no(e,n,t)):[]},Wt.sortBy=Ma,Wt.sortedUniq=function(e){return e&&e.length?io(e):[]},Wt.sortedUniqBy=function(e,n){return e&&e.length?io(e,li(n,2)):[]},Wt.split=function(e,n,t){return t&&"number"!=typeof t&&yi(e,n,t)&&(n=t=o),(t=t===o?p:t>>>0)?(e=xl(e))&&("string"==typeof n||null!=n&&!al(n))&&!(n=lo(n))&&Xn(e)?bo(at(e),0,t):e.split(n,t):[]},Wt.spread=function(e,n){if("function"!=typeof e)throw new ze(i);return n=null==n?0:mt(vl(n),0),Gr((function(t){var r=t[n],o=bo(t,0,n);return r&&zn(o,r),yn(e,this,o)}))},Wt.tail=function(e){var n=null==e?0:e.length;return n?no(e,1,n):[]},Wt.take=function(e,n,t){return e&&e.length?no(e,0,(n=t||n===o?1:vl(n))<0?0:n):[]},Wt.takeRight=function(e,n,t){var r=null==e?0:e.length;return r?no(e,(n=r-(n=t||n===o?1:vl(n)))<0?0:n,r):[]},Wt.takeRightWhile=function(e,n){return e&&e.length?fo(e,li(n,3),!1,!0):[]},Wt.takeWhile=function(e,n){return e&&e.length?fo(e,li(n,3)):[]},Wt.tap=function(e,n){return n(e),e},Wt.throttle=function(e,n,t){var r=!0,o=!0;if("function"!=typeof e)throw new ze(i);return nl(t)&&(r="leading"in t?!!t.leading:r,o="trailing"in t?!!t.trailing:o),Ea(e,n,{leading:r,maxWait:n,trailing:o})},Wt.thru=ha,Wt.toArray=pl,Wt.toPairs=Wl,Wt.toPairsIn=Dl,Wt.toPath=function(e){return qa(e)?Mn(e,Ni):ul(e)?[e]:Lo(Ri(xl(e)))},Wt.toPlainObject=yl,Wt.transform=function(e,n,t){var r=qa(e),o=r||Ja(e)||sl(e);if(n=li(n,4),null==t){var i=e&&e.constructor;t=o?r?new i:[]:nl(e)&&Ya(i)?Dt(He(e)):{}}return(o?bn:xr)(e,(function(e,r,o){return n(t,e,r,o)})),t},Wt.unary=function(e){return La(e,1)},Wt.union=ta,Wt.unionBy=ra,Wt.unionWith=oa,Wt.uniq=function(e){return e&&e.length?co(e):[]},Wt.uniqBy=function(e,n){return e&&e.length?co(e,li(n,2)):[]},Wt.uniqWith=function(e,n){return n="function"==typeof n?n:o,e&&e.length?co(e,o,n):[]},Wt.unset=function(e,n){return null==e||uo(e,n)},Wt.unzip=ia,Wt.unzipWith=aa,Wt.update=function(e,n,t){return null==e?e:so(e,n,mo(t))},Wt.updateWith=function(e,n,t,r){return r="function"==typeof r?r:o,null==e?e:so(e,n,mo(t),r)},Wt.values=Ul,Wt.valuesIn=function(e){return null==e?[]:qn(e,Ol(e))},Wt.without=la,Wt.words=Yl,Wt.wrap=function(e,n){return Na(mo(n),e)},Wt.xor=ca,Wt.xorBy=ua,Wt.xorWith=sa,Wt.zip=fa,Wt.zipObject=function(e,n){return vo(e||[],n||[],er)},Wt.zipObjectDeep=function(e,n){return vo(e||[],n||[],Kr)},Wt.zipWith=da,Wt.entries=Wl,Wt.entriesIn=Dl,Wt.extend=_l,Wt.extendWith=wl,cc(Wt,Wt),Wt.add=xc,Wt.attempt=Xl,Wt.camelCase=$l,Wt.capitalize=Fl,Wt.ceil=bc,Wt.clamp=function(e,n,t){return t===o&&(t=n,n=o),t!==o&&(t=(t=ml(t))==t?t:0),n!==o&&(n=(n=ml(n))==n?n:0),ar(ml(e),n,t)},Wt.clone=function(e){return lr(e,4)},Wt.cloneDeep=function(e){return lr(e,5)},Wt.cloneDeepWith=function(e,n){return lr(e,5,n="function"==typeof n?n:o)},Wt.cloneWith=function(e,n){return lr(e,4,n="function"==typeof n?n:o)},Wt.conformsTo=function(e,n){return null==n||cr(e,n,El(n))},Wt.deburr=Ql,Wt.defaultTo=function(e,n){return null==e||e!=e?n:e},Wt.divide=_c,Wt.endsWith=function(e,n,t){e=xl(e),n=lo(n);var r=e.length,i=t=t===o?r:ar(vl(t),0,r);return(t-=n.length)>=0&&e.slice(t,i)==n},Wt.eq=Ua,Wt.escape=function(e){return(e=xl(e))&&G.test(e)?e.replace(H,Kn):e},Wt.escapeRegExp=function(e){return(e=xl(e))&&te.test(e)?e.replace(ne,"\\$&"):e},Wt.every=function(e,n,t){var r=qa(e)?wn:pr;return t&&yi(e,n,t)&&(n=o),r(e,li(n,3))},Wt.find=ma,Wt.findIndex=Qi,Wt.findKey=function(e,n){return En(e,li(n,3),xr)},Wt.findLast=ya,Wt.findLastIndex=qi,Wt.findLastKey=function(e,n){return En(e,li(n,3),br)},Wt.floor=wc,Wt.forEach=xa,Wt.forEachRight=ba,Wt.forIn=function(e,n){return null==e?e:mr(e,li(n,3),Ol)},Wt.forInRight=function(e,n){return null==e?e:yr(e,li(n,3),Ol)},Wt.forOwn=function(e,n){return e&&xr(e,li(n,3))},Wt.forOwnRight=function(e,n){return e&&br(e,li(n,3))},Wt.get=zl,Wt.gt=$a,Wt.gte=Fa,Wt.has=function(e,n){return null!=e&&hi(e,n,Mr)},Wt.hasIn=Ll,Wt.head=Vi,Wt.identity=oc,Wt.includes=function(e,n,t,r){e=Va(e)?e:Ul(e),t=t&&!r?vl(t):0;var o=e.length;return t<0&&(t=mt(o+t,0)),cl(e)?t<=o&&e.indexOf(n,t)>-1:!!o&&Bn(e,n,t)>-1},Wt.indexOf=function(e,n,t){var r=null==e?0:e.length;if(!r)return-1;var o=null==t?0:vl(t);return o<0&&(o=mt(r+o,0)),Bn(e,n,o)},Wt.inRange=function(e,n,t){return n=hl(n),t===o?(t=n,n=0):t=hl(t),function(e,n,t){return e>=yt(n,t)&&e<mt(n,t)}(e=ml(e),n,t)},Wt.invoke=Pl,Wt.isArguments=Qa,Wt.isArray=qa,Wt.isArrayBuffer=Ha,Wt.isArrayLike=Va,Wt.isArrayLikeObject=Ga,Wt.isBoolean=function(e){return!0===e||!1===e||tl(e)&&Cr(e)==m},Wt.isBuffer=Ja,Wt.isDate=Za,Wt.isElement=function(e){return tl(e)&&1===e.nodeType&&!il(e)},Wt.isEmpty=function(e){if(null==e)return!0;if(Va(e)&&(qa(e)||"string"==typeof e||"function"==typeof e.splice||Ja(e)||sl(e)||Qa(e)))return!e.length;var n=pi(e);if(n==w||n==z)return!e.size;if(wi(e))return!jr(e).length;for(var t in e)if(Oe.call(e,t))return!1;return!0},Wt.isEqual=function(e,n){return Pr(e,n)},Wt.isEqualWith=function(e,n,t){var r=(t="function"==typeof t?t:o)?t(e,n):o;return r===o?Pr(e,n,o,t):!!r},Wt.isError=Ka,Wt.isFinite=function(e){return"number"==typeof e&&ht(e)},Wt.isFunction=Ya,Wt.isInteger=Xa,Wt.isLength=el,Wt.isMap=rl,Wt.isMatch=function(e,n){return e===n||Er(e,n,ui(n))},Wt.isMatchWith=function(e,n,t){return t="function"==typeof t?t:o,Er(e,n,ui(n),t)},Wt.isNaN=function(e){return ol(e)&&e!=+e},Wt.isNative=function(e){if(_i(e))throw new _e("Unsupported core-js use. Try https://npms.io/search?q=ponyfill.");return Or(e)},Wt.isNil=function(e){return null==e},Wt.isNull=function(e){return null===e},Wt.isNumber=ol,Wt.isObject=nl,Wt.isObjectLike=tl,Wt.isPlainObject=il,Wt.isRegExp=al,Wt.isSafeInteger=function(e){return Xa(e)&&e>=-9007199254740991&&e<=f},Wt.isSet=ll,Wt.isString=cl,Wt.isSymbol=ul,Wt.isTypedArray=sl,Wt.isUndefined=function(e){return e===o},Wt.isWeakMap=function(e){return tl(e)&&pi(e)==I},Wt.isWeakSet=function(e){return tl(e)&&"[object WeakSet]"==Cr(e)},Wt.join=function(e,n){return null==e?"":vt.call(e,n)},Wt.kebabCase=ql,Wt.last=Ki,Wt.lastIndexOf=function(e,n,t){var r=null==e?0:e.length;if(!r)return-1;var i=r;return t!==o&&(i=(i=vl(t))<0?mt(r+i,0):yt(i,r-1)),n==n?function(e,n,t){for(var r=t+1;r--;)if(e[r]===n)return r;return r}(e,n,i):On(e,Tn,i,!0)},Wt.lowerCase=Hl,Wt.lowerFirst=Vl,Wt.lt=fl,Wt.lte=dl,Wt.max=function(e){return e&&e.length?hr(e,oc,Ar):o},Wt.maxBy=function(e,n){return e&&e.length?hr(e,li(n,2),Ar):o},Wt.mean=function(e){return Rn(e,oc)},Wt.meanBy=function(e,n){return Rn(e,li(n,2))},Wt.min=function(e){return e&&e.length?hr(e,oc,Tr):o},Wt.minBy=function(e,n){return e&&e.length?hr(e,li(n,2),Tr):o},Wt.stubArray=gc,Wt.stubFalse=mc,Wt.stubObject=function(){return{}},Wt.stubString=function(){return""},Wt.stubTrue=function(){return!0},Wt.multiply=kc,Wt.nth=function(e,n){return e&&e.length?Ur(e,vl(n)):o},Wt.noConflict=function(){return an._===this&&(an._=Ne),this},Wt.noop=uc,Wt.now=za,Wt.pad=function(e,n,t){e=xl(e);var r=(n=vl(n))?it(e):0;if(!n||r>=n)return e;var o=(n-r)/2;return Fo(ft(o),t)+e+Fo(st(o),t)},Wt.padEnd=function(e,n,t){e=xl(e);var r=(n=vl(n))?it(e):0;return n&&r<n?e+Fo(n-r,t):e},Wt.padStart=function(e,n,t){e=xl(e);var r=(n=vl(n))?it(e):0;return n&&r<n?Fo(n-r,t)+e:e},Wt.parseInt=function(e,n,t){return t||null==n?n=0:n&&(n=+n),bt(xl(e).replace(re,""),n||0)},Wt.random=function(e,n,t){if(t&&"boolean"!=typeof t&&yi(e,n,t)&&(n=t=o),t===o&&("boolean"==typeof n?(t=n,n=o):"boolean"==typeof e&&(t=e,e=o)),e===o&&n===o?(e=0,n=1):(e=hl(e),n===o?(n=e,e=0):n=hl(n)),e>n){var r=e;e=n,n=r}if(t||e%1||n%1){var i=_t();return yt(e+i*(n-e+nn("1e-"+((i+"").length-1))),n)}return Hr(e,n)},Wt.reduce=function(e,n,t){var r=qa(e)?Ln:Dn,o=arguments.length<3;return r(e,li(n,4),t,o,fr)},Wt.reduceRight=function(e,n,t){var r=qa(e)?Sn:Dn,o=arguments.length<3;return r(e,li(n,4),t,o,dr)},Wt.repeat=function(e,n,t){return n=(t?yi(e,n,t):n===o)?1:vl(n),Vr(xl(e),n)},Wt.replace=function(){var e=arguments,n=xl(e[0]);return e.length<3?n:n.replace(e[1],e[2])},Wt.result=function(e,n,t){var r=-1,i=(n=yo(n,e)).length;for(i||(i=1,e=o);++r<i;){var a=null==e?o:e[Ni(n[r])];a===o&&(r=i,a=t),e=Ya(a)?a.call(e):a}return e},Wt.round=Cc,Wt.runInContext=e,Wt.sample=function(e){return(qa(e)?Zt:Jr)(e)},Wt.size=function(e){if(null==e)return 0;if(Va(e))return cl(e)?it(e):e.length;var n=pi(e);return n==w||n==z?e.size:jr(e).length},Wt.snakeCase=Gl,Wt.some=function(e,n,t){var r=qa(e)?In:to;return t&&yi(e,n,t)&&(n=o),r(e,li(n,3))},Wt.sortedIndex=function(e,n){return ro(e,n)},Wt.sortedIndexBy=function(e,n,t){return oo(e,n,li(t,2))},Wt.sortedIndexOf=function(e,n){var t=null==e?0:e.length;if(t){var r=ro(e,n);if(r<t&&Ua(e[r],n))return r}return-1},Wt.sortedLastIndex=function(e,n){return ro(e,n,!0)},Wt.sortedLastIndexBy=function(e,n,t){return oo(e,n,li(t,2),!0)},Wt.sortedLastIndexOf=function(e,n){if(null!=e&&e.length){var t=ro(e,n,!0)-1;if(Ua(e[t],n))return t}return-1},Wt.startCase=Jl,Wt.startsWith=function(e,n,t){return e=xl(e),t=null==t?0:ar(vl(t),0,e.length),n=lo(n),e.slice(t,t+n.length)==n},Wt.subtract=Ac,Wt.sum=function(e){return e&&e.length?Un(e,oc):0},Wt.sumBy=function(e,n){return e&&e.length?Un(e,li(n,2)):0},Wt.template=function(e,n,t){var r=Wt.templateSettings;t&&yi(e,n,t)&&(n=o),e=xl(e),n=wl({},n,r,Ko);var i,a,l=wl({},n.imports,r.imports,Ko),c=El(l),u=qn(l,c),s=0,f=n.interpolate||xe,d="__p += '",p=Ae((n.escape||xe).source+"|"+f.source+"|"+(f===K?fe:xe).source+"|"+(n.evaluate||xe).source+"|$","g"),h="//# sourceURL="+(Oe.call(n,"sourceURL")?(n.sourceURL+"").replace(/\s/g," "):"lodash.templateSources["+ ++Ke+"]")+"\n";e.replace(p,(function(n,t,r,o,l,c){return r||(r=o),d+=e.slice(s,c).replace(be,Yn),t&&(i=!0,d+="' +\n__e("+t+") +\n'"),l&&(a=!0,d+="';\n"+l+";\n__p += '"),r&&(d+="' +\n((__t = ("+r+")) == null ? '' : __t) +\n'"),s=c+n.length,n})),d+="';\n";var v=Oe.call(n,"variable")&&n.variable;if(v){if(ue.test(v))throw new _e("Invalid `variable` option passed into `_.template`")}else d="with (obj) {\n"+d+"\n}\n";d=(a?d.replace($,""):d).replace(F,"$1").replace(Q,"$1;"),d="function("+(v||"obj")+") {\n"+(v?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(i?", __e = _.escape":"")+(a?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+d+"return __p\n}";var g=Xl((function(){return we(c,h+"return "+d).apply(o,u)}));if(g.source=d,Ka(g))throw g;return g},Wt.times=function(e,n){if((e=vl(e))<1||e>f)return[];var t=p,r=yt(e,p);n=li(n),e-=p;for(var o=$n(r,n);++t<e;)n(t);return o},Wt.toFinite=hl,Wt.toInteger=vl,Wt.toLength=gl,Wt.toLower=function(e){return xl(e).toLowerCase()},Wt.toNumber=ml,Wt.toSafeInteger=function(e){return e?ar(vl(e),-9007199254740991,f):0===e?e:0},Wt.toString=xl,Wt.toUpper=function(e){return xl(e).toUpperCase()},Wt.trim=function(e,n,t){if((e=xl(e))&&(t||n===o))return Fn(e);if(!e||!(n=lo(n)))return e;var r=at(e),i=at(n);return bo(r,Vn(r,i),Gn(r,i)+1).join("")},Wt.trimEnd=function(e,n,t){if((e=xl(e))&&(t||n===o))return e.slice(0,lt(e)+1);if(!e||!(n=lo(n)))return e;var r=at(e);return bo(r,0,Gn(r,at(n))+1).join("")},Wt.trimStart=function(e,n,t){if((e=xl(e))&&(t||n===o))return e.replace(re,"");if(!e||!(n=lo(n)))return e;var r=at(e);return bo(r,Vn(r,at(n))).join("")},Wt.truncate=function(e,n){var t=30,r="...";if(nl(n)){var i="separator"in n?n.separator:i;t="length"in n?vl(n.length):t,r="omission"in n?lo(n.omission):r}var a=(e=xl(e)).length;if(Xn(e)){var l=at(e);a=l.length}if(t>=a)return e;var c=t-it(r);if(c<1)return r;var u=l?bo(l,0,c).join(""):e.slice(0,c);if(i===o)return u+r;if(l&&(c+=u.length-c),al(i)){if(e.slice(c).search(i)){var s,f=u;for(i.global||(i=Ae(i.source,xl(de.exec(i))+"g")),i.lastIndex=0;s=i.exec(f);)var d=s.index;u=u.slice(0,d===o?c:d)}}else if(e.indexOf(lo(i),c)!=c){var p=u.lastIndexOf(i);p>-1&&(u=u.slice(0,p))}return u+r},Wt.unescape=function(e){return(e=xl(e))&&V.test(e)?e.replace(q,ct):e},Wt.uniqueId=function(e){var n=++Be;return xl(e)+n},Wt.upperCase=Zl,Wt.upperFirst=Kl,Wt.each=xa,Wt.eachRight=ba,Wt.first=Vi,cc(Wt,(yc={},xr(Wt,(function(e,n){Oe.call(Wt.prototype,n)||(yc[n]=e)})),yc),{chain:!1}),Wt.VERSION="4.17.21",bn(["bind","bindKey","curry","curryRight","partial","partialRight"],(function(e){Wt[e].placeholder=Wt})),bn(["drop","take"],(function(e,n){Ft.prototype[e]=function(t){t=t===o?1:mt(vl(t),0);var r=this.__filtered__&&!n?new Ft(this):this.clone();return r.__filtered__?r.__takeCount__=yt(t,r.__takeCount__):r.__views__.push({size:yt(t,p),type:e+(r.__dir__<0?"Right":"")}),r},Ft.prototype[e+"Right"]=function(n){return this.reverse()[e](n).reverse()}})),bn(["filter","map","takeWhile"],(function(e,n){var t=n+1,r=1==t||3==t;Ft.prototype[e]=function(e){var n=this.clone();return n.__iteratees__.push({iteratee:li(e,3),type:t}),n.__filtered__=n.__filtered__||r,n}})),bn(["head","last"],(function(e,n){var t="take"+(n?"Right":"");Ft.prototype[e]=function(){return this[t](1).value()[0]}})),bn(["initial","tail"],(function(e,n){var t="drop"+(n?"":"Right");Ft.prototype[e]=function(){return this.__filtered__?new Ft(this):this[t](1)}})),Ft.prototype.compact=function(){return this.filter(oc)},Ft.prototype.find=function(e){return this.filter(e).head()},Ft.prototype.findLast=function(e){return this.reverse().find(e)},Ft.prototype.invokeMap=Gr((function(e,n){return"function"==typeof e?new Ft(this):this.map((function(t){return Sr(t,e,n)}))})),Ft.prototype.reject=function(e){return this.filter(Ta(li(e)))},Ft.prototype.slice=function(e,n){e=vl(e);var t=this;return t.__filtered__&&(e>0||n<0)?new Ft(t):(e<0?t=t.takeRight(-e):e&&(t=t.drop(e)),n!==o&&(t=(n=vl(n))<0?t.dropRight(-n):t.take(n-e)),t)},Ft.prototype.takeRightWhile=function(e){return this.reverse().takeWhile(e).reverse()},Ft.prototype.toArray=function(){return this.take(p)},xr(Ft.prototype,(function(e,n){var t=/^(?:filter|find|map|reject)|While$/.test(n),r=/^(?:head|last)$/.test(n),i=Wt[r?"take"+("last"==n?"Right":""):n],a=r||/^find/.test(n);i&&(Wt.prototype[n]=function(){var n=this.__wrapped__,l=r?[1]:arguments,c=n instanceof Ft,u=l[0],s=c||qa(n),f=function(e){var n=i.apply(Wt,zn([e],l));return r&&d?n[0]:n};s&&t&&"function"==typeof u&&1!=u.length&&(c=s=!1);var d=this.__chain__,p=!!this.__actions__.length,h=a&&!d,v=c&&!p;if(!a&&s){n=v?n:new Ft(this);var g=e.apply(n,l);return g.__actions__.push({func:ha,args:[f],thisArg:o}),new $t(g,d)}return h&&v?e.apply(this,l):(g=this.thru(f),h?r?g.value()[0]:g.value():g)})})),bn(["pop","push","shift","sort","splice","unshift"],(function(e){var n=Le[e],t=/^(?:push|sort|unshift)$/.test(e)?"tap":"thru",r=/^(?:pop|shift)$/.test(e);Wt.prototype[e]=function(){var e=arguments;if(r&&!this.__chain__){var o=this.value();return n.apply(qa(o)?o:[],e)}return this[t]((function(t){return n.apply(qa(t)?t:[],e)}))}})),xr(Ft.prototype,(function(e,n){var t=Wt[n];if(t){var r=t.name+"";Oe.call(It,r)||(It[r]=[]),It[r].push({name:n,func:t})}})),It[Wo(o,2).name]=[{name:"wrapper",func:o}],Ft.prototype.clone=function(){var e=new Ft(this.__wrapped__);return e.__actions__=Lo(this.__actions__),e.__dir__=this.__dir__,e.__filtered__=this.__filtered__,e.__iteratees__=Lo(this.__iteratees__),e.__takeCount__=this.__takeCount__,e.__views__=Lo(this.__views__),e},Ft.prototype.reverse=function(){if(this.__filtered__){var e=new Ft(this);e.__dir__=-1,e.__filtered__=!0}else(e=this.clone()).__dir__*=-1;return e},Ft.prototype.value=function(){var e=this.__wrapped__.value(),n=this.__dir__,t=qa(e),r=n<0,o=t?e.length:0,i=function(e,n,t){for(var r=-1,o=t.length;++r<o;){var i=t[r],a=i.size;switch(i.type){case"drop":e+=a;break;case"dropRight":n-=a;break;case"take":n=yt(n,e+a);break;case"takeRight":e=mt(e,n-a)}}return{start:e,end:n}}(0,o,this.__views__),a=i.start,l=i.end,c=l-a,u=r?l:a-1,s=this.__iteratees__,f=s.length,d=0,p=yt(c,this.__takeCount__);if(!t||!r&&o==c&&p==c)return po(e,this.__actions__);var h=[];e:for(;c--&&d<p;){for(var v=-1,g=e[u+=n];++v<f;){var m=s[v],y=m.iteratee,x=m.type,b=y(g);if(2==x)g=b;else if(!b){if(1==x)continue e;break e}}h[d++]=g}return h},Wt.prototype.at=va,Wt.prototype.chain=function(){return pa(this)},Wt.prototype.commit=function(){return new $t(this.value(),this.__chain__)},Wt.prototype.next=function(){this.__values__===o&&(this.__values__=pl(this.value()));var e=this.__index__>=this.__values__.length;return{done:e,value:e?o:this.__values__[this.__index__++]}},Wt.prototype.plant=function(e){for(var n,t=this;t instanceof Ut;){var r=Di(t);r.__index__=0,r.__values__=o,n?i.__wrapped__=r:n=r;var i=r;t=t.__wrapped__}return i.__wrapped__=e,n},Wt.prototype.reverse=function(){var e=this.__wrapped__;if(e instanceof Ft){var n=e;return this.__actions__.length&&(n=new Ft(this)),(n=n.reverse()).__actions__.push({func:ha,args:[na],thisArg:o}),new $t(n,this.__chain__)}return this.thru(na)},Wt.prototype.toJSON=Wt.prototype.valueOf=Wt.prototype.value=function(){return po(this.__wrapped__,this.__actions__)},Wt.prototype.first=Wt.prototype.head,ln&&(Wt.prototype[ln]=function(){return this}),Wt}();an._=ut,(r=function(){return ut}.call(n,t,n,e))===o||(e.exports=r)}.call(this)},666:(e,n,t)=>{"use strict";t.r(n),t.d(n,{default:()=>i});const r=window.$,o={minBracketWidth:6,interpretDashing:(e,n)=>{void 0!==e.dashed&&"dashed"===e.dashed&&(e.dashWidth?n["stroke-dasharray"]=e.dashWidth:n["stroke-dasharray"]=4)},generateArrowHeadElem:(e,n)=>{const t="arrowHead-"+(new Date).getTime(),r=document.createElementNS("http://www.w3.org/2000/svg","defs"),i=o.makeSvgElement("marker",{id:t,viewBox:"0 0 10 10",refX:8.7,refY:3,markerUnits:"strokeWidth",markerWidth:n,markerHeight:n,orient:"auto",stroke:e,fill:e}),a=o.makeSvgElement("path",{d:"M 0,0 L0,6 L9,3 z"});return i.appendChild(a),r.appendChild(i),{arrowHeadId:t,defs:r}},makeElementHtml:(e,n,t)=>{let o="<"+e+" ";"svg"===e&&(o+='xmlns="http://www.w3.org/2000/svg" version="1.1" class="bxySvg" ');let i="";return void 0!==n&&(i=r.map(n,((e,n)=>n+'="'+e+'"')).join(" ")),o+=void 0!==t?i+">"+t+"</"+e+">":i+"></"+e+">",o},makeSvgElement:(e,n)=>{const t=document.createElementNS("http://www.w3.org/2000/svg",e);"svg"===e&&(t.setAttribute("xmlns","http://www.w3.org/2000/svg"),t.setAttribute("version","1.1"),t.setAttribute("preserveAspectRatio","none"));for(let e in n)t.setAttribute(e,n[e]);return void 0!==n.text&&(t.textContent=n.text),t},makeDomElement:(e,n)=>{const t=document.createElement(e);for(let e in n)t.setAttribute(e,n[e]);return t},renderSvg:(e,n,t,i,a,l,c)=>{let u,s,f,d,p=r("#bxySvgGenerator");0===p.length&&(r("body").append(r('<div id="bxySvgGenerator"></div>')),p=r("#bxySvgGenerator"));for(let n of e){let e="";n.hasOwnProperty("cssTransform")&&(e="transform:"+n.cssTransform);let t="";n.hasOwnProperty("backgroundColor")&&(t="background:"+n.backgroundColor+";");let r="";n.hasOwnProperty("border")&&(r="border:"+n.border+";"),f={class:n.outerClass,style:"position:absolute;left:"+parseInt(n.x)+"px;top:"+parseInt(n.y)+"px;width:"+parseInt(n.width)+"px;height:"+parseInt(n.height)+"px;"+e+t+r},n.hasOwnProperty("title")&&(f.title=n.title),n.hasOwnProperty("metaTag")&&(d=n.metaTag.split("|"),f[d[0]]=d[1]),u=o.makeDomElement("div",f),s=o.makeSvgElement("svg",{width:n.width,height:n.height,viewBox:n.viewBox}),n.usesArrow&&s.appendChild(n.arrowHeadRecord.defs),s.appendChild(n.el),u.appendChild(s),p[0].appendChild(u)}const h=p[0].innerHTML;return p.empty(),h},makeLine:e=>{const n=e.endpoints,t=n.p1,r=n.p2,i={p1:{x:Math.min(t.x,r.x),y:Math.min(t.y,r.y)},p2:{x:Math.max(t.x,r.x),y:Math.max(t.y,r.y)}},a=void 0===e.color?"#000":e.color,l=void 0===e.strokeWidth?3:e.strokeWidth;let c;c=r.x<t.x&&r.y<t.y?{p1:{x:i.p2.x,y:i.p2.y},p2:{x:i.p1.x,y:i.p1.y}}:r.x<t.x?{p1:{x:i.p2.x,y:i.p1.y},p2:{x:i.p1.x,y:i.p2.y}}:r.y<t.y?{p1:{x:i.p1.x,y:i.p2.y},p2:{x:i.p2.x,y:i.p1.y}}:{p1:{x:i.p1.x,y:i.p1.y},p2:{x:i.p2.x,y:i.p2.y}};let u,s={"vector-effect":"non-scaling-stroke","stroke-width":l,stroke:a,fill:a,d:"M "+(c.p1.x-i.p1.x)+" "+(c.p1.y-i.p1.y)+" L "+(c.p2.x-i.p1.x)+" "+(c.p2.y-i.p1.y)};void 0!==e.usesArrow&&(u=o.generateArrowHeadElem(e.color,e.arrowHeadSize),s["marker-end"]="url(#"+u.arrowHeadId+")"),o.interpretDashing(e,s);const f=o.makeSvgElement("path",s),d=[-10,-10,Math.max(20,Math.abs(i.p2.x-i.p1.x)+20),Math.max(20,Math.abs(i.p2.y-i.p1.y)+20)];return o.renderSvg([{el:f,x:i.p1.x+e.lineStartOffset.x-10,y:i.p1.y+e.lineStartOffset.y-10,width:d[2],height:d[3],color:a,viewBox:d.join(" "),usesArrow:e.usesArrow,arrowHeadRecord:u,arrowHeadSize:e.arrowHeadSize}])},makeEllipse:e=>{const n=e.dimensions,t=e.buffer||4,r="0 0 "+n.width+" "+n.height,i=o.makeBufferedViewBox({buffer:t,bufferAllSides:!0,viewBox:r});let a={cx:n.width/2,cy:n.height/2,rx:Math.max(0,n.width/2-e.buffer),ry:Math.max(0,n.height/2-e.buffer),stroke:e.color,"stroke-width":e.strokeWidth,"fill-opacity":e.fillOpacity,fill:e.color};o.interpretDashing(e,a);const l={el:o.makeSvgElement("ellipse",a),x:n.x,y:n.y,width:n.width,height:n.height,viewBox:i};return o.renderSvg([l])},makeBullsEye:e=>{const n=e.dimensions,t=e.buffer||4,r="0 0 "+n.width+" "+n.height,i=o.makeBufferedViewBox({buffer:t,bufferAllSides:!0,viewBox:r});let a,l,c=[];const u=[1,5,9,13,17,3,7,11,15],s=void 0!==e.innerRingsColor?e.innerRingsColor:e.color,f=[e.color,e.color,e.color,e.color,e.color,s,s,s,s],d=[e.color,e.color,e.color,e.color,e.color,s,s,s,s];for(let t=0;t<u.length;++t)a={cx:n.width/2,cy:n.height/2,rx:u[t],ry:u[t],stroke:f[t],"stroke-width":e.strokeWidth,"fill-opacity":e.fillOpacity,fill:d[t]},l=o.makeSvgElement("ellipse",a),c.push({el:l,x:n.x,y:n.y,width:n.width,height:n.height,viewBox:i});return o.renderSvg(c)},makeBufferedViewBox:e=>{const n=2*e.buffer;let t,r;return r="string"==typeof e.viewBox?e.viewBox.split(" "):e.viewBox,t=e.bufferAllSides?[parseInt(r[0])-e.buffer,parseInt(r[1])-e.buffer,parseInt(r[2])+n,parseInt(r[3])+n]:[parseInt(r[0]),parseInt(r[1]),parseInt(r[2])+n,parseInt(r[3])+n],t.join(" ")},makeSimplePath:e=>{const n=void 0===e.buffer?4:e.buffer,t=2*n,r=o.makeBufferedViewBox({buffer:n,bufferAllSides:!0,viewBox:e.viewBox}),i=void 0===e.color?"#000":e.color,a=void 0===e.strokeWidth?3:e.strokeWidth,l=void 0===e.outerClass?"bxy-sticker-inner":e.outerClass;let c,u,s,f=[];for(let d of e.d)c={"vector-effect":"non-scaling-stroke","stroke-width":a,stroke:i,d},void 0!==e.fill?c.fill=e.fill:c["fill-opacity"]=0,void 0!==e.transform&&(c.transform=e.transform),void 0!==e.fillOpacity&&(c["fill-opacity"]=e.fillOpacity,c.fill=e.color),o.interpretDashing(e,c),u=o.makeSvgElement("path",c),s={el:u,x:e.dimensions.x-n,y:e.dimensions.y-n,width:e.dimensions.width+t,height:e.dimensions.height+t,outerClass:l,title:e.title,viewBox:r},void 0!==e.cssTransform&&(s.cssTransform=e.cssTransform),void 0!==e.metaTag&&(s.metaTag=e.metaTag),f.push(s);return o.renderSvg(f)},makeRightCurlyBracePath:e=>{let n={stroke:e.color,"stroke-width":e.strokeWidth||"3","vector-effect":"non-scaling-stroke","fill-opacity":0,d:"M0,0 A100, 173.20508075688772 0 0 1  100, 173.20508075688772 A100, 173.20508075688772 0 0 0 200 346.41016151377545 A100, 173.20508075688772 0 0 0 100, 519.6152422706632 A100, 173.20508075688772 0 0 1 0, 692.8203230275509"};return o.interpretDashing(e,n),o.makeSvgElement("path",n)},makeLeftCurlyBrace:e=>{const n=o.makeRightCurlyBracePath({dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth});return o.renderSvg([{el:n,width:8,height:e.dimensions.height,viewBox:"0 0 200 692",x:e.dimensions.x,y:e.dimensions.y,cssTransform:"scaleX(-1)"}])},makeRightCurlyBrace:e=>{const n=o.makeRightCurlyBracePath({dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth});return o.renderSvg([{el:n,width:8,height:e.dimensions.height,viewBox:"0 0 200 692",x:e.dimensions.x,y:e.dimensions.y}])},makeSymmetricCurlyBraces:e=>{const n="0 0 200 692",t=o.makeRightCurlyBracePath({dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth}),r=o.makeRightCurlyBracePath({dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth});return o.renderSvg([{el:t,width:8,height:e.dimensions.height,viewBox:n,x:e.dimensions.x-1,y:e.dimensions.y,cssTransform:"scaleX(-1)"},{el:r,width:8,height:e.dimensions.height,viewBox:n,x:e.dimensions.x+e.dimensions.width-8+1,y:e.dimensions.y,dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth}])},makeTopBracket:e=>{const n=e.dimensions.width,t=e.dimensions.height;return o.makeSimplePath(r.extend({},!0,e,{buffer:0,viewBox:[0,0,n,t],d:["M 0 "+t+" L 0 0 L "+n+" 0 L "+n+" "+t]}))},makeBottomBracket:e=>{const n=e.dimensions.width,t=e.dimensions.height;return o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,n,t],d:["M 0 0 L 0 "+t+" L "+n+" "+t+" L "+n+"0"]}))},makeLeftBracket:e=>{const n=e.dimensions.width,t=e.dimensions.height;return o.makeSimplePath(r.extend({},!0,e,{buffer:0,viewBox:[0,0,n,t],d:["M "+n+" "+t+" L 0 "+t+" L 0 0 L "+n+" 0"]}))},makeRightBracket:e=>{const n=e.dimensions.width,t=e.dimensions.height;return o.makeSimplePath(r.extend({},!0,e,{buffer:0,viewBox:[0,0,n,t],d:["M 0 0 L "+n+" 0 L "+n+" "+t+" L 0 "+t]}))},makeHorizontalBrackets:e=>{const n=e.dimensions.width,t=e.dimensions.height,i=Math.min(o.minBracketWidth,parseInt(t/10)),a=Math.max(t-o.minBracketWidth,t-parseInt(t/10));return o.makeSimplePath(r.extend({},!0,e,{buffer:0,viewBox:[0,0,n,t],d:["M 0 "+i+" L 0 0 L "+n+" 0 L "+n+" "+i,"M 0 "+a+" L 0 "+t+" L "+n+" "+t+" L "+n+" "+a]}))},makeVerticalBrackets:e=>{const n=e.dimensions.width,t=e.dimensions.height,i=Math.min(o.minBracketWidth,parseInt(n/10)),a=Math.max(n-o.minBracketWidth,n-parseInt(n/10));return o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,n,t],d:["M "+i+" 0 L 0 0 L 0 "+t+" L "+i+" "+t,"M "+a+" 0 L "+n+" 0 L "+n+" "+t+" L "+a+" "+t]}))},makeRectangle:e=>{const n=e.dimensions,t=e.buffer||4,r="0 0 "+n.width+" "+n.height,i=o.makeBufferedViewBox({buffer:t,bufferAllSides:!0,viewBox:r});let a={x:0,y:0,width:n.width,height:n.height,stroke:e.color,fill:e.color,"stroke-width":e.strokeWidth,"fill-opacity":e.fillOpacity};o.interpretDashing(e,a),void 0!==e.rx&&(a.rx=e.rx,a.ry=e.ry);const l={el:o.makeSvgElement("rect",a),x:n.x,y:n.y,width:n.width,height:n.height,viewBox:i};return o.renderSvg([l])},makeRightTriangle:e=>o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,100,125],d:["M 0 125 L 100 125 L 0 0 Z"]})),makeIsocelesTriangle:e=>o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,100,125],d:["M 0 125 L 100 125 L 50 0 Z"]})),makeTheta:e=>o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,469,700],d:["M469 334c-2,440 -453,468 -469,2 -13,-435 472,-460 469,-2zm-383 -20l298 0c-9,-366 -288,-376 -298,-6l0 6zm297 46l-297 0c16,345 279,397 297,11 0,-4 0,-7 0,-11z"],fill:e.color})),makeSigma:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,16,16],d:["M2,1l5.46,7.27L2,15h12v-4h-1v1c0,0.552-0.448,1-1,1H4.97l4.39-5.52L5.25,2H12c0.552,0,1,0.448,1,1v1h1V1H2z"],fill:e.color})),makeSmiley:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,49,49],d:["M25,1A24,24,0,1,0,49,25,24,24,0,0,0,25,1Zm0,46A22,22,0,1,1,47,25,22,22,0,0,1,25,47ZM35.77,33.32a1,1,0,0,1-.13,1.41C31.73,38,28.06,39.1,24.9,39.1a16,16,0,0,1-10.63-4.45,1,1,0,0,1,1.45-1.38c0.34,0.35,8.35,8.52,18.63-.08A1,1,0,0,1,35.77,33.32ZM15,19a3,3,0,1,1,3,3A3,3,0,0,1,15,19Zm14,0a3,3,0,1,1,3,3A3,3,0,0,1,29,19Z"],fill:e.color})),makeFrowney:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,100,125],d:["M50,2.5C23.809,2.5,2.5,23.809,2.5,50S23.809,97.5,50,97.5S97.5,76.191,97.5,50S76.191,2.5,50,2.5z M50,91.684    C27.016,91.684,8.316,72.984,8.316,50S27.016,8.316,50,8.316S91.684,27.016,91.684,50S72.984,91.684,50,91.684z M37.489,41.386    c2.964,0,5.369-2.403,5.369-5.369c0-2.966-2.405-5.368-5.369-5.368c-2.966,0-5.369,2.402-5.369,5.368    C32.12,38.982,34.523,41.386,37.489,41.386z M62.511,41.386c2.965,0,5.369-2.403,5.369-5.369c0-2.966-2.404-5.368-5.369-5.368    c-2.966,0-5.368,2.402-5.368,5.368C57.143,38.982,59.545,41.386,62.511,41.386z M50.001,51.186    c-13.939,0-20.525,9.548-22.06,14.597c-0.467,1.537,0.399,3.161,1.936,3.628c1.539,0.471,3.161-0.399,3.628-1.936    c0.032-0.105,3.336-10.473,16.496-10.473c13.015,0,16.363,10.061,16.494,10.472c0.381,1.255,1.534,2.063,2.781,2.063    c0.28,0,0.564-0.04,0.846-0.127c1.538-0.467,2.405-2.091,1.938-3.627C70.524,60.733,63.939,51.186,50.001,51.186z"]})),makeThumbsUp:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,218,346.25],d:["M28 263l31 -9c64,42 77,13 92,10 4,0 1,4 17,0 22,-7 31,-19 23,-35 19,-6 21,-18 15,-33 15,-9 15,-26 3,-38 19,-37 -11,-67 -80,-48 -5,-36 11,-59 5,-80 -7,-27 -25,-31 -50,-30 3,68 8,35 -25,101 -27,55 -3,48 -57,63 -6,36 4,70 26,99zm4 -12c-16,-24 -23,-49 -21,-77 48,-14 33,-15 57,-65 33,-71 31,-34 27,-97 31,1 32,26 26,50 -7,27 -6,40 -1,62 26,-7 74,-21 82,6 7,27 -22,40 -35,41l-42 -7c9,-28 36,-19 44,-19l10 -3 7 -13c-29,8 -10,3 -31,4 -24,1 -40,15 -43,40l8 1c-8,7 -13,16 -14,28l9 1c-5,6 -10,15 -12,26l14 3c-5,7 -9,15 -11,26l29 4c-29,10 -50,-1 -74,-20l-29 9zm87 -58c12,-30 27,-10 49,-12 5,0 27,-7 33,-14 24,20 -36,32 -39,33l-43 -7zm-2 27l10 -15c44,7 28,8 70,-4 10,19 -35,26 -35,26l-45 -7zm3 30l9 -17c36,5 26,7 53,0 4,16 -17,22 -23,22l-39 -5z"],fill:e.color})),makeThumbsDown:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,226,357.5],d:["M18 27l33 4c59,-51 77,-23 92,-23 5,0 0,-4 18,-2 23,3 33,15 28,32 20,4 24,15 20,32 17,7 19,23 8,37 25,36 -1,70 -74,60 0,38 19,59 16,82 -3,27 -21,34 -46,37 -6,-70 3,-37 -40,-99 -35,-52 -10,-48 -67,-56 -11,-36 -6,-71 12,-104zm6 12c-13,26 -16,53 -10,81 51,7 35,11 67,58 44,66 36,29 41,95 32,-7 29,-32 19,-55 -11,-27 -11,-40 -9,-63 27,4 78,10 82,-18 4,-28 -28,-37 -41,-36l-42 13c13,27 39,14 48,13l10 1 9 12c-30,-4 -10,-1 -33,1 -23,2 -41,-9 -49,-34l8 -3c-8,-6 -15,-14 -18,-26l9 -3c-6,-5 -11,-13 -16,-24l15 -5c-7,-6 -12,-15 -15,-25l28 -8c-30,-7 -50,8 -72,30l-31 -4zm96 46c17,28 30,7 52,5 6,-1 29,4 36,9 21,-23 -42,-27 -44,-27l-44 13zm-5 -27l12 14c44,-13 27,-12 72,-6 7,-21 -39,-22 -40,-22l-44 14zm-1 -31l11 16c36,-11 26,-11 54,-7 2,-18 -20,-20 -27,-20l-38 11z"],fill:e.color})),makeStar:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,1024,1280],d:["M521.19122173 257.59668148l48.67463902 112.36592198c10.61521383 24.46677333 33.65799506 41.42522469 60.32548344 44.14375505l123.62840495 12.55702124-92.30057877 79.48464988c-20.71261235 17.86462815-29.90383408 45.43829333-23.8195042 72.10578173l27.44421136 121.68659752-105.37541531-64.20909827c-11.52139061-6.99050667-24.85513482-10.74466765-38.31833283-10.74466765-13.59265185 0-26.79694222 3.75416098-38.31833286 10.74466765l-105.37541529 64.20909827 27.44421135-121.68659752c5.95487605-26.66748839-3.10689185-54.24115358-23.8195042-72.10578173l-92.30057876-79.48464988 123.62840494-12.55702124c26.53803457-2.71853037 49.71026963-19.5475279 60.32548346-44.14375505l48.1568237-112.36592198m0-117.80298272c-6.2137837 0-12.55702124 3.3657995-15.40500543 10.09739852l-85.43952593 197.28763258c-2.45962272 5.56651457-7.63777581 9.45012939-13.72210568 10.09739853l-216.446799 22.00715063c-14.7577363 1.55344592-20.45370469 19.80643555-9.32067556 29.51547258l163.11182222 140.45740248c4.66033778 4.01306864 6.86105283 10.35630617 5.43706074 16.44063605l-48.1568237 213.98717629c-2.58907653 11.26248297 6.34323753 20.58315852 16.44063604 20.58315852 2.84798419 0 5.95487605-0.77672297 8.67340642-2.45962272l186.15460346-113.40155259c2.71853037-1.68289975 5.69596839-2.45962272 8.80286024-2.45962272s6.08432987 0.77672297 8.80286026 2.45962272l186.15460344 113.40155259c2.84798419 1.68289975 5.82542222 2.45962272 8.67340644 2.45962272 10.09739852 0 19.02971259-9.32067555 16.44063604-20.58315852L693.23535803 565.69679013c-1.4239921-6.08432987 0.77672297-12.42756741 5.43706073-16.44063605l163.11182222-140.45740248c11.26248297-9.70903703 5.43706075-27.96202667-9.32067555-29.51547258l-216.44679901-22.00715063c-6.08432987-0.64726914-11.26248297-4.40143013-13.72210567-10.09739853l-85.43952593-197.28763258c-3.23634569-6.73159902-9.45012939-10.09739852-15.66391309-10.09739852z"],fill:e.color})),makeRibbon:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:"0 0 100 100",d:["M76.979,12.22c-0.366-0.579-1.004-0.93-1.689-0.93H59.165c-0.768,0-1.468,0.439-1.802,1.132l-6.634,13.76l-7.117-13.808  c-0.343-0.666-1.028-1.084-1.777-1.084H24.71c-0.686,0-1.323,0.351-1.689,0.93c-0.367,0.579-0.411,1.306-0.118,1.926l15.213,32.151  c-6.585,4.021-10.99,11.274-10.99,19.538C27.125,78.448,37.387,88.71,50,88.71s22.875-10.262,22.875-22.875  c0-8.264-4.405-15.518-10.99-19.538l15.213-32.151C77.391,13.525,77.347,12.799,76.979,12.22z M27.869,15.29h12.747l14.572,28.271  C53.521,43.172,51.785,42.96,50,42.96c-2.927,0-5.724,0.559-8.299,1.564L27.869,15.29z M68.875,65.835  c0,10.407-8.468,18.875-18.875,18.875s-18.875-8.468-18.875-18.875S39.593,46.96,50,46.96S68.875,55.428,68.875,65.835z   M59.201,42.617l-6.178-11.984l7.397-15.343h11.71L59.201,42.617z M48.207,53.277l-2.999,6.074l-6.703,0.973  c-0.754,0.109-1.38,0.638-1.615,1.361s-0.039,1.519,0.506,2.051l4.852,4.728l-1.146,6.677c-0.128,0.75,0.181,1.509,0.796,1.956  c0.349,0.253,0.762,0.382,1.176,0.382c0.318,0,0.638-0.076,0.931-0.229L50,74.098l5.994,3.151c0.675,0.353,1.491,0.295,2.106-0.152  s0.924-1.206,0.796-1.956l-1.145-6.677l4.852-4.728c0.545-0.532,0.741-1.327,0.506-2.051s-0.861-1.252-1.615-1.361l-6.703-0.973  l-2.997-6.074c-0.337-0.683-1.032-1.115-1.794-1.115C49.239,52.162,48.544,52.595,48.207,53.277z M51.669,62.064  c0.292,0.591,0.855,1,1.507,1.095l3.732,0.542l-2.7,2.632c-0.472,0.46-0.687,1.122-0.576,1.771l0.638,3.72l-3.339-1.756  c-0.582-0.307-1.279-0.307-1.861,0l-3.34,1.756l0.638-3.72c0.11-0.648-0.104-1.311-0.575-1.771l-2.701-2.632l3.732-0.542  c0.651-0.095,1.215-0.504,1.506-1.095L50,58.682L51.669,62.064z"],fill:e.color})),makeAxis:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:e.strokeWidth,viewBox:"0 0 90 90",d:["M89.7,85.7c0,0.2-0.1,0.3-0.2,0.4l-3.2,2.2c-0.1,0.1-0.2,0.1-0.3,0.1c-0.1,0-0.2,0-0.2-0.1c-0.2-0.1-0.3-0.3-0.3-0.4v-1.2  H13c-0.6,0-1-0.4-1-1V15.8h-1.2c-0.2,0-0.4-0.1-0.4-0.3c-0.1-0.2-0.1-0.4,0-0.5l2.2-3.2c0.2-0.3,0.6-0.3,0.8,0l2.2,3.2  c0.1,0.2,0.1,0.4,0,0.5c-0.1,0.2-0.3,0.3-0.4,0.3H14v68.9h71.4v-1.2c0-0.2,0.1-0.4,0.3-0.4c0.2-0.1,0.4-0.1,0.5,0l3.2,2.2  C89.6,85.4,89.7,85.6,89.7,85.7z"],fill:"solid"})),makeBomb:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:e.strokeWidth,viewBox:"0 0 100 100",d:["M44.5,44.4v-3.9c0-1.1-0.9-2-2-2h-5.6c0-2.2,0.3-5.1,1.8-6.9c1.1-1.3,2.6-1.9,4.7-1.9c3.1,0,6.1,1.2,8.9,2.3  c5.4,2.2,11.1,4.4,16.9-1.6c0.6-0.6,0.6-1.5,0-2.1c-0.6-0.6-1.5-0.6-2.1,0c-4.4,4.6-8.5,3-13.6,0.9c-3.1-1.3-6.4-2.6-10-2.6  c-3,0-5.3,1-7,3c-2.2,2.6-2.5,6.3-2.5,8.8h-5.1c-1.1,0-2,0.9-2,2v3.9C18.3,47.9,12.3,56.3,12.3,66c0,12.9,10.4,23.3,23.3,23.3  S59,78.9,59,66C59,56.3,53,47.9,44.5,44.4z M32.9,80.3c-0.2,0.6-0.8,1.1-1.4,1.1c-0.1,0-0.3,0-0.4-0.1c-6.8-2-11.3-8.2-11.3-15.3  c0-3.5,1.1-6.9,3.3-9.7c0.5-0.7,1.4-0.8,2.1-0.3c0.7,0.5,0.8,1.4,0.3,2.1c-1.7,2.3-2.7,5-2.7,7.9c0,5.7,3.8,10.8,9.2,12.4  C32.7,78.6,33.2,79.5,32.9,80.3z","M82.3,14.5c0.5-0.6,0.5-1.6-0.2-2.1c-0.6-0.5-1.6-0.5-2.1,0.2l-8.6,10.1c-0.5,0.6-0.5,1.6,0.2,2.1c0.3,0.2,0.6,0.4,1,0.4  c0.4,0,0.8-0.2,1.1-0.5L82.3,14.5z","M60.7,13.9C60.7,13.9,60.7,13.9,60.7,13.9l3.9,8.7c0,0,0,0,0,0l0.5,1.1c0.3,0.6,0.8,0.9,1.4,0.9c0.2,0,0.4,0,0.6-0.1  c0.8-0.3,1.1-1.2,0.7-2l-0.5-1.1c0,0,0,0,0,0l-3.9-8.7c0,0,0,0,0,0l-0.5-1.1c-0.3-0.8-1.2-1.1-2-0.7c-0.8,0.3-1.1,1.2-0.7,2  L60.7,13.9z","M75.5,32.4c-0.6-0.6-1.6-0.5-2.1,0.1c-0.6,0.6-0.5,1.6,0.1,2.1l9.7,9.2c0.3,0.3,0.7,0.4,1,0.4c0.4,0,0.8-0.2,1.1-0.5  c0.6-0.6,0.5-1.6-0.1-2.1L75.5,32.4z","M86.2,26.6l-10.5,0c-0.8,0-1.5,0.7-1.5,1.5c0,0.8,0.7,1.5,1.5,1.5l10.5,0c0.8,0,1.5-0.7,1.5-1.5  C87.7,27.3,87,26.6,86.2,26.6z","M50.9,21.7l11.6,5.4c0.2,0.1,0.4,0.1,0.6,0.1c0.6,0,1.1-0.3,1.4-0.9c0.4-0.8,0-1.6-0.7-2L52.2,19c-0.7-0.4-1.6,0-2,0.7  C49.9,20.5,50.2,21.3,50.9,21.7z","M69.5,34.8c-0.8,0-1.5,0.7-1.5,1.5l0,11.3c0,0.8,0.7,1.5,1.5,1.5c0.8,0,1.5-0.7,1.5-1.5l0-11.3C71,35.4,70.4,34.8,69.5,34.8  z"],fill:e.color})),makeCheckmark:e=>{let n;return n=e.iconUsage?r.extend({},e.dimensions):{x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25),height:Math.max(e.dimensions.height,25)},o.makeSimplePath(r.extend({},!0,e,{strokeWidth:e.strokeWidth,viewBox:"0 0 587 783.75",d:["M0 303c61,65 122,129 184,194 134,-166 227,-376 403,-497 -181,160 -285,402 -400,627 -62,-108 -125,-216 -187,-324z"],color:"#090",fill:"#4f4",dimensions:n,dashed:void 0}))},makeXmark:e=>{let n,t;return e.iconUsage?(n=r.extend({},e.dimensions),t=e.strokeWidth):(t=5,n={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25),height:Math.max(e.dimensions.height,25)}),o.makeSimplePath(r.extend({},!0,e,{strokeWidth:t,viewBox:"0 0 100 100",d:["M10 10 L 80 80 M 80 10 L 10 80"],color:"red",dimensions:n,dashed:void 0}))},makePi:e=>{let n,t;return e.iconUsage?(n=r.extend({},e.dimensions),t=e.strokeWidth):(t=1,n={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25)},n.height=n.width),o.makeSimplePath(r.extend({},!0,e,{strokeWidth:t,viewBox:"0 0 110 137.5",d:["M21.33,40.487h-3.057c0,0,2.938-21.636,19.974-21.636s53.479,0,53.479,0v11.337H74.157c0,0-3.265,22.259-3.265,34.25  c0,11.989,7.242,14.363,10.091,14.363s7.479-5.46,7.479-6.528c0-1.069,0-2.612,0-2.612h3.265c0,0-1.009,21.487-15.848,21.487  c-14.84,0-13.415-24.93-13.296-25.761c0.118-0.831,3.087-35.021,3.087-35.021H47.15c0,0-0.514,26.395-2.256,34.151  c-1.741,7.756-3.481,26.631-13.139,26.631c-9.654,0-6.171-8.586-6.013-9.379c0.157-0.791,7.122-10.289,8.705-14.72  c1.582-4.432,3.799-36.723,3.799-36.723s-9.676-1.613-13.296,4.273C21.33,40.487,21.33,40.487,21.33,40.487z"],color:e.color,fill:e.color,dimensions:n,dashed:void 0}))},makeAlpha:e=>{let n,t;return e.iconUsage?(n=r.extend({},e.dimensions),t=e.strokeWidth):(t=1,n={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25)},n.height=n.width),o.makeSimplePath(r.extend({},!0,e,{strokeWidth:t,viewBox:"0 0 1000 1250",d:["M893 755c14,-17 39,-19 56,-5 17,15 19,40 4,57 -181,211 -273,23 -329,-153 -254,411 -603,196 -586,-174 16,-346 418,-629 607,-33 47,-101 88,-205 131,-308 9,-20 32,-30 52,-22 21,9 30,32 22,53 -54,130 -106,263 -172,388 37,123 74,361 215,197zm-300 -204c-166,-554 -461,-392 -476,-68 -15,337 264,458 476,68z"],color:e.color,fill:e.color,dimensions:n,dashed:void 0}))},makeBeta:e=>{let n,t;return e.iconUsage?(n=r.extend({},e.dimensions),t=e.strokeWidth):(t=1,n={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25)},n.height=n.width),o.makeSimplePath(r.extend({},!0,e,{strokeWidth:t,viewBox:"0 0 1000 1250",d:["M291 982c-15,8 -33,2 -40,-13 -8,-14 -3,-32 12,-40 64,-34 46,-199 28,-374 -13,-118 -26,-241 -14,-338 16,-131 74,-218 227,-200 10,2 21,4 32,8 32,11 64,34 86,66 23,33 35,75 29,126 -2,16 -6,33 -12,51 -6,15 -12,30 -20,44 23,10 44,26 63,46 28,31 50,73 61,118 12,45 14,93 2,137 -28,111 -133,196 -358,138 -10,-2 -17,-9 -21,-18 5,118 -8,213 -75,249zm61 -448c6,56 12,112 15,164 5,-15 21,-24 36,-20 182,46 265,-14 286,-95 9,-34 8,-72 -2,-108 -9,-35 -25,-68 -47,-92 -17,-17 -36,-30 -58,-34 -12,13 -24,23 -36,32 -15,11 -29,18 -42,22 -19,5 -36,4 -50,-6 -8,-6 -15,-15 -18,-27 -3,-11 1,-23 9,-30l0 0c38,-35 76,-52 112,-55 11,-15 21,-33 27,-52 5,-14 8,-27 10,-39 4,-34 -4,-63 -19,-84 -15,-21 -36,-36 -57,-44 -7,-2 -13,-4 -20,-4 -107,-14 -148,50 -160,147 -11,91 2,210 14,325z"],color:e.color,fill:e.color,dimensions:n,dashed:void 0}))},makeGrid:e=>{let n,t;e.iconUsage?(n=r.extend({},e.dimensions),t=e.strokeWidth):(t=1,n={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25)},n.height=n.width);const i=o.makeBufferedViewBox({buffer:5,viewBox:[0,0,100,100]});let a,l,c="";for(a=0;a<=10;++a)l=10*a,c+="M 0 "+l+" L 100 "+l+" ",c+="M "+l+" 0 L "+l+" 100 ";return o.makeSimplePath(r.extend({},!0,e,{strokeWidth:t,viewBox:i,d:[c],dimensions:n,dashed:void 0}))},makeRightSideMarker:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,100,50],d:["M 0 25 L 25 0 L 100 0 L 100 50 L 25 50 Z"],fill:e.color,outerClass:"bxy-right-side-marker",buffer:0})),makeAngle:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,30,35],transform:"translate(-390 -560)",d:["M401.883,578.324l12.971-12.971l-0.707-0.707L390.793,588H419v-1h-13.524    C405.357,583.749,404.098,580.706,401.883,578.324z M393.207,587l7.969-7.969c2.026,2.192,3.183,4.984,3.3,7.969H393.207z"],fill:e.color})),makeTrophy:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,100,125],d:["M69.402,82.288H30.598c-0.855,0-1.548,0.692-1.548,1.548v8.462c0,0.857,0.693,1.55,1.548,1.55h38.804  c0.854,0,1.549-0.693,1.549-1.55v-8.462C70.951,82.98,70.258,82.288,69.402,82.288z","M93.357,15.879c-1.635-2.293-5.112-4.738-12.479-4.309c0.062-1.208,0.104-2.446,0.123-3.716  c0.017-0.94-0.681-1.703-1.537-1.703H20.536c-0.856,0-1.551,0.762-1.537,1.703c0.019,1.271,0.061,2.508,0.123,3.717  c-7.363-0.43-10.845,2.013-12.479,4.307c-2.331,3.271-2.174,8,0.428,12.978c3.722,7.119,12.165,14.247,22.486,16.61  C36.188,54.68,43.49,57.225,43.49,57.225h13.021c0,0,7.301-2.545,13.934-11.759c10.32-2.365,18.764-9.492,22.486-16.61  C95.532,23.88,95.688,19.15,93.357,15.879z M11.381,26.603c-1.723-3.295-2.007-6.175-0.778-7.9c1.311-1.838,4.444-2.606,8.914-2.228  c1.002,9.551,3.36,16.971,6.236,22.688C19.17,36.406,13.945,31.507,11.381,26.603z M63.782,24.541l-6.49,6.326l1.532,8.933  c0.105,0.611-0.256,0.872-0.803,0.584L50,36.166l-8.023,4.218c-0.547,0.288-0.907,0.026-0.803-0.584l1.533-8.933l-6.49-6.326  c-0.444-0.433-0.306-0.856,0.307-0.945l8.968-1.303l4.011-8.129c0.274-0.556,0.719-0.556,0.993,0l4.011,8.129l8.968,1.303  C64.088,23.685,64.227,24.109,63.782,24.541z M88.619,26.603c-2.564,4.904-7.789,9.804-14.372,12.561  c2.876-5.717,5.233-13.137,6.235-22.688c4.472-0.379,7.604,0.39,8.914,2.228C90.626,20.428,90.342,23.308,88.619,26.603z","M61.506,78.811c-6.724-9.961-5.283-18.379-5.283-18.379H43.777c0,0,1.44,8.418-5.284,18.379H61.506z"],fill:e.color})),makeButtonWithCursor:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 128 120" enable-background="new 0 0 128 128" xml:space="preserve"><path d="M120,28H8c-4.4,0-8,3.6-8,8v32c0,4.4,3.6,8,8,8h81.264l-0.955-4H8c-2.206,0-4-1.794-4-4V36c0-2.206,1.794-4,4-4h112  c2.206,0,4,1.794,4,4v32c0,1.907-1.343,3.5-3.132,3.898l0.358,0.109c1.417,0.431,2.569,1.364,3.32,2.56  C126.629,73.119,128,70.714,128,68V36C128,31.6,124.4,28,120,28z"/><path d="M114.174,81.744l5.973-2.11c0.815-0.288,1.353-1.066,1.333-1.931c-0.019-0.863-0.591-1.617-1.417-1.868l-25.48-7.748  c-0.686-0.21-1.431-0.034-1.952,0.456c-0.522,0.491-0.741,1.225-0.575,1.922l5.773,24.184c0.192,0.805,0.86,1.408,1.681,1.518  c0.82,0.106,1.623-0.297,2.02-1.023l3.009-5.509l9.558,9.766c0.391,0.398,0.909,0.601,1.431,0.601c0.452,0,0.907-0.153,1.28-0.464  l6.476-5.4c0.429-0.357,0.688-0.878,0.716-1.436c0.028-0.557-0.178-1.101-0.567-1.5L114.174,81.744z M115.662,95.281l-10.156-10.377  c-0.379-0.387-0.896-0.601-1.43-0.601c-0.091,0-0.183,0.006-0.274,0.019c-0.628,0.087-1.177,0.467-1.48,1.022l-1.811,3.315  l-3.756-15.732l16.32,4.963l-3.189,1.127c-0.645,0.228-1.128,0.768-1.282,1.434c-0.154,0.665,0.041,1.363,0.519,1.852l9.934,10.148  L115.662,95.281z"/></svg>',makeButton:e=>'<div class="button-icon" style="width:'+e.width+"px;height:"+e.height+'px;">'+e.contents+"</div>",makeTerminal:e=>{const n=parseInt(.9*e.width);return'<div class="terminal-icon" style="width:'+e.width+"px;height:"+n+'px;">&gt;_</div>'},makeLock:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:1,viewBox:[0,0,100,100],d:["M77.9,41.2h-0.3v-8.9c0-15-11.7-27.6-26.7-28.1c-15.5-0.5-28.3,12-28.3,27.5c0,1.2,1,2.1,2.1,2.1H33c0.9,0,1.7-0.7,1.7-1.7  c0-8.3,6.4-15.5,14.7-15.9c8.9-0.4,16.2,6.7,16.2,15.4v9.4H34.7h-12h-0.6c-4,0-7.3,3.2-7.3,7.3v40c0,4,3.2,7.2,7.2,7.2h55.8  c4,0,7.3-3.2,7.3-7.3v-40C85.1,44.5,81.9,41.2,77.9,41.2z M22.9,87.7v-7l5.5,7H22.9z M34.7,87.7L22.9,72.6v-2.9h4l14.1,18H34.7z   M47.3,87.7l-14.1-18h6.3l14.1,18H47.3z M60,87.7l-14.1-18h6.3l14.1,18H60z M77.1,87.7h-4.5l-14.1-18h6.3l12.3,15.7V87.7z   M77.1,77.3l-5.9-7.6h5.9V77.3z"],fill:e.color})),makeSimpleX:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:1,viewBox:[0,0,100,100],d:["M75.1,7.3L50,32.3L24.9,7.3c-1.2-1.2-3.1-1.2-4.2,0L5.8,22.1L33,49.3L5.8,76.5l14.8,14.8c1.2,1.2,3.1,1.2,4.2,0L50,66.3  l25.1,25.1c1.2,1.2,3.1,1.2,4.2,0l14.8-14.8L67,49.3l27.2-27.2L79.3,7.3C78.1,6.1,76.2,6.1,75.1,7.3z"],fill:e.color})),makeHidden:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:1,viewBox:[0,0,100,100],d:["M 8.9 46.05 Q 7.3 46.05 6.15 47.2 5 48.35 5 50 5 51.6 6.15 52.75 7.3 53.9 8.9 53.9 L 25.65 53.9 Q 27.3 53.9 28.45 52.75 29.6 51.6 29.6 50 29.6 48.35 28.45 47.2 27.3 46.05 25.65 46.05 L 8.9 46.05 M 37.05 68.5 Q 38.2 67.35 38.2 65.75 38.2 64.1 37.05 62.95 35.9 61.85 34.25 61.85 32.65 61.85 31.5 62.95 L 18.2 76.25 Q 17.05 77.4 17.05 79.05 17.05 80.65 18.2 81.8 19.35 82.95 20.95 82.95 22.6 82.95 23.75 81.8 L 37.05 68.5 M 52.75 71.55 Q 51.6 70.4 50 70.4 48.4 70.4 47.25 71.55 46.1 72.7 46.1 74.35 L 46.1 91.05 Q 46.1 92.7 47.25 93.85 48.4 95 50 95 51.6 95 52.75 93.85 53.9 92.7 53.9 91.05 L 53.9 74.35 Q 53.9 72.7 52.75 71.55 M 93.85 47.2 Q 92.7 46.05 91.1 46.05 L 74.35 46.05 Q 72.75 46.05 71.55 47.2 70.4 48.35 70.4 50 70.4 51.6 71.55 52.75 72.75 53.9 74.35 53.9 L 91.1 53.9 Q 92.7 53.9 93.85 52.75 95 51.6 95 50 95 48.35 93.85 47.2 M 81.8 81.8 Q 82.95 80.65 82.95 79.05 82.95 77.4 81.8 76.25 L 68.5 62.95 Q 67.4 61.85 65.75 61.85 64.1 61.85 62.95 62.95 61.85 64.1 61.85 65.75 61.85 67.35 62.95 68.5 L 76.3 81.8 Q 77.4 82.95 79.05 82.95 80.65 82.95 81.8 81.8 M 82.95 20.95 Q 82.95 19.3 81.8 18.15 80.65 17 79.05 17 77.4 17 76.3 18.15 L 62.95 31.45 Q 61.85 32.6 61.85 34.25 61.85 35.85 62.95 37 64.1 38.15 65.75 38.15 67.4 38.15 68.5 37 L 81.8 23.7 Q 82.95 22.55 82.95 20.95 M 53.9 8.9 Q 53.9 7.3 52.75 6.15 51.6 5 50 5 48.4 5 47.25 6.15 46.1 7.3 46.1 8.9 L 46.1 25.65 Q 46.1 27.25 47.25 28.4 48.4 29.55 50 29.55 51.6 29.55 52.75 28.4 53.9 27.25 53.9 25.65 L 53.9 8.9 M 23.75 18.15 Q 22.6 17 20.95 17 19.35 17 18.2 18.15 17.05 19.3 17.05 20.95 17.05 22.55 18.2 23.7 L 31.5 37 Q 32.65 38.15 34.25 38.15 35.9 38.15 37.05 37 38.2 35.85 38.2 34.25 38.2 32.6 37.05 31.45 L 23.75 18.15 Z"],fill:e.color})),makeRunningMan:e=>'<svg xmlns:x="http://ns.adobe.com/Extensibility/1.0/" xmlns:i="http://ns.adobe.com/AdobeIllustrator/10.0/" xmlns:graph="http://ns.adobe.com/Graphs/1.0/" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 85" style="enable-background:new 10 10 100 70;" xml:space="preserve"><switch><foreignObject requiredExtensions="http://ns.adobe.com/AdobeIllustrator/10.0/" x="0" y="0" width="1" height="1"/><g i:extraneous="self"><g fill-rule="evenodd" fill="'+e+'"><path d="M48.8,57.3c-0.8-0.5-1.4-1.2-1.8-2c-1.5,4.3-3.6,9.6-4.7,12.2c-2.9,0.1-9.5-0.6-14.9-1.5c-2.3-0.4-4.5,1.2-4.8,3.5     c-0.4,2.3,1.2,4.5,3.5,4.8c0.2,0,4.6,0.7,9.2,1.2c2.5,0.3,4.6,0.4,6.4,0.4c3.9,0,6.2-0.8,7.4-3c0.9-1.6,3-7.1,4.9-12.2     c-1.2-0.8-2.5-1.7-4-2.7C49.4,57.7,49,57.4,48.8,57.3z"/><path d="M97.4,43.5c-0.5-1.7-2.2-2.8-4-2.3c-0.8,0.2-6.7,1.8-10.3,2.8c-0.1-0.4-0.3-0.8-0.4-1.1c-1.4-4.1-3.5-10.3-8.9-12.4     c-1.2-0.5-4-1.7-5.8-2.5c-7.6-3.3-20.8,0.3-22.5,0.9c-0.9,0.4-2.9,1.1-8.7,12.5C36,43,36.7,45,38.3,45.8c0.5,0.2,1,0.4,1.5,0.4     c1.2,0,2.3-0.7,2.9-1.8c1.9-3.7,4.5-8.2,5.5-9.4c1.3-0.4,4.4-1.1,7.8-1.5c-3.7,5.1-7,13.2-7.6,16.1c-0.8,4.2,1,5.6,1.6,6     c1.4,1,14.2,9.5,16.1,11.5c-0.5,2.9-3.1,11.4-5.4,18.4c-0.7,2.2,0.5,4.6,2.7,5.3c0.4,0.1,0.9,0.2,1.3,0.2c1.8,0,3.4-1.1,4-2.9     c2.2-6.8,6-18.6,5.9-22c-0.1-3.3-3.1-6.2-9.7-10.7c2.1-5.2,5.6-12.7,8.9-16.6c1.2,1.8,2.1,4.3,2.7,6.2c1,2.8,1.6,4.8,3.5,5.7     c0.5,0.3,1.1,0.4,1.6,0.4c0.4,0,0.9-0.1,1.3-0.2c1.4-0.5,8-2.3,12.1-3.4C96.8,47,97.8,45.3,97.4,43.5z"/><ellipse transform="matrix(0.3937 -0.9192 0.9192 0.3937 28.3646 78.9709)" cx="74" cy="18" rx="9" ry="9"/><path d="M10.8,34.5h20.7c1.4,0,2.5-1.1,2.5-2.5s-1.1-2.5-2.5-2.5H10.8c-1.4,0-2.5,1.1-2.5,2.5S9.5,34.5,10.8,34.5z"/><path d="M7.9,45h20.7c1.4,0,2.5-1.1,2.5-2.5s-1.1-2.5-2.5-2.5H7.9c-1.4,0-2.5,1.1-2.5,2.5S6.5,45,7.9,45z"/><path d="M28.1,53c0-1.4-1.1-2.5-2.5-2.5H5c-1.4,0-2.5,1.1-2.5,2.5c0,1.4,1.1,2.5,2.5,2.5h20.7C27,55.5,28.1,54.4,28.1,53z"/></g></g></switch></svg>',makeScan:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve"><g><g fill-rule="evenodd" fill="'+e+'"><path d="M23.3,62.8H9.2C6.9,62.8,5,64.7,5,67v14.2c0,2.3,1.9,4.2,4.2,4.2h14.2c2.3,0,4.2-1.9,4.2-4.2V67    C27.5,64.7,25.6,62.8,23.3,62.8z"/><path d="M90.8,62.8H76.7c-2.3,0-4.2,1.9-4.2,4.2v14.2c0,2.3,1.9,4.2,4.2,4.2h14.2c2.3,0,4.2-1.9,4.2-4.2V67    C95,64.7,93.1,62.8,90.8,62.8z"/><path d="M57.1,62.8H42.9c-2.3,0-4.2,1.9-4.2,4.2v14.2c0,2.3,1.9,4.2,4.2,4.2h14.2c2.3,0,4.2-1.9,4.2-4.2V67    C61.2,64.7,59.4,62.8,57.1,62.8z M57.1,81.1C57.1,81.1,57.1,81.1,57.1,81.1l-14.2,0c0,0,0,0,0,0l0-14.2c0,0,0,0,0,0h14.2    c0,0,0,0,0,0L57.1,81.1z"/><path d="M87.5,52.5l5-24.4l-9,3c-3.4-4.6-7.8-8.4-12.9-11.2c-6.2-3.4-13.3-5.2-20.6-5.2c-22.4,0-40.6,17-40.6,37.8    c0,1.7,1.4,3.1,3.1,3.1s3.1-1.4,3.1-3.1C15.6,35.1,31,20.9,50,20.9c10.7,0,20.7,4.6,27.2,12.2L68.8,36L87.5,52.5z"/></g></g></svg>',makeRabbit:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns" viewBox="0 0 100 75" version="1.1" x="0px" y="10px"><g stroke="none" stroke-width="1" fill-rule="evenodd" sketch:type="MSPage"><g sketch:type="MSArtboardGroup" transform="translate(0.000000, -7.000000)" fill="'+e+'"><path d="M60.1164483,76.5101184 C60.1164483,77.7869765 61.1184016,79.097951 62.3543737,79.4324469 L72.798828,82.2590697 C74.9502082,82.841306 76.9428079,85.1218308 77.229578,87.3473934 L77.4381368,88.9659749 L61.2268002,86.7611761 C59.0007748,86.4584288 55.762595,85.1122528 53.9830021,83.7528954 L30.0193357,65.4480423 C18.6673757,64.6909954 9.4627489,56.133214 7.77382209,45.1160791 L4.34635739,45.1647777 C1.94608449,45.1988816 -1.83318034e-16,43.2833095 -1.07537429e-17,40.8862227 L12.0835739,27.3645101 C17.4743573,21.3386402 23.6068695,17.4194231 31.6593886,17.4194231 C32.7498041,17.4194231 33.8233498,17.4912885 34.8755022,17.6305187 C36.0956627,17.7349159 37.3050822,17.9433886 38.4888396,18.2605754 C54.0954993,22.4423673 65.570761,42.6024939 65.570761,42.6024939 C66.516058,44.0861571 68.636741,45.6806441 70.3388841,46.136732 L71.0643059,46.3311082 C72.7686884,46.7877961 75.036606,46.0402598 76.1348435,44.6627794 L79.3667959,40.6090557 L69.0683577,35.5886404 C54.9830017,29.5 58.824985,11.8109045 58.824985,11.8109045 C58.9924242,10.7260817 59.7843012,10.4649372 60.587326,11.2216236 L82.7393229,32.0953411 L64.7779732,12.0675015 C65.0289152,8.20500861 68.1652109,7 68.1652109,7 L85.5324488,34.7272898 L86.921334,36.0360295 L96.0521825,42.4677019 C98.138955,43.9376022 99.8625925,47.2144004 99.8888571,49.7773535 L100.007257,61.3310185 L99.3236978,61.8899026 C97.5857982,63.3108255 94.5445704,63.6651439 92.5224884,62.6881932 L89.3807164,61.1702742 C86.2103299,59.6385304 81.4523901,60.2321429 78.7512966,62.4950512 L69.6842316,70.0912108 C68.6969982,70.9182902 67.3970043,71.7079683 65.972973,72.3860195 C65.450814,57.828347 59.4984737,45.9574271 46.7248907,37.1161254 C45.6127483,36.4326524 43.9592431,38.4195836 44.7777067,39.1109172 C56.0407574,49.2817354 60.1164483,60.3235994 60.1164483,74.5177084 L60.1164483,76.5101184 Z M95.0509461,53.9162538 C96.1764172,53.9162538 97.0887918,53.0084656 97.0887918,51.8886521 C97.0887918,50.7688386 96.1764172,49.8610504 95.0509461,49.8610504 C93.925475,49.8610504 93.0131004,50.7688386 93.0131004,51.8886521 C93.0131004,53.0084656 93.925475,53.9162538 95.0509461,53.9162538 L95.0509461,53.9162538 Z M19.9417759,92 L19.9417759,89.8393536 C19.9417758,87.5932185 21.6918837,85.2820263 23.828826,84.6248277 C23.828826,84.6248277 35.0800582,81.8619915 38.1368268,76.9378159 C38.1368268,76.9378159 46.7248911,83.7447645 46.7248911,83.7447645 C34.7889374,89.6827409 19.9417759,92 19.9417759,92 L19.9417759,92 Z" sketch:type="MSShapeGroup"/></g></g></svg>',makeTurtle:()=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 75 70" enable-background="new 0 0 95 95" xml:space="preserve"><path d="M87.242,46.239c-5.27,0-9.811,1.512-10.09,1.061c-0.281-0.445,1.796-1.456,3.025-2.802  C69.529,35.867,66.388,23.76,47.223,23.76c-19.398,0-24.78,18.723-35.316,28.476l1.905,1.904c0,0-3.586,1.238-6.277,1.57  c-2.691,0.336-6.951,0.741-6.951,1.348c0,0.531,5.606,0.896,8.407,0.896c2.804,0,7.513-0.338,7.513-0.338s0.337,0.445-2.47,1.342  c-2.804,0.9-3.471,1.686-5.49,4.266c-2.014,2.578-4.215,4.748-4.215,5.713c0,1.09,0.445,1.812,2.014,1.812S9.034,71,10.551,71  c2.909,0,2.909-1.807,3.694-3.152c0.789-1.348,1.362-2.158,2.258-2.943c0.901-0.787,2.02-1.008,3.474-1.568  c1.456-0.564,3.702-1.686,3.702-1.686s3.813,1.461,10.424,1.461c6.617,0,18.836-0.34,24.327-0.34c5.493,0,6.562-2.295,7.906-2.295  c0.672,0,3.981,1.965,3.981,2.748c0,1.117-5.161,4.93-5.161,6.051c0,1.125,1.795,1.965,5.05,1.965c4.653,0,5.205-2.605,6.501-4.207  c1.401-1.734,2.572-3.363,2.572-5.383c0-2.521-5.042-4.818-5.042-4.818s1.011-1.571,3.025-1.571c2.017,0,6.056,0.45,10.428,0.45  c4.373,0,6.727,0.56,6.727-3.589C94.417,47.976,92.514,46.239,87.242,46.239z M89.167,50.5c-0.553,0-1-0.447-1-1s0.447-1,1-1  s1,0.447,1,1S89.72,50.5,89.167,50.5z"/></svg>',makeSnail:()=>'<svg style="transform:scaleX(-1.0)" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:cc="http://creativecommons.org/ns#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd" xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape" version="1.1" x="0px" y="5px" viewBox="0 0 75 75"><g transform="translate(0,-952.36218)"><path style="text-indent:0;text-transform:none;direction:ltr;block-progression:tb;baseline-shift:baseline;color:#000000;enable-background:accumulate;" d="m 63.748703,971.36229 c -5.43917,0.046 -12.9678,1.9026 -17.33056,4.9688 -5.33006,3.7325 -9.84923,9.9737 -12.23149,20.2812 -1.91437,7.74631 -1.56839,15.38211 1.72054,19.75001 5.65023,-0.3712 12.79569,-0.6555 19.30136,-0.4375 -5.52288,-4.5469 -7.39127,-10.3988 -7.25756,-17.56251 -0.0291,-9.4042 7.41348,-15 14.82795,-15 6.96147,0.06 12.98292,5.6893 12.88842,13 -0.0443,5.72511 -4.66524,9.92801 -9.91658,10.00001 -3.86287,-0.055 -8.81178,-2.1402 -8.91553,-7.00003 0.012,-3.41788 2.27613,-6.76628 5.94369,-6.99998 0.52311,-0.01 1.00104,0.4716 1.00104,1 0,0.5284 -0.47793,1.01 -1.00104,1 -2.58389,0.4032 -3.81164,2.1726 -3.94161,4.99998 0.0869,3.54803 4.10317,4.92403 6.91345,5.00003 4.15393,-0.085 7.88782,-3.7511 7.94578,-8.00001 -0.0251,-5.3606 -4.55816,-11 -10.91762,-11 -6.44788,0 -12.88287,4.6227 -12.85715,12.9688 -0.0323,6.38281 1.10231,13.05131 8.54015,17.68741 10.33074,0.4959 17.71944,1.8254 22.77372,2.625 3.622699,-1.5245 6.11839,-4.1742 7.789365,-8 1.71466,-3.9255 2.5026,-9.064 2.5026,-15.25001 0,-13.3656 -12.517635,-24.0313 -27.778925,-24.0312 z m -45.73514,1 c -1.65858,0 -3.00313,1.3431 -3.00313,3 0,1.6569 1.34455,3 3.00313,3 0.59787,0 1.15869,-0.1992 1.62669,-0.5 1.92801,1.5462 3.44429,3.6637 3.409799,5.9375 -0.0532,2.3056 -1.432899,5.3535 -2.09593,10.1875 -0.37363,-0.053 -0.78261,-0.094 -1.18874,-0.094 -0.58486,0.01 -1.18456,0.1249 -1.81439,0.2813 0.087,-2.7692 -0.50124,-4.9363 -1.34515,-7.0625 -0.88646,-2.2334 -2.73222,-4.4208 -5.91241,-7.5 0.18193,-0.3868 0.31283,-0.7944 0.31283,-1.25 0,-1.6569 -1.3445495,-3 -3.0031295,-3 -1.65858,0 -3.00313,1.3431 -3.00313,3 0,1.6569 1.34455,3 3.00313,3 0.46283,0 0.89106,-0.1257 1.28258,-0.3125 3.0970895,3.0036 4.7355995,4.9984 5.4431695,6.7813 0.74291,1.8716 1.40489,3.8601 1.15746,7 -0.16002,0.067 -0.31086,0.1478 -0.46924,0.2187 -0.89952,8.26371 -0.58523,17.83861 2.47133,25.28131 3.12374,7.606 8.840111,13.0022 19.30135,13.0312 l 57.810216,0 c -0.672391,-1.924 -2.13834,-4.398 -4.410841,-6.7188 -2.40769,-2.4191 -5.888875,-4.6967 -9.635035,-6 -8.34215,-1.2926 -22.74908,-3.8874 -46.07925,-2.2187 -2.51776,-0.2143 -4.76029,-1.7063 -6.06882,-3.6563 -3.74447,-5.5541 -3.29333,-13.0509 -5.25548,-19.75001 -0.18057,-0.1675 -0.39608,-0.3318 -0.65693,-0.4687 0.62315,-4.7755 2.09036,-7.7341 2.1585,-10.6875 -0.1,-3.42 -1.90212,-5.6714 -4.19187,-7.5938 0.0934,-0.2898 0.15641,-0.5852 0.15641,-0.9062 0.0525,-1.7066 -1.59672,-2.9573 -3.00312,-2.9998 z" fill="#000000" fill-opacity="1" stroke="none" marker="none" visibility="visible" display="inline" overflow="visible"/></g></svg>',makeSprayCanIcon:()=>'<span><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" style="width:20px;height:12px;" viewBox="0 0 88 88" enable-background="new 0 0 100 100" xml:space="preserve"><path d="M30.292,91.893c-0.277,0-0.552-0.114-0.75-0.338l-2.614-2.956  c-0.366-0.413-0.327-1.046,0.086-1.411c0.414-0.365,1.047-0.327,1.412,0.087l2.614,2.956c0.366,0.413,0.327,1.046-0.086,1.411  C30.764,91.81,30.528,91.893,30.292,91.893z M26.219,85.882c-0.332,0-0.656-0.165-0.847-0.466l-1.656-2.622  c-0.295-0.467-0.155-1.085,0.312-1.38c0.465-0.295,1.084-0.156,1.379,0.312l1.656,2.622c0.295,0.467,0.155,1.085-0.312,1.38  C26.586,85.832,26.402,85.882,26.219,85.882z M10.305,85.543c-0.413,0-0.799-0.257-0.943-0.668L8.17,81.488  c-0.183-0.521,0.091-1.092,0.612-1.275c0.519-0.188,1.092,0.091,1.275,0.611l1.191,3.387c0.183,0.521-0.091,1.092-0.612,1.275  C10.527,85.525,10.415,85.543,10.305,85.543z M84.585,81.594c-0.552,0-1-0.447-1-1v-2.37c0-0.553,0.448-1,1-1s1,0.447,1,1v2.37  C85.585,81.146,85.137,81.594,84.585,81.594z M23.399,79.747c-0.364,0-0.715-0.199-0.892-0.546  c-5.812-11.412-2.957-18.242-0.737-21.298c0.626-0.862,1.326-1.614,2.066-2.26c-0.73-1.527-1.142-3.388-0.999-5.575  c0.398-6.072,3.779-9.768,7.464-11.549c-0.075-0.425-0.104-0.851-0.079-1.273c0.373-6.19,3.492-11.47,9.269-15.692  c0.446-0.325,1.071-0.229,1.397,0.218c0.326,0.445,0.229,1.071-0.217,1.397c-5.273,3.854-8.117,8.631-8.453,14.198  c-0.008,0.129-0.006,0.263,0.004,0.398c0.222-0.067,0.444-0.129,0.665-0.185c3.565-0.885,6.866-0.192,8.028,1.689  c0.469,0.759,0.976,2.358-0.893,4.539c-1.135,1.327-2.825,1.668-4.636,0.935c-1.701-0.688-3.474-2.361-4.438-4.311  c-2.501,1.267-5.737,4.008-6.114,9.766c-0.107,1.637,0.158,3.044,0.651,4.221c2.304-1.447,4.773-1.989,6.625-1.696  c1.512,0.238,2.556,1.021,2.941,2.201c0.958,2.938-0.12,4.43-0.848,5.059c-1.396,1.204-3.763,1.251-6.033,0.122  c-1.153-0.574-2.318-1.482-3.266-2.72c-0.546,0.499-1.059,1.064-1.516,1.693c-3.367,4.637-3.047,11.46,0.901,19.214  c0.25,0.492,0.055,1.095-0.438,1.346C23.707,79.712,23.552,79.747,23.399,79.747z M26.495,56.169  c0.748,0.979,1.662,1.695,2.567,2.146c1.498,0.745,3.075,0.81,3.834,0.153c0.819-0.707,0.51-2.136,0.253-2.925  c-0.18-0.551-0.834-0.764-1.352-0.845C30.364,54.474,28.363,54.982,26.495,56.169z M32.819,39.677  c0.718,1.374,1.986,2.676,3.316,3.213c1.519,0.616,2.158-0.135,2.368-0.381c0.447-0.522,1.134-1.501,0.71-2.188  c-0.581-0.94-2.979-1.512-5.843-0.799C33.215,39.562,33.029,39.611,32.819,39.677z M8.299,77.702c-0.497,0-0.927-0.369-0.991-0.875  L6.76,72.481c-0.069-0.548,0.319-1.048,0.867-1.117c0.546-0.063,1.048,0.318,1.117,0.867l0.548,4.346  c0.069,0.548-0.319,1.048-0.867,1.117C8.383,77.699,8.341,77.702,8.299,77.702z M84.585,75.176c-0.552,0-1-0.447-1-1v-7.112  c0-0.553,0.448-1,1-1s1,0.447,1,1v7.112C85.585,74.729,85.137,75.176,84.585,75.176z M7.632,68.187c-0.552,0-1-0.447-1-1v-4.063  c0-0.553,0.448-1,1-1s1,0.447,1,1v4.063C8.632,67.739,8.185,68.187,7.632,68.187z M84.585,63.322c-0.552,0-1-0.447-1-1V37.405  c0-0.553,0.448-1,1-1s1,0.447,1,1v24.917C85.585,62.875,85.137,63.322,84.585,63.322z M7.658,59.402c-0.009,0-0.018,0-0.027,0  c-0.552-0.016-0.988-0.475-0.973-1.026c0.345-12.844,4.494-18.087,7.337-20.179c0.154-0.413,0.33-0.842,0.53-1.288  c3.832-8.567,13.136-16.174,25.527-20.871c0.517-0.194,1.094,0.064,1.29,0.581s-0.064,1.094-0.581,1.29  c-11.451,4.34-20.123,11.193-23.981,18.909c1.926-0.503,3.74-0.106,4.861,1.103c1.118,1.207,1.284,3.004,0.442,4.807  c-1.462,3.134-4.531,4.828-6.84,3.769c-1.321-0.604-2.312-2.105-2.115-4.675c-2.346,3.048-4.25,8.389-4.471,16.607  C8.643,58.972,8.198,59.402,7.658,59.402z M15.668,39.46c-1.003,3-0.587,4.764,0.406,5.218c1.131,0.513,3.128-0.506,4.196-2.796  c0.5-1.071,0.465-1.995-0.097-2.603c-0.686-0.739-2.026-0.88-3.414-0.357C16.398,39.058,16.033,39.236,15.668,39.46z M44.426,20.661  c-0.358,0-0.705-0.192-0.884-0.531c-0.259-0.487-0.074-1.093,0.414-1.352c1.179-0.627,2.449-1.23,3.774-1.794  c0.51-0.218,1.096,0.021,1.312,0.528c0.216,0.508-0.02,1.096-0.528,1.312c-1.272,0.542-2.49,1.12-3.619,1.72  C44.745,20.624,44.584,20.661,44.426,20.661z M43.329,16.909c-0.403,0-0.784-0.246-0.935-0.646c-0.196-0.517,0.064-1.094,0.581-1.29  c0.439-0.166,0.782-0.279,1.084-0.294c0.085-0.022,0.199-0.055,0.351-0.1c0.527-0.157,1.085,0.147,1.241,0.679  c0.156,0.53-0.148,1.085-0.678,1.241c-0.34,0.1-0.648,0.189-0.925,0.207c-0.085,0.031-0.203,0.076-0.364,0.138  C43.566,16.889,43.447,16.909,43.329,16.909z M55.574,16.296c-0.435,0-0.834-0.285-0.96-0.724c-0.153-0.531,0.154-1.085,0.685-1.237  c0.778-0.224,1.567-0.438,2.365-0.641c0.539-0.138,1.08,0.188,1.216,0.722c0.137,0.535-0.187,1.079-0.722,1.216  c-0.779,0.199-1.548,0.407-2.308,0.625C55.758,16.283,55.665,16.296,55.574,16.296z M48.571,15.53c-0.456,0-0.868-0.313-0.974-0.777  c-0.124-0.538,0.213-1.074,0.751-1.197c1.599-0.366,3.268-0.689,4.961-0.96c0.542-0.093,1.058,0.284,1.146,0.829  c0.087,0.546-0.284,1.059-0.829,1.146c-1.65,0.265-3.276,0.579-4.832,0.935C48.72,15.522,48.645,15.53,48.571,15.53z M61.835,13.657  c-0.522,0-0.962-0.406-0.997-0.935c-0.036-0.552,0.382-1.027,0.933-1.063c0.938-0.061,1.89-0.11,2.857-0.146  c0.543-0.049,1.017,0.409,1.037,0.961c0.021,0.553-0.41,1.017-0.962,1.037c-0.949,0.036-1.883,0.084-2.803,0.145  C61.879,13.656,61.857,13.657,61.835,13.657z M90.627,90.353H60.354c-2.063,0-3.74-1.578-3.74-3.519v-55.19  c0-0.67,0.2-1.297,0.547-1.831c-0.36-0.715-0.547-1.488-0.547-2.153v-1.615c0-1.949,1.587-4.036,3.95-4.036h0.668  c0.846-2.483,2.916-6.444,6.424-6.444h0.961V9.107c0-1.104,0.896-2,2-2h9.747c1.104,0,2,0.896,2,2v6.456h1.303  c3.528,0,5.423,3.941,6.154,6.444h0.243c2.424,0,4.304,2.17,4.304,4.036v1.668c0,0.616-0.217,1.336-0.606,2.014  c0.383,0.552,0.606,1.211,0.606,1.918v55.19C94.368,88.774,92.69,90.353,90.627,90.353z M60.614,86.353h29.753V32.125H60.614V86.353  z M60.795,28.125h29.177c0.135-0.088,0.331-0.344,0.395-0.516v-1.386c-0.081-0.105-0.237-0.216-0.304-0.216h-29.42  c-0.015,0.026-0.027,0.057-0.031,0.077l0.002,1.574C60.624,27.772,60.71,27.991,60.795,28.125z M65.55,22.008h20.043  c-0.534-1.222-1.322-2.444-1.926-2.444h-16.01C67.005,19.563,66.162,20.775,65.55,22.008z M72.618,15.563h5.747v-4.456h-5.747  V15.563z"/>',makeSettingsIcon:e=>o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,100,100],d:["M49.71,95c-2.757,0-3.253-2.49-3.871-5.594c-0.733-3.752-2.109-5.723-4.478-6.466    c-0.056-0.018-0.139-0.054-0.214-0.094c-0.562-0.147-1.115-0.307-1.663-0.486c-2.331-0.595-4.53,0.338-7.074,3.036    c-2.354,2.489-4.2,4.437-6.758,2.393l-1.186-0.943c-0.333-0.264-0.585-0.462-2.394-1.91c-0.025-0.018-0.049-0.037-0.073-0.057    c-0.01-0.008-0.02-0.015-0.03-0.023l-2.008-1.615c-0.456-0.368-0.456-0.368-1.456-1.162l-0.12-0.096    c-2.544-2.051-1.06-4.266,0.817-7.071c2.121-3.157,2.54-5.525,1.394-7.735l0.001,0c-0.024-0.048-0.047-0.101-0.066-0.154    c-0.294-0.508-0.566-1.032-0.834-1.552c-1.227-2.076-3.449-2.978-7.166-2.882c-3.442,0.089-6.108,0.155-6.471-3.086l-0.16-1.458    c-0.049-0.451-0.075-0.697-0.345-3.105l0.961-0.217l-0.972,0.109l-0.508-4.569c-0.361-3.253,2.258-3.767,5.575-4.418    c3.736-0.741,5.708-2.121,6.453-4.485c0.015-0.05,0.045-0.118,0.077-0.182c0.133-0.503,0.305-1.122,0.513-1.732    c0.568-2.3-0.366-4.495-3.051-7.035c-2.499-2.37-4.433-4.204-2.394-6.764l2.871-3.585c0.018-0.027,0.046-0.064,0.066-0.089    l2.877-3.583c2.039-2.558,4.261-1.065,7.075,0.827c3.153,2.112,5.524,2.529,7.722,1.38c0.038-0.02,0.087-0.04,0.138-0.058    c0.542-0.31,1.052-0.571,1.571-0.833c2.074-1.219,2.98-3.443,2.882-7.181c-0.09-3.432-0.16-6.087,3.084-6.464l9.241-1.029    c3.239-0.354,3.773,2.269,4.426,5.593c0.725,3.714,2.104,5.686,4.478,6.437c0.056,0.018,0.141,0.056,0.218,0.096    c0.544,0.141,1.092,0.304,1.628,0.473c2.345,0.607,4.551-0.321,7.092-3.028c2.38-2.499,4.214-4.425,6.761-2.394l1.256,1.001    c0.307,0.243,0.642,0.509,2.327,1.858c0.018,0.013,0.035,0.027,0.052,0.042c0.02,0.015,0.038,0.031,0.053,0.043l3.58,2.864    c2.535,2.039,1.069,4.237-0.785,7.021l-0.064,0.096c-2.087,3.111-2.507,5.481-1.361,7.686c0.022,0.042,0.045,0.1,0.065,0.16    c0.26,0.453,0.498,0.918,0.741,1.393l0.021,0.04c0.008,0.012,0.016,0.025,0.023,0.038c1.246,2.152,3.475,3.058,7.215,2.955    c3.451-0.087,6.11-0.156,6.469,3.088l0.506,4.527c0.008,0.041,0.013,0.082,0.016,0.122c0.001,0.011,0.003,0.021,0.004,0.031    l0.134,1.238c0.17,1.562,0.17,1.562,0.235,2.134l0.136,1.196c0,0.002,0,0.004,0,0.006c0.348,3.233-2.248,3.751-5.535,4.407    l-0.1,0.02c-3.676,0.719-5.647,2.096-6.396,4.465c-0.018,0.057-0.06,0.151-0.1,0.229c-0.126,0.489-0.289,1.049-0.469,1.616    c-0.61,2.336,0.321,4.543,3.033,7.107c2.489,2.365,4.424,4.205,2.39,6.755c-0.684,0.853-0.836,1.045-1.038,1.301    c-0.236,0.299-0.541,0.684-1.831,2.297c-0.018,0.023-0.04,0.047-0.062,0.071l-2.883,3.598c-2.032,2.537-4.235,1.07-7.025-0.786    l-0.089-0.059c-3.109-2.091-5.479-2.513-7.687-1.368c-0.039,0.02-0.094,0.043-0.15,0.063c-0.478,0.275-1.001,0.555-1.536,0.818    c-2.089,1.218-3,3.445-2.896,7.188c0.095,3.422,0.169,6.102-3.088,6.466l-1.591,0.182c-0.389,0.046-0.814,0.096-2.977,0.339    c-0.034,0.004-0.069,0.006-0.103,0.006v0c-0.001,0-0.008,0.003-0.041,0.005c-1.837,0.205-2.403,0.266-2.773,0.306    c-0.386,0.042-0.558,0.06-1.752,0.197C50.07,94.99,49.885,95,49.71,95z M42.039,81.104c4,1.332,5.169,5.109,5.704,7.848    c0.741,3.722,1.019,4.213,2.307,4.072c1.195-0.137,1.367-0.155,1.757-0.197c0.372-0.04,0.942-0.102,2.807-0.31    c0.014-0.002,0.028-0.003,0.043-0.004c0.043-0.005,0.093-0.009,0.128-0.009c2.086-0.236,2.511-0.286,2.898-0.331l1.601-0.183    c1.291-0.145,1.455-0.684,1.351-4.438c-0.08-2.851,0.242-6.851,3.927-8.995c0.573-0.285,1.075-0.553,1.569-0.838    c0.056-0.032,0.136-0.066,0.212-0.091c3.785-1.889,7.288-0.046,9.604,1.513l0.085,0.056c3.078,2.049,3.614,2.192,4.415,1.192    l2.875-3.589c0.013-0.016,0.074-0.088,0.088-0.104c0.008-0.009,0.016-0.017,0.024-0.025l0.003-0.003    c1.239-1.552,1.543-1.936,1.778-2.234c0.204-0.258,0.357-0.451,1.045-1.309c0.803-1.006,0.539-1.502-2.173-4.079    c-2.079-1.965-4.673-5.008-3.601-9.104c0.188-0.596,0.345-1.137,0.492-1.692c0.019-0.074,0.066-0.181,0.112-0.267    c1.32-4.013,5.112-5.19,7.86-5.728l0.097-0.019c3.625-0.724,4.11-1.001,3.973-2.277l-0.136-1.191    c-0.066-0.575-0.066-0.575-0.236-2.145l-0.134-1.233c-0.002-0.013-0.003-0.026-0.005-0.039c-0.004-0.024-0.008-0.048-0.011-0.072    l-0.511-4.57c-0.141-1.279-0.675-1.445-4.392-1.349c-2.88,0.083-6.843-0.229-8.992-3.846c-0.029-0.04-0.055-0.082-0.078-0.127    l-0.063-0.123c-0.243-0.475-0.48-0.94-0.744-1.393c-0.036-0.062-0.073-0.151-0.099-0.235c-1.907-3.722-0.053-7.256,1.514-9.59    l0.063-0.094c2.045-3.068,2.19-3.604,1.189-4.409L76.8,16.676c-0.096-0.053-0.175-0.118-0.238-0.192    c-1.56-1.248-1.884-1.505-2.181-1.741l-1.261-1.006c-1.004-0.8-1.499-0.541-4.068,2.157c-3.053,3.252-6.017,4.42-9.104,3.617    c-0.592-0.185-1.151-0.35-1.701-0.49c-0.07-0.018-0.138-0.043-0.203-0.076c-0.019-0.01-0.05-0.028-0.081-0.047    c-4.002-1.32-5.176-5.11-5.712-7.857c-0.73-3.718-1.007-4.21-2.298-4.066l-9.238,1.029c-1.295,0.15-1.447,0.644-1.349,4.399    c0.076,2.885-0.248,6.876-3.9,9.019c-0.584,0.297-1.105,0.564-1.616,0.858c-0.057,0.033-0.136,0.067-0.212,0.093    c-3.699,1.921-7.246,0.064-9.588-1.507c-3.15-2.118-3.691-2.267-4.497-1.257l-2.879,3.586c0.016-0.014-0.011,0.02-0.065,0.088    l-2.87,3.584c-0.806,1.012-0.544,1.507,2.163,4.074c2.071,1.959,4.643,4.975,3.63,9.053c-0.213,0.634-0.373,1.211-0.525,1.786    c-0.019,0.071-0.058,0.165-0.101,0.246c-1.297,3.988-5.099,5.177-7.854,5.724c-3.725,0.731-4.212,1.008-4.07,2.293l0.508,4.568    l0.011,0.108c0.27,2.414,0.297,2.66,0.346,3.111l0.159,1.453c0.143,1.278,0.675,1.441,4.406,1.348    c2.867-0.079,6.849,0.247,8.999,3.893c0.296,0.574,0.57,1.101,0.868,1.609c0.042,0.071,0.074,0.146,0.097,0.225    c1.893,3.754,0.046,7.266-1.514,9.587c-2.112,3.155-2.26,3.697-1.255,4.507l0.114,0.091c1.008,0.8,1.008,0.8,1.468,1.171    l1.993,1.603c0.051,0.033,0.1,0.071,0.144,0.114c1.773,1.419,2.022,1.616,2.352,1.877l1.193,0.949    c1.012,0.809,1.511,0.545,4.099-2.19c1.935-2.052,4.959-4.639,9.06-3.588c0.61,0.198,1.165,0.356,1.729,0.502    c0.057,0.015,0.112,0.034,0.165,0.059C41.954,81.056,41.998,81.08,42.039,81.104z M21.972,84.854c0,0.001,0.002,0.002,0.006,0.005    C21.976,84.858,21.974,84.856,21.972,84.854z M41.9,81.059c0.027,0.008,0.054,0.017,0.08,0.025    C41.956,81.075,41.929,81.066,41.9,81.059z M66.309,77.644c-0.026,0.011-0.054,0.025-0.083,0.043    C66.254,77.673,66.282,77.658,66.309,77.644z M22.277,66.181c0,0,0.001,0.001,0.001,0.002    C22.278,66.182,22.277,66.181,22.277,66.181z M81.071,58.039c-0.004,0.011-0.008,0.024-0.011,0.036    C81.064,58.064,81.068,58.051,81.071,58.039z M92.594,45.606c0,0.001,0,0.001,0.001,0.002    C92.595,45.608,92.595,45.607,92.594,45.606z M92.593,45.605L92.593,45.605L92.593,45.605z M92.502,45.268    c0,0.011,0,0.028,0.003,0.051C92.504,45.301,92.503,45.283,92.502,45.268z M58.046,18.927c0.004,0.001,0.009,0.003,0.013,0.004    C58.055,18.929,58.051,18.928,58.046,18.927z M76.969,16.756C76.969,16.756,76.969,16.756,76.969,16.756    C76.969,16.756,76.969,16.756,76.969,16.756z M76.967,16.755L76.967,16.755L76.967,16.755z M76.965,16.754    C76.965,16.754,76.965,16.755,76.965,16.754C76.965,16.755,76.965,16.754,76.965,16.754z M76.963,16.754    C76.963,16.754,76.963,16.754,76.963,16.754C76.963,16.754,76.963,16.754,76.963,16.754z M76.961,16.753L76.961,16.753    L76.961,16.753z M49.964,65.65c-3.537,0-6.945-1.189-9.747-3.43c-3.266-2.611-5.318-6.337-5.777-10.491    c-0.951-8.579,5.252-16.333,13.827-17.286c4.16-0.464,8.243,0.721,11.506,3.332c3.264,2.612,5.315,6.34,5.777,10.499    c0.462,4.154-0.722,8.24-3.335,11.504s-6.339,5.315-10.492,5.774C51.134,65.617,50.547,65.65,49.964,65.65z M50.025,36.301    c-0.512,0-1.026,0.029-1.543,0.086c-7.503,0.834-12.93,7.62-12.098,15.126c0.402,3.634,2.197,6.893,5.054,9.178    c2.857,2.284,6.433,3.32,10.069,2.916c0,0,0,0,0,0c3.633-0.401,6.893-2.195,9.179-5.051c2.287-2.857,3.323-6.432,2.919-10.066    c-0.405-3.639-2.2-6.902-5.055-9.188C56.099,37.342,53.119,36.301,50.025,36.301z"],fill:e.color})),makeNoEntryIcon:e=>'<svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><g fill-rule="evenodd" fill="'+e+'"><path data-name="Compound Path" d="M50,89.11A39.11,39.11,0,1,0,22.33,77.66,39,39,0,0,0,50,89.11ZM72,72a31.17,31.17,0,0,1-41.28,2.42l43.71-43.7A31.17,31.17,0,0,1,72,72ZM28,28a31.16,31.16,0,0,1,40.72-2.86L25.14,68.71A31.17,31.17,0,0,1,28,28Z"/></g></svg>',makeTrashIcon:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 24 26" version="1.1" x="0px" y="0px"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g transform="scale(1.2 1.2) translate(-2 0)"><rect x="0" y="0" width="24" height="24"/><path d="M5,6 L5.73274082,20.8571429 C5.73274082,20.8571429 5.99625939,22 6.98958614,22 L11.598019,22 L12.4359159,22 L17.0443487,22 C18.0380944,22 18.301613,20.8571429 18.301613,20.8571429 L19,6 L5,6 Z M15.5,8 L15.5,8 L15.5,8 C15.2205531,8 14.9908183,8.22036187 14.9791847,8.49956654 L14.5208153,19.5004335 L14.5208153,19.5004335 C14.5097883,19.7650799 14.7153876,19.9885573 14.980034,19.9995842 C14.9866857,19.9998614 14.9933425,20 15,20 L15,20 L15,20 C15.2794469,20 15.5091817,19.7796381 15.5208153,19.5004335 L15.9791847,8.49956654 L15.9791847,8.49956654 C15.9902117,8.23492012 15.7846124,8.01144271 15.519966,8.00041578 C15.5133143,8.00013862 15.5066575,8 15.5,8 Z M9.47918818,19.5003499 L9.02097843,8.49965006 L9.02097843,8.49965006 C9.00934688,8.22039979 8.77957571,8 8.50008331,8 L8.50008331,8 L8.50008331,8 C8.23515945,8 8.02039624,8.21476322 8.02039624,8.47968707 C8.02039624,8.48634356 8.02053479,8.49299933 8.02081182,8.49965006 L8.47902157,19.5003499 L8.47902157,19.5003499 C8.49065312,19.7796002 8.72042429,20 8.99991669,20 L8.99991669,20 L8.99991669,20 C9.26484055,20 9.47960376,19.7852368 9.47960376,19.5203129 C9.47960376,19.5136564 9.47946521,19.5070007 9.47918818,19.5003499 Z M8.00719509,3 L5.11111111,3 L5.11111111,3 C4.49746139,3 4,3.49746139 4,4.11111111 L4,4.11111111 L4,5 L20,5 L20,4.11111111 C20,3.49746139 19.5025386,3 18.8888889,3 L15.9926121,3 C15.9368649,2.4385197 15.4631369,2 14.8869871,2 L9.11301289,2 C8.99358834,2 8.87494478,2.0192532 8.76164871,2.05701856 C8.33332638,2.19979267 8.04982846,2.57814658 8.00719509,3 Z M12,8 C12.2761424,8 12.5,8.22385763 12.5,8.5 L12.5,19.5 C12.5,19.7761424 12.2761424,20 12,20 C11.7238576,20 11.5,19.7761424 11.5,19.5 L11.5,8.5 C11.5,8.22385763 11.7238576,8 12,8 Z" fill="#000000"/></g></g></svg>',makeCompressTimeIcon:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="-434 236 90 80" style="enable-background:new -434 236 90 90;" xml:space="preserve"><g fill-rule="evenodd" fill="'+e+'"><path d="M-354.9,251.1h-5.3h-2.6v2.6v27.8c-0.1-0.3-0.3-0.5-0.5-0.8l-29.1-29.1c-0.5-0.5-1-0.7-1.3-0.5c-0.4,0.2-0.5,0.6-0.5,1.3   v29.1c-0.1-0.3-0.3-0.5-0.5-0.8l-29.1-29.1c-0.5-0.5-1-0.7-1.3-0.5c-0.4,0.2-0.5,0.6-0.5,1.3v60.4c0,0.7,0.2,1.1,0.5,1.3   c0.4,0.2,0.8,0,1.3-0.5l29.1-29.1c0.2-0.2,0.4-0.5,0.5-0.8v29.1c0,0.7,0.2,1.1,0.5,1.3c0.4,0.2,0.8,0,1.3-0.5l29.1-29.1   c0.2-0.2,0.4-0.5,0.5-0.8v27.8v2.6h2.6h5.3h2.6v-2.6v-57.8v-2.6H-354.9z"/></g></svg>',makeSmallUdacityIcon:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="'+e.width+'px" height="'+e.height+'px" viewBox="0 0 32 32" enable-background="new 0 0 32 32"><image x="0" y="0" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAABGdBTUEAALGPC/xhBQAAACBjSFJN AAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAABOFBMVEUAs+YAsuYKvOkSveo1 xezR8vv6/v6I3PQowuu+7Pn///+V4PUCu+my6Pgdv+u66/ln0/Hv+v31/P531/P9/v8At+j3/f7a 9PxLy+/+//8twuzM8Pv8/v9t1fLt+v3u+v1v1fIAtOeY4fXg9vxKy+6S3/UAuOgAtecAs+f2/P4g v+ut5/d21/NXzvCg4/ZWzvDi9/zT8vs9yO3l+PwAuenc9fuX4fWG3PPC7frD7fpHyu4zxez7/v84 xu3s+f0MvOp42POo5fdUzu/U8vxZz/CR3/Wr5vfS8vvn+P0rw+wPvOokwOv5/f606fgAuunX8/xr 1PLQ8ftSze8AtugnwuuU4PUEu+nW8/yJ3PQYv+qQ3/TP8fuq5vfh9vzB7fq/7Pn0/P5w1fI3xu2s 5/fm+PyN3vQ5x+0xxOwxFuTVAAAAAWJLR0QKaND0VgAAAAlwSFlzAAAWJQAAFiUBSVIk8AAAAAd0 SU1FB+IKHAUqGL3rdjoAAAFBSURBVDjL5dPZUsIwFAbgBMTqj6BiF0FcsGLdEaniUtwVVMR93/f3 fwPbkpS0Os5wbW7Sk/NN0ov/EEL/XIQ0AUgo0Az7QUukVRLbbe2ICqAjBns12vHOes0A6epGokf2 gCKp0HqTHkj1AbEQTXPQP4DBoQz1wLAMfcQ+9wCQHbU3DwCSQf3ArQUwRv8RUINgPAB0TIhAgRYA k5gSwTRmGEgj457nMOt+EBeQPOYYKMCsR2oeC85uwn6cFrHIE7WE5frVKxaydl1CnpJicnWNg3Vs sN/ftLC1bexgN1dGZc8L7b4lHzBR0oGq5aTtsCakOoojhQnj+MRpF059sT8rIxLmeTyvQL7gnof2 8grq9Y07C7dV3KV+Do5yb9/78PikAc8v4rA1Buf1LeE8/v5h+qZLHD0j/vlVo4HV1PD+Dr4BCLwn yyZy1tMAAAAldEVYdGRhdGU6Y3JlYXRlADIwMTgtMTAtMjhUMTI6NDI6MjQtMDc6MDC16UJJAAAA JXRFWHRkYXRlOm1vZGlmeQAyMDE4LTEwLTI4VDEyOjQyOjI0LTA3OjAwxLT69QAAAABJRU5ErkJg gg==" width="32" height="32"></image></svg>',makeLabelHtml:e=>{const n=e.dimensions,t={style:"width:"+n.width+"px;height:"+n.height+"px;left:"+n.x+"px;top:"+n.y+"px;opacity:"+e.opacity+";color:"+e.color+";padding-top:10px;"};return'<div class="bxy-sticker-inner">'+o.makeElementHtml("div",t,"<div>"+e.label+"</div>")+"</div>"},makeHomeFolderIcon:e=>'<svg xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://www.w3.org/2000/svg" xmlns:cc="http://creativecommons.org/ns#" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" version="1.1" x="0px" y="0px" viewBox="10 10 75 75"><g transform="translate(0,-952.36218)"><path style="baseline-shift:baseline;block-progression:tb;color:#000000;direction:ltr;text-indent:0;enable-background:accumulate;text-transform:none;" fill="#000" d="m13.812,968.89c-0.51636,0.005-0.86248,0.14455-1.0312,0.28125-0.16877,0.1367-0.25,0.26805-0.25,0.65625v3.8125,1h-1-1.5312c-0.41876,0.003-0.66765,0.1155-0.8125,0.25-0.13976,0.1297-0.2422,0.34985-0.25,0.78125,0.000058,0.017-0.000057,0.0143,0,0.0312,0.0088,2.6282,0.0011,3.3996,0,4.8438h82.125v-4.875c0-0.4119-0.12605-0.606-0.28125-0.75s-0.3925-0.29125-0.875-0.28125h-0.03125-44.562-1v-1-3.7188c0-0.4015-0.08843-0.6006-0.25-0.75s-0.44128-0.28125-0.875-0.28125h-29.375zm-5.4688,13.656c-0.050524,0.004-0.098821,0.0172-0.15625,0.0312-0.064504,0.012-0.13338,0.0425-0.1875,0.0625-0.34403,0.1268-0.49236,0.38875-0.5,0.78125-0.000232,0.012,0,0.0193,0,0.0312l1.7812,51.437a1.0001,1.0001,0,0,1,0,0.062c0,0.1465,0.079205,0.3075,0.34375,0.5,0.26454,0.1926,0.71304,0.3438,1.0938,0.3438l79.031,0.031a1.0001,1.0001,0,0,1,0.03125,0c0.56827,0.011,0.65633-0.094,0.65625-0.094-0.00008,0.0001,0.10538-0.1587,0.09375-0.7188a1.0001,1.0001,0,0,1,0,-0.062l1.97-51.44c0-0.012,0.000232-0.0192,0-0.0312-0.0077-0.3976-0.14181-0.6885-0.5-0.8125h-0.03125c-0.11803-0.036-0.27448-0.0625-0.4375-0.0625h-0.03125-83.031a1.0001,1.0001,0,0,1,-0.0625,0c-0.023769,0.0009-0.039804,0-0.0625,0zm41.656,8.375,20.219,20.219-3.9062,3.9375-3.2812-3.2812,0,15.656-10.438,0,0-7.8125c0-1.4454-1.1484-2.625-2.5938-2.625s-2.625,1.1796-2.625,2.625v7.8125h-10.438v-15.656l-3.25,3.2812-3.9062-3.9375,20.22-20.18zm7.8125,2.625,5.2188,0,0,7.1562-5.2188-5.2187,0-1.9375z"/></g></svg>',makeLabelSvg:e=>{const n=e.dimensions,t=e.buffer||4,r="0 0 "+n.width+" "+n.height,i=o.makeBufferedViewBox({buffer:t,bufferAllSides:!0,viewBox:r});let a={x:0,y:16,text:e.label,"font-size":18,width:n.width,height:n.height,stroke:e.color,fill:e.color,dashed:e.dashed,"stroke-width":e.strokeWidth,"fill-opacity":e.fillOpacity};o.interpretDashing(e,a);const l={el:o.makeSvgElement("text",a),x:n.x,y:n.y,width:n.width,height:n.height,viewBox:i};return o.renderSvg([l])},makeCustom:e=>{const n=e.dimensions;let t='<img src="'+e.imageUrl+'" style="width:'+n.width+"px;height:"+n.height+"px;top:"+n.y+"px;left:"+n.x+"px;opacity:1.0;";return void 0!==e.cssTransform&&(t+="transform:"+e.cssTransform),t+='">',t}},i=o},55:(e,n,t)=>{var r=t(994),o=t(227);"string"==typeof(o=o.__esModule?o.default:o)&&(o=[[e.id,o,""]]);r(o,{insert:"head",singleton:!1}),e.exports=o.locals||{}},994:(e,n,t)=>{"use strict";var r,o=function(){var e={};return function(n){if(void 0===e[n]){var t=document.querySelector(n);if(window.HTMLIFrameElement&&t instanceof window.HTMLIFrameElement)try{t=t.contentDocument.head}catch(e){t=null}e[n]=t}return e[n]}}(),i=[];function a(e){for(var n=-1,t=0;t<i.length;t++)if(i[t].identifier===e){n=t;break}return n}function l(e,n){for(var t={},r=[],o=0;o<e.length;o++){var l=e[o],c=n.base?l[0]+n.base:l[0],u=t[c]||0,s="".concat(c," ").concat(u);t[c]=u+1;var f=a(s),d={css:l[1],media:l[2],sourceMap:l[3]};-1!==f?(i[f].references++,i[f].updater(d)):i.push({identifier:s,updater:v(d,n),references:1}),r.push(s)}return r}function c(e){var n=document.createElement("style"),r=e.attributes||{};if(void 0===r.nonce){var i=t.nc;i&&(r.nonce=i)}if(Object.keys(r).forEach((function(e){n.setAttribute(e,r[e])})),"function"==typeof e.insert)e.insert(n);else{var a=o(e.insert||"head");if(!a)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");a.appendChild(n)}return n}var u,s=(u=[],function(e,n){return u[e]=n,u.filter(Boolean).join("\n")});function f(e,n,t,r){var o=t?"":r.media?"@media ".concat(r.media," {").concat(r.css,"}"):r.css;if(e.styleSheet)e.styleSheet.cssText=s(n,o);else{var i=document.createTextNode(o),a=e.childNodes;a[n]&&e.removeChild(a[n]),a.length?e.insertBefore(i,a[n]):e.appendChild(i)}}function d(e,n,t){var r=t.css,o=t.media,i=t.sourceMap;if(o?e.setAttribute("media",o):e.removeAttribute("media"),i&&"undefined"!=typeof btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(i))))," */")),e.styleSheet)e.styleSheet.cssText=r;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(r))}}var p=null,h=0;function v(e,n){var t,r,o;if(n.singleton){var i=h++;t=p||(p=c(n)),r=f.bind(null,t,i,!1),o=f.bind(null,t,i,!0)}else t=c(n),r=d.bind(null,t,n),o=function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(t)};return r(e),function(n){if(n){if(n.css===e.css&&n.media===e.media&&n.sourceMap===e.sourceMap)return;r(e=n)}else o()}}e.exports=function(e,n){(n=n||{}).singleton||"boolean"==typeof n.singleton||(n.singleton=(void 0===r&&(r=Boolean(window&&document&&document.all&&!window.atob)),r));var t=l(e=e||[],n);return function(e){if(e=e||[],"[object Array]"===Object.prototype.toString.call(e)){for(var r=0;r<t.length;r++){var o=a(t[r]);i[o].references--}for(var c=l(e,n),u=0;u<t.length;u++){var s=a(t[u]);0===i[s].references&&(i[s].updater(),i.splice(s,1))}t=c}}}},379:function(e,n,t){"use strict";var r=this&&this.__awaiter||function(e,n,t,r){return new(t||(t=Promise))((function(o,i){function a(e){try{c(r.next(e))}catch(e){i(e)}}function l(e){try{c(r.throw(e))}catch(e){i(e)}}function c(e){var n;e.done?o(e.value):(n=e.value,n instanceof t?n:new t((function(e){e(n)}))).then(a,l)}c((r=r.apply(e,n||[])).next())}))};Object.defineProperty(n,"__esModule",{value:!0}),n.registerBbyButtons=n.workRegx=void 0;const o=t(419),i=t(471),a=t(475);t(55);const l=window.Jupyter;n.workRegx=/work\/lessons-(\d+)-(\w+)\.ipynb/;class c extends Error{constructor(e,n,t){super(e),n&&(this.cellIndex=n),t&&(this.detail=t)}}n.registerBbyButtons=()=>{l.toolbar.add_buttons_group([l.keyboard_manager.actions.register({help:"同步课程",icon:"fa-retweet",handler:M},"sync-lesson","ipybbycell")]),l.toolbar.add_buttons_group([l.keyboard_manager.actions.register({help:"添加「课程」",icon:"fa-book",handler:v},"add-lesson","ipybbycell")]),l.toolbar.add_buttons_group([l.keyboard_manager.actions.register({help:"添加「普通 Step」",icon:"fa-font",handler:p},"add-string-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「Verify Step」",icon:"fa-columns",handler:g},"add-verify-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「OJ Step」",icon:"fa-magic",handler:h},"add-oj-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「Matplotlib Step」",icon:"fa-area-chart",handler:m},"add-matplotlib-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「Turtle Step」",icon:"fa-pencil",handler:y},"add-turtle-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「Quiz Step」",icon:"fa-question-circle",handler:x},"add-quiz-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「Upload File Step」",icon:"fa-upload",handler:b},"add-upload-file-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「折叠块」",icon:"fa-eye",handler:_},"add-detail-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「图片播放器」",icon:"fa-image",handler:w},"add-image-player-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「视频」",icon:"fa-file-video-o",handler:k},"add-video-player-step","ipybbycell"),l.keyboard_manager.actions.register({help:"添加「音频」",icon:"fa-file-audio-o",handler:C},"add-audio-player-step","ipybbycell")]),l.toolbar.add_buttons_group([l.keyboard_manager.actions.register({help:"添加「文件 Cell」",icon:"fa-file",handler:A},"add-file-cell","ipybbycell")])};const u=function(e){l.notebook.insert_cell_below("code").set_text(e),l.notebook.select(l.notebook.get_selected_index()+1),l.notebook.focus_cell()},s=function(e){l.notebook.insert_cell_below("markdown").set_text(e),l.notebook.select(l.notebook.get_selected_index()+1),l.notebook.focus_cell()},f=function(e){const n=l.notebook.get_selected_index();if(!n)return void alert("请选中一个 Markdown Cell");const t=l.notebook.get_cell(n);"markdown"===t.cell_type?t.set_text(t.get_text()+"\n"+e):alert("请选中一个 Markdown Cell")},d=function(){s("### 步骤标题"),u("#platform-desc\nfrom ipyaliplayer import Player\nPlayer(vid='--替换你的视频id，上传地址 https://www.boyuai.com/elites/admin/public-video', aspect_ratio=4/3)\n"),s("\x3c!--步骤描述 --\x3e\n\n#### 知识点\n- 总结视频中的知识点\n\n#### 代码练习说明\n- 代码练习题目说明\n\n#### 代码练习提示\n- 代码练习提示")},p=function(){d(),u("#platform-lock-hidden\n\n# platform-lock-hidden 的代码不会展示，但会被运行\n\ndef add(x):\n  return x + 1"),u("#platform-edit\n\n# platform-edit 可被学员编辑\n\n$$$"),u("#platform-edit-answer\n\n# 练习答案代码\n# 我们提供“一键填入”功能将答案复制到对应的代码块中\n# 建议 platform-edit-answer 块是直接在 platform-edit 块的基础上修改，并添加额外的解释说明\n\nx = add(0)"),u('#platform-lock\n\n# platform-lock 的代码会被展示和运行，无法修改\nprint("add(0) =", x)'),s("add(0) = 1")},h=function(){s("### 步骤标题"),u("#platform-desc\n"),s("#### 题目描述\n\n在此处填写题目描述\n\n#### 输入描述\n\n在此处填写输入描述\n\n#### 输出描述\n\n在此处填写输出描述\n\n#### 输入样例\n\n在此处填写输入样例\n\n#### 输出样例\n\n在此处填写输出样例\n"),u("//platform-edit\n#include <iostream>\nusing namespace std;\n\nint main(){\n    \n    return 0;\n}"),u("//platform-edit-answer\n//参考答案\n#include <iostream>\nusing namespace std;\n\nint main(){\n\n    \n    return 0;\n}"),s("ONLINE_JUDGE_PROBLEM_ID=XXX")},v=function(){l.notebook.insert_cell_below("markdown").set_text("## 单元标题\n\n单元简介（目前不展示这部分，所以可以写的简单一点）"),l.notebook.delete_cells(),p()},g=function(){d(),u("#platform-edit\n\ndef add(x):\n  return x"),u("#platform-edit-answer\n\ndef add(x):\n  return x + 1"),u("#platform-lock\nprint(add(1))"),u('#platform-verify\nimport json\nif add(2) == 3 and add(-1) == 0:\n  print(json.dumps({"result": True, "displayResult": "good"}))\nelse:\n  print(json.dumps({"result": False, "displayResult": "bad"}))')},m=function(){d(),u("#platform-edit\n\nimport matplotlib.pyplot as plt\nplt.plot([1, 2, 3])\nplt.show()"),u("#platform-edit-answer\n\nimport matplotlib.pyplot as plt\nplt.plot([1, 2, 3, 4])\nplt.show()"),u('#platform-lock-hidden\n\n# 不要修改\nprint("#matplotlib#")'),s("#matplotlib#")},y=function(){d(),u("#platform-lock\nfrom ipyturtle2 import TurtleWidget\n\nt = TurtleWidget()\nt"),u("#platform-edit\n\nt.forward(100)\nt.left(90)\nt.pencolor('red')\nt.forward(100)\nt.left(90)\nt.forward(100)\nt.left(90)\nt.forward(100)"),u("#platform-edit-answer\n\nt.forward(100)\nt.left(90)\nt.pencolor('blue')\nt.forward(100)"),u('#platform-lock-hidden\n\n# 不要修改\nprint("#turtle#")'),s("#turtle#")},x=function(){s("### 步骤标题"),u("#platform-desc\nfrom ipyaliplayer import Player\nPlayer(vid='--替换你的视频id，上传地址 https://www.boyuai.com/elites/admin/public-video', aspect_ratio=4/3)\n"),s("\x3c!--步骤描述 --\x3e\n\n#### 知识点\n- 总结视频中的知识点"),u('#platform-quiz\nimport ipyquiz\ntype = "normal"\nquizzes = []\n\nquizzes.append({\n  "id": "fill-1",\n  "type": "FILL",\n  "title": "学习是系统通过____提升性能的过程。",\n  "answer": "经验"\n})\n\nquizzes.append({\n  "id": "fill-2",\n  "type": "FILL",\n  "title": """\n试试**markdown**吧\n$x+1$\n""",\n  "answer": "1"\n})\n\nquizzes.append({\n  "id": "fill-3",\n  "type": "FILL",\n  "title": "填啥都行",\n  "answer": ""\n})\n\nquizzes.append({\n  "id": "choice-1",\n  "type": "SELECT",\n  "title": "matplotlib 绘制图形的基本组成包含文字部分和图形部分，以下说法错误的是：",\n  "answer": "1",\n  "options": [\n      {\n          "value": "0",\n          "text": "图形标题、图例是基本组成中的文字部分。"\n      },\n      {\n          "value": "1",\n          "text": "x、y 坐标轴、刻度标签是基本组成中的文字部分。"\n      },\n      {\n          "value": "2",\n          "text": "边框、网格是基本组成中的图形部分。"\n      },\n      {\n          "value": "3",\n          "text": "数据图形（折线图及散点图）是基本组成中的图形部分。"\n      },\n  ]\n})\n\nquizzes.append({\n  "id": "choice-2",\n  "type": "SELECT",\n  "title": "以下关于 matplotlib 绘制图形的层次的说法，错误的是：",\n  "answer": "3",\n  "options": [\n      {\n          "value": "0",\n          "text": "画架层（canvas）类似于在绘画时需要一个画架放置画板。"\n      },\n      {\n          "value": "1",\n          "text": "画板层（figure）是指在画板上可以铺上画纸，是允许绘图的最大空间"\n      },\n      {\n          "value": "2",\n          "text": "画纸层（axes）上可以进行各种图形的绘制，图形的组成元素在画纸上体现"\n      },\n      {\n          "value": "3",\n          "text": "画板层（figure）可以包含一张画纸绘制单个图，但是无法包含多张画纸绘制多个子图或者图中图。"\n      },\n  ]\n})\n\nipyquiz.QuizWidget(value=quizzes, type=type quiz_id="__ipyquiz_quiz_id")\n')},b=function(){s("### 步骤标题"),u("#platform-desc\nfrom ipyaliplayer import Player\nPlayer(vid='--替换你的视频id，上传地址 https://www.boyuai.com/elites/admin/public-video', aspect_ratio=4/3)\n"),s("\x3c!--步骤描述 --\x3e\n\n#### 知识点\n- 总结视频中的知识点"),u('#platform-upload-file\n[\n  {\n      "file-type": "image",\n      "file-max-count": 1,\n      "title": "请上传一张图片"\n  },\n  {\n      "file-type": "doc",\n      "file-max-count": 2,\n      "title": "请上传全部的文本文件"\n  }\n]')},_=function(){f("\n<details>\n\n<summary>标题</summary>\n\n内容\n\n</details>\n  ")},w=function(){f('\n\x3c!-- ---------------------------------------- --\x3e\n\x3c!-- /////////// 图片播放器 Begin /////////// --\x3e\n\x3c!-- ---------------------------------------- --\x3e\n<div class="image-player">\n<div class="image-viewer">\n\n\n\x3c!-------------- 在此处添加图片资源 -------------------\x3e\n<img src="【在此处粘贴替换图片地址】" />\n<img src="【在此处粘贴替换图片地址】" />\n<img src="【在此处粘贴替换图片地址】" />\n\x3c!-------------- 在此处添加图片资源 -------------------\x3e\n\n\n</div>\n<div class="button-wrapper">\n<button class="last"></button>\n<div>\n<span class="current">0</span>\n<span>/</span>\n<span class="total">0</span>\n</div>\n<button class="next"></button>\n</div>\n</div>\n\x3c!-- ---------------------------------------- --\x3e\n\x3c!-- /////////// 图片播放器 End //////////// --\x3e\n\x3c!-- ---------------------------------------- --\x3e\n')},k=function(){f('\n\x3c!-- ---------------------------------------- --\x3e\n\x3c!-- /////////// 视频播放器 Begin /////////// --\x3e\n\x3c!-- ---------------------------------------- --\x3e\n<div class="ipy-ali-player" data-vid="【此处填入视频vid】" data-aspect-ratio="4/3"></div>\n\x3c!-- ---------------------------------------- --\x3e\n\x3c!-- /////////// 视频播放器 End //////////// --\x3e\n\x3c!-- ---------------------------------------- --\x3e\n')},C=function(){f('\n\x3c!-- ---------------------------------------- --\x3e\n\x3c!-- /////////// 音频播放器 Begin /////////// --\x3e\n\x3c!-- ---------------------------------------- --\x3e\n<audio controls>\n  <source src="【此处填入音频链接】" />\n</audio>\n\x3c!-- ---------------------------------------- --\x3e\n\x3c!-- /////////// 音频播放器 End //////////// --\x3e\n\x3c!-- ---------------------------------------- --\x3e\n')},A=function(){u("#platform-lock-hidden\n\nimport os\n# basepath与惠楚确认\nbasepath = os.path.expanduser('~/share/bby/')\n\n# 以下2选1, 请阅读博小鱼对接文档\n#os.chdir(basepath)\n#filepath = os.path.join(basepath, 'test.txt')")},M=function(){return r(this,void 0,void 0,(function*(){const e=l.notebook.toJSON(),t=n.workRegx.exec(l.notebook.notebook_path),u=/user\/(dev-)?user-(\d+)/.exec(l.notebook.base_url);if(!t||!u)return void alert("工作路径匹配失败");const s="dev-"===u[1]?"dev.boyuai.com":"www.boyuai.com",f=Number(t[1]),d=t[2],p=`https://${s}/api/v1`,h=Number(u[2]),v=()=>r(this,void 0,void 0,(function*(){const n={content:e,userId:h,token:d};fetch(`${p}/lessons/${f}/jupyter`,{body:JSON.stringify(n),headers:{"content-type":"application/json"},method:"PUT"}).then((e=>{e.ok?alert("同步成功，请刷新博小鱼步骤页后查看，中途请不要运行代码"):e.json().then((e=>{const n=e.message||e.error||"原因未知";alert("同步失败, "+n)}))})).catch((e=>{console.error(e)}))}));try{const n=o.parseStepsFromCells(e);for(let t=0;t<n.length;t++){const r=n[t];if("code"===r.stepType&&""===r.verify&&!r.verifyCode){let n=r.codeAnswerCells[r.codeAnswerCells.length-1];if((!n||n.$cellIndex<r.codeCells[r.codeCells.length-1].$cellIndex)&&(n=r.codeCells[r.codeCells.length-1]),!n)throw new c(`代码题步骤 ${r.title} 的 Code cell 不合法`);const t=e.cells[(n.$cellIndex||0)+1];if(!t||"markdown"!==t.cell_type||""!==t.source)throw new c(`代码题步骤 ${r.title} 没有正确预留verify块`,n.$cellIndex,`cellIndex ${n.$cellIndex||0}`)}}for(let n=0;n<e.cells.length;n++){const t=e.cells[n];if(!(t.outputs&&(t.outputs=[],t.execution_count=null),Object.keys(t.metadata).forEach((e=>{e.startsWith("bxy")||delete t.metadata[e]})),"markdown"!==t.cell_type||0!==t.source.indexOf("### ")||e.cells[n+1]&&0==e.cells[n+1].source.indexOf("#platform-desc")))throw new c(`步骤 ${t.source.replace("###","")} 没有预留视频块`,n,`cellIndex: ${n}\n\n模板：\n#platform-desc\n# from ipyaliplayer import Player\n# Player(vid='替换视频ID', aspect_ratio=4/3)`);const{type:r,code:l}=o.parseCodeCell(t.source);if("quiz"===r){const e=yield a.parseQuizQuestions({code:l,userId:h,lessonId:f,token:d,apiPrefix:p});if(null==e?void 0:e.statusCode)throw new c(`Quiz 解析失败: ${null==e?void 0:e.message}`,n,l);if(!e.value||!e.value.length)throw new c("Quiz 解析失败: 缺少选项",n);for(const r of e.value){if("string"==typeof r.id&&r.id.startsWith("uuid-")){const t=r.id.slice(5),o=yield a.getQuizQuestionByUUID({uuid:t,apiPrefix:p});if(!o.uuid)throw new c(`Quiz 解析失败: 题目 ${r.id} 解析异常`,n);const l=e.value.findIndex((e=>e.id===r.id));if(-1===l)throw new c(`Quiz 解析失败: 题目 ${r.id} 匹配失败`,n);const u=i.parseQuestionOptions(o);e.value[l]=Object.assign(Object.assign({},o),{id:r.id,options:u}),console.log("quiz quetion 更新完成",{question:e.value[l]})}t.metadata.bxyQuizStep||(t.metadata.bxyQuizStep={}),t.metadata.bxyQuizStep.json=e}}}v()}catch(e){l.dialog.modal({title:"可能存在错误，请确认是否同步",body:`<p style="margin-bottom: 8px">${(null==e?void 0:e.message)||"未知错误"}</p><pre>${(null==e?void 0:e.detail)||JSON.stringify(e)}</pre>`,sanitize:!1,buttons:{强行同步:{click:v},[null!=e.cellIndex?"取消同步，查看错误Cell":"取消同步"]:{class:"btn-primary",click:()=>{null!=e.cellIndex&&(l.notebook.select(e.cellIndex),l.notebook.focus_cell())}}}})}}))}},112:(e,n,t)=>{"use strict";var r,o;Object.defineProperty(n,"__esModule",{value:!0});const i=t(379),a=t(673);window.__webpack_public_path__=document.querySelector("body").getAttribute("data-base-url")+"nbextensions/ipybbycell",r=[t(636),t(273)],void 0===(o=((e,n)=>(window.requirejs.config({map:{"*":{ipybbycell:"nbextensions/ipybbycell/extension"}}}),{load_ipython_extension:function(){(i.workRegx.test(e.notebook.notebook_path)||location.host.includes("localhost"))&&(console.log("Current namespace:",e),i.registerBbyButtons(),n("#jupyter_bby_help").length>0||n("<li/>").append(n("<a/>").html("博小鱼文档").attr("title","博小鱼文档").attr("id","jupyter_bby_help").attr("href","https://fe9m1yda6v.feishu.cn/docs/doccnfjrG2MKIq7echn96kyuakc").attr("target","_blank").append(n("<i/>").addClass("fa fa-external-link menu-icon pull-right"))).insertBefore(n(n("#help_menu > .divider")[1])),a.registerBxyPanel())}})).apply(n,r))||(e.exports=o)},673:function(e,n,t){"use strict";var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(n,"__esModule",{value:!0}),n.registerBxyPanel=void 0;const o=t(966),i=r(t(666)),a=window.Jupyter,l=window.$,c=window._;t(55),n.registerBxyPanel=()=>{f.init()};const u="显示博小鱼面板",s="隐藏博小鱼面板",f={init:()=>{console.log("bxy: Main constructor running.");const e=d.getAccessLevel();"create"===e&&p.ensureNotebookGetsBxyId(),f.initSetupButton(),a.notebook.metadata.bxyId&&p.loadManifest(e).then((()=>{f.initInteractivity()})).catch((e=>{console.log("bxy: Not setting up bxy because this notebook has never had any authoring done yet (no recordingId)."),console.log(e)}))},initSetupButton:()=>{let e,n=!1;if(a.notebook.metadata.bxyId)e=u;else{const t=l("#bxy-setup-button");t.length>0&&t.remove(),e="激活博小鱼面板",n=!0}const t=l('<div id="bxy-setup-button" style=display:none; class="btn-group"><button class="btn btn-default" title="博小鱼面板开关"><span>'+e+"</div></button></span>"),r=l("#maintoolbar-container");t.appendTo(r),n?l("#bxy-setup-button").click((()=>{f.firstTimeSetup()})):l("#bxy-setup-button").click((()=>{f.toggleAccessLevel()})),l("#bxy-setup-button").show()},initInteractivity:()=>{f.addEvents(),f.setupControlPanels(),f.updateControlPanels();for(const e of a.notebook.get_cells())f.refreshCellSideMarker(e)},firstTimeSetup:()=>{p.ensureNotebookGetsBxyId(),h.queueSaveNotebookCallback((()=>{f.initInteractivity(),f.toggleAccessLevel("create"),l("#bxy-setup-button").unbind("click").click((()=>{f.toggleAccessLevel()}))})),h.saveNotebookDebounced()},addEvents:()=>{a.notebook.events.on("select.Cell",((e,n)=>{console.log("bxy: cell select event fired, e, cell:",e,n.cell),f.updateControlPanels()})),a.notebook.events.on("create.Cell",((e,n)=>{const t=n.cell;void 0===h.getMetadataCellId(t.metadata)?h.setMetadataCellId(t.metadata,h.generateUniqueId()):h.getMetadataCellId(t.metadata),h.refreshCellMaps(),f.updateControlPanels()})),a.notebook.events.on("delete.Cell",((e,n)=>{console.log("bxy: cell delete event fired, e, cell:",e,n.cell),h.refreshCellMaps(),f.toggleAccessLevel("view")})),a.notebook.events.on("set_dirty.Notebook",((e,n)=>{h.refreshCellMaps()})),window.addEventListener("mousemove",(e=>{let n,t;d.setPointerPosition({x:e.clientX,y:e.clientY});const r=d.getPointerPosition(),o=f.sitePanel[0].getBoundingClientRect(),i=f.outerControlPanel.width(),a=f.outerControlPanel.height();if(d.getControlPanelDragging()){const e=d.getControlPanelDragOffset();n={x:r.x-e.left,y:r.y-e.top}}if(void 0!==n){t={x:Math.min(window.innerWidth-i-25,Math.max(0,n.x)),y:Math.min(o.bottom-a-25,Math.max(25,n.y))};const e={left:t.x+"px",top:t.y+"px",right:"unset"};f.outerControlPanel.css(e)}}))},changeAccessLevel:e=>{"create"===e?(p.ensureNotebookGetsBxyId(),h.assignCellIds(),h.queueSaveNotebookCallback((()=>{})),h.saveNotebookDebounced()):f.outerControlPanel.fadeOut(f.panelFadeTime),d.setAccessLevel(e),f.updateControlPanels()},toggleAccessLevel:e=>{let n;const t=void 0===e?d.getAccessLevel():e;void 0!==e?"create"===t?(n=s,f.changeAccessLevel("create")):(n=u,f.changeAccessLevel("view")):"create"===t?(n=u,f.changeAccessLevel("view")):(n=s,f.changeAccessLevel("create")),l("#bxy-setup-button span:last").text(n)},panelFadeTime:350,sitePanel:l(),outerControlPanel:l(),controlPanelsShell:l(),controlPanelIds:{},setupControlPanels:()=>{0===l("#bxy-outer-control-panel").length&&l('<div id="bxy-outer-control-panel">  <div id="bxy-inner-control-panel">    <div class="bxy-small-dot-pattern" id="bxy-drag-handle">&nbsp;&nbsp;</div>    <div id="bxy-control-panels-shell"></div>  </div></div>').appendTo(l("body")),f.sitePanel=l("#site"),f.outerControlPanel=l("#bxy-outer-control-panel"),f.outerControlPanel.hide(),f.controlPanelsShell=l("#bxy-control-panels-shell"),l("#bxy-drag-handle").on("mousedown",(e=>{f.startPanelDragging(e)})).on("mouseup",(e=>{d.getControlPanelDragging()&&(console.log("bxy: no longer dragging control panel"),d.setControlPanelDragging(!1),e.preventDefault(),e.stopPropagation())})),f.setupOneControlPanel("bxy-control-panel-title",'<div></div><div id="bxy-logo-text">博小鱼控制面板</div>'),f.setupOneControlPanel("bxy-notifier","<div />");const e=e=>e.on("focus",(()=>{a.keyboard_manager.disable()})).on("blur",(()=>{a.keyboard_manager.enable()})),n=(e,n)=>l('<div class="bxy-form-item" id="'+e+`"><span style="flex: 1;text-align-last: justify;">${n}</span></div>`);f.setupOneControlPanel("bxy-lesson-config",'<div class="bxy-config-title">单元配置</div>');const t=n("poster-template-item","海报模板ID");l("#bxy-lesson-config").append(t);const r=e(l('<input style="width: 130px;" />').attr("type","text").on("input",(e=>{const n=e.target.value;n?a.notebook.metadata.bxyPosterId=n:delete a.notebook.metadata.bxyPosterId})));l("#poster-template-item").append(r),f.setupOneControlPanel("bxy-cell-config",'<div class="bxy-config-title">Cell配置</div>');const i=n("poster-slot-item","海报素材占位ID");l("#bxy-cell-config").append(i);const c=e(l('<input style="width: 100px;" />').attr("type","text").on("input",(e=>{const n=e.target.value,t=a.notebook.get_selected_cell();n?t.metadata.bxyPosterSlotId=n:delete t.metadata.bxyPosterSlotId})));l("#poster-slot-item").append(c);const u=n("poster-quiz-option-item","海报Quiz占位ID");l("#bxy-cell-config").append(u);const s=e(l('<input style="width: 100px;" />').attr("type","text").on("input",(e=>{f.resetNotifier(),d.formHasError=!1;const n=e.target.value,t=a.notebook.get_selected_cell();try{t.metadata=o.markQuizOptionSlots(t.metadata,n)}catch(e){f.setNotifier((null==e?void 0:e.message)||"未知错误"),d.formHasError=!0}})));l("#poster-quiz-option-item").append(s),f.setupOneControlPanel("bxy-config-btns","");const p=()=>{h.saveNotebookDebounced();const e=a.notebook.get_selected_cell();f.refreshCellSideMarker(e),alert("保存成功")},v=l('<button class="bxy-save-btn">保存</button>').on("click",(()=>{d.formHasError?alert("请先改正配置"):p()})),g=l('<button class="bxy-close-btn">保存并关闭</button>').on("click",(()=>{d.formHasError?alert("请先改正配置"):(p(),f.toggleAccessLevel("view"))}));l("#bxy-config-btns").append(v),l("#bxy-config-btns").append(g)},updateControlPanels:()=>{const e=d.getAccessLevel(),n="none"===f.outerControlPanel.css("display");"create"===e&&n&&f.outerControlPanel.fadeIn(f.panelFadeTime),f.resetNotifier();const t=a.notebook.metadata.bxyPosterId;l("#poster-template-item input").val(t||"");const r=a.notebook.get_selected_cell().metadata,i=r.bxyPosterSlotId,c=o.parseQuizOptionSlots(r);l("#poster-slot-item input").val(i||""),l("#poster-quiz-option-item input").val(c||""),f.showControlPanels(["bxy-notifier","bxy-lesson-config","bxy-cell-config","bxy-config-btns"])},showControlPanels:e=>{f.controlPanelsShell.children().hide(),f.controlPanelIds["bxy-control-panel-title"].css({display:"flex"});for(const n of e)f.controlPanelIds[n].show()},setupOneControlPanel:(e,n,t)=>{void 0===f.controlPanelIds&&(f.controlPanelIds={}),l('<div class="bxy-control-panel" id="'+e+'">'+n+"</div>").appendTo(f.controlPanelsShell),f.controlPanelIds[e]=f.controlPanelsShell.find("#"+e),f.bindControlPanelCallbacks(f.controlPanelIds[e],t)},bindControlPanelCallbacks:(e,n)=>{if(void 0!==n){let t,r;for(t of n)for(r of t.ids)e.find("#"+r).on(t.event,t.fn)}},startPanelDragging:e=>{console.log("bxy: dragging control panel");const n=f.outerControlPanel.position(),t=d.getPointerPosition();d.setControlPanelDragging(!0),d.setControlPanelDragOffset({left:t.x-n.left,top:t.y-n.top}),e.preventDefault(),e.stopPropagation()},refreshCellSideMarker:e=>{const n=l(e.element[0]);if(n.find(".bxy-right-side-marker").unbind("mouseenter mouseleave click").remove(),!e.metadata.bxyCellId)return;if(Object.keys(e.metadata).filter((e=>e.startsWith("bxy"))).length<=1)return;const t=i.default.makeRightSideMarker({color:"#ffc963",dimensions:{x:n.width()+12,y:10,width:18,height:12},metaTag:"bxy-id|"+e.metadata.bxyCellId,title:"Cell 含有博小鱼特殊配置"});l(t).appendTo(n);const r=n.find(".bxy-right-side-marker");r.length>0&&r.on("click",(()=>{f.toggleAccessLevel("create")}))},notificationMsgs:{},setNotifier:(e,n)=>{const t=f.controlPanelIds["bxy-notifier"];if(t.show().children().hide(),!f.notificationMsgs.hasOwnProperty(e)){const r="bxy-notification-"+h.generateUniqueId();l('<div id="'+r+'">'+e+"</div>").appendTo(t);const o=t.find("#"+r);f.notificationMsgs[e]=o,f.bindControlPanelCallbacks(o,n)}f.notificationMsgs[e].show()},resetNotifier:()=>{f.setNotifier('<div><a target="_blank" href="https://fe9m1yda6v.feishu.cn/docs/doccnQKBB3HazZtDhZYcHaunUte">使用说明</a></div>')}},d={formHasError:!1,accessLevel:"view",getAccessLevel:()=>d.accessLevel,setAccessLevel:e=>d.accessLevel=e,manifest:{},getManifest:()=>d.manifest,controlPanelDragging:!1,getControlPanelDragging:()=>d.controlPanelDragging,setControlPanelDragging:e=>{d.controlPanelDragging=e},controlPanelDragOffset:{left:0,top:0},getControlPanelDragOffset:()=>d.controlPanelDragOffset,setControlPanelDragOffset:e=>{d.controlPanelDragOffset=e},pointer:{x:0,y:0},getPointerPosition:()=>d.pointer,setPointerPosition:e=>{d.pointer=e}},p={ensureNotebookGetsBxyId:()=>{const e=a.notebook;e.metadata.bxyId||(e.metadata.bxyId=h.generateUniqueId()),h.assignCellIds(),h.refreshCellMaps(),console.log("bxy: Notebook is now ready to use bxy.")},loadManifest:e=>{if(!a.notebook.metadata.bxyId){if("create"!==e)return console.log('bxy: loadManifest is bailing early because we are not in "create" mode and this notebook has no bxy id.'),Promise.reject();p.ensureNotebookGetsBxyId()}return Promise.resolve()}},h={saveNotebookCallbacks:[],queueSaveNotebookCallback:e=>{h.saveNotebookCallbacks.push(e)},generateUniqueId:()=>"id_"+Math.random().toString(36).substr(2,7),assignCellIds:()=>{const e=a.notebook.get_cells();let n,t;for(let r=0;r<e.length;++r)n=e[r],t=h.generateUniqueId(),void 0===h.getMetadataCellId(n.metadata)&&h.setMetadataCellId(n.metadata,t)},getMetadataCellId:e=>e.bxyCellId,setMetadataCellId:(e,n)=>(e.bxyCellId=n,n),processSaveNotebookCallbacks:()=>{let e;for(;h.saveNotebookCallbacks.length>0;)e=h.saveNotebookCallbacks.shift(),null==e||e();console.log("bxy: Notebook saved successfully.")},saveNotebook:()=>{a.notebook.save_notebook().then((()=>{h.processSaveNotebookCallbacks()})).catch((e=>{console.error("bxy: saveNotebook caught exception:",e)}))},saveDebounceTiming:1e3,saveNotebookDebounced:()=>{c.debounce(h.saveNotebook,h.saveDebounceTiming)()},createBxyTagRegex:()=>RegExp('<span class="bxy-highlight (bxy-[^"]+)">(.*?)</span>',"gm"),cellMaps:{},refreshCellMaps:()=>{let e,n,t,r,o;h.cellMaps={cells:a.notebook.get_cells(),maps:{},location:{}};const i=Object.keys(h.cellMaps.cells);for(let a=0;a<i.length;++a)if(e=h.cellMaps.cells[a],n=h.getMetadataCellId(e.metadata),h.cellMaps.maps[n]=a,e.hasOwnProperty("inner_cell")?t=l(e.inner_cell).parents(".cell"):e.hasOwnProperty("element")&&(t=l(e.element)),void 0!==t&&t.attr({"bxy-cell-id":h.getMetadataCellId(e.metadata)}),"markdown"===e.cell_type){const t=e.get_text();let i,a;for(r=h.createBxyTagRegex();null!==(i=r.exec(t));)a=i[1].match(/bxy-(id_.[^-]+)-(id_[^\s]+)/),o=(null==a?void 0:a[1])+"_"+(null==a?void 0:a[2]),h.cellMaps.location[o]=n}}}},475:function(e,n){"use strict";var t=this&&this.__awaiter||function(e,n,t,r){return new(t||(t=Promise))((function(o,i){function a(e){try{c(r.next(e))}catch(e){i(e)}}function l(e){try{c(r.throw(e))}catch(e){i(e)}}function c(e){var n;e.done?o(e.value):(n=e.value,n instanceof t?n:new t((function(e){e(n)}))).then(a,l)}c((r=r.apply(e,n||[])).next())}))};Object.defineProperty(n,"__esModule",{value:!0}),n.getQuizQuestionByUUID=n.parseQuizQuestions=void 0,n.parseQuizQuestions=({code:e,lessonId:n,userId:r,token:o,apiPrefix:i})=>t(void 0,void 0,void 0,(function*(){const t={code:e,lessonId:n,userId:r,token:o};return fetch(`${i}/jupyterhub/admin-widgets-parse/json`,{body:JSON.stringify(t),headers:{"content-type":"application/json"},method:"POST"}).then((e=>e.json()))})),n.getQuizQuestionByUUID=({uuid:e,apiPrefix:n})=>t(void 0,void 0,void 0,(function*(){return fetch(`${n}/quiz-questions/uuid/${e}`,{headers:{"content-type":"application/json"},method:"GET"}).then((e=>e.json()))}))},636:n=>{"use strict";n.exports=e},273:e=>{"use strict";e.exports=n}},r={};function o(e){var n=r[e];if(void 0!==n)return n.exports;var i=r[e]={id:e,loaded:!1,exports:{}};return t[e].call(i.exports,i,i.exports,o),i.loaded=!0,i.exports}return o.d=(e,n)=>{for(var t in n)o.o(n,t)&&!o.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},o.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),o.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),o.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},o.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),o(112)})()));
//# sourceMappingURL=extension.js.map