# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ThermalCameraRegionResponse(Model):
    """ThermalCameraRegionResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID for the region
    :type id: str
    :param name: Required. The name of the region
    :type name: str
    :param instance: Required. The unique set of coordinates that designates a
     region.
    :type instance: int
    :param xcoordinate: Required. The "X" coordinate that determines the
     position of the region.
     In other words, where the region is located.
    :type xcoordinate: int
    :param ycoordinate: Required. The "Y" coordinate that determines the
     position of the region.
     In other words, where the region is located.
    :type ycoordinate: int
    :param width: Required. The width of the region
    :type width: int
    :param height: Required. The height of the region
    :type height: int
    :param created: Required. The Date the thermal region was originally
     created
    :type created: datetime
    :param updated: Required. Represents the last time the region had
     properties that were updated
    :type updated: datetime
    :param active: Required. Whether or not the thermal region is currently
     active
    :type active: bool
    :param thermal_camera_serial_number: Required. The serial number for the
     Thermal Camera the region belongs to
    :type thermal_camera_serial_number: long
    :param location: Required.
    :type location:
     ~smartdiagnostics_sdk.models.ThermalCameraRegionLocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'instance': {'required': True},
        'xcoordinate': {'required': True},
        'ycoordinate': {'required': True},
        'width': {'required': True},
        'height': {'required': True},
        'created': {'required': True},
        'updated': {'required': True},
        'active': {'required': True},
        'thermal_camera_serial_number': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'instance': {'key': 'Instance', 'type': 'int'},
        'xcoordinate': {'key': 'XCoordinate', 'type': 'int'},
        'ycoordinate': {'key': 'YCoordinate', 'type': 'int'},
        'width': {'key': 'Width', 'type': 'int'},
        'height': {'key': 'Height', 'type': 'int'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'active': {'key': 'Active', 'type': 'bool'},
        'thermal_camera_serial_number': {'key': 'ThermalCameraSerialNumber', 'type': 'long'},
        'location': {'key': 'Location', 'type': 'ThermalCameraRegionLocationChild'},
    }

    def __init__(self, **kwargs):
        super(ThermalCameraRegionResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.instance = kwargs.get('instance', None)
        self.xcoordinate = kwargs.get('xcoordinate', None)
        self.ycoordinate = kwargs.get('ycoordinate', None)
        self.width = kwargs.get('width', None)
        self.height = kwargs.get('height', None)
        self.created = kwargs.get('created', None)
        self.updated = kwargs.get('updated', None)
        self.active = kwargs.get('active', None)
        self.thermal_camera_serial_number = kwargs.get('thermal_camera_serial_number', None)
        self.location = kwargs.get('location', None)
