# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NotificationsV4SummaryResponse(Model):
    """A rollup of all notifications at and under a resource.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The type of resource this summary is for.
     Possible values include: 'Location', 'System', 'Asset'
    :type resource_type: str or ~smartdiagnostics_sdk.models.enum
    :param resource_id: Required. The {Location}, {System}, or {Asset} id
     depending on the
     value of {ResourceType}
    :type resource_id: str
    :param total_unread_notifications: Required. The total number of unread
     notifications for or under this resource
    :type total_unread_notifications: int
    :param breakdown_by_notification_type: Required. Breakdown of
     notifications under the resource
    :type breakdown_by_notification_type:
     ~smartdiagnostics_sdk.models.NotificationsV4SummaryResponseBreakdownByNotificationType
    """

    _validation = {
        'resource_type': {'required': True},
        'resource_id': {'required': True},
        'total_unread_notifications': {'required': True},
        'breakdown_by_notification_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'ResourceType', 'type': 'str'},
        'resource_id': {'key': 'ResourceId', 'type': 'str'},
        'total_unread_notifications': {'key': 'TotalUnreadNotifications', 'type': 'int'},
        'breakdown_by_notification_type': {'key': 'BreakdownByNotificationType', 'type': 'NotificationsV4SummaryResponseBreakdownByNotificationType'},
    }

    def __init__(self, **kwargs):
        super(NotificationsV4SummaryResponse, self).__init__(**kwargs)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.total_unread_notifications = kwargs.get('total_unread_notifications', None)
        self.breakdown_by_notification_type = kwargs.get('breakdown_by_notification_type', None)
