# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NotificationV4Response(Model):
    """NotificationV4Response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Id of the notification
    :type id: str
    :param is_read: Required. If the notification has been read by the user
    :type is_read: bool
    :param is_email_notification: Required. If the notification should be sent
     via email
    :type is_email_notification: bool
    :param is_in_app_notification: Required. If the notification should be
     displayed in SD4 Notification Center
    :type is_in_app_notification: bool
    :param is_sms_notification: Required. If the notification should be sent
     via SMS
    :type is_sms_notification: bool
    :param message: Required. Content of the notification
    :type message: str
    :param source_id: Required. Id of the resource that triggered the
     notification
    :type source_id: str
    :ivar v4_source_type: Required. The type of resource that triggered the
     notification. Default value: "Alert" .
    :vartype v4_source_type: str
    """

    _validation = {
        'id': {'required': True},
        'is_read': {'required': True},
        'is_email_notification': {'required': True},
        'is_in_app_notification': {'required': True},
        'is_sms_notification': {'required': True},
        'message': {'required': True},
        'source_id': {'required': True},
        'v4_source_type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'is_read': {'key': 'IsRead', 'type': 'bool'},
        'is_email_notification': {'key': 'IsEmailNotification', 'type': 'bool'},
        'is_in_app_notification': {'key': 'IsInAppNotification', 'type': 'bool'},
        'is_sms_notification': {'key': 'IsSmsNotification', 'type': 'bool'},
        'message': {'key': 'Message', 'type': 'str'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'v4_source_type': {'key': 'V4SourceType', 'type': 'str'},
    }

    v4_source_type = "Alert"

    def __init__(self, *, id: str, is_read: bool, is_email_notification: bool, is_in_app_notification: bool, is_sms_notification: bool, message: str, source_id: str, **kwargs) -> None:
        super(NotificationV4Response, self).__init__(**kwargs)
        self.id = id
        self.is_read = is_read
        self.is_email_notification = is_email_notification
        self.is_in_app_notification = is_in_app_notification
        self.is_sms_notification = is_sms_notification
        self.message = message
        self.source_id = source_id
