# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeResponse(Model):
    """NodeResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: long
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param hub:
    :type hub: ~smartdiagnostics_sdk.models.HubChild
    :param base_station: Required.
    :type base_station: ~smartdiagnostics_sdk.models.BaseStationNodeChild
    :param repeater:
    :type repeater: ~smartdiagnostics_sdk.models.RepeaterNodeChild
    :param serial_number: Required.
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param firmware_version:
    :type firmware_version: str
    :param node_type_code: Required. Possible values include:
     'KcfHubVibrationV1', 'Invalid', 'KcfFlow', 'KcfPressureVoltage',
     'KcfPressureCurrent', 'KcfPower', 'KcfVibration', 'KcfVibrationV1',
     'KcfVoltage', 'KcfCurrent', 'KcfAtoDVoltage', 'KcfAtoDCurrent',
     'KcfOilQuality', 'Generic', 'KcfAgnostic', 'KcfHumidity',
     'KcfExtendedTemperatureVibration', 'KcfHubAnalogAdapterV1'
    :type node_type_code: str or ~smartdiagnostics_sdk.models.enum
    :param active: Required.
    :type active: bool
    :param created: Required.
    :type created: datetime
    :param updated: Required.
    :type updated: datetime
    :param monitoring_points: Required.
    :type monitoring_points:
     list[~smartdiagnostics_sdk.models.MonitoringPointChild]
    :param battery_voltage:
    :type battery_voltage: float
    :param burst_success_rate:
    :type burst_success_rate: float
    :param is_online:
    :type is_online: bool
    :param last_update_time:
    :type last_update_time: datetime
    :param packet_success_rate:
    :type packet_success_rate: float
    :param temperature:
    :type temperature: float
    :param wireless_efficiency:
    :type wireless_efficiency: float
    """

    _validation = {
        'id': {'required': True},
        'location': {'required': True},
        'corporation': {'required': True},
        'base_station': {'required': True},
        'serial_number': {'required': True, 'max_length': 8},
        'nickname': {'max_length': 30},
        'node_type_code': {'required': True},
        'active': {'required': True},
        'created': {'required': True},
        'updated': {'required': True},
        'monitoring_points': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'hub': {'key': 'Hub', 'type': 'HubChild'},
        'base_station': {'key': 'BaseStation', 'type': 'BaseStationNodeChild'},
        'repeater': {'key': 'Repeater', 'type': 'RepeaterNodeChild'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'firmware_version': {'key': 'FirmwareVersion', 'type': 'str'},
        'node_type_code': {'key': 'NodeTypeCode', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'monitoring_points': {'key': 'MonitoringPoints', 'type': '[MonitoringPointChild]'},
        'battery_voltage': {'key': 'BatteryVoltage', 'type': 'float'},
        'burst_success_rate': {'key': 'BurstSuccessRate', 'type': 'float'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
        'last_update_time': {'key': 'LastUpdateTime', 'type': 'iso-8601'},
        'packet_success_rate': {'key': 'PacketSuccessRate', 'type': 'float'},
        'temperature': {'key': 'Temperature', 'type': 'float'},
        'wireless_efficiency': {'key': 'WirelessEfficiency', 'type': 'float'},
    }

    def __init__(self, *, id: int, location, corporation, base_station, serial_number: str, node_type_code, active: bool, created, updated, monitoring_points, hub=None, repeater=None, nickname: str=None, firmware_version: str=None, battery_voltage: float=None, burst_success_rate: float=None, is_online: bool=None, last_update_time=None, packet_success_rate: float=None, temperature: float=None, wireless_efficiency: float=None, **kwargs) -> None:
        super(NodeResponse, self).__init__(**kwargs)
        self.id = id
        self.location = location
        self.corporation = corporation
        self.hub = hub
        self.base_station = base_station
        self.repeater = repeater
        self.serial_number = serial_number
        self.nickname = nickname
        self.firmware_version = firmware_version
        self.node_type_code = node_type_code
        self.active = active
        self.created = created
        self.updated = updated
        self.monitoring_points = monitoring_points
        self.battery_voltage = battery_voltage
        self.burst_success_rate = burst_success_rate
        self.is_online = is_online
        self.last_update_time = last_update_time
        self.packet_success_rate = packet_success_rate
        self.temperature = temperature
        self.wireless_efficiency = wireless_efficiency
