#!/usr/bin/env python3

# Name: __init__.py
# Author: Vikram Dayal

# init file for RaspberryMotors package
'''
Welcome to a Raspberry Pi service library dedicated to motor control. This library has
been started as an interface to control servo motors using the GPIO pins on the Raspberry pi.
Other types of motors like Stepper motors and DC motors will be added as we go along.

If you want to figure out how to use the library, you might start by using the examples in the order provided below:

example_simple_servo.py: simple setup and control a single servo
example_simple_2servos.py: simple setup and control two servos sequentially
example_timer_servo.py: advanced setup and control two servos simultaneously
example_advanced_servo.py: adanced setup using using the BCM interface and using ResetGpioAtShutdown(False)

To find out more about the examples or the motors pagckage, type in:
help("RaspberryMotors.example_simple_servo")
help("RaspberryMotors.example_simple_2servos")
help("RaspberryMotors.example_timer_servo")
help("RaspberryMotors.example_advanced_servo")
help("RaspberryMotors.motors")


'''